/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.jxdinfo.document.excel.tools.core.common.utils.ZipUtil;
import java.util.Date;
import java.util.concurrent.CountDownLatch;

public class LoadLsDataUtil {
    public static boolean isMultSheet(String zipStr) {
        boolean isMultSheet = false;
        Object lsDataObj = ZipUtil.unZipReport(zipStr);
        if (lsDataObj instanceof JSONObject) {
            isMultSheet = false;
        } else if (lsDataObj instanceof JSONArray) {
            isMultSheet = true;
        }
        return isMultSheet;
    }

    public static String lsLoadUrl(String zipStr) {
        long start = new Date().getTime();
        JSONArray nSheets = (JSONArray)ZipUtil.unZipReport(zipStr);
        long end = new Date().getTime();
        System.out.println("-------lsLoadUrl\u89e3\u538b------" + (end - start));
        long start1 = new Date().getTime();
        for (int i = 0; i < nSheets.size(); ++i) {
            JSONObject sheet = nSheets.getJSONObject(i);
            if (sheet.getIntValue("status") == 1) continue;
            sheet.remove((Object)"celldata");
        }
        long end1 = new Date().getTime();
        System.out.println("-------lsLoadUrl\u5904\u7406celldata------" + (end1 - start1));
        Long startTime = new Date().getTime();
        String resStr = JSON.toJSONString((Object)nSheets, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat});
        Long endTime = new Date().getTime();
        System.out.println("-------lsLoadUrl--toJSONString-------");
        System.out.println(endTime - startTime);
        return resStr;
    }

    public static String lsLoadSheetUrl(String zipStr, String index) {
        String[] indexArr = index.split(",");
        JSONObject resObj = new JSONObject();
        JSONArray nSheets = (JSONArray)ZipUtil.unZipReport(zipStr);
        block0: for (int i = 0; i < indexArr.length; ++i) {
            for (int j = 0; j < nSheets.size(); ++j) {
                JSONObject sheet = nSheets.getJSONObject(j);
                if (!sheet.getString("index").equals(indexArr[i])) continue;
                resObj.put(indexArr[i], sheet.get((Object)"celldata"));
                continue block0;
            }
        }
        Long startTime = new Date().getTime();
        String resStr = JSON.toJSONString((Object)resObj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat});
        Long endTime = new Date().getTime();
        System.out.println("-------lsLoadSheetUrl--toJSONString-------");
        System.out.println(endTime - startTime);
        return resStr;
    }

    public static String lsLoadUrlStr(JSONArray nSheets) {
        long start1 = new Date().getTime();
        for (int i = 0; i < nSheets.size(); ++i) {
            JSONObject sheet = nSheets.getJSONObject(i);
            if (sheet.getIntValue("status") == 1) continue;
            sheet.remove((Object)"celldata");
        }
        long end1 = new Date().getTime();
        System.out.println("-------lsLoadUrl\u5904\u7406celldata------" + (end1 - start1));
        Long startTime = new Date().getTime();
        String resStr = JSON.toJSONString((Object)nSheets, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat});
        Long endTime = new Date().getTime();
        System.out.println("-------lsLoadUrl--toJSONString-------" + (endTime - startTime));
        return resStr;
    }

    public static JSONArray lsLoadUrlJson(JSONArray nSheets) {
        for (int i = 0; i < nSheets.size(); ++i) {
            JSONObject sheet = nSheets.getJSONObject(i);
            if (sheet.getIntValue("status") == 1) continue;
            sheet.remove((Object)"celldata");
        }
        return nSheets;
    }

    public static String lsLoadSheetUrlStr(JSONArray nSheets, String index) {
        String[] indexArr = index.split(",");
        JSONObject resObj = new JSONObject();
        block0: for (int i = 0; i < indexArr.length; ++i) {
            for (int j = 0; j < nSheets.size(); ++j) {
                JSONObject sheet = nSheets.getJSONObject(j);
                if (!sheet.getString("index").equals(indexArr[i])) continue;
                resObj.put(indexArr[i], sheet.get((Object)"celldata"));
                continue block0;
            }
        }
        Long startTime = new Date().getTime();
        String resStr = JSON.toJSONString((Object)resObj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat});
        Long endTime = new Date().getTime();
        System.out.println("-------lsLoadSheetUrl--toJSONString-------");
        System.out.println(endTime - startTime);
        return resStr;
    }

    public static JSONObject lsLoadSheetUrlJson(JSONArray nSheets, String index) {
        String[] indexArr = index.split(",");
        JSONObject resObj = new JSONObject();
        block0: for (int i = 0; i < indexArr.length; ++i) {
            for (int j = 0; j < nSheets.size(); ++j) {
                JSONObject sheet = nSheets.getJSONObject(j);
                if (!sheet.getString("index").equals(indexArr[i])) continue;
                resObj.put(indexArr[i], sheet.get((Object)"celldata"));
                continue block0;
            }
        }
        return resObj;
    }

    public static JSONObject handleLsData(JSONArray sheets) {
        JSONObject res = new JSONObject();
        res.put("main", (Object)new JSONArray());
        res.put("other", (Object)new JSONObject());
        CountDownLatch latch = new CountDownLatch(sheets.size());
        for (int i = 0; i < sheets.size(); ++i) {
            JSONObject sheet = sheets.getJSONObject(i);
            sheet.remove((Object)"load");
            new Thread(() -> {
                if (sheet.getIntValue("status") == 1) {
                    res.getJSONArray("main").add((Object)sheet);
                } else {
                    JSONArray celldata = sheet.getJSONArray("celldata");
                    res.getJSONObject("other").put(sheet.getString("index"), (Object)celldata);
                    sheet.remove((Object)"celldata");
                    res.getJSONArray("main").add((Object)sheet);
                }
                latch.countDown();
            }).start();
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return res;
    }
}

