/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils;

import com.jxdinfo.document.excel.tools.core.common.utils.StringUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileUtil {
    private static final Pattern FILE_ID_PATTERN = Pattern.compile("(\\d+)(\\.\\w+)?$");
    private static final String OSS_PREFIX = "oss://";

    public static Long extractFileId(String path) {
        Matcher matcher;
        int lastSeparator;
        if (StringUtil.isNullOrEmpty(path)) {
            return 0L;
        }
        if (path.startsWith(OSS_PREFIX)) {
            path = path.substring(OSS_PREFIX.length());
        }
        if ((lastSeparator = Math.max(path.lastIndexOf(47), path.lastIndexOf(92))) != -1) {
            path = path.substring(lastSeparator + 1);
        }
        if ((matcher = FILE_ID_PATTERN.matcher(path)).find()) {
            try {
                return Long.parseLong(matcher.group(1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0L;
    }
}

