/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils.fileUpload;

import com.jxdinfo.document.excel.tools.core.common.utils.fileUpload.ReportToolImageCompressConfig;
import com.jxdinfo.document.excel.tools.core.common.utils.fileUpload.ReportToolImageStorage;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.wmf.tosvg.WMFTranscoder;
import org.apache.commons.lang3.StringUtils;

public class FileUploadUtil {
    public static ReportToolImageStorage imageCompress(InputStream inputStream, String fileName, String contentType, ReportToolImageCompressConfig compressConfig, boolean compressFlag) throws IOException, TranscoderException {
        String suffix = FileUploadUtil.getFileSuffix(fileName);
        if (StringUtils.isEmpty((CharSequence)suffix)) {
            return null;
        }
        ByteArrayOutputStream compressedImageStream = new ByteArrayOutputStream();
        block10 : switch (contentType) {
            case "image/jpeg": 
            case "image/png": 
            case "image/gif": 
            case "image/bmp": {
                if (("image/png".equals(contentType) || "image/gif".equals(contentType)) && (inputStream = FileUploadUtil.checkImageBands(inputStream)) == null) {
                    return null;
                }
                int size = FileUploadUtil.getStreamSize(inputStream);
                int maximum = compressConfig.getCompressMaximum();
                if (compressFlag && size >= maximum) {
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                    bufferedInputStream.mark(Integer.MAX_VALUE);
                    for (float quality = compressConfig.getCompressQuality(); quality > 0.1f; quality -= 0.1f) {
                        compressedImageStream.reset();
                        Thumbnails.of((InputStream[])new InputStream[]{bufferedInputStream}).size(compressConfig.getDefaultWidth(), compressConfig.getDefaultHeight()).outputQuality(quality).toOutputStream((OutputStream)compressedImageStream);
                        byte[] compressedImage = compressedImageStream.toByteArray();
                        long imageSize = compressedImage.length;
                        if (imageSize <= (long)maximum) break block10;
                        bufferedInputStream.reset();
                    }
                    break;
                }
                compressedImageStream = FileUploadUtil.toByteArrayOutputStream(inputStream);
                break;
            }
            case "image/webp": 
            case "image/tiff": {
                compressedImageStream = FileUploadUtil.imageToPng(inputStream);
                suffix = "png";
                break;
            }
            case "image/wmf": 
            case "application/octet-stream": {
                if ("application/octet-stream".equals(contentType) && !"wmf".equalsIgnoreCase(suffix)) break;
                ByteArrayOutputStream svgStream = new ByteArrayOutputStream();
                new WMFTranscoder().transcode(new TranscoderInput(inputStream), new TranscoderOutput((OutputStream)svgStream));
                compressedImageStream = svgStream;
                suffix = "svg";
                break;
            }
            default: {
                compressedImageStream = FileUploadUtil.toByteArrayOutputStream(inputStream);
            }
        }
        ReportToolImageStorage reportToolInstanceImageStorage = new ReportToolImageStorage();
        reportToolInstanceImageStorage.setSuffix(suffix);
        reportToolInstanceImageStorage.setImageStream(compressedImageStream);
        return reportToolInstanceImageStorage;
    }

    public static String getFileSuffix(String fileName) {
        if (StringUtils.isEmpty((CharSequence)fileName)) {
            return "";
        }
        int lastIndex = fileName.lastIndexOf(".");
        if (lastIndex == -1 || lastIndex == 0) {
            return "";
        }
        return fileName.substring(lastIndex + 1).toLowerCase();
    }

    public static InputStream checkImageBands(InputStream inputStream) {
        try {
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            WritableRaster raster = bufferedImage.getRaster();
            int numBands = raster.getNumBands();
            if (numBands != 4) {
                bufferedImage = FileUploadUtil.generateFourBandsBufferedImage(bufferedImage);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
            return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BufferedImage generateFourBandsBufferedImage(BufferedImage bufferedImage) {
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        BufferedImage rgbaImage = new BufferedImage(width, height, 2);
        Graphics2D g2d = rgbaImage.createGraphics();
        g2d.drawImage((Image)bufferedImage, 0, 0, null);
        g2d.dispose();
        return rgbaImage;
    }

    public static ByteArrayOutputStream toByteArrayOutputStream(InputStream inputStream) throws IOException {
        int bytesRead;
        if (inputStream == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            byteArrayOutputStream.write(buffer, 0, bytesRead);
        }
        return byteArrayOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteArrayOutputStream imageToPng(InputStream inputStream) throws IOException {
        BufferedImage originalImage = ImageIO.read(inputStream);
        if (originalImage == null) {
            throw new IOException("\u65e0\u6cd5\u8bfb\u53d6\u56fe\u50cf");
        }
        BufferedImage processedImage = new BufferedImage(originalImage.getWidth(), originalImage.getHeight(), 2);
        Graphics2D g2d = processedImage.createGraphics();
        g2d.drawImage((Image)originalImage, 0, 0, null);
        g2d.dispose();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageWriter writer = ImageIO.getImageWritersByFormatName("PNG").next();
        try (ImageOutputStream imageOutput = ImageIO.createImageOutputStream(byteArrayOutputStream);){
            writer.setOutput(imageOutput);
            writer.write(processedImage);
        }
        finally {
            writer.dispose();
        }
        return byteArrayOutputStream;
    }

    public static int getStreamSize(InputStream inputStream) throws IOException {
        ReportToolImageCompressConfig compressConfig = new ReportToolImageCompressConfig();
        int size = compressConfig.getCompressMaximum();
        if (inputStream.markSupported()) {
            inputStream.mark(Integer.MAX_VALUE);
            try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
                int nRead;
                byte[] data = new byte[16384];
                while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
                    buffer.write(data, 0, nRead);
                }
                buffer.flush();
                size = buffer.size();
                inputStream.reset();
            }
        }
        return size;
    }
}

