/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils.excel.importer.strategy;

import com.jxdinfo.document.excel.tools.core.common.utils.CalUtil;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.constant.ExcelImportConstant;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.importer.factory.LuckySheetFactory;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.importer.strategy.AbstractCellDataValueStrategy;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.model.cell.CellData;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.model.cell.CellInlineText;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FontUnderline;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.stereotype.Component;

@Component
public class StringCellStrategy
extends AbstractCellDataValueStrategy {
    @Override
    public boolean supports(CellType cellType) {
        return cellType == CellType.STRING;
    }

    @Override
    public void setCellValue(XSSFWorkbook workbook, XSSFCell cell, CellData cellData) {
        XSSFRichTextString richTextString = cell.getRichStringCellValue();
        cellData.getV().getCt().setFa("General");
        if (richTextString.hasFormatting()) {
            ArrayList<CellInlineText> inlineTexts = new ArrayList<CellInlineText>();
            StringCellStrategy.setRichTextString(workbook, richTextString, cell.getCellStyle(), inlineTexts);
            cellData.getV().getCt().setS(inlineTexts);
            cellData.getV().getCt().setT("inlineStr");
        } else {
            String cellValue = cell.getStringCellValue();
            if (cellValue.contains("\n")) {
                ArrayList<CellInlineText> inlineTexts = new ArrayList<CellInlineText>();
                StringCellStrategy.setTextString(workbook, cellValue, cell.getCellStyle(), inlineTexts);
                cellData.getV().getCt().setS(inlineTexts);
                cellData.getV().getCt().setT("inlineStr");
            } else {
                cellData.getV().setV(cellValue);
                cellData.getV().getCt().setT("s");
            }
        }
    }

    private static void setRichTextString(XSSFWorkbook workbook, XSSFRichTextString richTextString, XSSFCellStyle cellStyle, List<CellInlineText> inlineTexts) {
        String string = richTextString.getString();
        for (int i = 0; i < richTextString.numFormattingRuns(); ++i) {
            int lengthOfFormattingRun = richTextString.getLengthOfFormattingRun(i);
            int indexOfFormattingRun = richTextString.getIndexOfFormattingRun(i);
            String substring = string.substring(indexOfFormattingRun, indexOfFormattingRun + lengthOfFormattingRun);
            XSSFFont font = richTextString.getFontOfFormattingRun(i);
            if (font == null && cellStyle != null) {
                font = cellStyle.getFont();
            }
            StringCellStrategy.setLineTextFont(workbook, inlineTexts, substring, font);
        }
    }

    private static void setTextString(XSSFWorkbook workbook, String richTextString, XSSFCellStyle cellStyle, List<CellInlineText> inlineTexts) {
        String[] splitArray = richTextString.split("\n");
        for (int i = 0; i < splitArray.length; ++i) {
            if (i < splitArray.length - 1) {
                splitArray[i] = splitArray[i] + "\n";
            }
            XSSFFont font = cellStyle.getFont();
            StringCellStrategy.setLineTextFont(workbook, inlineTexts, splitArray[i], font);
        }
    }

    private static void setLineTextFont(XSSFWorkbook workbook, List<CellInlineText> inlineTexts, String substring, XSSFFont font) {
        CellInlineText inlineText = LuckySheetFactory.createInlineText();
        if (font != null) {
            inlineText.setFf(ExcelImportConstant.FONT_NAME.get(font.getFontName()));
            inlineText.setBl(ExcelImportConstant.BORD.get(font.getBold()));
            inlineText.setIt(ExcelImportConstant.FONT_ITALIC.get(font.getItalic()));
            inlineText.setUn(ExcelImportConstant.UNDERLINE.get(FontUnderline.valueOf((byte)font.getUnderline())));
            inlineText.setCl(ExcelImportConstant.STRIKE.get(font.getStrikeout()));
            inlineText.setFs(font.getFontHeightInPoints());
            XSSFColor xssfColor = font.getXSSFColor();
            if (xssfColor != null) {
                inlineText.setFc(CalUtil.getColor(workbook, xssfColor));
            }
        }
        inlineText.setV(substring);
        inlineTexts.add(inlineText);
    }
}

