/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils.excel.importer.factory;

import com.jxdinfo.document.excel.tools.core.common.utils.CalUtil;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.constant.ExcelImportConstant;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.model.border.BorderInfo;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.model.border.BorderInfoStyle;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.model.border.BorderInfoValue;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.model.cell.CellComment;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.model.cell.CellData;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.model.cell.CellDataCt;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.model.cell.CellDataValue;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.model.cell.CellInlineText;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.model.sheet.LuckySheet;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.model.sheet.RowAndColRange;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.model.sheet.SheetConditionFormat;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class LuckySheetFactory {
    public static LuckySheet createLuckySheet(String sheetName) {
        LuckySheet luckySheet = new LuckySheet();
        luckySheet.setName(sheetName);
        luckySheet.setColor("");
        return luckySheet;
    }

    public static CellData createCellData() {
        CellData cellData = new CellData();
        CellDataValue v = new CellDataValue();
        v.setCt(new CellDataCt());
        cellData.setV(v);
        return cellData;
    }

    public static CellInlineText createInlineText() {
        return new CellInlineText();
    }

    public static CellComment createComment() {
        return new CellComment();
    }

    public static SheetConditionFormat createConditionFormat() {
        SheetConditionFormat conditionFormat = new SheetConditionFormat();
        conditionFormat.setCellrange(new ArrayList<RowAndColRange>());
        conditionFormat.setConditionRange(new ArrayList<RowAndColRange>());
        return conditionFormat;
    }

    public static BorderInfo createBorder() {
        BorderInfo border = new BorderInfo();
        border.setRangeType("cell");
        border.setValue(new BorderInfoValue());
        return border;
    }

    public static BorderInfoStyle createBorderStyle(XSSFWorkbook workbook, XSSFColor borderColor, BorderStyle borderStyle) {
        if (borderColor == null) {
            return null;
        }
        BorderInfoStyle style = new BorderInfoStyle();
        if (borderColor.isAuto()) {
            style.setColor("rgb(0,0,0)");
        } else if (!borderStyle.equals((Object)BorderStyle.NONE)) {
            style.setColor(CalUtil.getColor(workbook, borderColor));
        }
        if (borderStyle == null) {
            style.setStyle(ExcelImportConstant.BORDER_TYPE.get(BorderStyle.NONE));
        } else {
            style.setStyle(ExcelImportConstant.BORDER_TYPE.get(borderStyle));
        }
        if (StringUtils.isBlank((CharSequence)style.getColor()) && (style.getStyle() == null || style.getStyle() == 0)) {
            return null;
        }
        return style;
    }

    public static boolean hasBorderStyle(BorderInfo border) {
        return border.getValue().getT() != null || border.getValue().getR() != null || border.getValue().getB() != null || border.getValue().getL() != null;
    }

    public static boolean isRightCellValue(String t) {
        return t.equals("n") || t.equals("d");
    }

    public static boolean isCenterCellValue(String t) {
        return t.equals("b");
    }

    public static String getGeneral(CellData cellData) {
        CellDataValue v = cellData.getV();
        if (v == null) {
            return "";
        }
        CellDataCt ct = v.getCt();
        if (ct == null) {
            return "";
        }
        String t = v.getCt().getT();
        if (t == null) {
            return "";
        }
        return t;
    }
}

