/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.processor;

import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;

public class CopyPrintProcessor {
    public static void copyPrintSetting(Workbook srcWorkbook, Workbook destWorkbook, Sheet srcSheet, Sheet destSheet) {
        int sheetIndex;
        String printArea;
        CellRangeAddress repeatingRows = srcSheet.getRepeatingRows();
        if (repeatingRows != null) {
            destSheet.setRepeatingRows(repeatingRows);
        }
        if ((printArea = srcWorkbook.getPrintArea(sheetIndex = srcWorkbook.getSheetIndex(srcSheet))) != null) {
            destWorkbook.setPrintArea(destWorkbook.getSheetIndex(destSheet), CopyPrintProcessor.extractCellRange(printArea));
        }
    }

    public static String extractCellRange(String fullRange) {
        if (fullRange == null || fullRange.isEmpty()) {
            return "";
        }
        int exclamationIndex = fullRange.indexOf(33);
        if (exclamationIndex >= 0 && exclamationIndex < fullRange.length() - 1) {
            return fullRange.substring(exclamationIndex + 1);
        }
        return "";
    }
}

