/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.processor;

import com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.cache.StyleCache;
import java.util.Objects;
import org.apache.poi.ss.usermodel.ConditionalFormatting;
import org.apache.poi.ss.usermodel.ConditionalFormattingRule;
import org.apache.poi.ss.usermodel.SheetConditionalFormatting;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFSheetConditionalFormatting;

public class CopyConditionalFormattingProcessor {
    public static void copyConditionalFormatting(XSSFSheet source, XSSFSheet target, StyleCache styleCache) {
        XSSFSheetConditionalFormatting sourceScf = source.getSheetConditionalFormatting();
        if (Objects.isNull(sourceScf)) {
            return;
        }
        int formattingNum = sourceScf.getNumConditionalFormattings();
        if (formattingNum == 0) {
            return;
        }
        XSSFSheetConditionalFormatting targetScf = target.getSheetConditionalFormatting();
        for (int i = 0; i < formattingNum; ++i) {
            ConditionalFormatting cf = sourceScf.getConditionalFormattingAt(i);
            CellRangeAddress[] ranges = cf.getFormattingRanges();
            ConditionalFormattingRule[] rules = new ConditionalFormattingRule[cf.getNumberOfRules()];
            for (int j = 0; j < cf.getNumberOfRules(); ++j) {
                rules[j] = styleCache.getCachedRule(cf.getRule(j), (SheetConditionalFormatting)targetScf, source.getSheetName(), target.getSheetName());
            }
            targetScf.addConditionalFormatting(ranges, rules);
        }
    }
}

