/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.helper;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.constant.ExcelExportConstant;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.cache.StyleCache;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.helper.ColorHelper;
import org.apache.poi.ss.usermodel.FontUnderline;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ReportFontHelper {
    public static XSSFFont createFont(XSSFWorkbook wb, StyleCache styleCache, JSONObject jsonObjectValue) {
        XSSFFont font = wb.createFont();
        if (jsonObjectValue.get((Object)"ff") != null) {
            if (jsonObjectValue.get((Object)"ff").toString().matches("^(-?\\d+)(\\.\\d+)?$")) {
                font.setFontName(ExcelExportConstant.ff_IntegerToName.get(jsonObjectValue.getInteger("ff")));
            } else {
                font.setFontName(jsonObjectValue.get((Object)"ff").toString());
            }
        } else {
            font.setFontName(ExcelExportConstant.ff_IntegerToName.get(13));
        }
        if (jsonObjectValue.get((Object)"fc") != null) {
            String fc = jsonObjectValue.get((Object)"fc").toString();
            XSSFColor color = ColorHelper.parseColorToXSSF(fc);
            font.setColor(color);
        } else {
            font.setColor(ColorHelper.getDefaultColor());
        }
        if (jsonObjectValue.get((Object)"bl") != null) {
            font.setBold("1".equals(jsonObjectValue.get((Object)"bl").toString()));
        }
        if (jsonObjectValue.get((Object)"it") != null) {
            font.setItalic("1".equals(jsonObjectValue.get((Object)"it").toString()));
        }
        if (jsonObjectValue.get((Object)"cl") != null) {
            font.setStrikeout("1".equals(jsonObjectValue.get((Object)"cl").toString()));
        }
        if (jsonObjectValue.get((Object)"un") != null) {
            font.setUnderline("1".equals(jsonObjectValue.get((Object)"un").toString()) ? FontUnderline.SINGLE : FontUnderline.NONE);
        }
        Short fs = 10;
        if (jsonObjectValue.get((Object)"fs") != null) {
            fs = new Short(jsonObjectValue.get((Object)"fs").toString());
            font.setFontHeightInPoints(fs.shortValue());
        } else {
            font.setFontHeight(10.0);
        }
        if (jsonObjectValue.get((Object)"sup") != null && "1".equals(jsonObjectValue.get((Object)"sup").toString())) {
            font.setTypeOffset((short)1);
            int defaultFs = Integer.parseInt(String.valueOf(fs)) - 2;
            font.setFontHeightInPoints(new Short(String.valueOf(defaultFs)).shortValue());
        }
        if (jsonObjectValue.get((Object)"sub") != null && "1".equals(jsonObjectValue.get((Object)"sub").toString())) {
            font.setTypeOffset((short)2);
            int defaultFs = Integer.parseInt(String.valueOf(fs)) - 2;
            font.setFontHeightInPoints(new Short(String.valueOf(defaultFs)).shortValue());
        }
        return styleCache.getStyle(font);
    }
}

