/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils.excel.importer.helper;

import com.jxdinfo.document.excel.tools.core.common.utils.CalUtil;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.constant.ExcelImportConstant;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.importer.factory.LuckySheetFactory;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.model.cell.CellData;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.FontUnderline;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class CellDataStyleHelper {
    public static void setCellDataStyle(XSSFWorkbook workbook, XSSFCell cell, CellData cellData) {
        XSSFCellStyle cellStyle = cell.getCellStyle();
        if (cellStyle == null) {
            return;
        }
        CellDataStyleHelper.setDataFormat(cellStyle, cellData);
        CellDataStyleHelper.setBackgroundColor(workbook, cellStyle, cellData);
        CellDataStyleHelper.setFont(workbook, cellStyle, cellData);
        CellDataStyleHelper.setHorizontalAlignment(cellStyle, cellData);
        CellDataStyleHelper.setVerticalAlignment(cellStyle, cellData);
        CellDataStyleHelper.setRotation(cellStyle, cellData);
        CellDataStyleHelper.setWrapText(cellStyle, cellData);
    }

    private static void setWrapText(XSSFCellStyle cellStyle, CellData cellData) {
        if (cellStyle.getWrapText()) {
            cellData.getV().setTb(ExcelImportConstant.WRAP.get(cellStyle.getWrapText()));
        } else {
            cellData.getV().setTb(ExcelImportConstant.WRAP.get(false));
        }
    }

    private static void setRotation(XSSFCellStyle cellStyle, CellData cellData) {
        cellData.getV().setTr(cellStyle.getRotation() == 0 ? 0 : 3);
        cellData.getV().setRt(cellStyle.getRotation());
    }

    private static void setVerticalAlignment(XSSFCellStyle cellStyle, CellData cellData) {
        VerticalAlignment verticalAlignment = cellStyle.getVerticalAlignment();
        if (verticalAlignment == null) {
            cellData.getV().setVt(ExcelImportConstant.V_AL_TYPE.get(VerticalAlignment.CENTER));
        } else {
            cellData.getV().setVt(ExcelImportConstant.V_AL_TYPE.get(verticalAlignment));
        }
    }

    private static void setHorizontalAlignment(XSSFCellStyle cellStyle, CellData cellData) {
        HorizontalAlignment alignment = cellStyle.getAlignment();
        if (alignment == null) {
            cellData.getV().setHt(ExcelImportConstant.H_AL_TYPE.get(HorizontalAlignment.LEFT));
        } else if (alignment == HorizontalAlignment.GENERAL) {
            CellDataStyleHelper.setGeneralHorizontalAlignment(cellData);
        } else {
            cellData.getV().setHt(ExcelImportConstant.H_AL_TYPE.get(alignment));
        }
    }

    public static void setGeneralHorizontalAlignment(CellData cellData) {
        String t = LuckySheetFactory.getGeneral(cellData);
        if (LuckySheetFactory.isRightCellValue(t)) {
            cellData.getV().setHt(ExcelImportConstant.H_AL_TYPE.get(HorizontalAlignment.RIGHT));
        } else if (LuckySheetFactory.isCenterCellValue(t)) {
            cellData.getV().setHt(ExcelImportConstant.H_AL_TYPE.get(HorizontalAlignment.CENTER));
        } else {
            cellData.getV().setHt(ExcelImportConstant.H_AL_TYPE.get(HorizontalAlignment.LEFT));
        }
    }

    private static void setFont(XSSFWorkbook workbook, XSSFCellStyle cellStyle, CellData cellData) {
        XSSFFont font = cellStyle.getFont();
        if (font == null) {
            return;
        }
        cellData.getV().setFf(ExcelImportConstant.FONT_NAME.get(font.getFontName()));
        cellData.getV().setBl(ExcelImportConstant.BORD.get(font.getBold()));
        cellData.getV().setIt(ExcelImportConstant.FONT_ITALIC.get(font.getItalic()));
        cellData.getV().setUn(ExcelImportConstant.UNDERLINE.get(FontUnderline.valueOf((byte)font.getUnderline())));
        cellData.getV().setCl(ExcelImportConstant.STRIKE.get(font.getStrikeout()));
        cellData.getV().setFs(font.getFontHeightInPoints());
        XSSFColor xssfColor = font.getXSSFColor();
        if (xssfColor != null) {
            cellData.getV().setFc(CalUtil.getColor(workbook, xssfColor));
        }
    }

    private static void setBackgroundColor(XSSFWorkbook workbook, XSSFCellStyle cellStyle, CellData cellData) {
        XSSFColor fillForegroundXSSFColor = cellStyle.getFillForegroundXSSFColor();
        XSSFColor fillBackgroundXSSFColor = cellStyle.getFillBackgroundXSSFColor();
        FillPatternType fillPattern = cellStyle.getFillPattern();
        if (fillPattern.equals((Object)FillPatternType.NO_FILL)) {
            if (fillBackgroundXSSFColor == null) {
                return;
            }
            cellData.getV().setBg(CalUtil.getColor(workbook, fillBackgroundXSSFColor));
        } else if (fillPattern.equals((Object)FillPatternType.SOLID_FOREGROUND)) {
            if (fillForegroundXSSFColor == null) {
                return;
            }
            cellData.getV().setBg(CalUtil.getColor(workbook, fillForegroundXSSFColor));
        }
    }

    private static void setDataFormat(XSSFCellStyle cellStyle, CellData cellData) {
        String dataFormatString = cellStyle.getDataFormatString();
        if (dataFormatString == null) {
            if (ExcelImportConstant.DATE_MAP.get(cellStyle.getDataFormat()) != null) {
                dataFormatString = ExcelImportConstant.DATE_MAP.get(cellStyle.getDataFormat());
                cellData.getV().getCt().setT("d");
            } else {
                return;
            }
        }
        cellData.getV().getCt().setFa(dataFormatString);
    }
}

