/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils.excel.importer.helper;

import com.jxdinfo.document.excel.tools.core.common.utils.CalUtil;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.importer.factory.LuckySheetFactory;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.importer.helper.CellCommentHelper;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.importer.helper.CellDataStyleHelper;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.importer.helper.CellDataValueHelper;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.importer.helper.SheetConfigHelper;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.model.cell.CellData;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.model.cell.CellDataMc;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.model.sheet.LuckySheet;
import java.util.Map;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="document.excel.tools.core.common.utils.excel.importer.helper.CellDataHelper")
public class CellDataHelper {
    @Autowired
    private CellDataValueHelper cellDataValueHelper;

    public void setCellData(XSSFWorkbook workbook, XSSFSheet sheet, LuckySheet luckySheet) {
        Map<String, CellDataMc> merge = luckySheet.getConfig().getMerge();
        for (int rowIndex = CalUtil.getFirstRowBase0((Sheet)sheet); rowIndex <= sheet.getLastRowNum(); ++rowIndex) {
            XSSFRow row = sheet.getRow(rowIndex);
            if (row == null) continue;
            for (int colIndex = row.getFirstCellNum(); colIndex < row.getLastCellNum(); ++colIndex) {
                XSSFCell cell = row.getCell(colIndex);
                if (cell == null) continue;
                CellData cellData = LuckySheetFactory.createCellData();
                cellData.setC(colIndex);
                cellData.setR(rowIndex);
                this.cellDataValueHelper.setCellDataValue(workbook, merge, cell, cellData);
                CellDataStyleHelper.setCellDataStyle(workbook, cell, cellData);
                CellCommentHelper.setCellComment(cell, cellData);
                luckySheet.getCelldata().add(cellData);
                SheetConfigHelper.setBorder(workbook, cell, luckySheet);
            }
        }
    }
}

