/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.helper.ImgSrcHelper;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.helper.RowColHelper;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ReportImagesHelper {
    public static void setImages(XSSFWorkbook wb, XSSFSheet sheet, JSONObject images, JSONArray visibledatarow, JSONArray visibledatacolumn, String reqURL) {
        if (images != null) {
            for (String imageKey : images.keySet()) {
                XSSFDrawing patriarch = sheet.createDrawingPatriarch();
                JSONObject imgObj = images.getJSONObject(imageKey);
                String src = imgObj.getString("src");
                if (!ObjectUtils.isNotEmpty((Object)src) || src.indexOf("base64") <= -1 && !src.startsWith("/") && !src.startsWith("http")) continue;
                JSONObject defaultObj = imgObj.getJSONObject("default");
                Map<String, Integer> colrowMap = RowColHelper.getColRowMap(defaultObj, visibledatarow, visibledatacolumn);
                XSSFClientAnchor anchor = new XSSFClientAnchor(colrowMap.get("dx1").intValue(), colrowMap.get("dy1").intValue(), colrowMap.get("dx2").intValue(), colrowMap.get("dy2").intValue(), colrowMap.get("col1").intValue(), colrowMap.get("row1").intValue(), colrowMap.get("col2").intValue(), colrowMap.get("row2").intValue());
                anchor.setAnchorType(ClientAnchor.AnchorType.MOVE_AND_RESIZE);
                JSONObject imgRes = ImgSrcHelper.handleImgSrc(src, reqURL);
                String picType = imgRes.getString("picType");
                byte[] imgBytes = imgRes.getBytes("imgBytes");
                if (ObjectUtils.isEmpty((Object)imgBytes)) continue;
                int format = 6;
                switch (picType) {
                    case "jpeg": {
                        format = 5;
                        break;
                    }
                    case "emf": {
                        format = 2;
                        break;
                    }
                    case "dib": {
                        format = 7;
                        break;
                    }
                    case "pict": {
                        format = 4;
                        break;
                    }
                    case "wmf": {
                        format = 3;
                        break;
                    }
                }
                patriarch.createPicture(anchor, wb.addPicture(imgBytes, format));
            }
        }
    }
}

