/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.helper;

import com.alibaba.fastjson.JSONObject;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ReportFormatHelper {
    public static String getFormat(JSONObject ct) {
        String fa = "";
        if (ct == null) {
            return fa;
        }
        fa = ct.getString("fa");
        String t = ct.getString("t");
        if (Objects.nonNull(fa)) {
            fa = fa.replace("\"", "");
            if ("d".equals(t) && fa.contains("YYYY")) {
                fa = fa.replaceAll("YYYY", "yyyy");
            }
            if ("d".equals(t) && fa.contains("DD")) {
                fa = fa.replaceAll("DD", "dd");
            }
            if ("d".equals(t) && fa.contains("D")) {
                fa = fa.replaceAll("D", "d");
            }
            if (fa.contains("AM/PM")) {
                fa = fa.replaceAll("AM/PM", "a");
            }
            if ("n".equals(t) && fa.startsWith("##") && fa.endsWith("0")) {
                fa = fa.substring(2);
            }
        }
        return fa;
    }

    public static int getContentType(String v, JSONObject jsonObjectValue, String fa) {
        boolean isCgidExist;
        int cellContentType = 0;
        JSONObject ct = jsonObjectValue.getJSONObject("ct");
        if (ct == null) {
            return cellContentType;
        }
        String t = ct.getString("t");
        if (jsonObjectValue.containsKey((Object)"type")) {
            cellContentType = 4;
        }
        if (Objects.nonNull(t)) {
            if ("n".equals(t)) {
                cellContentType = 1;
            }
            if ("d".equals(t)) {
                cellContentType = 2;
            }
        }
        if (!(isCgidExist = jsonObjectValue.containsKey((Object)"cgid")) && StringUtils.isNotEmpty((CharSequence)v) && cellContentType == 0) {
            return cellContentType;
        }
        if (ct.getJSONArray("s") != null || StringUtils.isNotBlank((CharSequence)fa) && fa.equals("html")) {
            cellContentType = 3;
        }
        return cellContentType;
    }

    public static void setDataFormat(XSSFWorkbook wb, JSONObject ct, CellStyle cellStyle, String fa) {
        XSSFDataFormat df = wb.createDataFormat();
        if (ct != null && Objects.nonNull(fa)) {
            cellStyle.setDataFormat(df.getFormat(fa));
        }
    }
}

