/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils.excel.exporter.helper;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Base64;
import java.util.Locale;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImgSrcHelper {
    private static final Logger logger = LoggerFactory.getLogger(ImgSrcHelper.class);

    public static JSONObject handleImgSrc(String src, String reqURL) {
        String base64Encoder = "";
        String picType = "png";
        byte[] imageBytes = null;
        if (src.contains("base64")) {
            base64Encoder = src.substring(src.indexOf(",") + 1);
            picType = src.substring(0, src.indexOf(",")).replace("data:image/", "").replace(";base64", "");
            imageBytes = Base64.getDecoder().decode(base64Encoder);
        } else {
            boolean srcFlag;
            boolean bl = srcFlag = src.contains(".") && src.lastIndexOf(".") < src.length() - 1;
            if (src.startsWith("/")) {
                if (ObjectUtils.isNotEmpty((Object)reqURL)) {
                    imageBytes = ImgSrcHelper.encodeImageToBytes(reqURL + src);
                    if (srcFlag) {
                        picType = src.substring(src.lastIndexOf(".") + 1);
                    }
                }
            } else {
                imageBytes = ImgSrcHelper.encodeImageToBytes(src);
                if (srcFlag) {
                    picType = src.substring(src.lastIndexOf(".") + 1);
                }
            }
        }
        picType = picType.toLowerCase(Locale.ROOT);
        JSONObject resObj = new JSONObject();
        resObj.put("picType", (Object)picType);
        resObj.put("imgBytes", (Object)imageBytes);
        return resObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] encodeImageToBytes(String imageUrl) {
        InputStream inputStream = null;
        ByteArrayOutputStream outputStream = null;
        byte[] imageBytes = null;
        try {
            int bytesRead;
            inputStream = new URL(imageUrl).openStream();
            outputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            imageBytes = outputStream.toByteArray();
        }
        catch (Exception e) {
            logger.error("\u56fe\u7247\u8f6c\u6362\u5f02\u5e38\uff1a{} imageUrl", (Object)(imageUrl + "errorMsg" + e.getMessage()));
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception e) {
                logger.error("\u56fe\u7247\u8f6c\u6362\u6d41\u5173\u95ed\uff1a{}", (Object)e.getMessage());
            }
        }
        return imageBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject encodeImage(String imageUrl) {
        String base64String = "";
        InputStream inputStream = null;
        ByteArrayOutputStream outputStream = null;
        byte[] imageBytes = null;
        try {
            int bytesRead;
            inputStream = new URL(imageUrl).openStream();
            outputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            imageBytes = outputStream.toByteArray();
            base64String = Base64.getEncoder().encodeToString(imageBytes);
        }
        catch (Exception e) {
            logger.error("encodeImage \u56fe\u7247\u8f6c\u6362\u5f02\u5e38\uff1a{} imageUrl", (Object)(imageUrl + "errorMsg" + e.getMessage()));
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception e) {
                logger.error(" encodeImage \u56fe\u7247\u8f6c\u6362\u6d41\u5173\u95ed\uff1a{}", (Object)e.getMessage());
            }
        }
        JSONObject res = new JSONObject();
        res.put("base64String", (Object)base64String);
        res.put("byteArr", (Object)imageBytes);
        return res;
    }
}

