/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public class DateUtils {
    private static final String[] cnChars = new String[]{"\u3007", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341", "\u5341\u4e00", "\u5341\u4e8c"};

    public static String getTimeStrByLocalDateTime(LocalDateTime localDateTime) {
        DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return localDateTime.format(format);
    }

    public static String getNowYear() {
        Date day = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyy");
        return df.format(day);
    }

    public static String getNowMonth() {
        Date day = new Date();
        SimpleDateFormat df = new SimpleDateFormat("MM");
        return df.format(day);
    }

    public static String getNowDay() {
        Date day = new Date();
        SimpleDateFormat df = new SimpleDateFormat("dd");
        return df.format(day);
    }

    public static String getLastMonth() {
        Calendar cal = Calendar.getInstance();
        cal.add(2, -1);
        SimpleDateFormat dft = new SimpleDateFormat("MM");
        return dft.format(cal.getTime());
    }

    public static String getLastYear() {
        String nowYear = DateUtils.getNowYear();
        return String.valueOf(Integer.valueOf(nowYear) - 1);
    }

    public static String getLastYearMonth() {
        Calendar cal = Calendar.getInstance();
        cal.add(2, -1);
        SimpleDateFormat dft = new SimpleDateFormat("yyyy-MM");
        return dft.format(cal.getTime());
    }

    public static String getLastYearMonth1() {
        Calendar cal = Calendar.getInstance();
        cal.add(2, -1);
        SimpleDateFormat dft = new SimpleDateFormat("yyyy\u5e74MM\u6708");
        return dft.format(cal.getTime());
    }

    public static String getNowDate0() {
        Date day = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyy\u5e74MM\u6708");
        return df.format(day);
    }

    public static String getNowDate() {
        Date day = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM");
        return df.format(day);
    }

    public static String getNowDate2() {
        Date day = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        return df.format(day);
    }

    public static String getNowDate3() {
        Date day = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return df.format(day);
    }

    public static String getNowDate4() {
        Date day = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        return df.format(day);
    }

    public static String getNowDate5() {
        Date day = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        return df.format(day);
    }

    public static String getNowDate6() {
        Date day = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206");
        return df.format(day);
    }

    public static String getNowDate7() {
        Date day = new Date();
        SimpleDateFormat df = new SimpleDateFormat("HH:mm");
        return df.format(day);
    }

    public static String processDate(Timestamp time) {
        String result = "";
        if (time != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
            result = sdf.format(time);
        }
        return result;
    }

    public static String TimestampToTime(Timestamp time) {
        String result = "";
        if (time != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            result = sdf.format(time);
        }
        return result;
    }

    public static String TimestampToTimeSimple(Timestamp time) {
        String result = "";
        if (time != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            result = sdf.format(time);
        }
        return result;
    }

    public static Date processStrToDate(String time) {
        if (time != null) {
            time = time.replace("\u5e74", "-").replace("\u6708", "-").replace("\u65e5", "");
            time = time.replace("/", "-");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date date = null;
        try {
            date = sdf.parse(time);
        }
        catch (ParseException e) {
            System.out.println("\u8f6c\u6362\u5931\u8d25\uff01");
        }
        return date;
    }

    public static String processStrToStr(String time) {
        if (time != null) {
            time = time.replace("\u5e74", "-").replace("\u6708", "-").replace("\u65e5", "");
            time = time.replace("/", "-");
        } else {
            time = "";
        }
        return time;
    }

    public static String processStrToStr1(String time) {
        if (time != null) {
            time = time.substring(0, 10);
            time = time.replace("\u5e74", "-").replace("\u6708", "-").replace("\u65e5", "");
            time = time.replace("/", "-");
        } else {
            time = "";
        }
        return time;
    }

    public static String strProcessDate(String time) {
        String result = "";
        time = time != null ? time.replace("/", "-") : "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date date = sdf.parse(time);
            Timestamp timestamp = new Timestamp(date.getTime());
            result = DateUtils.processDate(timestamp);
        }
        catch (Exception e) {
            System.out.println("\u8f6c\u6362\u5931\u8d25\uff01");
            result = time;
        }
        return result;
    }

    public static String getNextDay(String nowDate) {
        nowDate = DateUtils.processStrToStr(nowDate);
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            calendar.setTime(sdf.parse(nowDate));
        }
        catch (ParseException e) {
            System.out.println("\u83b7\u53d6\u5931\u8d25\uff01");
        }
        calendar.add(6, 1);
        Date date = calendar.getTime();
        return sdf.format(date);
    }

    public static String getLastDay(String nowDate) {
        nowDate = DateUtils.processStrToStr(nowDate);
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            calendar.setTime(sdf.parse(nowDate));
        }
        catch (ParseException e) {
            System.out.println("\u83b7\u53d6\u5931\u8d25\uff01");
        }
        calendar.add(6, -1);
        Date date = calendar.getTime();
        return sdf.format(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> getMonthBetween(String minDate, String maxDate) {
        minDate = DateUtils.processStrToStr(minDate);
        maxDate = DateUtils.processStrToStr(maxDate);
        ArrayList<String> result = new ArrayList<String>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        Calendar min = Calendar.getInstance();
        Calendar max = Calendar.getInstance();
        Boolean flag = true;
        Date dateMin = null;
        Date dateMax = null;
        try {
            dateMin = sdf.parse(minDate);
            return result;
        }
        catch (ParseException e) {
            System.out.println("\u83b7\u53d6\u5931\u8d25\uff01");
            flag = false;
            return flag;
        }
        finally {
            try {
                dateMax = sdf.parse(maxDate);
                return dateMax;
            }
            catch (ParseException e) {
                System.out.println("\u83b7\u53d6\u5931\u8d25\uff01");
                flag = false;
                return flag;
            }
            finally {
                if (flag != true) return result;
                min.setTime(dateMin);
                min.set(min.get(1), min.get(2), 1);
                max.setTime(dateMax);
                max.set(max.get(1), max.get(2), 2);
                Calendar curr = min;
                while (curr.before(max)) {
                    result.add(sdf.format(curr.getTime()));
                    curr.add(2, 1);
                }
                return result;
            }
        }
    }

    public static Date getLastMonthOfDate(Date date) {
        Calendar para = Calendar.getInstance(Locale.CHINA);
        para.setTime(date);
        para.set(5, para.getActualMaximum(5));
        para.set(11, 23);
        para.set(12, 59);
        para.set(13, 59);
        return para.getTime();
    }

    public static String getMonthInCN(int month) {
        return cnChars[month];
    }

    public static String getYearInCN(int year) {
        int[] yearInInt = new int[]{year / 1000, year % 1000 / 100, year % 100 / 10, year % 10};
        StringBuilder result = new StringBuilder();
        for (int i1 : yearInInt) {
            result.append(cnChars[i1]);
        }
        return result.toString();
    }

    public static int[] yearAndMonthValue(Timestamp yearAndMonth) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(yearAndMonth);
        int year = cal.get(1);
        int month = cal.get(2) + 2;
        if (month > 12) {
            month -= 12;
        }
        int[] yearAndMonthArr = new int[]{++year, month};
        return yearAndMonthArr;
    }

    public static int[] yearAndMonthSystem() {
        String nowDate = DateUtils.getNowDate();
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM");
        Date d = null;
        try {
            d = sdf1.parse(nowDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(d);
        int endYear = cal1.get(1);
        int endMonth = cal1.get(2);
        int[] yearAndMonth = new int[]{endYear, endMonth};
        return yearAndMonth;
    }

    public static String getNowDateFormat(String format) {
        Date day = new Date();
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(day);
    }

    public static String getPushForwardForDaysZeroMinutes(int days) {
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyy-MM-dd HH:mm");
        LocalDateTime nowDateTime = LocalDateTime.now();
        LocalDateTime preDate = nowDateTime.minusDays(days);
        preDate = preDate.minusHours(preDate.getHour()).minusMinutes(preDate.getMinute());
        return preDate.format(df);
    }

    public static int getNowDayOfWeek(String now) throws ParseException {
        try {
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
            Date nowdate = sf.parse(now);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(nowdate);
            int w = calendar.get(7) - 1;
            if (w == 0) {
                w = 7;
            }
            return w;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static String getISOTimeFromYMDHM(String timestamp) {
        DateTimeFormatter dtf1 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
        LocalDateTime ldt = LocalDateTime.parse(timestamp, dtf1);
        ZoneOffset offset = ZoneOffset.of("+08:00");
        OffsetDateTime date = OffsetDateTime.of(ldt, offset);
        DateTimeFormatter dtf2 = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");
        return date.format(dtf2) + "+08:00";
    }

    public static String getISOTimeFromYMD(String timestamp) {
        DateTimeFormatter dtf1 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
        LocalDateTime ldt = LocalDateTime.parse(timestamp + " 00:00", dtf1);
        ZoneOffset offset = ZoneOffset.of("+08:00");
        OffsetDateTime date = OffsetDateTime.of(ldt, offset);
        DateTimeFormatter dtf2 = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");
        return date.format(dtf2) + "+08:00";
    }

    public static String getYMDHMFromISOTime(String ISOdate) {
        if (ISOdate.endsWith("+08:00")) {
            ISOdate = ISOdate.substring(0, ISOdate.length() - 6);
        }
        LocalDateTime dt = LocalDateTime.parse(ISOdate);
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyy-MM-dd HH:mm");
        return dt.format(df);
    }

    public static String addDate(String date1, long day) throws ParseException {
        SimpleDateFormat sim = new SimpleDateFormat("yyyy-MM-dd");
        Date date = sim.parse(date1);
        long time = date.getTime();
        day = day * 24L * 60L * 60L * 1000L;
        String newDate = sim.format(new Date(time += day));
        return newDate;
    }

    public static Long getDurationSecond(Timestamp startTime, Timestamp endTime) {
        if (Objects.isNull(startTime) || Objects.isNull(endTime)) {
            return null;
        }
        Duration duration = Duration.between(startTime.toLocalDateTime(), endTime.toLocalDateTime());
        return duration.getSeconds();
    }

    public static String hexTimestamp() {
        return Long.toHexString(System.currentTimeMillis());
    }
}

