/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils;

import com.jxdinfo.document.excel.tools.core.common.utils.WpsThemeColorUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.util.Units;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class CalUtil {
    public static final double WIDTH_CORRECTION_FACTOR = 0.8;
    public static final double CUSTOM_GREATER_WIDTH_CORRECTION_FACTOR = 0.88;
    public static final double CUSTOM_LESS_WIDTH_CORRECTION_FACTOR = 0.9;

    public static int getFirstRowBase0(Sheet sheet) {
        int firstRowNum = sheet.getFirstRowNum();
        return Math.max(firstRowNum, 0);
    }

    public static short getMaxColNum(Sheet sheet) {
        short maxColNum = 0;
        for (int i = CalUtil.getFirstRowBase0(sheet); i <= sheet.getLastRowNum(); ++i) {
            Row row = sheet.getRow(i);
            if (row == null) continue;
            maxColNum = (short)Math.max(maxColNum, row.getLastCellNum());
        }
        return maxColNum;
    }

    public static String getColor(XSSFWorkbook workbook, XSSFColor bgColor) {
        if (bgColor == null) {
            return null;
        }
        byte[] rgb = bgColor.getRGBWithTint();
        String argbString = bgColor.getARGBHex();
        return bgColor.getTheme() > 0 ? WpsThemeColorUtil.getColorFromTheme(workbook, bgColor.getTheme(), bgColor.getTint()) : (rgb == null ? CalUtil.argbToColorString(argbString) : CalUtil.rgbToColorString(rgb));
    }

    public static String argbToColorString(String argbHex) {
        if (argbHex == null) {
            return null;
        }
        if (argbHex.length() == 8 && argbHex.startsWith("FF")) {
            return "#" + argbHex.substring(2);
        }
        return null;
    }

    public static String rgbToColorString(byte[] rgb) {
        if (rgb == null || rgb.length != 3) {
            return null;
        }
        return String.format("#%02X%02X%02X", rgb[0] & 0xFF, rgb[1] & 0xFF, rgb[2] & 0xFF);
    }

    public static int twips2Pixel(int twips) {
        double points = (double)twips / 20.0;
        return Units.pointsToPixel((double)points);
    }

    public static int characterLen2Pixel(int characterLen) {
        return (int)Math.round((double)((float)characterLen * 7.0017f) / 0.8);
    }

    public static int getColumnWidthPixel(double columnWidthInPixels) {
        int doubleColumnWidth = (int)Math.round(columnWidthInPixels);
        int nowColumnWidth = (int)Math.round(columnWidthInPixels / 0.8);
        if (nowColumnWidth > 70) {
            nowColumnWidth = (double)doubleColumnWidth > columnWidthInPixels ? (int)(columnWidthInPixels / 0.88) - 1 : (int)(columnWidthInPixels / 0.88);
        }
        if (nowColumnWidth < 70) {
            nowColumnWidth = (double)doubleColumnWidth > columnWidthInPixels ? (int)(columnWidthInPixels / 0.9) - 1 : (int)(columnWidthInPixels / 0.9);
        }
        return nowColumnWidth;
    }
}

