/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils.offLine;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadUtil {
    private static final Logger logger = LoggerFactory.getLogger(DownloadUtil.class);

    public static DownloadResult FileDownloader(Map<String, Object> param) {
        String outputType;
        String fileUrl = param.get("filePath").toString();
        String pathDirectory = param.get("pathDirectory").toString();
        String string = outputType = param.get("outputType") != null ? param.get("outputType").toString() : "";
        if (fileUrl.contains(pathDirectory)) {
            String[] parts = fileUrl.split(pathDirectory);
            String afterUploads = parts[1].substring(1);
            List<String> nameParts = Arrays.asList(afterUploads.split("/"));
            String fileName = nameParts.get(0);
            String localDirectory = param.get("localDirectory").toString() + pathDirectory + "/";
            if (nameParts.size() > 1) {
                localDirectory = localDirectory + nameParts.get(0) + "/";
                fileName = nameParts.get(1);
            }
            Path targetPath = Paths.get(localDirectory, fileName);
            logger.error("\u79bb\u7ebf\u4e0b\u8f7d-\u57fa\u7840\u8def\u5f84{}", (Object)targetPath);
            return DownloadUtil.downloadFile(fileUrl, targetPath, outputType);
        }
        if (fileUrl.contains("reportImg")) {
            int endIndex = fileUrl.endsWith("/") ? fileUrl.length() - 1 : fileUrl.length();
            int lastSlashIndex = fileUrl.lastIndexOf(47, endIndex - 1);
            String fileName = fileUrl.substring(lastSlashIndex + 1, endIndex);
            String localDirectory = param.get("localDirectory").toString() + "/";
            Path targetPath = Paths.get(localDirectory, fileName);
            logger.error("\u79bb\u7ebf\u4e0b\u8f7d-\u57fa\u7840\u8def\u5f84{}", (Object)targetPath);
            return DownloadUtil.downloadFile(fileUrl, targetPath, outputType);
        }
        String fileName = IdWorker.get32UUID() + ".png";
        String localDirectory = param.get("localDirectory").toString() + "/";
        Path targetPath = Paths.get(localDirectory, fileName);
        return DownloadUtil.downloadFile(fileUrl, targetPath, outputType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DownloadResult downloadFile(String fileUrl, Path targetPath, String outputType) {
        HttpURLConnection connection = null;
        InputStream inputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int bytesRead;
            URL url = new URL(fileUrl);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            inputStream = connection.getInputStream();
            byte[] chunk = new byte[4096];
            while ((bytesRead = inputStream.read(chunk)) != -1) {
                byteArrayOutputStream.write(chunk, 0, bytesRead);
            }
            inputStream.close();
            if ("base64".equalsIgnoreCase(outputType)) {
                String base64String = Base64.getEncoder().encodeToString(byteArrayOutputStream.toByteArray());
                logger.error("\u79bb\u7ebf\u4e0b\u8f7d-base64{}", (Object)base64String);
                String mimeType = DownloadUtil.detectMimeType(targetPath);
                String base64WithPrefix = "data:" + mimeType + ";base64," + base64String;
                DownloadResult downloadResult = new DownloadResult(targetPath, base64WithPrefix);
                return downloadResult;
            }
            byte[] data = byteArrayOutputStream.toByteArray();
            DownloadResult downloadResult = new DownloadResult(targetPath, data);
            return downloadResult;
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error("\u79bb\u7ebf\u4e0b\u8f7d error{}", (Object)e.getMessage());
            DownloadResult downloadResult = new DownloadResult(Paths.get("", new String[0]), (String)null);
            return downloadResult;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (connection != null) {
                    connection.disconnect();
                }
                byteArrayOutputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static String detectMimeType(Path filePath) {
        try {
            String contentType = Files.probeContentType(filePath);
            if (contentType != null) {
                return contentType;
            }
        }
        catch (IOException e) {
            logger.warn("\u65e0\u6cd5\u81ea\u52a8\u68c0\u6d4bMIME\u7c7b\u578b", (Throwable)e);
        }
        String fileName = filePath.getFileName().toString().toLowerCase();
        if (fileName.endsWith(".jpg") || fileName.endsWith(".jpeg")) {
            return "image/jpeg";
        }
        if (fileName.endsWith(".png")) {
            return "image/png";
        }
        if (fileName.endsWith(".gif")) {
            return "image/gif";
        }
        if (fileName.endsWith(".bmp")) {
            return "image/bmp";
        }
        if (fileName.endsWith(".webp")) {
            return "image/webp";
        }
        return "application/octet-stream";
    }

    public static class DownloadResult {
        private Path filePath;
        private String base64;
        private byte[] bytes;

        public DownloadResult(Path filePath, String base64) {
            this.filePath = filePath;
            this.base64 = base64;
            this.bytes = null;
        }

        public DownloadResult(Path filePath, byte[] bytes) {
            this.filePath = filePath;
            this.base64 = null;
            this.bytes = bytes;
        }

        public Path getFilePath() {
            return this.filePath;
        }

        public String getBase64() {
            return this.base64;
        }

        public byte[] getBytes() {
            return this.bytes;
        }
    }
}

