/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils.excel.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;

public class ReportCellWHHelper {
    private JSONObject rowHidden;
    private JSONObject colHidden;
    private int defaultRow;
    private int defaultCol;
    private JSONArray visibleDataRow;
    private JSONArray visibleDataColumn;

    public JSONArray getVisibleDataRow() {
        return this.visibleDataRow;
    }

    public JSONArray getVisibleDataColumn() {
        return this.visibleDataColumn;
    }

    public ReportCellWHHelper(JSONObject sheetJson) {
        if (sheetJson.containsKey((Object)"config")) {
            JSONObject config = sheetJson.getJSONObject("config");
            this.rowHidden = config.containsKey((Object)"rowhidden") ? config.getJSONObject("rowhidden") : null;
            this.colHidden = config.containsKey((Object)"colhidden") ? config.getJSONObject("colhidden") : null;
            this.defaultRow = config.containsKey((Object)"row") ? config.getIntValue("row") : 84;
            this.defaultCol = config.containsKey((Object)"column") ? config.getIntValue("column") : 60;
        }
    }

    public void setCellWH(XSSFSheet sheet, JSONArray visibledatarow, JSONArray visibledatacolumn) {
        int i;
        if (visibledatarow == null) {
            visibledatarow = new JSONArray();
            for (i = 0; i < this.defaultRow; ++i) {
                visibledatarow.add(i, (Object)((i + 1) * 25));
            }
            this.visibleDataRow = visibledatarow;
        }
        if (visibledatacolumn == null) {
            visibledatacolumn = new JSONArray();
            for (i = 0; i < this.defaultCol; ++i) {
                visibledatacolumn.add(i, (Object)((i + 1) * 76));
            }
            this.visibleDataColumn = visibledatacolumn;
        }
        for (i = 0; i < visibledatarow.size(); ++i) {
            XSSFRow row = sheet.createRow(i);
            if (this.rowHidden != null && this.rowHidden.containsKey((Object)i)) {
                row.setZeroHeight(true);
                row.setHeight((short)0);
                continue;
            }
            float rowHeight = i == 0 ? visibledatarow.getFloat(i).floatValue() - 1.0f : visibledatarow.getFloat(i).floatValue() - visibledatarow.getFloat(i - 1).floatValue() - 1.0f;
            row.setHeightInPoints(rowHeight / 96.0f * 72.0f);
        }
        for (int j = 0; j < visibledatacolumn.size(); ++j) {
            if (this.colHidden != null && this.colHidden.containsKey((Object)j)) {
                sheet.setColumnWidth(j, 0);
                sheet.setColumnHidden(j, true);
                continue;
            }
            int colHeight = j == 0 ? visibledatacolumn.getIntValue(j) - 1 : visibledatacolumn.getIntValue(j) - visibledatacolumn.getIntValue(j - 1) - 1;
            sheet.setColumnWidth(j, colHeight * 33);
        }
    }
}

