/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils.excel.processor;

import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFPicture;
import org.apache.poi.xssf.usermodel.XSSFShape;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class CopyPicturesProcessor {
    private static final int PICTURE_TYPE_EMF = 2;
    private static final int PICTURE_TYPE_WMF = 3;
    private static final int PICTURE_TYPE_PICT = 4;
    private static final int PICTURE_TYPE_JPEG = 5;
    private static final int PICTURE_TYPE_PNG = 6;
    private static final int PICTURE_TYPE_DIB = 7;

    public static void copyPictures(XSSFSheet srcSheet, XSSFSheet destSheet, XSSFWorkbook destWorkbook) {
        XSSFDrawing srcDrawing = srcSheet.getDrawingPatriarch();
        if (srcDrawing == null) {
            return;
        }
        XSSFDrawing destDrawing = destSheet.createDrawingPatriarch();
        if (destDrawing == null) {
            destDrawing = destSheet.createDrawingPatriarch();
        }
        for (XSSFShape shape : srcDrawing.getShapes()) {
            if (!(shape instanceof XSSFPicture)) continue;
            XSSFPicture srcPicture = (XSSFPicture)shape;
            try {
                byte[] pictureData = srcPicture.getPictureData().getData();
                int format = CopyPicturesProcessor.getPictureFormat(srcPicture.getPictureData().getPictureType());
                int pictureIndex = destWorkbook.addPicture(pictureData, format);
                XSSFClientAnchor srcAnchor = (XSSFClientAnchor)srcPicture.getAnchor();
                XSSFClientAnchor destAnchor = destWorkbook.getCreationHelper().createClientAnchor();
                destAnchor.setCol1((int)srcAnchor.getCol1());
                destAnchor.setRow1(srcAnchor.getRow1());
                destAnchor.setCol2((int)srcAnchor.getCol2());
                destAnchor.setRow2(srcAnchor.getRow2());
                destAnchor.setDx1(srcAnchor.getDx1());
                destAnchor.setDy1(srcAnchor.getDy1());
                destAnchor.setDx2(srcAnchor.getDx2());
                destAnchor.setDy2(srcAnchor.getDy2());
                destDrawing.createPicture((ClientAnchor)destAnchor, pictureIndex);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static int getPictureFormat(int pictureType) {
        switch (pictureType) {
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 7;
            }
        }
        return 6;
    }
}

