/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils.excel.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.document.excel.tools.core.common.utils.StringUtil;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.cache.StyleCache;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.helper.ImgSrcHelper;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.helper.ReportCellStyleHelper;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.helper.ReportFontHelper;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ReportCellContentHelper {
    private final XSSFWorkbook wb;
    private final StyleCache styleCache;

    public ReportCellContentHelper(XSSFWorkbook wb, StyleCache styleCache) {
        this.wb = wb;
        this.styleCache = styleCache;
    }

    public void setDefaultCellContent(XSSFCell cell, XSSFCellStyle cellStyle, String value) {
        cell.setCellStyle((CellStyle)cellStyle);
        if (value == null) {
            return;
        }
        cell.setCellValue(value);
    }

    public void setCellContent(XSSFCell cell, XSSFCellStyle cellStyle, CellType cellType, String value) {
        this.setCellStyleAndType(cell, cellStyle, cellType);
        if (value == null) {
            return;
        }
        if (cellType.equals((Object)CellType.NUMERIC) && StringUtil.isNumber(value)) {
            cell.setCellValue(Double.parseDouble(value));
        } else {
            cell.setCellValue(value);
        }
    }

    public void setCellContent(XSSFCell cell, XSSFCellStyle cellStyle, CellType cellType, Date value) {
        this.setCellStyleAndType(cell, cellStyle, cellType);
        if (value == null) {
            return;
        }
        cell.setCellValue(value);
    }

    public void setCellStyleAndType(XSSFCell cell, XSSFCellStyle cellStyle, CellType cellType) {
        cell.setCellStyle((CellStyle)this.styleCache.getStyle(this.wb, cellStyle));
        cell.setCellType(cellType);
    }

    public void dealCellContextHtml(String cgid, String v, JSONObject htmlData, String reqURL, XSSFSheet sheet, XSSFCell cell, XSSFCellStyle cellStyle, JSONObject jsonObjectValueCell) {
        JSONArray htmlJsonArray = htmlData.getJSONArray(cgid);
        if (CollectionUtils.isEmpty((Collection)htmlJsonArray)) {
            this.setCellContent(cell, cellStyle, CellType.STRING, v);
            return;
        }
        this.dealCellContextSelf(htmlJsonArray, reqURL, sheet, cell, jsonObjectValueCell);
    }

    public void dealCellContextSelf(JSONArray dataArray, String reqURL, XSSFSheet sheet, XSSFCell cell, JSONObject jsonObjectValueCell) {
        XSSFRichTextString richText = new XSSFRichTextString();
        XSSFFont firstLineFont = null;
        for (int i = 0; i < dataArray.size(); ++i) {
            JSONObject jsonObjectValue = dataArray.getJSONObject(i);
            String srcString = jsonObjectValue.getString("src");
            if (StringUtils.isNotBlank((CharSequence)srcString)) {
                int rowIndex = cell.getRow().getRowNum();
                int columnIndex = cell.getColumnIndex();
                this.dealCellContextImages(sheet, srcString, reqURL, rowIndex, columnIndex);
                continue;
            }
            String text = jsonObjectValue.getString("v").replace("\r\n", "\n");
            XSSFFont font = ReportFontHelper.createFont(this.wb, this.styleCache, jsonObjectValue);
            richText.append(text, font);
            if (firstLineFont != null) continue;
            firstLineFont = font;
        }
        XSSFCellStyle style = this.wb.createCellStyle();
        ReportCellStyleHelper.textBeak(jsonObjectValueCell, style);
        if (firstLineFont != null) {
            style.setFont(firstLineFont);
        }
        ReportCellStyleHelper.alignment(jsonObjectValueCell, style);
        ReportCellStyleHelper.backGround(jsonObjectValueCell, style);
        cell.setCellStyle((CellStyle)this.styleCache.getStyle(this.wb, style));
        cell.setCellValue((RichTextString)richText);
    }

    private void dealCellContextImages(XSSFSheet sheet, String src, String reqURL, int rowIndex, int columnIndex) {
        XSSFDrawing patriarch = sheet.createDrawingPatriarch();
        if (ObjectUtils.isNotEmpty((Object)src) && (src.contains("base64") || src.startsWith("/") || src.startsWith("http"))) {
            XSSFClientAnchor anchor = this.wb.getCreationHelper().createClientAnchor();
            anchor.setCol1(columnIndex);
            anchor.setRow1(rowIndex);
            anchor.setCol2(columnIndex + 1);
            anchor.setRow2(rowIndex + 1);
            JSONObject imgRes = ImgSrcHelper.handleImgSrc(src, reqURL);
            String picType = imgRes.getString("picType");
            byte[] imgBytes = imgRes.getBytes("imgBytes");
            if (ObjectUtils.isEmpty((Object)imgBytes)) {
                return;
            }
            int format = 6;
            switch (picType) {
                case "jpeg": {
                    format = 5;
                    break;
                }
                case "emf": {
                    format = 2;
                    break;
                }
                case "dib": {
                    format = 7;
                    break;
                }
                case "pict": {
                    format = 4;
                    break;
                }
                case "wmf": {
                    format = 3;
                    break;
                }
            }
            patriarch.createPicture((ClientAnchor)anchor, this.wb.addPicture(imgBytes, format));
        }
    }

    public void dealCellContextData(String fa, String m, String v, XSSFCell cell, XSSFCellStyle cellStyle) {
        if (!this.isValidDateFormat(fa) || StringUtils.isEmpty((CharSequence)m)) {
            this.setCellContent(cell, cellStyle, CellType.STRING, v);
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(fa);
        try {
            Date date = sdf.parse(m);
            this.setCellContent(cell, cellStyle, CellType.NUMERIC, date);
        }
        catch (ParseException e) {
            System.err.println("\u65e5\u671f\u89e3\u6790\u5931\u8d25: " + e.getMessage());
            if (StringUtils.isBlank((CharSequence)m)) {
                this.setCellContent(cell, cellStyle, CellType.STRING, v);
            }
            this.setCellContent(cell, cellStyle, CellType.STRING, m);
        }
    }

    private boolean isValidDateFormat(String format) {
        try {
            new SimpleDateFormat(format);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public void dealCellContextType(String checkType, String checked, String v, XSSFCell cell, XSSFCellStyle cellStyle, JSONObject jsonObjectValueCell) {
        String[] vArray;
        ArrayList<String> typeDataList = new ArrayList<String>();
        for (String vS : vArray = v.split(",")) {
            typeDataList.add(checkType);
            typeDataList.add(vS);
        }
        if (CollectionUtils.isEmpty(typeDataList)) {
            this.setCellContent(cell, cellStyle, CellType.STRING, v);
            return;
        }
        this.dealCellContextSelfType(checked, typeDataList, cell, jsonObjectValueCell);
    }

    private void dealCellContextSelfType(String checked, List<String> typeDataList, XSSFCell cell, JSONObject jsonObjectValueCell) {
        XSSFRichTextString richText = new XSSFRichTextString();
        XSSFFont firstLineFont = null;
        for (int i = 0; i < typeDataList.size(); ++i) {
            String text = typeDataList.get(i);
            String textNext = i < typeDataList.size() - 1 ? typeDataList.get(i + 1) : null;
            XSSFFont font = ReportFontHelper.createFont(this.wb, this.styleCache, jsonObjectValueCell);
            if (text.equals("radio") || text.equals("checkBox")) {
                font.setFontName("Wingdings 2");
                if (text.equals("radio")) {
                    if (checked.equals(textNext)) {
                        richText.append("\u25cf  ", font);
                    } else {
                        richText.append("\u25cb ", font);
                    }
                } else if (textNext != null && checked.contains(textNext)) {
                    richText.append("\u2611 ", font);
                } else {
                    richText.append("\u2610 ", font);
                }
                text = "";
            } else if (firstLineFont == null) {
                firstLineFont = font;
            }
            richText.append(text, font);
        }
        XSSFCellStyle style = this.wb.createCellStyle();
        ReportCellStyleHelper.textBeak(jsonObjectValueCell, style);
        if (firstLineFont != null) {
            style.setFont(firstLineFont);
        }
        ReportCellStyleHelper.alignment(jsonObjectValueCell, style);
        ReportCellStyleHelper.backGround(jsonObjectValueCell, style);
        cell.setCellStyle((CellStyle)this.styleCache.getStyle(this.wb, style));
        cell.setCellValue((RichTextString)richText);
    }
}

