/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils.excel.entity;

import com.jxdinfo.document.excel.tools.core.common.utils.excel.helper.ColorHelper;
import java.util.Objects;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;

public class BorderKey {
    private final BorderStyle borderTop;
    private final BorderStyle borderBottom;
    private final BorderStyle borderLeft;
    private final BorderStyle borderRight;
    private final XSSFColor topBorderColor;
    private final XSSFColor bottomBorderColor;
    private final XSSFColor leftBorderColor;
    private final XSSFColor rightBorderColor;

    public BorderKey(XSSFCellStyle style) {
        this.borderTop = style.getBorderTop();
        this.borderBottom = style.getBorderBottom();
        this.borderLeft = style.getBorderLeft();
        this.borderRight = style.getBorderRight();
        this.topBorderColor = style.getTopBorderXSSFColor();
        this.bottomBorderColor = style.getBottomBorderXSSFColor();
        this.leftBorderColor = style.getLeftBorderXSSFColor();
        this.rightBorderColor = style.getRightBorderXSSFColor();
    }

    public BorderKey(BorderStyle borderTop, BorderStyle borderBottom, BorderStyle borderLeft, BorderStyle borderRight, XSSFColor topBorderColor, XSSFColor bottomBorderColor, XSSFColor rightBorderColor, XSSFColor leftBorderColor) {
        this.borderTop = borderTop;
        this.borderBottom = borderBottom;
        this.borderLeft = borderLeft;
        this.borderRight = borderRight;
        this.topBorderColor = topBorderColor;
        this.bottomBorderColor = bottomBorderColor;
        this.rightBorderColor = rightBorderColor;
        this.leftBorderColor = leftBorderColor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BorderKey borderKey = (BorderKey)o;
        return this.borderTop == borderKey.borderTop && this.borderBottom == borderKey.borderBottom && this.borderLeft == borderKey.borderLeft && this.borderRight == borderKey.borderRight && this.colorEquals(this.topBorderColor, borderKey.topBorderColor) && this.colorEquals(this.bottomBorderColor, borderKey.bottomBorderColor) && this.colorEquals(this.leftBorderColor, borderKey.leftBorderColor) && this.colorEquals(this.rightBorderColor, borderKey.rightBorderColor);
    }

    public int hashCode() {
        return Objects.hash(this.borderTop, this.borderBottom, this.borderLeft, this.borderRight, this.colorHashCode(this.topBorderColor), this.colorHashCode(this.bottomBorderColor), this.colorHashCode(this.leftBorderColor), this.colorHashCode(this.rightBorderColor));
    }

    public BorderStyle getBorderTop() {
        return this.borderTop;
    }

    public BorderStyle getBorderBottom() {
        return this.borderBottom;
    }

    public BorderStyle getBorderLeft() {
        return this.borderLeft;
    }

    public BorderStyle getBorderRight() {
        return this.borderRight;
    }

    public XSSFColor getTopBorderColor() {
        return this.topBorderColor;
    }

    public XSSFColor getBottomBorderColor() {
        return this.bottomBorderColor;
    }

    public XSSFColor getLeftBorderColor() {
        return this.leftBorderColor;
    }

    public XSSFColor getRightBorderColor() {
        return this.rightBorderColor;
    }

    public static BorderKey getBorderKeyStyle(boolean hasTop, boolean hasLeft, boolean hasRight, boolean hasBottom, BorderStyle borderStyle, XSSFColor color) {
        XSSFColor blackColor = ColorHelper.getDefaultColor();
        return new BorderKey(hasTop ? borderStyle : BorderStyle.NONE, hasBottom ? borderStyle : BorderStyle.NONE, hasLeft ? borderStyle : BorderStyle.NONE, hasRight ? borderStyle : BorderStyle.NONE, hasTop ? color : blackColor, hasBottom ? color : blackColor, hasLeft ? color : blackColor, hasRight ? color : blackColor);
    }

    private boolean colorEquals(XSSFColor c1, XSSFColor c2) {
        if (c1 == null && c2 == null) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        String argb1 = c1.getARGBHex();
        String argb2 = c2.getARGBHex();
        return Objects.equals(argb1, argb2);
    }

    private String colorHashCode(XSSFColor color) {
        if (color == null) {
            return null;
        }
        return color.getARGBHex();
    }
}

