/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils.mergeCells;

import com.jxdinfo.document.excel.tools.core.common.utils.mergeCells.MergeGroup;
import com.jxdinfo.document.excel.tools.core.common.utils.mergeCells.MergeRegion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;

public class MergeGroupRecursive {
    private List<String> mergeColumnsList = new ArrayList<String>();
    private Map<String, Integer> columnIndexCache = new HashMap<String, Integer>();

    public MergeGroupRecursive(List<String> mergeColumnsList) {
        this.mergeColumnsList = mergeColumnsList;
    }

    public MergeGroup buildMergeGroups(List<Map<String, Object>> rows, List<String> groupColumns, List<String> conditionColumns, int currentLevel, List<MergeRegion> mergeRegions, int parentStartIndex) {
        if (currentLevel >= groupColumns.size()) {
            this.processConditionColumns(rows, conditionColumns, mergeRegions, parentStartIndex);
            return new MergeGroup(rows, currentLevel);
        }
        String currentColumn = groupColumns.get(currentLevel);
        this.generateGroupMergeRegion(rows, currentColumn, mergeRegions, parentStartIndex);
        LinkedHashMap<String, MergeGroup> groups = new LinkedHashMap<String, MergeGroup>();
        int currentStartIndex = parentStartIndex;
        for (List<Map<String, Object>> subList : this.partitionByColumn(rows, currentColumn)) {
            String key = (String)subList.get(0).get(currentColumn);
            int childStart = currentStartIndex;
            groups.put(key, this.buildMergeGroups(subList, groupColumns, conditionColumns, currentLevel + 1, mergeRegions, childStart));
            currentStartIndex += subList.size();
        }
        MergeGroup parentGroup = new MergeGroup(rows, currentLevel);
        parentGroup.setSubGroups(groups);
        return parentGroup;
    }

    private List<List<Map<String, Object>>> partitionByColumn(List<Map<String, Object>> rows, String column) {
        ArrayList<List<Map<String, Object>>> partitions = new ArrayList<List<Map<String, Object>>>();
        if (rows == null || rows.isEmpty()) {
            return partitions;
        }
        ArrayList<Map<String, Object>> currentGroup = new ArrayList<Map<String, Object>>();
        String previousValue = null;
        for (Map<String, Object> row : rows) {
            String currentValue = MergeGroupRecursive.buildCompositeKey(row, column);
            if (previousValue == null || currentValue.equals(previousValue)) {
                currentGroup.add(row);
            } else {
                partitions.add(currentGroup);
                currentGroup = new ArrayList();
                currentGroup.add(row);
            }
            previousValue = currentValue;
        }
        if (!currentGroup.isEmpty()) {
            partitions.add(currentGroup);
        }
        return partitions;
    }

    private static String buildCompositeKey(Map<String, Object> row, String column) {
        Object value = row.getOrDefault(column, "");
        return value.toString().trim().replaceAll("\\s+", "").replaceAll("[^a-zA-Z0-9\\u4e00-\\u9fa5]", "");
    }

    private void generateGroupMergeRegion(List<Map<String, Object>> rows, String currentColumn, List<MergeRegion> mergeRegions, int startIndex) {
        if (CollectionUtils.isEmpty(rows)) {
            return;
        }
        int startMergeRow = 0;
        Object previousValue = null;
        int columnIndex = this.getColumnIndex(currentColumn);
        for (int i = 0; i < rows.size(); ++i) {
            Object currentValue = rows.get(i).get(currentColumn);
            if (i == rows.size() - 1 || !Objects.equals(currentValue, previousValue)) {
                int endRow;
                if (i > 0 && Objects.equals(previousValue, currentValue)) {
                    endRow = startIndex + i + 1;
                    mergeRegions.add(new MergeRegion(startIndex + startMergeRow, endRow, columnIndex));
                } else if (previousValue != null && i > startMergeRow) {
                    endRow = startIndex + i;
                    mergeRegions.add(new MergeRegion(startIndex + startMergeRow, endRow, columnIndex));
                }
                startMergeRow = i;
            }
            previousValue = currentValue;
        }
    }

    private void processConditionColumns(List<Map<String, Object>> rows, List<String> conditionColumns, List<MergeRegion> mergeRegions, int startIndex) {
        if (CollectionUtils.isEmpty(conditionColumns) || CollectionUtils.isEmpty(rows)) {
            return;
        }
        for (String col : conditionColumns) {
            int startMergeRow = 0;
            int columnIndex = this.getColumnIndex(col);
            for (int i = 0; i < rows.size(); ++i) {
                String nextValue;
                String currentValue = MergeGroupRecursive.buildCompositeKey(rows.get(i), col);
                boolean isLastRow = i == rows.size() - 1;
                String string = nextValue = isLastRow ? null : MergeGroupRecursive.buildCompositeKey(rows.get(i + 1), col);
                if (!isLastRow && currentValue.equals(nextValue)) continue;
                int firstRow = startIndex + startMergeRow;
                int lastRow = startIndex + i + 1;
                mergeRegions.add(new MergeRegion(firstRow, lastRow, columnIndex));
                startMergeRow = i + 1;
            }
        }
    }

    private int getColumnIndex(String colName) {
        return this.columnIndexCache.computeIfAbsent(colName, k -> this.mergeColumnsList.indexOf(k));
    }

    public List<String> getMergeColumnsList() {
        return this.mergeColumnsList;
    }

    public void setMergeColumnsList(List<String> mergeColumnsList) {
        this.mergeColumnsList = mergeColumnsList;
    }

    public Map<String, Integer> getColumnIndexCache() {
        return this.columnIndexCache;
    }

    public void setColumnIndexCache(Map<String, Integer> columnIndexCache) {
        this.columnIndexCache = columnIndexCache;
    }
}

