/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils.excel.helper;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.helper.ColorHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;

public class ReportCellStyleHelper {
    public static void alignment(JSONObject jsonObjectValue, XSSFCellStyle cellStyle) {
        if (jsonObjectValue.get((Object)"ht") != null) {
            switch (jsonObjectValue.getInteger("ht")) {
                case 0: {
                    cellStyle.setAlignment(HorizontalAlignment.CENTER);
                    break;
                }
                case 1: {
                    cellStyle.setAlignment(HorizontalAlignment.LEFT);
                    break;
                }
                case 2: {
                    cellStyle.setAlignment(HorizontalAlignment.RIGHT);
                }
            }
        } else {
            cellStyle.setAlignment(HorizontalAlignment.CENTER);
        }
        if (jsonObjectValue.get((Object)"vt") != null) {
            switch (jsonObjectValue.getInteger("vt")) {
                case 0: {
                    cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
                    break;
                }
                case 1: {
                    cellStyle.setVerticalAlignment(VerticalAlignment.TOP);
                    break;
                }
                case 2: {
                    cellStyle.setVerticalAlignment(VerticalAlignment.BOTTOM);
                }
            }
        } else {
            cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        }
    }

    public static void backGround(JSONObject jsonObjectValue, XSSFCellStyle cellStyle) {
        if (jsonObjectValue.get((Object)"bg") != null) {
            String bg = jsonObjectValue.get((Object)"bg").toString();
            cellStyle.setFillForegroundColor(ColorHelper.parseColorToXSSF(bg));
            cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        }
    }

    public static void textBeak(JSONObject jsonObjectValue, XSSFCellStyle cellStyle) {
        if (jsonObjectValue.containsKey((Object)"tb")) {
            String tb = jsonObjectValue.get((Object)"tb").toString();
            cellStyle.setWrapText(StringUtils.equals((CharSequence)"2", (CharSequence)tb));
        }
    }
}

