/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils.excel.helper;

import com.jxdinfo.document.excel.tools.core.common.utils.excel.constant.ExcelConstant;
import java.awt.Color;
import org.apache.poi.xssf.usermodel.XSSFColor;

public class ColorHelper {
    public static XSSFColor getDefaultColor() {
        String colorStr = ExcelConstant.fc_FontColor.get("Black");
        String[] colors = colorStr.split(",");
        Color color = new Color(Integer.parseInt(ColorHelper.colorFormat(colors), 16));
        return new XSSFColor(color, null);
    }

    public static XSSFColor parseColorToXSSF(String colorStr) {
        if (colorStr.contains("#")) {
            colorStr = colorStr.substring(1);
            Color color = new Color(Integer.parseInt(colorStr, 16));
            return new XSSFColor(color, null);
        }
        if (ExcelConstant.fc_FontColor.containsKey(colorStr)) {
            colorStr = ExcelConstant.fc_FontColor.get(colorStr);
            String[] colors = colorStr.split(",");
            Color color = new Color(Integer.parseInt(ColorHelper.colorFormat(colors), 16));
            return new XSSFColor(color, null);
        }
        if (colorStr.contains("(") && colorStr.contains(")")) {
            int strStartIndex = colorStr.indexOf("(");
            int strEndIndex = colorStr.indexOf(")");
            String[] colors = colorStr.substring(strStartIndex + 1, strEndIndex).split(",");
            Color color = new Color(Integer.parseInt(ColorHelper.colorFormat(colors), 16));
            return new XSSFColor(color, null);
        }
        if ("transparent".equals(colorStr)) {
            colorStr = ExcelConstant.fc_FontColor.get("White");
            String[] colors = colorStr.split(",");
            Color color = new Color(Integer.parseInt(ColorHelper.colorFormat(colors), 16));
            return new XSSFColor(color, null);
        }
        colorStr = ExcelConstant.fc_FontColor.get("Black");
        String[] colors = colorStr.split(",");
        Color color = new Color(Integer.parseInt(ColorHelper.colorFormat(colors), 16));
        return new XSSFColor(color, null);
    }

    private static String colorFormat(String[] colors) {
        String R = Integer.toHexString(Integer.parseInt(colors[0].replaceAll(" ", "")));
        R = R.length() < 2 ? '0' + R : R;
        String B = Integer.toHexString(Integer.parseInt(colors[1].replaceAll(" ", "")));
        B = B.length() < 2 ? '0' + B : B;
        String G = Integer.toHexString(Integer.parseInt(colors[2].replaceAll(" ", "")));
        G = G.length() < 2 ? '0' + G : G;
        return R + B + G;
    }
}

