/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils.excel.processor;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.springframework.util.CollectionUtils;

public class CopyDataValidationsProcessor {
    public static void copyDataValidations(XSSFSheet sourceSheet, XSSFSheet targetSheet) {
        DataValidationHelper sourceHelper = sourceSheet.getDataValidationHelper();
        if (Objects.isNull(sourceHelper)) {
            return;
        }
        List sourceValidations = sourceSheet.getDataValidations();
        if (CollectionUtils.isEmpty((Collection)sourceValidations)) {
            return;
        }
        DataValidationHelper targetHelper = targetSheet.getDataValidationHelper();
        for (DataValidation sourceValidation : sourceValidations) {
            DataValidationConstraint sourceConstraint = sourceValidation.getValidationConstraint();
            CellRangeAddressList addressList = sourceValidation.getRegions();
            DataValidationConstraint targetConstraint = null;
            switch (sourceConstraint.getValidationType()) {
                case 3: {
                    String listFormula = sourceConstraint.getFormula1();
                    targetConstraint = targetHelper.createFormulaListConstraint(listFormula);
                    break;
                }
                case 1: 
                case 2: {
                    targetConstraint = targetHelper.createNumericConstraint(sourceConstraint.getValidationType(), sourceConstraint.getOperator(), sourceConstraint.getFormula1(), sourceConstraint.getFormula2());
                    break;
                }
                case 4: {
                    targetConstraint = targetHelper.createDateConstraint(sourceConstraint.getOperator(), sourceConstraint.getFormula1(), sourceConstraint.getFormula2(), "yyyy-MM-dd");
                    break;
                }
                case 7: {
                    targetConstraint = targetHelper.createCustomConstraint(sourceConstraint.getFormula1());
                    break;
                }
                default: {
                    targetConstraint = targetHelper.createExplicitListConstraint(sourceConstraint.getExplicitListValues());
                }
            }
            DataValidation targetValidation = targetHelper.createValidation(targetConstraint, addressList);
            targetValidation.setErrorStyle(sourceValidation.getErrorStyle());
            targetValidation.setEmptyCellAllowed(sourceValidation.getEmptyCellAllowed());
            targetValidation.setShowErrorBox(sourceValidation.getShowErrorBox());
            targetValidation.setShowPromptBox(sourceValidation.getShowPromptBox());
            if (sourceValidation.getErrorBoxText() != null) {
                targetValidation.createErrorBox("\u63d0\u793a:", sourceValidation.getErrorBoxText());
            }
            targetSheet.addValidationData(targetValidation);
        }
    }
}

