/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils.excel.cache;

import com.jxdinfo.document.excel.tools.core.common.utils.excel.entity.BorderKey;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.entity.FontKey;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.entity.RuleKey;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.entity.StyleKey;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.helper.ColorHelper;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ConditionalFormattingRule;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.SheetConditionalFormatting;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StyleCache
implements AutoCloseable {
    private final XSSFWorkbook destWorkbook;
    private XSSFWorkbook srcWorkbook;
    private static final Map<StyleKey, XSSFCellStyle> GLOBAL_STYLE_CACHE = new ConcurrentHashMap<StyleKey, XSSFCellStyle>();
    private static final Map<String, XSSFCellStyle> BASE_STYLE_CACHE = new ConcurrentHashMap<String, XSSFCellStyle>();
    private static final Map<FontKey, XSSFFont> GLOBAL_FONT_CACHE = new ConcurrentHashMap<FontKey, XSSFFont>();
    private static final Map<RuleKey, ConditionalFormattingRule> GLOBAL_RULE_CACHE = new ConcurrentHashMap<RuleKey, ConditionalFormattingRule>();
    private static final Logger logger = LoggerFactory.getLogger(StyleCache.class);

    public StyleCache(XSSFWorkbook destWorkbook) {
        this.destWorkbook = destWorkbook;
    }

    public XSSFCellStyle getStyle(XSSFWorkbook srcWorkbook, XSSFCellStyle srcStyle) {
        this.srcWorkbook = srcWorkbook;
        short fontIndex = srcStyle.getFontIndex();
        if (fontIndex < 0 || fontIndex >= srcWorkbook.getNumberOfFonts()) {
            fontIndex = 0;
        }
        XSSFFont srcFont = srcWorkbook.getFontAt(fontIndex);
        FontKey fontKey = new FontKey(this.destWorkbook, srcFont);
        BorderKey borderKey = new BorderKey(srcStyle);
        return this.getCellStyle(srcStyle, borderKey, srcFont, fontKey);
    }

    public XSSFCellStyle getStyle(XSSFWorkbook srcWorkbook, XSSFCellStyle srcStyle, XSSFFont srcFont) {
        this.srcWorkbook = srcWorkbook;
        FontKey fontKey = new FontKey(this.destWorkbook, srcFont);
        BorderKey borderKey = new BorderKey(srcStyle);
        return this.getCellStyle(srcStyle, borderKey, srcFont, fontKey);
    }

    public XSSFCellStyle getStyle(XSSFWorkbook srcWorkbook, XSSFCellStyle srcStyle, BorderKey borderKey) {
        this.srcWorkbook = srcWorkbook;
        short fontIndex = srcStyle.getFontIndex();
        if (fontIndex < 0 || fontIndex >= srcWorkbook.getNumberOfFonts()) {
            fontIndex = 0;
        }
        XSSFFont srcFont = srcWorkbook.getFontAt(fontIndex);
        FontKey fontKey = new FontKey(this.destWorkbook, srcFont);
        return this.getCellStyle(srcStyle, borderKey, srcFont, fontKey);
    }

    public XSSFFont getStyle(XSSFFont srcFont) {
        FontKey fontKey = new FontKey(this.destWorkbook, srcFont);
        return GLOBAL_FONT_CACHE.computeIfAbsent(fontKey, key -> {
            XSSFFont newFont = this.destWorkbook.createFont();
            this.cloneFont(srcFont, newFont);
            return newFont;
        });
    }

    public XSSFCellStyle getCustomBorderStyle(XSSFCellStyle srcStyle, boolean hasTop, boolean hasLeft, boolean hasRight, boolean hasBottom, BorderStyle borderStyle, XSSFColor color) {
        BorderKey borderKey = BorderKey.getBorderKeyStyle(hasTop, hasLeft, hasRight, hasBottom, borderStyle, color);
        short fontIndex = srcStyle.getFontIndex();
        if (fontIndex < 0 || fontIndex >= this.destWorkbook.getNumberOfFonts()) {
            fontIndex = 0;
        }
        XSSFFont srcFont = this.destWorkbook.getFontAt(fontIndex);
        FontKey fontKey = new FontKey(this.destWorkbook, srcFont);
        StyleKey styleKey = new StyleKey(this.destWorkbook, (CellStyle)srcStyle, fontKey, borderKey);
        return GLOBAL_STYLE_CACHE.computeIfAbsent(styleKey, k -> {
            logger.debug("getCustomBorderStyle \u521b\u5efa\u65b0\u6837\u5f0f\uff0c\u5f53\u524d\u7f13\u5b58\u5927\u5c0f\uff1a{}", (Object)GLOBAL_STYLE_CACHE.size());
            XSSFCellStyle newStyle = this.destWorkbook.createCellStyle();
            this.setBaseStyle(srcStyle, newStyle);
            XSSFFont destFont = GLOBAL_FONT_CACHE.computeIfAbsent(fontKey, key -> {
                XSSFFont font = this.destWorkbook.createFont();
                this.cloneFont(srcFont, font);
                return font;
            });
            newStyle.setFont((Font)destFont);
            if (hasTop) {
                newStyle.setBorderTop(borderStyle);
                newStyle.setTopBorderColor(color);
            }
            if (hasLeft) {
                newStyle.setBorderLeft(borderStyle);
                newStyle.setLeftBorderColor(color);
            }
            if (hasRight) {
                newStyle.setBorderRight(borderStyle);
                newStyle.setRightBorderColor(color);
            }
            if (hasBottom) {
                newStyle.setBorderBottom(borderStyle);
                newStyle.setBottomBorderColor(color);
            }
            return newStyle;
        });
    }

    public ConditionalFormattingRule getCachedRule(ConditionalFormattingRule srcRule, SheetConditionalFormatting targetScf, String sourceSheet, String targetSheet) {
        RuleKey key = new RuleKey(this.destWorkbook, srcRule, sourceSheet, targetSheet);
        return GLOBAL_RULE_CACHE.computeIfAbsent(key, k -> {
            ConditionalFormattingRule newRule = key.createAdaptedRule(srcRule, targetScf, sourceSheet, targetSheet);
            newRule = key.deepCopyRule(srcRule, newRule);
            return newRule;
        });
    }

    private XSSFCellStyle getCellStyle(XSSFCellStyle srcStyle, BorderKey borderKey, XSSFFont srcFont, FontKey fontKey) {
        StyleKey styleKey = new StyleKey(this.destWorkbook, (CellStyle)srcStyle, fontKey, borderKey);
        return GLOBAL_STYLE_CACHE.computeIfAbsent(styleKey, k -> {
            logger.error("getCellStyle \u521b\u5efa\u65b0\u6837\u5f0f\uff0c\u5f53\u524d\u7f13\u5b58\u5927\u5c0f\uff1a{}", (Object)GLOBAL_STYLE_CACHE.size());
            XSSFCellStyle newStyle = this.destWorkbook.createCellStyle();
            this.setBaseStyle(srcStyle, newStyle);
            XSSFColor blackColor = ColorHelper.getDefaultColor();
            if (borderKey.getBorderTop() != null) {
                newStyle.setBorderTop(borderKey.getBorderTop());
                if (borderKey.getTopBorderColor() != null) {
                    newStyle.setTopBorderColor(borderKey.getTopBorderColor());
                } else {
                    newStyle.setTopBorderColor(blackColor);
                }
            }
            if (borderKey.getBorderBottom() != null) {
                newStyle.setBorderBottom(borderKey.getBorderBottom());
                if (borderKey.getBottomBorderColor() != null) {
                    newStyle.setBottomBorderColor(borderKey.getBottomBorderColor());
                } else {
                    newStyle.setBottomBorderColor(blackColor);
                }
            }
            if (borderKey.getBorderLeft() != null) {
                newStyle.setBorderLeft(borderKey.getBorderLeft());
                if (borderKey.getLeftBorderColor() != null) {
                    newStyle.setLeftBorderColor(borderKey.getLeftBorderColor());
                } else {
                    newStyle.setLeftBorderColor(blackColor);
                }
            }
            if (borderKey.getBorderRight() != null) {
                newStyle.setBorderRight(borderKey.getBorderRight());
                if (borderKey.getRightBorderColor() != null) {
                    newStyle.setRightBorderColor(borderKey.getRightBorderColor());
                } else {
                    newStyle.setRightBorderColor(blackColor);
                }
            }
            XSSFFont destFont = GLOBAL_FONT_CACHE.computeIfAbsent(fontKey, key -> {
                XSSFFont newFont = this.destWorkbook.createFont();
                this.cloneFont(srcFont, newFont);
                return newFont;
            });
            newStyle.setFont((Font)destFont);
            return newStyle;
        });
    }

    private void setBaseStyle(XSSFCellStyle srcStyle, XSSFCellStyle newStyle) {
        String formatString = this.getFormatString(this.srcWorkbook, srcStyle);
        if (StringUtils.isNotBlank((CharSequence)formatString)) {
            newStyle.setDataFormat(this.destWorkbook.getCreationHelper().createDataFormat().getFormat(formatString));
        } else {
            newStyle.setDataFormat(srcStyle.getDataFormat());
        }
        newStyle.setAlignment(srcStyle.getAlignment());
        newStyle.setVerticalAlignment(srcStyle.getVerticalAlignment());
        newStyle.setWrapText(srcStyle.getWrapText());
        if (srcStyle.getFillForegroundColorColor() != null) {
            newStyle.setFillForegroundColor(srcStyle.getFillForegroundColorColor());
        } else {
            newStyle.setFillForegroundColor(srcStyle.getFillForegroundColor());
        }
        if (srcStyle.getFillBackgroundColorColor() != null) {
            newStyle.setFillBackgroundColor(srcStyle.getFillBackgroundColorColor());
        } else {
            newStyle.setFillBackgroundColor(srcStyle.getFillBackgroundColor());
        }
        newStyle.setFillPattern(srcStyle.getFillPattern());
    }

    private void cloneFont(XSSFFont src, XSSFFont dest) {
        dest.setBold(src.getBold());
        dest.setColor(src.getXSSFColor());
        dest.setFontHeight(src.getFontHeight());
        dest.setFontName(src.getFontName());
        dest.setItalic(src.getItalic());
        dest.setStrikeout(src.getStrikeout());
        dest.setTypeOffset(src.getTypeOffset());
        dest.setUnderline(src.getUnderline());
        dest.setFontHeightInPoints(src.getFontHeightInPoints());
    }

    private String getFormatString(XSSFWorkbook srcWorkbook, XSSFCellStyle srcStyle) {
        short srcFormatCode = srcStyle.getDataFormat();
        if (srcWorkbook == null) {
            return this.destWorkbook.getCreationHelper().createDataFormat().getFormat(srcFormatCode);
        }
        return srcWorkbook.getCreationHelper().createDataFormat().getFormat(srcFormatCode);
    }

    @Override
    public void close() {
        this.dispose();
    }

    public void dispose() {
        int workbookHash = System.identityHashCode(this.destWorkbook);
        GLOBAL_STYLE_CACHE.entrySet().removeIf(entry -> ((StyleKey)entry.getKey()).getWorkbookHash() == workbookHash);
        GLOBAL_FONT_CACHE.entrySet().removeIf(entry -> ((FontKey)entry.getKey()).getWorkbookHash() == workbookHash);
        GLOBAL_RULE_CACHE.entrySet().removeIf(entry -> ((RuleKey)entry.getKey()).getWorkbookHash() == workbookHash);
        BASE_STYLE_CACHE.remove(String.valueOf(workbookHash));
    }
}

