/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils.excel.processor;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.apache.poi.xssf.usermodel.XSSFCreationHelper;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class CopyCellCommentProcessor {
    public static void copyCellComment(XSSFSheet srcSheet, XSSFSheet destSheet, XSSFWorkbook destWorkbook) {
        XSSFDrawing drawing = destSheet.getDrawingPatriarch();
        for (Row srcRow : srcSheet) {
            XSSFRow destRow = destSheet.getRow(srcRow.getRowNum());
            if (destRow == null) {
                destRow = destSheet.createRow(srcRow.getRowNum());
            }
            for (Cell srcCell : srcRow) {
                Comment srcComment;
                Cell destCell = destRow.getCell(srcCell.getColumnIndex());
                if (destCell == null) {
                    destCell = destRow.createCell(srcCell.getColumnIndex());
                }
                if ((srcComment = srcCell.getCellComment()) == null) continue;
                if (drawing == null) {
                    drawing = destSheet.createDrawingPatriarch();
                }
                ClientAnchor srcAnchor = srcComment.getClientAnchor();
                XSSFCreationHelper helper = destWorkbook.getCreationHelper();
                ClientAnchor anchor = helper.createClientAnchor();
                anchor.setDx1(srcAnchor.getDx1());
                anchor.setDy1(srcAnchor.getDy1());
                anchor.setDx2(srcAnchor.getDx2());
                anchor.setDy2(srcAnchor.getDy2());
                anchor.setCol1((int)srcAnchor.getCol1());
                anchor.setRow1(srcAnchor.getRow1());
                anchor.setCol2((int)srcAnchor.getCol2());
                anchor.setRow2(srcAnchor.getRow2());
                XSSFComment destComment = drawing.createCellComment(anchor);
                destComment.setString((RichTextString)new XSSFRichTextString(srcComment.getString().getString()));
                destComment.setVisible(srcComment.isVisible());
                destCell.setCellComment((Comment)destComment);
            }
        }
    }
}

