/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils.excel.helper;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.constant.ExcelConstant;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFDataValidationConstraint;
import org.apache.poi.xssf.usermodel.XSSFSheet;

public class ReportDataValidationHelper {
    public static void setDataValidation(JSONObject dataVerification, XSSFSheet sheet) {
        DataValidationHelper helper = sheet.getDataValidationHelper();
        Map<String, Integer> opTypeMap = ExcelConstant.opTypeMap;
        if (dataVerification != null) {
            Map dataVe = dataVerification.getInnerMap();
            for (Map.Entry dataEntry : dataVe.entrySet()) {
                DataValidationConstraint dvc;
                String[] colRow = ((String)dataEntry.getKey()).split("_");
                CellRangeAddressList dstAddrList = new CellRangeAddressList(Integer.parseInt(colRow[0]), Integer.parseInt(colRow[0]), Integer.parseInt(colRow[1]), Integer.parseInt(colRow[1]));
                JSONObject dataVeValue = (JSONObject)dataEntry.getValue();
                DataValidation dstDataValidation = null;
                if ("dropdown".equals(dataVeValue.getString("type"))) {
                    if (dataVeValue.getString("value1").contains(",")) {
                        String[] textlist = dataVeValue.getString("value1").split(",");
                        dstDataValidation = helper.createValidation(helper.createExplicitListConstraint(textlist), dstAddrList);
                    } else {
                        dstDataValidation = helper.createValidation(helper.createFormulaListConstraint(dataVeValue.getString("value1")), dstAddrList);
                    }
                }
                if ("checkbox".equals(dataVeValue.getString("type"))) {
                    // empty if block
                }
                if ("number".equals(dataVeValue.getString("type"))) {
                    Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
                    Boolean booleanValue1 = false;
                    Boolean booleanValue2 = false;
                    booleanValue1 = pattern.matcher(dataVeValue.getString("value1")).matches();
                    booleanValue2 = pattern.matcher(dataVeValue.getString("value2")).matches();
                    DataValidationConstraint dvc2 = null;
                    dvc2 = booleanValue1 != false && booleanValue2 != false ? helper.createIntegerConstraint(opTypeMap.get(dataVeValue.getString("type2")).intValue(), dataVeValue.getString("value1"), dataVeValue.getString("value2")) : helper.createDecimalConstraint(opTypeMap.get(dataVeValue.getString("type2")).intValue(), dataVeValue.getString("value1"), dataVeValue.getString("value2"));
                    dstDataValidation = helper.createValidation(dvc2, dstAddrList);
                }
                if ("number_integer".equals(dataVeValue.getString("type")) || "number_decimal".equals(dataVeValue.getString("type")) || "text_length".equals(dataVeValue.getString("type"))) {
                    if (StringUtils.isBlank((CharSequence)dataVeValue.getString("type2"))) continue;
                    dvc = helper.createNumericConstraint(opTypeMap.get(dataVeValue.getString("type")).intValue(), opTypeMap.get(dataVeValue.getString("type2")).intValue(), dataVeValue.getString("value1"), dataVeValue.getString("value2"));
                    dstDataValidation = helper.createValidation(dvc, dstAddrList);
                }
                if ("date".equals(dataVeValue.getString("type"))) {
                    if (StringUtils.isBlank((CharSequence)dataVeValue.getString("type2"))) continue;
                    dvc = new XSSFDataValidationConstraint(opTypeMap.get(dataVeValue.getString("type")).intValue(), opTypeMap.get(dataVeValue.getString("type2")).intValue(), dataVeValue.getString("value1"), dataVeValue.getString("value2"));
                    dstDataValidation = helper.createValidation(dvc, dstAddrList);
                }
                if ("text_content".equals(dataVeValue.getString("type"))) {
                    // empty if block
                }
                if ("validity".equals(dataVeValue.getString("type"))) {
                    // empty if block
                }
                if (!Objects.nonNull(dstDataValidation)) continue;
                dstDataValidation.createPromptBox("\u63d0\u793a:", dataVeValue.getString("hintText"));
                dstDataValidation.setShowErrorBox(dataVeValue.getBoolean("prohibitInput").booleanValue());
                dstDataValidation.setShowPromptBox(dataVeValue.getBoolean("hintShow").booleanValue());
                sheet.addValidationData(dstDataValidation);
            }
        }
    }
}

