/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils.excel.entity;

import com.jxdinfo.document.excel.tools.core.common.utils.excel.entity.BorderKey;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.entity.FontKey;
import java.util.Objects;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class StyleKey {
    private final int workbookHash;
    private final FontKey fontKey;
    private final short dataFormat;
    private final HorizontalAlignment alignment;
    private final VerticalAlignment verticalAlignment;
    private final BorderKey borderKey;
    private final XSSFColor fillBackgroundColorColor;
    private final short fillBackgroundColor;
    private final XSSFColor fillForegroundColorColor;
    private final short fillForegroundColor;
    private final FillPatternType fillPattern;
    private final boolean wrapText;

    public StyleKey(XSSFWorkbook destWorkbook, CellStyle style, FontKey fontKey, BorderKey borderKey) {
        this.workbookHash = System.identityHashCode(destWorkbook);
        this.fontKey = fontKey;
        this.dataFormat = style.getDataFormat();
        this.alignment = style.getAlignment();
        this.verticalAlignment = style.getVerticalAlignment();
        this.borderKey = borderKey;
        this.fillBackgroundColorColor = (XSSFColor)style.getFillBackgroundColorColor();
        this.fillBackgroundColor = style.getFillBackgroundColor();
        this.fillForegroundColorColor = (XSSFColor)style.getFillForegroundColorColor();
        this.fillForegroundColor = style.getFillForegroundColor();
        this.fillPattern = style.getFillPattern();
        this.wrapText = style.getWrapText();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StyleKey styleKey = (StyleKey)o;
        boolean backgroundColorEquals = this.areColorsEqual(this.fillBackgroundColorColor, styleKey.fillBackgroundColorColor);
        boolean foregroundColorEquals = this.areColorsEqual(this.fillForegroundColorColor, styleKey.fillForegroundColorColor);
        return this.workbookHash == styleKey.workbookHash && this.dataFormat == styleKey.dataFormat && this.alignment == styleKey.alignment && this.verticalAlignment == styleKey.verticalAlignment && this.fillBackgroundColor == styleKey.fillBackgroundColor && this.fillForegroundColor == styleKey.fillForegroundColor && backgroundColorEquals && foregroundColorEquals && this.fillPattern == styleKey.fillPattern && this.wrapText == styleKey.wrapText && Objects.equals(this.fontKey, styleKey.fontKey) && Objects.equals(this.borderKey, styleKey.borderKey);
    }

    public int hashCode() {
        int backgroundColorHash = this.fillBackgroundColorColor != null ? this.fillBackgroundColorColor.hashCode() : Objects.hashCode(this.fillBackgroundColor);
        int foregroundColorHash = this.fillForegroundColorColor != null ? this.fillForegroundColorColor.hashCode() : Objects.hashCode(this.fillForegroundColor);
        return Objects.hash(this.workbookHash, this.fontKey, this.dataFormat, this.alignment, this.verticalAlignment, this.fillBackgroundColor, this.borderKey, backgroundColorHash, foregroundColorHash, this.fillPattern, this.wrapText);
    }

    public int getWorkbookHash() {
        return this.workbookHash;
    }

    public FontKey getFontKey() {
        return this.fontKey;
    }

    public short getDataFormat() {
        return this.dataFormat;
    }

    public HorizontalAlignment getAlignment() {
        return this.alignment;
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public BorderKey getBorderKey() {
        return this.borderKey;
    }

    public XSSFColor getFillBackgroundColorColor() {
        return this.fillBackgroundColorColor;
    }

    public short getFillBackgroundColor() {
        return this.fillBackgroundColor;
    }

    public XSSFColor getFillForegroundColorColor() {
        return this.fillForegroundColorColor;
    }

    public short getFillForegroundColor() {
        return this.fillForegroundColor;
    }

    public FillPatternType getFillPattern() {
        return this.fillPattern;
    }

    public boolean isWrapText() {
        return this.wrapText;
    }

    private boolean areColorsEqual(XSSFColor color1, XSSFColor color2) {
        if (color1 == color2) {
            return true;
        }
        if (color1 == null || color2 == null) {
            return false;
        }
        byte[] rgb1 = color1.getRGB();
        byte[] rgb2 = color2.getRGB();
        return Objects.deepEquals(rgb1, rgb2);
    }
}

