/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils.excel.entity;

import java.util.Objects;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class FontKey {
    private final int workbookHash;
    private final boolean bold;
    private final short fontHeight;
    private final String fontName;
    private final boolean italic;
    private final boolean strikeout;
    private final short typeOffset;
    private final byte underline;
    private final String colorHex;
    private final short fontHeightInPoints;

    public FontKey(XSSFWorkbook destWorkbook, XSSFFont font) {
        this.workbookHash = destWorkbook.hashCode();
        this.bold = font.getBold();
        this.fontHeight = font.getFontHeight();
        this.fontName = font.getFontName();
        this.italic = font.getItalic();
        this.strikeout = font.getStrikeout();
        this.typeOffset = font.getTypeOffset();
        this.underline = font.getUnderline();
        this.colorHex = font.getXSSFColor() != null ? font.getXSSFColor().getARGBHex() : null;
        this.fontHeightInPoints = font.getFontHeightInPoints();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FontKey fontKey = (FontKey)o;
        return this.workbookHash == fontKey.workbookHash && this.bold == fontKey.bold && this.fontHeight == fontKey.fontHeight && this.italic == fontKey.italic && this.strikeout == fontKey.strikeout && this.typeOffset == fontKey.typeOffset && this.underline == fontKey.underline && this.fontHeightInPoints == fontKey.fontHeightInPoints && Objects.equals(this.fontName, fontKey.fontName) && Objects.equals(this.colorHex, fontKey.colorHex);
    }

    public int hashCode() {
        return Objects.hash(this.workbookHash, this.bold, this.fontHeight, this.fontName, this.italic, this.strikeout, this.typeOffset, this.underline, this.fontHeightInPoints, this.colorHex);
    }

    public int getWorkbookHash() {
        return this.workbookHash;
    }

    public boolean isBold() {
        return this.bold;
    }

    public short getFontHeight() {
        return this.fontHeight;
    }

    public String getFontName() {
        return this.fontName;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public boolean isStrikeout() {
        return this.strikeout;
    }

    public short getTypeOffset() {
        return this.typeOffset;
    }

    public byte getUnderline() {
        return this.underline;
    }

    public String getColorHex() {
        return this.colorHex;
    }

    public short getFontHeightInPoints() {
        return this.fontHeightInPoints;
    }
}

