/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils;

import com.itextpdf.text.Document;
import com.itextpdf.text.Element;
import com.itextpdf.text.Image;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.lang3.StringUtils;

public class PdfUtil {
    public static final String PAGE_ORIENTATION_PORTRAIT = "portrait";
    public static final String PAGE_SIZE_A4 = "A4";
    public static final String PAGE_SIZE_A5 = "A5";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] imagesZipToPdf(InputStream is, String pageOrientation, String pageSize) {
        if (StringUtils.isEmpty((CharSequence)pageOrientation)) {
            pageOrientation = PAGE_ORIENTATION_PORTRAIT;
        }
        if (StringUtils.isEmpty((CharSequence)pageSize)) {
            pageSize = PAGE_SIZE_A4;
        }
        Rectangle docS = PageSize.A4;
        if (pageSize.equals(PAGE_SIZE_A5)) {
            docS = PageSize.A5;
        }
        if (pageOrientation.equals("landscape")) {
            docS = docS.rotate();
        }
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        try (ZipInputStream zis = new ZipInputStream(is);){
            Document doc = new Document(docS);
            doc.setMargins(0.0f, 0.0f, 0.0f, 0.0f);
            PdfWriter writer = PdfWriter.getInstance((Document)doc, (OutputStream)bs);
            doc.open();
            HashMap<Integer, Image> imageMap = new HashMap<Integer, Image>();
            byte[] buffer = new byte[1024];
            ZipEntry en = zis.getNextEntry();
            while (en != null) {
                String imgName = en.getName();
                if (!en.isDirectory() && imgName.endsWith(".png")) {
                    int len;
                    ByteArrayOutputStream ms = new ByteArrayOutputStream();
                    while ((len = zis.read(buffer)) > 0) {
                        ms.write(buffer, 0, len);
                    }
                    Image img = Image.getInstance((byte[])ms.toByteArray());
                    img.scaleToFit(docS.getWidth(), docS.getHeight());
                    try {
                        int index = Integer.parseInt(imgName.substring(0, imgName.indexOf(46)));
                        imageMap.put(index, img);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                zis.closeEntry();
                en = zis.getNextEntry();
            }
            for (int p = 1; p <= imageMap.size(); ++p) {
                Image img;
                if (p > 1) {
                    doc.newPage();
                }
                if ((img = (Image)imageMap.get(p)) == null) continue;
                doc.add((Element)img);
            }
            doc.close();
            byte[] byArray = bs.toByteArray();
            return byArray;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException("\u751f\u6210PDF\u5931\u8d25", ex);
        }
    }
}

