/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils.excel.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.constant.ExcelConstant;
import com.jxdinfo.document.excel.tools.core.common.utils.excel.vo.DownloadExcelParamVo;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class CheckParamHelper {
    private String reqURL;
    private JSONObject formulaTextStyle;
    private String exportActiveIndex;
    private Integer activeSheetIndex;
    private static final ParserConfig parserConfig = new ParserConfig();
    private static final Map<String, Integer> indexMap = new HashMap<String, Integer>();
    private static final Map<Integer, Integer> maxColumnMap = new HashMap<Integer, Integer>();

    public void checkParam(DownloadExcelParamVo param) {
        if (param == null) {
            return;
        }
        this.reqURL = param.getReqURL();
        String formulaTextStyleStr = param.getFormulaTextStyleStr();
        this.formulaTextStyle = (JSONObject)JSON.parse((String)formulaTextStyleStr, (ParserConfig)parserConfig, (Feature[])new Feature[]{Feature.SupportAutoType});
        this.exportActiveIndex = param.getExportActiveIndex();
    }

    public void setActiveIndex(JSONArray sheets) {
        int index = 0;
        for (Object sheet : sheets) {
            JSONObject sheetJson = (JSONObject)sheet;
            String activityIndex = (String)sheetJson.get((Object)"index");
            indexMap.put(activityIndex, index);
            if (sheetJson.containsKey((Object)"column")) {
                int column = sheetJson.getIntValue("column");
                maxColumnMap.put(index, column);
            } else {
                JSONArray column = sheetJson.getJSONArray("visibledatacolumn");
                maxColumnMap.put(index, column.size());
            }
            if (StringUtils.equals((CharSequence)activityIndex, (CharSequence)this.exportActiveIndex)) {
                this.activeSheetIndex = index;
            }
            ++index;
        }
    }

    public Integer getActiveSheetIndex() {
        if (this.activeSheetIndex == null) {
            return 0;
        }
        return this.activeSheetIndex;
    }

    public String getReqURL() {
        if (this.reqURL == null) {
            return "";
        }
        return this.reqURL;
    }

    public JSONObject getFormulaTextStyle() {
        if (this.formulaTextStyle == null) {
            return ExcelConstant.formulaTextStyle;
        }
        return this.formulaTextStyle;
    }

    public String getExportActiveIndex() {
        if (this.exportActiveIndex == null) {
            return ExcelConstant.exportActiveIndex;
        }
        return this.exportActiveIndex;
    }

    public static Map<Integer, Integer> getMaxColumnMap() {
        return maxColumnMap;
    }

    public static Map<String, Integer> getIndexMap() {
        return indexMap;
    }

    static {
        parserConfig.setAutoTypeSupport(true);
    }
}

