/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils.reportToolThreadPool;

import com.jxdinfo.document.excel.tools.core.common.utils.reportToolThreadPool.ThreadPoolInfo;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Collectors;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class ThreadPoolManager {
    private static Map<String, ThreadPoolTaskExecutor> threadPoolMap = new ConcurrentHashMap<String, ThreadPoolTaskExecutor>(16);
    private static int corePoolSize = 1;
    private static int maxPoolSize = Integer.MAX_VALUE;
    private static int queueCapacity = Integer.MAX_VALUE;
    private static int keepAliveSeconds = 60;

    public static ThreadPoolTaskExecutor newThreadPool(String name) {
        return ThreadPoolManager.newThreadPool(name, corePoolSize, maxPoolSize);
    }

    public static ThreadPoolTaskExecutor newThreadPool(String name, int corePoolSize) {
        return ThreadPoolManager.newThreadPool(name, corePoolSize, corePoolSize);
    }

    public static ThreadPoolTaskExecutor newThreadPool(String name, int corePoolSize, int maxPoolSize) {
        return ThreadPoolManager.newThreadPool(name, corePoolSize, maxPoolSize, queueCapacity, keepAliveSeconds, null, null);
    }

    public static ThreadPoolTaskExecutor newThreadPool(String name, int corePoolSize, int maxPoolSize, int queueCapacity) {
        return ThreadPoolManager.newThreadPool(name, corePoolSize, maxPoolSize, queueCapacity, keepAliveSeconds, null, null);
    }

    public static ThreadPoolTaskExecutor newThreadPool(String name, int corePoolSize, int maxPoolSize, int queueCapacity, int keepAliveSeconds, ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        return threadPoolMap.computeIfAbsent(name, threadGroupName -> {
            ThreadPoolTaskExecutor threadPoolExecutor = new ThreadPoolTaskExecutor();
            threadPoolExecutor.setCorePoolSize(corePoolSize);
            threadPoolExecutor.setMaxPoolSize(maxPoolSize);
            threadPoolExecutor.setQueueCapacity(queueCapacity);
            threadPoolExecutor.setKeepAliveSeconds(keepAliveSeconds);
            threadPoolExecutor.setThreadGroupName(name);
            threadPoolExecutor.setThreadNamePrefix(name + "-");
            if (threadFactory != null) {
                threadPoolExecutor.setThreadFactory(threadFactory);
            }
            if (rejectedExecutionHandler != null) {
                threadPoolExecutor.setRejectedExecutionHandler(rejectedExecutionHandler);
            }
            threadPoolExecutor.afterPropertiesSet();
            return threadPoolExecutor;
        });
    }

    public static List<ThreadPoolInfo> threadPoolInfoList() {
        return threadPoolMap.entrySet().stream().map(entry -> ThreadPoolManager.threadPoolInfo((String)entry.getKey(), (ThreadPoolTaskExecutor)entry.getValue())).collect(Collectors.toList());
    }

    private static ThreadPoolInfo threadPoolInfo(String name, ThreadPoolTaskExecutor threadPool) {
        ThreadPoolInfo threadPoolInfo = new ThreadPoolInfo();
        threadPoolInfo.setName(name);
        threadPoolInfo.setCorePoolSize(threadPool.getCorePoolSize());
        threadPoolInfo.setMaxPoolSize(threadPool.getMaxPoolSize());
        threadPoolInfo.setActiveCount(threadPool.getActiveCount());
        return threadPoolInfo;
    }
}

