/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils.excel.entity;

import com.jxdinfo.document.excel.tools.core.common.utils.excel.entity.RuleStyleKey;
import java.util.Objects;
import org.apache.poi.ss.usermodel.BorderFormatting;
import org.apache.poi.ss.usermodel.ConditionType;
import org.apache.poi.ss.usermodel.ConditionalFormattingRule;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.FontFormatting;
import org.apache.poi.ss.usermodel.PatternFormatting;
import org.apache.poi.ss.usermodel.SheetConditionalFormatting;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class RuleKey {
    private final int workbookHash;
    private final String formula1;
    private final String formula2;
    private final ConditionType ruleType;
    private final RuleStyleKey ruleStyleKey;

    public RuleKey(XSSFWorkbook destWorkbook, ConditionalFormattingRule srcRule, String sourceSheet, String targetSheet) {
        this.workbookHash = destWorkbook.hashCode();
        this.formula1 = RuleKey.fixFormula(srcRule.getFormula1(), sourceSheet, targetSheet);
        this.formula2 = RuleKey.fixFormula(srcRule.getFormula2(), sourceSheet, targetSheet);
        this.ruleType = srcRule.getConditionType();
        this.ruleStyleKey = new RuleStyleKey(srcRule.getPatternFormatting(), srcRule.getFontFormatting(), srcRule.getBorderFormatting());
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuleKey ruleKey = (RuleKey)o;
        return this.workbookHash == ruleKey.workbookHash && Objects.equals(this.formula1, ruleKey.formula1) && Objects.equals(this.formula2, ruleKey.formula2) && Objects.equals(this.ruleType, ruleKey.ruleType) && Objects.equals(this.ruleStyleKey, ruleKey.ruleStyleKey);
    }

    public int hashCode() {
        return Objects.hash(this.workbookHash, this.formula1, this.formula2, this.ruleType, this.ruleStyleKey);
    }

    public int getWorkbookHash() {
        return this.workbookHash;
    }

    public String getFormula1() {
        return this.formula1;
    }

    public String getFormula2() {
        return this.formula2;
    }

    public ConditionType getRuleType() {
        return this.ruleType;
    }

    public RuleStyleKey getRuleStyleKey() {
        return this.ruleStyleKey;
    }

    public static String fixFormula(String formula, String sourceSheetName, String targetSheetName) {
        if (formula == null) {
            return null;
        }
        String fixed = formula.replace("'" + sourceSheetName + "'!", "'" + targetSheetName + "'!");
        fixed = fixed.replace(sourceSheetName + "!", targetSheetName + "!");
        fixed = fixed.replace(sourceSheetName + ":", targetSheetName + ":");
        fixed = fixed.replace("INDIRECT(\"" + sourceSheetName, "INDIRECT(\"" + targetSheetName);
        return fixed;
    }

    public String buildTextContainsFormula(String value, String cellRange) {
        return "ISNUMBER(SEARCH(\"" + value + "\", " + cellRange + "))";
    }

    public ConditionalFormattingRule createAdaptedRule(ConditionalFormattingRule srcRule, SheetConditionalFormatting targetScf, String sourceSheet, String targetSheet) {
        ConditionType conditionType = srcRule.getConditionType();
        if (conditionType.equals(ConditionType.CELL_VALUE_IS)) {
            return targetScf.createConditionalFormattingRule(srcRule.getComparisonOperation(), RuleKey.fixFormula(srcRule.getFormula1(), sourceSheet, targetSheet), RuleKey.fixFormula(srcRule.getFormula2(), sourceSheet, targetSheet));
        }
        if (conditionType.equals(ConditionType.FORMULA)) {
            return targetScf.createConditionalFormattingRule(RuleKey.fixFormula(srcRule.getFormula1(), sourceSheet, targetSheet));
        }
        return targetScf.createConditionalFormattingRule(RuleKey.fixFormula(srcRule.getFormula1(), sourceSheet, targetSheet));
    }

    public ConditionalFormattingRule deepCopyRule(ConditionalFormattingRule srcRule, ConditionalFormattingRule newRule) {
        if (srcRule.getPatternFormatting() != null) {
            PatternFormatting newPattern = newRule.createPatternFormatting();
            newPattern.setFillBackgroundColor(srcRule.getPatternFormatting().getFillBackgroundColor());
            newPattern.setFillForegroundColor(srcRule.getPatternFormatting().getFillForegroundColor());
            newPattern.setFillBackgroundColor(srcRule.getPatternFormatting().getFillBackgroundColorColor());
            newPattern.setFillForegroundColor(srcRule.getPatternFormatting().getFillForegroundColorColor());
            short fillPattern = srcRule.getPatternFormatting().getFillPattern();
            if (fillPattern != FillPatternType.NO_FILL.getCode()) {
                newPattern.setFillPattern(fillPattern);
            }
        }
        if (srcRule.getFontFormatting() != null) {
            FontFormatting newFont = newRule.createFontFormatting();
            newFont.setFontColor(srcRule.getFontFormatting().getFontColor());
            newFont.setFontStyle(srcRule.getFontFormatting().isBold(), srcRule.getFontFormatting().isItalic());
            newFont.setUnderlineType(srcRule.getFontFormatting().getUnderlineType());
        }
        if (srcRule.getBorderFormatting() != null) {
            BorderFormatting newBorder = newRule.createBorderFormatting();
            newBorder.setBorderBottom(srcRule.getBorderFormatting().getBorderBottom());
            newBorder.setBorderTop(srcRule.getBorderFormatting().getBorderTop());
            newBorder.setBorderLeft(srcRule.getBorderFormatting().getBorderLeft());
            newBorder.setBorderRight(srcRule.getBorderFormatting().getBorderRight());
        }
        return newRule;
    }
}

