/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.excel.tools.core.common.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.document.excel.tools.core.common.utils.YMLUtils;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ELNUtil {
    private static String elnPrefix;

    public static void setElnPrefix(String elnPrefix) {
        ELNUtil.elnPrefix = elnPrefix;
    }

    public static JSONObject convertElnItemData(JSONObject elnItemData) {
        if (elnItemData.getString("dataSource") == null) {
            return null;
        }
        if (!StringUtils.equals((CharSequence)elnItemData.getString("dataSource"), (CharSequence)"ELN-item")) {
            return null;
        }
        JSONObject syncData = new JSONObject();
        JSONArray analysisData = elnItemData.getJSONArray("analysisData");
        if (analysisData == null) {
            return null;
        }
        for (Object analysisItemObj : analysisData) {
            JSONObject analysisItem = (JSONObject)analysisItemObj;
            JSONObject analysisItemData = new JSONObject();
            JSONArray analysisList = analysisItem.getJSONArray("analysisList");
            if (analysisList == null) continue;
            ELNUtil.analyzeData(analysisList, analysisItemData);
            syncData.put(analysisItem.getString("key"), (Object)analysisItemData);
        }
        return syncData;
    }

    public static String getElnPrefix() {
        Map elnPath = (Map)YMLUtils.getValue("application.yml", "elnPath");
        Object backIp = YMLUtils.getValue("application.yml", "useFrontOrBackPath");
        String backIpString = backIp == null ? "front" : String.valueOf(backIp);
        String elnPrefix = StringUtils.equals((CharSequence)backIpString, (CharSequence)"front") ? elnPath.get("frontPath").toString() + "/" + elnPath.get("frontPrefix").toString() : String.valueOf(elnPath.get("backPath"));
        ELNUtil.setElnPrefix(elnPrefix);
        return elnPrefix;
    }

    public static void analyzeData(JSONArray analysisList, JSONObject analysisItemData) {
        for (Object itemObj : analysisList) {
            JSONObject item = (JSONObject)itemObj;
            String itemName = item.getString("name");
            Object itemValue = item.get((Object)"value");
            switch (item.getString("type")) {
                case "input": 
                case "timepicker": 
                case "checkbox": 
                case "radio": 
                case "signatureInput": {
                    analysisItemData.put(itemName, itemValue);
                    break;
                }
                case "image": 
                case "imageUpload": {
                    JSONObject itemValueImage = (JSONObject)itemValue;
                    ELNUtil.analyzeImgData(itemValueImage, analysisItemData, itemName);
                    break;
                }
                case "editGrid": 
                case "richTxtStepper": {
                    ELNUtil.analyzeEditGridData(itemValue, analysisItemData, itemName);
                    break;
                }
                case "attachment": {
                    JSONObject itemValueFile = (JSONObject)itemValue;
                    ELNUtil.analyzeAttachmentData(itemValueFile, analysisItemData, itemName);
                    break;
                }
                case "multiPicture": {
                    JSONArray multImageArray = JSONArray.parseArray((String)String.valueOf(itemValue));
                    ELNUtil.analyzeMultiPictureData(multImageArray, analysisItemData, itemName);
                    break;
                }
                case "repeat": {
                    JSONArray itemValueRepeat = (JSONArray)itemValue;
                    JSONArray repeatData = new JSONArray();
                    for (int i = 0; i < itemValueRepeat.size(); ++i) {
                        JSONArray repeatItem = itemValueRepeat.getJSONArray(i);
                        JSONObject repeatItemData = new JSONObject();
                        ELNUtil.analyzeData(repeatItem, repeatItemData);
                        repeatData.add((Object)repeatItemData);
                    }
                    analysisItemData.put("repeat_" + itemName, (Object)repeatData);
                    break;
                }
            }
        }
    }

    public static void analyzeImgData(JSONObject itemValueImage, JSONObject analysisItemData, String itemName) {
        boolean filledSymbolsImage;
        String elnPrefix = ELNUtil.elnPrefix;
        if (elnPrefix == null || elnPrefix.isEmpty()) {
            elnPrefix = ELNUtil.getElnPrefix();
        }
        if (filledSymbolsImage = itemValueImage.getBooleanValue("filledSymbols")) {
            analysisItemData.put(itemName, (Object)itemValueImage.getString("imageName"));
        } else {
            String width = itemValueImage.getString("width").replace("px", "");
            String height = itemValueImage.getString("height").replace("px", "");
            String imgType = "img_eln" + itemName;
            JSONObject imageData = new JSONObject();
            imageData.put("belowText", (Object)false);
            imageData.put("width", (Object)Double.valueOf(width));
            imageData.put("height", (Object)Double.valueOf(height));
            String imgSrc = "";
            if (!itemValueImage.getString("imageSrc").isEmpty()) {
                imgSrc = elnPrefix + itemValueImage.getString("imageSrc");
            }
            imageData.put("src", (Object)imgSrc);
            imageData.put("type", (Object)imgType);
            if (!imgSrc.isEmpty()) {
                analysisItemData.put(itemName, (Object)imageData);
            } else {
                analysisItemData.put(itemName, (Object)"");
            }
        }
    }

    public static void analyzeEditGridData(Object itemValue, JSONObject analysisItemData, String itemName) {
        JSONObject editGridData = new JSONObject();
        editGridData.put("dataSource", (Object)"ELN");
        JSONObject style = new JSONObject();
        style.put("border", (Object)"1px solid black");
        style.put("textAlign", (Object)"left");
        editGridData.put("style", (Object)style);
        editGridData.put("contentRows", itemValue);
        analysisItemData.put(itemName, (Object)editGridData);
    }

    public static void analyzeAttachmentData(JSONObject itemValueFile, JSONObject analysisItemData, String itemName) {
        boolean filledSymbolsFile;
        String elnPrefix = ELNUtil.elnPrefix;
        if (elnPrefix == null || elnPrefix.isEmpty()) {
            elnPrefix = ELNUtil.getElnPrefix();
        }
        if (filledSymbolsFile = itemValueFile.getBooleanValue("filledSymbols")) {
            analysisItemData.put(itemName, itemValueFile.get((Object)"fileName"));
        } else {
            JSONObject fileData = new JSONObject();
            fileData.put("type", (Object)"attachment");
            fileData.put("fileName", itemValueFile.get((Object)"fileName"));
            String fileSrc = "";
            if (!itemValueFile.getString("fileSrc").isEmpty()) {
                fileSrc = elnPrefix + itemValueFile.getString("fileSrc");
            }
            fileData.put("url", (Object)fileSrc);
            if (!fileSrc.isEmpty()) {
                analysisItemData.put(itemName, (Object)fileData);
            } else {
                analysisItemData.put(itemName, (Object)"");
            }
        }
    }

    public static void analyzeMultiPictureData(JSONArray multImageArray, JSONObject analysisItemData, String itemName) {
        String elnPrefix = ELNUtil.elnPrefix;
        if (elnPrefix == null || elnPrefix.isEmpty()) {
            elnPrefix = ELNUtil.getElnPrefix();
        }
        JSONArray resMulImgList = new JSONArray();
        for (Object multimage : multImageArray) {
            JSONArray multimageArr = (JSONArray)multimage;
            JSONObject resMulImgObj = new JSONObject();
            for (int i = 0; i < multimageArr.size(); ++i) {
                JSONObject multimageValue = multimageArr.getJSONObject(i);
                resMulImgObj.put("imageDesc_" + (i + 1), (Object)multimageValue.getString("imageDesc"));
                if (multimageArr.size() == 1) {
                    JSONObject imageDescObj = new JSONObject();
                    imageDescObj.put("rowSpan", (Object)1);
                    imageDescObj.put("colSpan", (Object)2);
                    imageDescObj.put("extend", (Object)true);
                    imageDescObj.put("useAfterCellMc", (Object)true);
                    imageDescObj.put("value", (Object)multimageValue.getString("imageDesc"));
                    resMulImgObj.put("imageDesc_" + (i + 1), (Object)imageDescObj);
                }
                String imageSrcObj = "";
                boolean filledSymbolsMult = multimageValue.getBooleanValue("filledSymbols");
                if (!filledSymbolsMult) {
                    JSONObject nImageSrcObj;
                    String multWidth = multimageValue.getString("width").replace("px", "");
                    String multHeight = multimageValue.getString("height").replace("px", "");
                    String multImgType = "img_eln_" + itemName;
                    JSONObject multImageData = new JSONObject();
                    multImageData.put("belowText", (Object)false);
                    multImageData.put("width", (Object)Double.valueOf(multWidth));
                    multImageData.put("height", (Object)Double.valueOf(multHeight));
                    String imgMulSrc = "";
                    if (!multimageValue.getString("imageSrc").isEmpty()) {
                        imgMulSrc = elnPrefix + multimageValue.getString("imageSrc");
                    }
                    multImageData.put("src", (Object)imgMulSrc);
                    multImageData.put("type", (Object)multImgType);
                    if (!imgMulSrc.isEmpty()) {
                        imageSrcObj = multImageData;
                        if (multimageArr.size() == 1) {
                            nImageSrcObj = new JSONObject();
                            nImageSrcObj.put("rowSpan", (Object)1);
                            nImageSrcObj.put("colSpan", (Object)2);
                            nImageSrcObj.put("extend", (Object)true);
                            nImageSrcObj.put("useAfterCellMc", (Object)true);
                            nImageSrcObj.put("value", (Object)multImageData);
                            imageSrcObj = nImageSrcObj;
                        }
                    } else {
                        imageSrcObj = "";
                        if (multimageArr.size() == 1) {
                            nImageSrcObj = new JSONObject();
                            nImageSrcObj.put("rowSpan", (Object)1);
                            nImageSrcObj.put("colSpan", (Object)2);
                            nImageSrcObj.put("extend", (Object)true);
                            nImageSrcObj.put("useAfterCellMc", (Object)true);
                            nImageSrcObj.put("value", (Object)"");
                            imageSrcObj = nImageSrcObj;
                        }
                    }
                } else {
                    imageSrcObj = multimageValue.getString("imageName");
                    if (multimageArr.size() == 1) {
                        JSONObject nImageSrcObj = new JSONObject();
                        nImageSrcObj.put("rowSpan", (Object)1);
                        nImageSrcObj.put("colSpan", (Object)2);
                        nImageSrcObj.put("extend", (Object)true);
                        nImageSrcObj.put("useAfterCellMc", (Object)true);
                        nImageSrcObj.put("value", (Object)multimageValue.getString("imageName"));
                        imageSrcObj = nImageSrcObj;
                    }
                }
                resMulImgObj.put("imageName_" + (i + 1), (Object)imageSrcObj);
            }
            resMulImgList.add((Object)resMulImgObj);
        }
        analysisItemData.put(itemName, (Object)resMulImgList);
    }
}

