/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.common.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.base.Strings;
import com.jxdinfo.document.common.dao.WordModelGroupInfoMapper;
import com.jxdinfo.document.common.dto.WordModelGroupInfoDto;
import com.jxdinfo.document.common.enums.OwnErrorEnum;
import com.jxdinfo.document.common.model.WordModelGroupInfo;
import com.jxdinfo.document.common.service.WordModelGroupInfoService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.license.ModuleVerify;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.time.LocalDateTime;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.document.common.service.impl.wordModelGroupInfoServiceImpl")
public class WordModelGroupInfoServiceImpl
implements WordModelGroupInfoService {
    @Resource
    private WordModelGroupInfoMapper mapper;

    @Override
    public ApiResponse<List<WordModelGroupInfo>> getList(Long id) {
        ModuleVerify mv = new ModuleVerify();
        if (!mv.verify("a775d647e0f64fdd8ad6db742f091ae4")) {
            return ApiResponse.fail((String)"\u6388\u6743\u9a8c\u8bc1\u5931\u8d25\uff0c\u8bf7\u7533\u8bf7\u667a\u80fd\u62a5\u544a\u6a21\u5757\u6388\u6743\uff01");
        }
        if (HussarUtils.isEmpty((Object)id)) {
            throw new HussarException(OwnErrorEnum.PARAMS_NULL_ERROR.getMsg());
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)lambdaQueryWrapper.eq(WordModelGroupInfo::getParentId, (Object)id)).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        List list = this.mapper.selectList((Wrapper)lambdaQueryWrapper);
        return ApiResponse.success((Object)list);
    }

    @Override
    @HussarTransactional
    public ApiResponse<Integer> update(WordModelGroupInfo wordModelGroupInfo) {
        if (HussarUtils.isEmpty((Object)wordModelGroupInfo.getId())) {
            throw new HussarException(OwnErrorEnum.PARAMS_NULL_ERROR.getMsg());
        }
        wordModelGroupInfo.setDelFlag("0");
        wordModelGroupInfo.setLastEditor(BaseSecurityUtil.getUser().getId());
        wordModelGroupInfo.setLastTime(LocalDateTime.now());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(WordModelGroupInfo::getId, (Object)wordModelGroupInfo.getId());
        int row = this.mapper.update((Object)wordModelGroupInfo, (Wrapper)queryWrapper);
        return ApiResponse.success((Object)row);
    }

    @Override
    @HussarTransactional
    public ApiResponse<Integer> add(WordModelGroupInfoDto wordModelGroupInfoDto) {
        if (Strings.isNullOrEmpty((String)wordModelGroupInfoDto.getGroupName()) || HussarUtils.isEmpty((Object)wordModelGroupInfoDto.getParentId())) {
            throw new HussarException(OwnErrorEnum.PARAMS_NULL_ERROR.getMsg());
        }
        WordModelGroupInfo wordModelGroupInfo = new WordModelGroupInfo();
        wordModelGroupInfo.setGroupName(wordModelGroupInfoDto.getGroupName());
        wordModelGroupInfo.setParentId(wordModelGroupInfoDto.getParentId());
        int row = this.mapper.insert((Object)wordModelGroupInfo);
        return ApiResponse.success((Object)row);
    }

    @Override
    @HussarTransactional
    public ApiResponse<Integer> delete(Long id) {
        if (HussarUtils.isEmpty((Object)id)) {
            throw new HussarException(OwnErrorEnum.PARAMS_NULL_ERROR.getMsg());
        }
        int row = this.mapper.deleteById(id);
        return ApiResponse.success((Object)row);
    }
}

