/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.data.build.binddata.provide.data;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.document.data.build.binddata.content.BindConstant;
import com.jxdinfo.document.data.build.binddata.empty.BindDataCtx;
import com.jxdinfo.document.data.build.binddata.factory.BindNodeProvideFactory;
import com.jxdinfo.document.data.build.binddata.node.TableAreaBindNode;
import com.jxdinfo.document.data.build.binddata.provide.BindDataVisitor;
import com.jxdinfo.document.data.build.binddata.util.DataBindUtil;
import com.jxdinfo.document.data.build.binddata.util.JsonArrayMergerUtil;
import com.jxdinfo.document.data.build.binddata.util.MultiColumnPivotTable;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.data.build.binddata.provide.data.table_area")
public class TableAreaNodeDataProvide
implements BindDataVisitor {
    public static final String provideName = "com.jxdinfo.data.build.binddata.provide.data.table_area";

    @PostConstruct
    public void register() {
        BindNodeProvideFactory.register(provideName, this);
    }

    @Override
    public JSONObject getNodeDataSet(JSONObject nodeJsonObj, BindDataCtx bindDataCtx) {
        JSONObject tableBindAttrs;
        String tableType;
        if (HussarUtils.isEmpty((Object)nodeJsonObj.get((Object)"bindKey"))) {
            return null;
        }
        TableAreaBindNode tableAreaBindNode = (TableAreaBindNode)JsonUtil.convertValue((Object)nodeJsonObj, TableAreaBindNode.class);
        String tableAreaBindNodeBindKey = tableAreaBindNode.getBindKey();
        JSONObject tableMap = new JSONObject();
        JSONObject tableDataMap = new JSONObject();
        JSONArray childContent = nodeJsonObj.getJSONArray("bindContent");
        if (TableAreaNodeDataProvide.isPIVOT(childContent, tableType = (tableBindAttrs = nodeJsonObj.getJSONObject("bindAttrs")).getString("tableType"))) {
            for (Object o : childContent) {
                BindDataVisitor bindDataVisitor;
                JSONObject jsonObject;
                JSONObject childContentJson = JSON.parseObject((String)HussarUtils.toJson(o));
                String bindType = childContentJson.get((Object)BindConstant.JSON_TYPE).toString();
                if ("row_data".equals(bindType) || "col_data".equals(bindType) || !HussarUtils.isNotEmpty((Object)(jsonObject = (bindDataVisitor = BindNodeProvideFactory.get("com.jxdinfo.data.build.binddata.provide.data." + bindType)).getNodeDataSet(childContentJson, bindDataCtx)))) continue;
                tableMap.putAll((Map)jsonObject);
            }
            JSONObject buildPIVOT = TableAreaNodeDataProvide.buildPIVOT(childContent, bindDataCtx, tableType);
            if (HussarUtils.isNotEmpty((Object)buildPIVOT)) {
                tableMap.putAll((Map)buildPIVOT);
            }
        } else {
            for (Object o : childContent) {
                JSONObject childContentJson = JSON.parseObject((String)HussarUtils.toJson(o));
                String bindType = childContentJson.get((Object)BindConstant.JSON_TYPE).toString();
                BindDataVisitor bindDataVisitor = BindNodeProvideFactory.get("com.jxdinfo.data.build.binddata.provide.data." + bindType);
                JSONObject jsonObject = bindDataVisitor.getNodeDataSet(childContentJson, bindDataCtx);
                if (!HussarUtils.isNotEmpty((Object)jsonObject)) continue;
                tableMap.putAll((Map)jsonObject);
            }
        }
        if (bindDataCtx.isIncrement() && tableMap.isEmpty()) {
            return null;
        }
        tableDataMap.put(tableAreaBindNodeBindKey, (Object)tableMap);
        return tableDataMap;
    }

    private static boolean isPIVOT(JSONArray childContent, String tableType) {
        boolean flag = false;
        String eqType = "";
        if ("\u7eb5\u5411\u5ef6\u4f38\u8868\u683c".equals(tableType)) {
            eqType = "col_data";
        } else if ("\u6a2a\u5411\u5ef6\u4f38\u8868\u683c".equals(tableType)) {
            eqType = "row_data";
        }
        for (Object o : childContent) {
            JSONArray cloChildContent;
            JSONObject childContentJson = JSON.parseObject((String)o.toString());
            String bindType = childContentJson.getString(BindConstant.JSON_TYPE);
            if (!eqType.equals(bindType) || !HussarUtils.isNotEmpty((Object)(cloChildContent = childContentJson.getJSONArray("bindContent")))) continue;
            for (Object object : cloChildContent) {
                JSONObject colContentJson = JSON.parseObject((String)object.toString());
                String childType = colContentJson.getString(BindConstant.JSON_TYPE);
                if (!"dynamic_header".equals(childType)) continue;
                flag = true;
            }
        }
        return flag;
    }

    private static JSONObject buildPIVOT(JSONArray childContent, BindDataCtx bindDataCtx, String tableType) {
        JSONObject row = new JSONObject();
        JSONObject col = new JSONObject();
        JSONArray childrenArray = new JSONArray();
        ArrayList<String> columnArrayNameList = new ArrayList<String>();
        JSONArray cloTextContent = new JSONArray();
        HashMap<String, JSONArray> cloTextGroupContent = new HashMap<String, JSONArray>();
        JSONArray rowTextContent = new JSONArray();
        ArrayList<String> rowKeys = new ArrayList<String>();
        HashMap<String, List<String>> valueKeysMap = new HashMap<String, List<String>>();
        String rowTypeName = "";
        String colTypeName = "";
        for (Object o : childContent) {
            JSONObject childContentJson = JSON.parseObject((String)o.toString());
            String bindType = childContentJson.getString(BindConstant.JSON_TYPE);
            if ("col_data".equals(bindType)) {
                colTypeName = childContentJson.getString(BindConstant.BIND_KEY);
                if (!HussarUtils.isNotEmpty((Object)childContentJson.getJSONArray("bindContent"))) continue;
                childrenArray = childContentJson.getJSONArray("bindContent");
                TableAreaNodeDataProvide.processDynamicHeaderRecursively(childrenArray, rowTextContent, cloTextContent, rowKeys, valueKeysMap, columnArrayNameList, cloTextGroupContent, 0);
                continue;
            }
            if (!"row_data".equals(bindType)) continue;
            rowTypeName = childContentJson.getString(BindConstant.BIND_KEY);
            if (!HussarUtils.isNotEmpty((Object)childContentJson.getJSONArray("bindContent"))) continue;
            childrenArray = childContentJson.getJSONArray("bindContent");
            TableAreaNodeDataProvide.processDynamicHeaderRecursively(childrenArray, rowTextContent, cloTextContent, rowKeys, valueKeysMap, columnArrayNameList, cloTextGroupContent, 0);
        }
        for (int i = cloTextContent.size() - 1; i >= 0; --i) {
            JSONObject cloText = cloTextContent.getJSONObject(i);
            if ("text".equals(cloText.getString(BindConstant.JSON_TYPE))) continue;
            cloTextContent.remove(i);
        }
        for (Map.Entry entry : cloTextGroupContent.entrySet()) {
            JSONArray value = (JSONArray)entry.getValue();
            for (int i = value.size() - 1; i >= 0; --i) {
                JSONObject cloText = value.getJSONObject(i);
                if ("text".equals(cloText.getString(BindConstant.JSON_TYPE))) continue;
                value.remove(i);
            }
        }
        JSONArray allTableData = TableAreaNodeDataProvide.buildRowData(rowTextContent, bindDataCtx, cloTextContent);
        if ((HussarUtils.isEmpty((Object)allTableData) || allTableData.isEmpty()) && bindDataCtx.isIncrement()) {
            return null;
        }
        ArrayList<String> columnKeys = new ArrayList<String>();
        HashMap<String, List<String>> columnKeysMap = new HashMap<String, List<String>>();
        for (Object o : cloTextContent) {
            JSONObject colObj = JSON.parseObject((String)o.toString());
            columnKeys.add(colObj.getString(BindConstant.BIND_KEY));
        }
        for (Map.Entry entry : cloTextGroupContent.entrySet()) {
            String key = (String)entry.getKey();
            JSONArray value = (JSONArray)entry.getValue();
            ArrayList<String> columnKeysList = new ArrayList<String>();
            for (Object o : value) {
                JSONObject colObj = JSON.parseObject((String)o.toString());
                columnKeysList.add(colObj.getString(BindConstant.BIND_KEY));
            }
            columnKeysMap.put(key, columnKeysList);
        }
        JSONArray pivot = MultiColumnPivotTable.pivot(allTableData, rowKeys, columnArrayNameList, cloTextGroupContent, valueKeysMap);
        return TableAreaNodeDataProvide.convertWideToNested(pivot, rowKeys, columnKeysMap, valueKeysMap, columnArrayNameList, tableType, rowTypeName, colTypeName);
    }

    public static JSONObject convertWideToNested(JSONArray wideData, List<String> rowKeys, Map<String, List<String>> columnKey, Map<String, List<String>> valueKey, List<String> columnArrayNameList, String tableType, String rowTypeName, String colTypeName) {
        if (wideData.isEmpty()) {
            return new JSONObject();
        }
        HashMap<String, String> colValueToKey = new HashMap<String, String>();
        for (String columnArrayName : columnArrayNameList) {
            colValueToKey.put(columnKey.get(columnArrayName).get(0), columnArrayName);
        }
        JSONArray header = wideData.getJSONArray(0);
        JSONObject columnData = new JSONObject(true);
        for (int i = rowKeys.size(); i < header.size(); ++i) {
            String columnContent = header.getString(i);
            TableAreaNodeDataProvide.parseSingleColumnData(columnContent, colValueToKey, valueKey, columnData, i);
        }
        JSONObject rowDataTemplate = JsonArrayMergerUtil.safeDeepCopy(columnData);
        TableAreaNodeDataProvide.processRowDataTemplate(rowDataTemplate);
        TableAreaNodeDataProvide.removeIndexFromColumnData(columnData);
        String contentValueKey = TableAreaNodeDataProvide.getContentValueKey(valueKey);
        JSONArray rowData = new JSONArray();
        for (int i = 1; i < wideData.size(); ++i) {
            JSONArray row = wideData.getJSONArray(i);
            JSONObject singleRowData = JsonArrayMergerUtil.deepCopyJSONobject(rowDataTemplate);
            TableAreaNodeDataProvide.processRowData(row, singleRowData, contentValueKey);
            for (int j = 0; j < rowKeys.size(); ++j) {
                singleRowData.put(rowKeys.get(j), (Object)row.getString(j));
            }
            rowData.add((Object)singleRowData);
        }
        JSONObject table = new JSONObject();
        if ("\u7eb5\u5411\u5ef6\u4f38\u8868\u683c".equals(tableType)) {
            table.put(rowTypeName, (Object)rowData);
            table.put(colTypeName, (Object)columnData);
        } else if ("\u6a2a\u5411\u5ef6\u4f38\u8868\u683c".equals(tableType)) {
            table.put(colTypeName, (Object)rowData);
            table.put(rowTypeName, (Object)columnData);
        }
        return table;
    }

    private static JSONArray buildRowData(JSONArray rowTextContent, BindDataCtx bindDataCtx, JSONArray cloTextContent) {
        JSONObject textMap;
        BindDataVisitor bindDataVisitor;
        String bindType;
        JSONObject childContentJson;
        JSONArray textDataArray = new JSONArray();
        JSONObject textDataMap = new JSONObject();
        for (Object o : rowTextContent) {
            childContentJson = JSON.parseObject((String)HussarUtils.toJson(o));
            bindType = childContentJson.get((Object)BindConstant.JSON_TYPE).toString();
            bindDataVisitor = BindNodeProvideFactory.get("com.jxdinfo.data.build.binddata.provide.data." + bindType);
            if (!"text".equals(bindType) || !HussarUtils.isNotEmpty((Object)(textMap = bindDataVisitor.getNodeDataSet(childContentJson, bindDataCtx)))) continue;
            textDataMap.putAll((Map)textMap);
        }
        for (Object o : cloTextContent) {
            childContentJson = JSON.parseObject((String)HussarUtils.toJson(o));
            bindType = childContentJson.get((Object)BindConstant.JSON_TYPE).toString();
            bindDataVisitor = BindNodeProvideFactory.get("com.jxdinfo.data.build.binddata.provide.data." + bindType);
            if (!"text".equals(bindType) || !HussarUtils.isNotEmpty((Object)(textMap = bindDataVisitor.getNodeDataSet(childContentJson, bindDataCtx)))) continue;
            textDataMap.putAll((Map)textMap);
        }
        if (bindDataCtx.isIncrement() && textDataMap.isEmpty()) {
            return null;
        }
        textDataArray = DataBindUtil.convert(textDataMap);
        return textDataArray;
    }

    private static void processDynamicHeaderRecursively(JSONArray contentArray, JSONArray rowTextContent, JSONArray cloTextContent, List<String> rowKeys, Map<String, List<String>> valueKeysMap, List<String> columnArrayNameList, Map<String, JSONArray> cloTextGroupContent, int depth) {
        if (HussarUtils.isEmpty((Object)contentArray)) {
            return;
        }
        for (Object item : contentArray) {
            JSONArray childContent;
            String bindKey;
            JSONObject contentJson = JSON.parseObject((String)item.toString());
            String bindType = contentJson.getString(BindConstant.JSON_TYPE);
            if ("text".equals(bindType)) {
                rowTextContent.add((Object)contentJson);
                if (depth != 0) continue;
                rowKeys.add(contentJson.getString(BindConstant.BIND_KEY));
                continue;
            }
            if ("dynamic_header".equals(bindType)) {
                bindKey = contentJson.getString(BindConstant.BIND_KEY);
                childContent = contentJson.getJSONArray("bindContent");
                if (!HussarUtils.isNotEmpty((Object)childContent)) continue;
                columnArrayNameList.add(bindKey);
                cloTextContent.addAll((Collection)childContent);
                cloTextGroupContent.put(bindKey, childContent);
                TableAreaNodeDataProvide.processDynamicHeaderRecursively(childContent, rowTextContent, cloTextContent, rowKeys, valueKeysMap, columnArrayNameList, cloTextGroupContent, depth + 1);
                continue;
            }
            if (!"dynamic_header_data".equals(bindType)) continue;
            bindKey = contentJson.getString(BindConstant.BIND_KEY);
            childContent = contentJson.getJSONArray("bindContent");
            if (!HussarUtils.isNotEmpty((Object)childContent)) continue;
            rowTextContent.addAll((Collection)childContent);
            ArrayList<String> keyList = new ArrayList<String>();
            for (Object childItem : childContent) {
                JSONObject childObj = JSON.parseObject((String)childItem.toString());
                String childBindKey = childObj.getString(BindConstant.BIND_KEY);
                valueKeysMap.computeIfAbsent(bindKey, k -> new ArrayList()).add(childBindKey);
                keyList.add(childBindKey);
            }
            valueKeysMap.put(bindKey, keyList);
            TableAreaNodeDataProvide.processDynamicHeaderRecursively(childContent, rowTextContent, cloTextContent, rowKeys, valueKeysMap, columnArrayNameList, cloTextGroupContent, depth + 1);
        }
    }

    private static void parseSingleColumnData(String columndata, Map<String, String> colSymbolToKey, Map<String, List<String>> valueKey, JSONObject parentJSONNode, int index) {
        String columnName = "";
        String columnSymbol = "";
        String columnValue = "";
        int firstDelimiterIndex = columndata.indexOf(" |- ");
        if (firstDelimiterIndex == -1) {
            return;
        }
        int secondDelimiterIndex = columndata.indexOf(" |- ", firstDelimiterIndex + 1);
        columnSymbol = columndata.substring(0, firstDelimiterIndex);
        columnValue = secondDelimiterIndex == -1 ? columndata.substring(firstDelimiterIndex + 4) : columndata.substring(firstDelimiterIndex + 4, secondDelimiterIndex);
        columnName = colSymbolToKey.get(columnSymbol);
        if (columnName == null) {
            return;
        }
        JSONObject childJSONObject = null;
        if (parentJSONNode.containsKey((Object)columnName)) {
            JSONArray currentJSONArray = parentJSONNode.getJSONArray(columnName);
            for (int i = 0; i < currentJSONArray.size(); ++i) {
                JSONObject obj = currentJSONArray.getJSONObject(i);
                if (obj.containsKey((Object)columnSymbol) && HussarUtils.equalsSafe((Object)obj.get((Object)columnSymbol), (Object)columnValue)) {
                    childJSONObject = obj;
                    break;
                }
                if (i != currentJSONArray.size() - 1) continue;
                childJSONObject = new JSONObject(true);
                currentJSONArray.add((Object)childJSONObject);
                childJSONObject.put(columnSymbol, (Object)columnValue);
            }
        } else {
            JSONArray currentJSONArray = new JSONArray();
            parentJSONNode.put(columnName, (Object)currentJSONArray);
            childJSONObject = new JSONObject(true);
            childJSONObject.put(columnSymbol, (Object)columnValue);
            currentJSONArray.add((Object)childJSONObject);
        }
        if (columndata.length() <= columnSymbol.length() + columnValue.length() + 8) {
            childJSONObject.put("index", (Object)index);
            return;
        }
        columndata = columndata.substring(columnSymbol.length() + columnValue.length() + 8);
        TableAreaNodeDataProvide.parseSingleColumnData(columndata, colSymbolToKey, valueKey, childJSONObject, index);
    }

    private static void processRowDataTemplate(JSONObject sourceJSON) {
        ArrayList<String> keysToRemove = new ArrayList<String>();
        for (String key : sourceJSON.keySet()) {
            if ("index".equals(key)) continue;
            Object value = sourceJSON.get((Object)key);
            if (value instanceof JSONArray) {
                for (Object item : (JSONArray)value) {
                    if (!(item instanceof JSONObject)) continue;
                    TableAreaNodeDataProvide.processRowDataTemplate((JSONObject)item);
                }
                continue;
            }
            if (!(value instanceof String) || !key.startsWith("{") || !key.endsWith("}")) continue;
            keysToRemove.add(key);
        }
        for (String key : keysToRemove) {
            sourceJSON.remove((Object)key);
        }
    }

    private static void removeIndexFromColumnData(JSONObject sourceJSON) {
        if (sourceJSON == null) {
            return;
        }
        if (sourceJSON.containsKey((Object)"index")) {
            sourceJSON.remove((Object)"index");
        }
        for (String key : sourceJSON.keySet()) {
            Object value = sourceJSON.get((Object)key);
            if (value instanceof JSONArray) {
                for (Object item : (JSONArray)value) {
                    if (!(item instanceof JSONObject)) continue;
                    TableAreaNodeDataProvide.removeIndexFromColumnData((JSONObject)item);
                }
                continue;
            }
            if (!(value instanceof JSONObject)) continue;
            TableAreaNodeDataProvide.removeIndexFromColumnData((JSONObject)value);
        }
    }

    private static String getContentValueKey(Map<String, List<String>> valueKey) {
        for (String key : valueKey.keySet()) {
            List<String> value;
            List<String> valueList = value = valueKey.get(key);
            for (String listValue : valueList) {
                if (!listValue.startsWith("{") || !listValue.endsWith("}")) continue;
                return listValue;
            }
        }
        return "";
    }

    private static void processRowData(JSONArray data, JSONObject rowJSON, String contentValueKey) {
        if (rowJSON.containsKey((Object)"index")) {
            rowJSON.put(contentValueKey, data.get(rowJSON.getIntValue("index")));
            rowJSON.remove((Object)"index");
            return;
        }
        for (String key : rowJSON.keySet()) {
            Object value = rowJSON.get((Object)key);
            if (!(value instanceof JSONArray)) continue;
            for (Object item : (JSONArray)value) {
                if (!(item instanceof JSONObject)) continue;
                TableAreaNodeDataProvide.processRowData(data, (JSONObject)item, contentValueKey);
            }
        }
    }
}

