/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.transaction.quote.quotation.quotationdetailbpm.listener;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.operaterecord.service.IOperateRecordAPIService;
import com.jxdinfo.crm.common.api.operaterecord.vo.OperateRecordAPIVo;
import com.jxdinfo.crm.common.api.organUser.IUserBoService;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.common.api.util.CommonUtills;
import com.jxdinfo.crm.core.config.UnifyProperties;
import com.jxdinfo.crm.core.crm.datasourcefolder.customer.crmopportunity2.service.CrmOpportunity2Service;
import com.jxdinfo.crm.core.focus.dao.FocusMapper;
import com.jxdinfo.crm.core.opportunity.constant.OpportunityEditConstant;
import com.jxdinfo.crm.core.opportunity.dao.OpportunityMapper;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.crm.core.opportunity.service.OpportunityService;
import com.jxdinfo.crm.core.opportunityproduct.model.OpportunityProduct;
import com.jxdinfo.crm.core.opportunityproduct.service.OpportunityProductService;
import com.jxdinfo.crm.core.unify.dto.AddSysMessageType;
import com.jxdinfo.crm.core.unify.util.UnifyUtil;
import com.jxdinfo.crm.core.utills.EimPushUtil;
import com.jxdinfo.crm.transaction.quote.quotation.quotationdetailbpm.model.CrmQuoteDetail;
import com.jxdinfo.crm.transaction.quote.quotation.quotationdetailbpm.model.QuotationDetailBpmMaster;
import com.jxdinfo.crm.transaction.quote.quotation.quotationdetailbpm.service.CrmQuoteDetailService;
import com.jxdinfo.crm.transaction.quote.quotation.quotationdetailbpm.service.QuotationDetailBpmMasterService;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.job.execution.common.utils.SpringUtils;
import com.jxdinfo.hussar.workflow.manage.bpm.listener.visitor.HussarWorkflowListener;
import java.io.Serializable;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component(value="QuotationProcessSuccess")
public class QuotationProcessSuccessListener
implements HussarWorkflowListener {
    @Resource
    private OpportunityService opportunityService;
    @Resource
    private OpportunityProductService opportunityProductService;
    @Resource
    private IOperateRecordAPIService operateRecordAPIService;
    @Resource
    private CrmOpportunity2Service crmOpportunity2Service;
    @Resource
    private FocusMapper focusMapper;
    @Resource
    private OpportunityMapper opportunityMapper;
    @Resource
    private UnifyProperties unifyProperties;
    @Resource
    private QuotationDetailBpmMasterService quotationDetailBpmMasterService;
    @Resource
    private CrmQuoteDetailService crmQuoteDetailService;

    public void notify(Map<String, Object> map) {
        if (!"complete".equals(map.get("endType"))) {
            return;
        }
        QuotationDetailBpmMaster quotationDetailBpmMaster = (QuotationDetailBpmMaster)this.quotationDetailBpmMasterService.getById((Serializable)((Object)((String)map.get("businessId"))));
        List crmQuoteDetails = this.crmQuoteDetailService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CrmQuoteDetail::getQuoteId, (Object)quotationDetailBpmMaster.getQuoteId())).eq(CrmQuoteDetail::getDelFlag, (Object)"0"));
        LocalDateTime date = LocalDateTime.now();
        boolean updateOpportunityFlag = false;
        Long opportunityId = quotationDetailBpmMaster.getOpportunityId();
        if (opportunityId != null && CollectionUtil.isNotEmpty((Collection)crmQuoteDetails)) {
            IUserBoService userBoService = (IUserBoService)SpringUtils.getBean(IUserBoService.class);
            SecurityUser user = userBoService.selectSecurityByUserId(quotationDetailBpmMaster.getInitiator());
            String userName = user.getUserName();
            Long userId = user.getUserId();
            OpportunityEntity opportunity = (OpportunityEntity)this.opportunityService.getById((Serializable)opportunityId);
            List opportunityProductList = this.opportunityProductService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityProduct::getOpportunityId, (Object)opportunityId)).eq(OpportunityProduct::getDelFlag, (Object)"0"));
            List notExistProducts = crmQuoteDetails.stream().filter(o -> !opportunityProductList.stream().map(OpportunityProduct::getProductId).collect(Collectors.toSet()).contains(o.getProductId())).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(notExistProducts)) {
                ArrayList<Object> newOpportunityProducts = new ArrayList<Object>();
                for (CrmQuoteDetail quoteDetail : notExistProducts) {
                    OpportunityProduct opportunityProduct = new OpportunityProduct();
                    opportunityProduct.setProductId(quoteDetail.getProductId());
                    opportunityProduct.setProductName(quoteDetail.getProductName());
                    opportunityProduct.setOpportunityId(opportunityId);
                    opportunityProduct.setOpportunityName(quotationDetailBpmMaster.getOpportunityName());
                    opportunityProduct.setId(Long.valueOf(Long.parseLong(CommonUtills.generateAssignId())));
                    opportunityProduct.setSellPrice(quoteDetail.getSaleTotalAmount().toString());
                    opportunityProduct.setProductNumber(quoteDetail.getProductNumber() == null ? "0" : quoteDetail.getProductNumber().toString());
                    opportunityProduct.setCreateTime(date);
                    opportunityProduct.setCreatePerson(userId);
                    opportunityProduct.setCreatePersonName(userName);
                    opportunityProduct.setChangeTime(date);
                    opportunityProduct.setChangePerson(userId);
                    opportunityProduct.setChangePersonName(userName);
                    opportunityProduct.setDelFlag("0");
                    newOpportunityProducts.add(opportunityProduct);
                }
                OperateRecordAPIVo addProductRecord = new OperateRecordAPIVo();
                addProductRecord.setDelflag("0");
                addProductRecord.setProduceType(RecordProductTypeEnum.PRODUCE_PRODUCT_ADD.getId());
                ArrayList recordMapList = new ArrayList();
                for (Object opportunityProduct : newOpportunityProducts) {
                    HashMap<String, String> stringHashMap = new HashMap<String, String>();
                    stringHashMap.put("productName", opportunityProduct.getProductName());
                    if (HussarUtils.isNotEmpty((Object)opportunityProduct.getSellPrice()) && Double.parseDouble(opportunityProduct.getSellPrice()) > 0.0) {
                        stringHashMap.put("price", opportunityProduct.getSellPrice());
                    } else {
                        stringHashMap.put("price", "0.00");
                    }
                    recordMapList.add(stringHashMap);
                }
                addProductRecord.setRecordContent(JsonUtil.toJson((Object)recordMapList));
                this.operateRecordAPIService.saveOperateLog(addProductRecord, CrmBusinessTypeEnum.OPPORTUNITY, opportunity.getOpportunityId(), opportunity.getOpportunityName(), date, false, Arrays.asList(opportunity.getOpportunityId(), opportunity.getCustomerId()), user);
                this.opportunityProductService.saveBatch(newOpportunityProducts);
                updateOpportunityFlag = true;
            }
            ArrayList<OpportunityProduct> updateList = new ArrayList<OpportunityProduct>();
            HashMap<Long, String> oldPriceMap = new HashMap<Long, String>();
            for (OpportunityProduct op : opportunityProductList) {
                for (CrmQuoteDetail quoteDetail : crmQuoteDetails) {
                    if (!op.getProductId().equals(quoteDetail.getProductId()) || op.getSellPrice().equals(quoteDetail.getSaleTotalAmount().toString())) continue;
                    oldPriceMap.put(op.getId(), op.getSellPrice());
                    op.setSellPrice(quoteDetail.getSaleTotalAmount().toString());
                    op.setChangeTime(date);
                    op.setChangePerson(userId);
                    op.setChangePersonName(userName);
                    updateList.add(op);
                }
            }
            if (ToolUtil.isNotEmpty(updateList)) {
                ArrayList updateMapList = new ArrayList();
                OperateRecordAPIVo updateOperateRecord = new OperateRecordAPIVo();
                updateOperateRecord.setDelflag("0");
                updateOperateRecord.setProduceType(RecordProductTypeEnum.PRODUCE_OPPORTUNITY_PRODUCT_EDIT.getId());
                block4: for (OpportunityProduct op : updateList) {
                    for (Map.Entry oldOp : oldPriceMap.entrySet()) {
                        String newPrice;
                        if (!op.getId().equals(oldOp.getKey())) continue;
                        String oldPrice = ToolUtil.isEmpty(oldOp.getValue()) ? "0.00" : (String)oldOp.getValue();
                        if (Objects.equals(oldPrice, newPrice = ToolUtil.isEmpty((Object)op.getSellPrice()) ? "0.00" : op.getSellPrice())) continue block4;
                        HashMap<String, String> stringHashMap = new HashMap<String, String>();
                        stringHashMap.put("productName", op.getProductName());
                        stringHashMap.put("oldPrice", oldPrice);
                        stringHashMap.put("newPrice", newPrice);
                        updateMapList.add(stringHashMap);
                        continue block4;
                    }
                }
                if (CollectionUtil.isNotEmpty(updateMapList)) {
                    updateOperateRecord.setRecordContent(JsonUtil.toJson(updateMapList));
                    this.operateRecordAPIService.saveOperateLog(updateOperateRecord, CrmBusinessTypeEnum.OPPORTUNITY, opportunity.getOpportunityId(), opportunity.getOpportunityName(), date, false, Arrays.asList(opportunity.getOpportunityId(), opportunity.getCustomerId()), user);
                }
                this.opportunityProductService.saveOrUpdateBatch(updateList);
                updateOpportunityFlag = true;
            }
            Double oldOpportunityAmount = opportunity.getOpportunityAmount() == null ? 0.0 : Double.parseDouble(opportunity.getOpportunityAmount());
            opportunity.setOpportunityAmount(String.valueOf(oldOpportunityAmount));
            if (!Double.valueOf(opportunity.getOpportunityAmount()).equals(quotationDetailBpmMaster.getQuoteTotalPrice().doubleValue())) {
                opportunity.setOpportunityAmount(quotationDetailBpmMaster.getQuoteTotalPrice().toString());
                updateOpportunityFlag = true;
            }
            if (updateOpportunityFlag) {
                opportunity.setChangeTime(date);
                opportunity.setChangePerson(userId);
                opportunity.setChangePersonName(userName);
                this.opportunityService.updateById((Object)opportunity);
                Double newOpportunityAmount = opportunity.getOpportunityAmount() == null ? 0.0 : Double.parseDouble(opportunity.getOpportunityAmount());
                if (!newOpportunityAmount.equals(oldOpportunityAmount)) {
                    DecimalFormat df = new DecimalFormat("#,##0.00");
                    ArrayList changeField = new ArrayList();
                    HashMap<String, String> before = new HashMap<String, String>();
                    HashMap<String, String> after = new HashMap<String, String>();
                    HashMap<String, String> field = new HashMap<String, String>();
                    field.put("field", OpportunityEditConstant.OPPORTUNITY_AMOUNT.getField());
                    field.put("fieldName", OpportunityEditConstant.OPPORTUNITY_AMOUNT.getName());
                    changeField.add(field);
                    String oldAmount = df.format(oldOpportunityAmount);
                    String newAmount = df.format(newOpportunityAmount);
                    before.put(OpportunityEditConstant.OPPORTUNITY_AMOUNT.getField(), oldAmount);
                    after.put(OpportunityEditConstant.OPPORTUNITY_AMOUNT.getField(), newAmount);
                    String oldJson = JSON.toJSONString(before);
                    String newJson = JSON.toJSONString(after);
                    String changeFieldStr = JSON.toJSONString(changeField);
                    OperateRecordAPIVo operateRecordDO = this.crmOpportunity2Service.initializeOperateLog(RecordProductTypeEnum.PRODUCE_CHANGE.getId(), oldJson, newJson, changeFieldStr);
                    operateRecordDO.setChangeBatch(1);
                    this.operateRecordAPIService.saveOperateLog(operateRecordDO, CrmBusinessTypeEnum.OPPORTUNITY, opportunityId, opportunity.getOpportunityName(), date, false, Arrays.asList(opportunityId, opportunity.getCustomerId()), user);
                    df.setRoundingMode(RoundingMode.HALF_UP);
                    oldOpportunityAmount = oldOpportunityAmount / 10000.0;
                    newOpportunityAmount = newOpportunityAmount / 10000.0;
                    String oldOppAmount = df.format(oldOpportunityAmount);
                    String newOppAmount = df.format(newOpportunityAmount);
                    List focusId = this.focusMapper.selectCreateId("2", opportunity.getOpportunityId());
                    List productManagerIds = this.opportunityMapper.opportunityProductManagerList(opportunity.getOpportunityId(), "0", null);
                    List userIds = Stream.of(focusId, productManagerIds).flatMap(Collection::stream).collect(Collectors.toList());
                    if (CollectionUtil.isNotEmpty(userIds)) {
                        String title = "\u3010" + opportunity.getOpportunityName() + "\u3011\u5546\u673a\u91d1\u989d\u53d8\u5316";
                        String content = "\u5546\u673a\u91d1\u989d\u7531" + oldOppAmount + "\u4e07\u5143\u8c03\u6574\u4e3a" + newOppAmount + "\u4e07\u5143";
                        EimPushUtil.pushJqxArticleMessage((String)title, (String)content, (String)"/crm/sj/sjxq/xxzl", (String)String.valueOf(opportunity.getOpportunityId()), userIds);
                        AddSysMessageType addSysMessageType = new AddSysMessageType();
                        String userIdToString = StringUtil.join(userIds, (String)",");
                        String unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/businessDetails?row=" + "\"" + opportunity.getOpportunityId() + "\"";
                        String contentUnify = "\u3010\u5546\u673a\u52a8\u6001\u3011\u3010" + opportunity.getOpportunityName() + "\u3011\u5546\u673a\u91d1\u989d\u7531" + oldOppAmount + "\u4e07\u5143\u8c03\u6574\u4e3a" + newOppAmount + "\u4e07\u5143";
                        UnifyUtil.defaultMessage((AddSysMessageType)addSysMessageType, (String)contentUnify, (LocalDateTime)date, (SecurityUser)user, (String)userIdToString, (String)user.getUserName(), (String)unifyWebUrl, (String)"");
                        UnifyUtil.sendMessage((AddSysMessageType)addSysMessageType);
                    }
                }
            }
        }
    }
}

