/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.transaction.operationsmanage.invoice.crminvoice.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.config.Configure;
import com.deepoove.poi.data.RowRenderData;
import com.deepoove.poi.data.Rows;
import com.deepoove.poi.policy.RenderPolicy;
import com.jxdinfo.crm.common.api.associativeQuery.dto.AssociativeKeyword;
import com.jxdinfo.crm.common.api.associativeQuery.dto.AssociativeQueryDto;
import com.jxdinfo.crm.common.api.associativeQuery.service.IAssociativeQueryAPIService;
import com.jxdinfo.crm.common.api.associativeQuery.service.IAssociativeQueryAdapterService;
import com.jxdinfo.crm.common.api.associativeQuery.vo.AssociativeQueryVo;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.api.dataRightManage.vo.OperateVo;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.operaterecord.service.IOperateRecordAPIService;
import com.jxdinfo.crm.common.api.operaterecord.vo.OperateRecordAPIVo;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.common.api.trackrecord.service.ITrackRecordAPIService;
import com.jxdinfo.crm.common.api.util.CommonUtills;
import com.jxdinfo.crm.common.api.util.CrmDateUtils;
import com.jxdinfo.crm.common.api.util.DictUtils;
import com.jxdinfo.crm.common.api.util.entity.DateConvertVo;
import com.jxdinfo.crm.common.api.util.entity.PermissionDto;
import com.jxdinfo.crm.core.api.teammember.service.ITeamMemberApiService;
import com.jxdinfo.crm.core.common.dao.CommonMapper;
import com.jxdinfo.crm.core.common.service.CommonService;
import com.jxdinfo.crm.core.config.UnifyProperties;
import com.jxdinfo.crm.core.crm.datasourcefolder.customer.crmopportunity2.service.CrmOpportunity2Service;
import com.jxdinfo.crm.core.fileinfo.model.FileInfo;
import com.jxdinfo.crm.core.fileinfo.service.FileInfoService;
import com.jxdinfo.crm.core.focus.model.FocusEntity;
import com.jxdinfo.crm.core.focus.service.FocusService;
import com.jxdinfo.crm.core.opportunity.service.OpportunityService;
import com.jxdinfo.crm.core.scene.dao.CrmSceneMapper;
import com.jxdinfo.crm.core.scene.model.CrmScene;
import com.jxdinfo.crm.core.teammeber.service.TeamMeberService;
import com.jxdinfo.crm.core.unify.dto.AddSysMessageType;
import com.jxdinfo.crm.core.unify.util.UnifyUtil;
import com.jxdinfo.crm.transaction.api.service.IInvoiceDataRightModuleService;
import com.jxdinfo.crm.transaction.operationsmanage.contract.crmagreement.model.CrmAgreementMaster;
import com.jxdinfo.crm.transaction.operationsmanage.contract.crmagreement.service.CrmAgreementMasterService;
import com.jxdinfo.crm.transaction.operationsmanage.invoice.crminvoice.constant.InvoiceEditEnum;
import com.jxdinfo.crm.transaction.operationsmanage.invoice.crminvoice.dao.CrmInvoiceDetailMapper;
import com.jxdinfo.crm.transaction.operationsmanage.invoice.crminvoice.dao.CrmInvoiceMapper;
import com.jxdinfo.crm.transaction.operationsmanage.invoice.crminvoice.dto.CrmInvoiceAssociativeQueryDto;
import com.jxdinfo.crm.transaction.operationsmanage.invoice.crminvoice.dto.CrmInvoiceCrminvoicedataset1;
import com.jxdinfo.crm.transaction.operationsmanage.invoice.crminvoice.dto.CrmInvoiceDetailIncrementDTO;
import com.jxdinfo.crm.transaction.operationsmanage.invoice.crminvoice.dto.CrmInvoiceDto;
import com.jxdinfo.crm.transaction.operationsmanage.invoice.crminvoice.model.CrmInvoice;
import com.jxdinfo.crm.transaction.operationsmanage.invoice.crminvoice.model.CrmInvoiceDetail;
import com.jxdinfo.crm.transaction.operationsmanage.invoice.crminvoice.model.CrmInvoiceDetailMerge;
import com.jxdinfo.crm.transaction.operationsmanage.invoice.crminvoice.model.CrmInvoiceMaster;
import com.jxdinfo.crm.transaction.operationsmanage.invoice.crminvoice.service.CrmInvoiceDetailMergeService;
import com.jxdinfo.crm.transaction.operationsmanage.invoice.crminvoice.service.CrmInvoiceDetailService;
import com.jxdinfo.crm.transaction.operationsmanage.invoice.crminvoice.service.CrmInvoiceMasterService;
import com.jxdinfo.crm.transaction.operationsmanage.invoice.crminvoice.service.CrmInvoiceService;
import com.jxdinfo.crm.transaction.operationsmanage.invoice.crminvoice.service.ICrmInvoiceAssociativeQueryService;
import com.jxdinfo.crm.transaction.operationsmanage.invoice.crminvoice.util.MyPoiUtil;
import com.jxdinfo.crm.transaction.operationsmanage.invoice.crminvoice.util.ServerTableData;
import com.jxdinfo.crm.transaction.operationsmanage.invoice.crminvoice.util.ServerTablePolicy;
import com.jxdinfo.crm.transaction.operationsmanage.invoice.crminvoice.vo.CrmInvoiceDetailByWbsVo;
import com.jxdinfo.crm.transaction.operationsmanage.invoice.crminvoice.vo.CrmInvoiceDetailVO;
import com.jxdinfo.crm.transaction.operationsmanage.invoice.crminvoice.vo.CrmInvoicePageVO;
import com.jxdinfo.crm.transaction.operationsmanage.invoice.crminvoice.vo.CrmInvoiceSlavePageVO;
import com.jxdinfo.crm.transaction.operationsmanage.order.crmorder.model.CrmOrderMaster;
import com.jxdinfo.crm.transaction.operationsmanage.order.crmorder.model.CrmOrderProduct;
import com.jxdinfo.crm.transaction.operationsmanage.order.crmorder.service.CrmOrderMasterService;
import com.jxdinfo.crm.transaction.operationsmanage.order.crmorder.service.CrmOrderProductService;
import com.jxdinfo.crm.transaction.operationsmanage.refundclaim.crmrefundclaim.dao.CrmRefundClaimDetailMapper;
import com.jxdinfo.crm.transaction.operationsmanage.refundclaim.crmrefundclaim.model.CrmRefundClaimDetail;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.dao.SysDicSingleMapper;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.vo.DictVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.query.dto.SuperQueryConditionDto;
import com.jxdinfo.hussar.support.mp.base.query.generator.SingleTableQueryGenerator;
import com.jxdinfo.hussar.support.mp.base.query.generator.superquery.SuperQueryGenerator;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.engine.InstanceEngineService;
import com.jxdinfo.hussar.workflow.manage.engine.TaskEngineService;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="operationsmanage.invoice.crminvoice.CrmInvoiceServiceImpl")
@HussarTokenDs
public class CrmInvoiceServiceImpl
extends HussarServiceImpl<CrmInvoiceMapper, CrmInvoice>
implements CrmInvoiceService {
    private static final Logger logger = LoggerFactory.getLogger(CrmInvoiceServiceImpl.class);
    private static final String RETURN_CODE = "0";
    private static final String ORDER_RULE = "orderRule";
    private static final String DEFAULT_ORDER_RULE = "defaultOrderRule";
    private static final String ASC = ",asc;";
    private static final String DESC = ",desc;";
    @Autowired
    private CrmInvoiceMapper crmInvoiceMapper;
    @Autowired
    private CrmInvoiceMasterService crmInvoiceMasterService;
    @Autowired
    private CrmInvoiceDetailService crmInvoiceDetailService;
    @Resource
    private ICrmInvoiceAssociativeQueryService crmInvoiceAssociativeQueryService;
    @Resource
    private IAssociativeQueryAPIService associativeQueryService;
    @Resource
    private CommonService commonService;
    @Resource
    private TeamMeberService teamMeberService;
    @Resource
    private IOperateRecordAPIService operateRecordAPIService;
    @Resource
    private SysDicSingleMapper sysDicSingleMapper;
    @Resource
    private CrmCommonProperties crmProperties;
    @Resource
    private CrmOpportunity2Service crmOpportunity2Service;
    @Resource
    private FocusService focusService;
    @Resource
    private CrmSceneMapper crmSceneMapper;
    @Resource
    private CrmAgreementMasterService crmAgreementMasterService;
    @Resource
    private CrmOrderMasterService crmOrderMasterService;
    @Resource
    private ITaskEngineService taskEngineService;
    @Resource
    private CrmInvoiceDetailMapper crmInvoiceDetailMapper;
    @Resource
    private CrmRefundClaimDetailMapper crmRefundClaimDetailMapper;
    @Resource
    private CrmOrderProductService crmOrderProductService;
    @Resource
    private CommonMapper commonMapper;
    @Resource
    private UnifyProperties unifyProperties;
    @Resource
    private OpportunityService opportunityService;
    @Resource
    private CrmInvoiceDetailMergeService crmInvoiceDetailMergeService;
    @Resource
    private ITeamMemberApiService teamMemberApiService;
    @Resource
    private IInvoiceDataRightModuleService invoiceDataRightModuleService;
    @Resource
    private ITrackRecordAPIService trackRecordAPIService;
    @Resource
    private FileInfoService fileInfoService;

    public List<CrmInvoice> getByMap(Map<String, Object> map) {
        return this.crmInvoiceMapper.getByMap((CrmInvoice)BeanUtil.copy(map, CrmInvoice.class));
    }

    @Override
    public ApiResponse<CrmInvoicePageVO> hussarQueryPage(Page<CrmInvoice> page) {
        try {
            Page pager = new Page(page.getCurrent(), page.getSize());
            HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
            ArrayList<String> orderRule = new ArrayList<String>();
            if (page.orders() != null) {
                StringBuilder order = new StringBuilder();
                for (OrderItem orderItem : page.orders()) {
                    if (orderItem.isAsc()) {
                        order.append(orderItem.getColumn()).append(ASC);
                        continue;
                    }
                    order.append(orderItem.getColumn()).append(DESC);
                }
                orderRule.add(order.toString());
                parameterMap.put(ORDER_RULE, orderRule.toArray(new String[0]));
            }
            CrmInvoicePageVO crmInvoicePageVO = new CrmInvoicePageVO();
            SingleTableQueryGenerator singleTableQueryGenerator = new SingleTableQueryGenerator();
            QueryWrapper queryWrapper = singleTableQueryGenerator.initQueryWrapper((Object)new CrmInvoice(), parameterMap);
            List<CrmInvoice> list = this.crmInvoiceMapper.hussarQueryPage((Page<CrmInvoice>)pager, (QueryWrapper<CrmInvoice>)queryWrapper);
            crmInvoicePageVO.setData(list);
            crmInvoicePageVO.setCount(pager.getTotal());
            crmInvoicePageVO.setCode(RETURN_CODE);
            return ApiResponse.success((Object)crmInvoicePageVO);
        }
        catch (Exception e) {
            throw new HussarException("\u8868\u683c\u67e5\u8be2\u5f02\u5e38", (Throwable)e);
        }
    }

    @Override
    public ApiResponse<CrmInvoice> formQuery(String id) {
        try {
            BpmResponseResult taskResult;
            CrmInvoice crmInvoice = this.crmInvoiceMapper.formQuery(id);
            crmInvoice = this.updateCrmInvoiceInfo(crmInvoice);
            if (ToolUtil.isNotEmpty((Object)"1".equals(crmInvoice.getFlowStatus())) && ToolUtil.isNotEmpty((Object)(taskResult = this.taskEngineService.queryTaskIdByBusinessId(crmInvoice.getInvoiceId().toString())).getResult()) && taskResult.getCode().equals("1")) {
                Map resultMap = (Map)taskResult.getResult().get(0);
                crmInvoice.setTaskId(resultMap.get("taskId") + "");
            }
            ArrayList<Long> businessIds = new ArrayList<Long>();
            businessIds.add(crmInvoice.getInvoiceId());
            List fileRecordIds = this.trackRecordAPIService.selectRelationRecordIds(crmInvoice.getInvoiceId());
            if (CollectionUtil.isNotEmpty((Collection)fileRecordIds)) {
                businessIds.addAll(fileRecordIds);
            }
            LambdaQueryWrapper fileInfoQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(FileInfo::getBusinessId, businessIds)).ne(FileInfo::getDelFlag, (Object)"1");
            Integer userSecurityLevel = BaseSecurityUtil.getUser().getSecurityLevel();
            if (HussarUtils.isNotEmpty((Object)userSecurityLevel)) {
                fileInfoQueryWrapper.le(FileInfo::getSecurityLevel, (Object)userSecurityLevel);
            }
            crmInvoice.setFileCount(this.fileInfoService.count((Wrapper)fileInfoQueryWrapper));
            SecurityUser user = BaseSecurityUtil.getUser();
            long focusCount = this.focusService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(FocusEntity::getBusinessId, (Object)crmInvoice.getInvoiceId())).eq(FocusEntity::getCreatePersion, (Object)user.getId()));
            crmInvoice.setFocus(focusCount > 0L);
            return ApiResponse.success((Object)crmInvoice);
        }
        catch (Exception e) {
            throw new HussarException("\u8868\u5355\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public ApiResponse<CrmInvoiceSlavePageVO<CrmInvoiceDetailVO>> crmInvoiceDetailSlaveQuery(CrmInvoiceDetailIncrementDTO crmInvoiceDetailIncrementDTO) {
        try {
            boolean isPagination = crmInvoiceDetailIncrementDTO.getCurrent() != 0L && HussarUtils.isNotEmpty((Object)crmInvoiceDetailIncrementDTO.getCurrent());
            Page pager = new Page();
            if (isPagination) {
                pager = new Page(crmInvoiceDetailIncrementDTO.getCurrent(), crmInvoiceDetailIncrementDTO.getSize());
            }
            HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
            ArrayList<String> orderRule = new ArrayList<String>();
            if (crmInvoiceDetailIncrementDTO.getOrders() != null) {
                StringBuilder order = new StringBuilder();
                for (OrderItem orderItem : crmInvoiceDetailIncrementDTO.getOrders()) {
                    if (orderItem.isAsc()) {
                        order.append(orderItem.getColumn()).append(ASC);
                        continue;
                    }
                    order.append(orderItem.getColumn()).append(DESC);
                }
                orderRule.add(order.toString());
                parameterMap.put(ORDER_RULE, orderRule.toArray(new String[0]));
            }
            SingleTableQueryGenerator singleTableQueryGenerator = new SingleTableQueryGenerator();
            QueryWrapper queryWrapper = singleTableQueryGenerator.initQueryWrapper((Object)new CrmInvoiceDetail(), parameterMap);
            SuperQueryConditionDto superQueryConditionDto = new SuperQueryConditionDto();
            superQueryConditionDto.setField("invoiceId");
            superQueryConditionDto.setMatch("AND");
            superQueryConditionDto.setRule("_eq");
            superQueryConditionDto.setVal((Object)crmInvoiceDetailIncrementDTO.getId());
            List<SuperQueryConditionDto> superQueryConditionDtoList = HussarUtils.isNotEmpty(crmInvoiceDetailIncrementDTO.getSuperQueryConditionDto()) ? crmInvoiceDetailIncrementDTO.getSuperQueryConditionDto() : new ArrayList<SuperQueryConditionDto>();
            superQueryConditionDtoList.add(superQueryConditionDto);
            SuperQueryGenerator superQueryGenerator = new SuperQueryGenerator(CrmInvoiceDetail.class);
            superQueryGenerator.initSuperQueryWrapper(queryWrapper, superQueryConditionDtoList);
            if (isPagination) {
                List<CrmInvoiceDetailVO> list = this.crmInvoiceMapper.crmInvoiceDetailSlaveQuery((Page<CrmInvoiceDetail>)pager, (QueryWrapper<CrmInvoiceDetail>)queryWrapper);
                return ApiResponse.success(CrmInvoiceSlavePageVO.of(list, pager.getTotal()));
            }
            List<CrmInvoiceDetailVO> list = this.crmInvoiceMapper.crmInvoiceDetailSlaveQuery((QueryWrapper<CrmInvoiceDetail>)queryWrapper);
            return ApiResponse.success(CrmInvoiceSlavePageVO.of(list, Long.valueOf(list.size())));
        }
        catch (Exception e) {
            throw new HussarException("\u8868\u5355\u67e5\u8be2\u5931\u8d25");
        }
    }

    @Override
    @HussarTransactional
    public ApiResponse<String> insertOrUpdate(CrmInvoice crmInvoice) {
        try {
            CrmInvoiceMaster crmInvoiceMaster = crmInvoice.gainCrmInvoiceMaster();
            Long invoiceId = crmInvoice.getInvoiceId();
            CrmInvoice oldInvoice = null;
            if (invoiceId != null) {
                oldInvoice = this.crmInvoiceMapper.formQuery(invoiceId.toString());
            }
            SecurityUser user = BaseSecurityUtil.getUser();
            LocalDateTime date = LocalDateTime.now();
            if (crmInvoiceMaster.getInvoiceId() == null || this.crmInvoiceMasterService.getById(crmInvoiceMaster.getInvoiceId()) == null) {
                crmInvoiceMaster.setCreator(user.getId());
                crmInvoiceMaster.setCreateTime(date);
                crmInvoiceMaster.setLastEditor(user.getId());
                crmInvoiceMaster.setLastTime(date);
                crmInvoiceMaster.setDelFlag(RETURN_CODE);
                crmInvoiceMaster.setCreatorName(user.getUserName());
                crmInvoiceMaster.setCreateDepartment(user.getDeptId());
                crmInvoiceMaster.setCreateDepartmentName(user.getDeptName());
                crmInvoiceMaster.setLastEditorName(user.getUserName());
                crmInvoiceMaster.setChargePerson(user.getId());
                crmInvoiceMaster.setChargePersonName(user.getUserName());
                crmInvoiceMaster.setOwnDepartment(user.getDeptId());
                crmInvoiceMaster.setOwnDepartmentName(user.getDeptName());
                crmInvoiceMaster.setFlowStatus("1");
                crmInvoiceMaster.setAbandonState(RETURN_CODE);
                crmInvoiceMaster.setRefundAmount(0.0);
                crmInvoiceMaster.setNotRefundAmount(0.0);
            } else {
                crmInvoiceMaster.setLastEditor(user.getId());
                crmInvoiceMaster.setLastTime(date);
                crmInvoiceMaster.setLastEditorName(user.getUserName());
            }
            this.crmInvoiceMasterService.saveOrUpdate(crmInvoiceMaster);
            if (crmInvoiceMaster.getInvoiceId() != null) {
                this.teamMeberService.insertTeamMember(user.getUserName(), user.getId(), crmInvoiceMaster.getInvoiceId(), "1", "1", date, CrmBusinessTypeEnum.INVOICE.getId());
            }
            if (oldInvoice == null) {
                ArrayList<Long> typeIdList = new ArrayList<Long>(Collections.singletonList(crmInvoiceMaster.getInvoiceId()));
                this.operateRecordAPIService.saveOperateLog((OperateRecordAPIVo)null, CrmBusinessTypeEnum.INVOICE, crmInvoiceMaster.getInvoiceId(), crmInvoiceMaster.getInvoiceNumber(), date, false, typeIdList);
            } else {
                this.saveInvoiceOperateLog(oldInvoice, crmInvoice, date);
            }
            LambdaQueryWrapper ew0 = new LambdaQueryWrapper();
            ew0.eq(CrmInvoiceDetail::getInvoiceId, (Object)crmInvoiceMaster.getInvoiceId());
            this.crmInvoiceDetailService.remove((Wrapper)ew0);
            List<CrmInvoiceDetail> crmInvoiceDetails = crmInvoice.gainCrmInvoiceDetailArray();
            if (null != crmInvoiceDetails) {
                List<Object> agreementIdList = new ArrayList();
                for (CrmInvoiceDetail crmInvoiceDetail : crmInvoiceDetails) {
                    List agreementTypeList;
                    List agreementMasterList;
                    crmInvoiceDetail.setInvoiceId(crmInvoiceMaster.getInvoiceId());
                    if (crmInvoiceDetail.getInvoiceDetailId() == null || this.crmInvoiceDetailService.getById(crmInvoiceDetail.getInvoiceDetailId()) == null) {
                        crmInvoiceDetail.setCreator(BaseSecurityUtil.getUser().getId());
                        crmInvoiceDetail.setCreateTime(LocalDateTime.now());
                        crmInvoiceDetail.setLastEditor(BaseSecurityUtil.getUser().getId());
                        crmInvoiceDetail.setLastTime(LocalDateTime.now());
                        crmInvoiceDetail.setDelFlag(RETURN_CODE);
                        crmInvoiceDetail.setCreatorName(user.getUserName());
                        crmInvoiceDetail.setCreateDepartment(user.getDeptId());
                        crmInvoiceDetail.setCreateDepartmentName(user.getDeptName());
                        crmInvoiceDetail.setLastEditorName(user.getUserName());
                        crmInvoiceDetail.setRefundAmount(0.0);
                        crmInvoiceDetail.setNotRefundAmount(0.0);
                        crmInvoiceDetail.setReceivableAmount(0.0);
                    } else {
                        crmInvoiceDetail.setLastEditor(BaseSecurityUtil.getUser().getId());
                        crmInvoiceDetail.setLastTime(LocalDateTime.now());
                        crmInvoiceDetail.setLastEditorName(BaseSecurityUtil.getUser().getUserName());
                    }
                    if (!CollectionUtil.isNotEmpty((Collection)(agreementMasterList = this.crmAgreementMasterService.listByIds(agreementIdList = crmInvoiceDetails.stream().map(CrmInvoiceDetail::getAgreementId).distinct().collect(Collectors.toList())))) || !CollectionUtil.isNotEmpty(agreementTypeList = agreementMasterList.stream().map(CrmAgreementMaster::getAgreementType).distinct().collect(Collectors.toList()))) continue;
                    String opportunityType = String.join((CharSequence)",", agreementTypeList);
                    this.crmInvoiceMasterService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(CrmInvoiceMaster::getInvoiceId, (Object)crmInvoiceMaster.getInvoiceId())).set(CrmInvoiceMaster::getOpportunityType, (Object)opportunityType));
                }
                this.crmInvoiceDetailService.saveOrUpdateBatch(crmInvoiceDetails);
            }
            return ApiResponse.success((Object)String.valueOf(crmInvoiceMaster.getInvoiceId()), (String)"");
        }
        catch (Exception e) {
            throw new HussarException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    @HussarTransactional
    public ApiResponse<String> flowFormSubmit(CrmInvoiceDto crmInvoiceDto) {
        CrmInvoice crmInvoice = crmInvoiceDto.getFormdata();
        String businessId = "";
        Long invoiceId = crmInvoice.getInvoiceId();
        CrmInvoice oldInvoice = null;
        if (invoiceId != null) {
            oldInvoice = this.crmInvoiceMapper.formQuery(invoiceId.toString());
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime date = LocalDateTime.now();
        Boolean flag = false;
        try {
            CrmInvoiceMaster crmInvoiceMaster = crmInvoice.gainCrmInvoiceMaster();
            if (crmInvoiceMaster.getInvoiceId() == null || this.crmInvoiceMasterService.getById(crmInvoiceMaster.getInvoiceId()) == null) {
                crmInvoiceMaster.setCreator(user.getId());
                crmInvoiceMaster.setCreateTime(date);
                crmInvoiceMaster.setLastEditor(user.getId());
                crmInvoiceMaster.setLastTime(date);
                crmInvoiceMaster.setDelFlag(RETURN_CODE);
                crmInvoiceMaster.setCreatorName(user.getUserName());
                crmInvoiceMaster.setCreateDepartment(user.getDeptId());
                crmInvoiceMaster.setCreateDepartmentName(user.getDeptName());
                crmInvoiceMaster.setLastEditorName(user.getUserName());
                crmInvoiceMaster.setChargePerson(user.getId());
                crmInvoiceMaster.setChargePersonName(user.getUserName());
                crmInvoiceMaster.setOwnDepartment(user.getDeptId());
                crmInvoiceMaster.setOwnDepartmentName(user.getDeptName());
                crmInvoiceMaster.setFlowStatus("2");
                crmInvoiceMaster.setAbandonState(RETURN_CODE);
                crmInvoiceMaster.setRefundAmount(0.0);
                crmInvoiceMaster.setNotRefundAmount(0.0);
                flag = true;
            } else {
                crmInvoiceMaster.setLastEditor(user.getId());
                crmInvoiceMaster.setLastTime(date);
                crmInvoiceMaster.setLastEditorName(user.getUserName());
            }
            this.crmInvoiceMasterService.saveOrUpdate(crmInvoiceMaster);
            if (flag.booleanValue()) {
                if (crmInvoiceMaster.getInvoiceId() != null) {
                    this.teamMeberService.insertTeamMember(user.getUserName(), user.getId(), crmInvoiceMaster.getInvoiceId(), "1", "1", date, CrmBusinessTypeEnum.INVOICE.getId());
                }
                ArrayList<Long> typeIdList = new ArrayList<Long>(Collections.singletonList(crmInvoiceMaster.getInvoiceId()));
                this.operateRecordAPIService.saveOperateLog((OperateRecordAPIVo)null, CrmBusinessTypeEnum.INVOICE, crmInvoiceMaster.getInvoiceId(), crmInvoiceMaster.getInvoiceNumber(), date, false, typeIdList);
            } else {
                this.saveInvoiceOperateLog(oldInvoice, crmInvoice, date);
            }
            LambdaQueryWrapper ew0 = new LambdaQueryWrapper();
            ew0.eq(CrmInvoiceDetail::getInvoiceId, (Object)crmInvoiceMaster.getInvoiceId());
            this.crmInvoiceDetailService.remove((Wrapper)ew0);
            List<CrmInvoiceDetail> crmInvoiceDetails = crmInvoice.gainCrmInvoiceDetailArray();
            if (null != crmInvoiceDetails) {
                List opportunityTypeList;
                Object agreementMasterList;
                List agreementIdList = crmInvoiceDetails.stream().map(CrmInvoiceDetail::getAgreementId).distinct().collect(Collectors.toList());
                Map<Object, Object> agreementMasterMap = new HashMap();
                if (CollectionUtils.isNotEmpty(agreementIdList)) {
                    agreementMasterList = this.crmAgreementMasterService.listByIds(agreementIdList);
                    agreementMasterMap = agreementMasterList.stream().collect(Collectors.toMap(CrmAgreementMaster::getAgreementId, v -> v));
                }
                agreementMasterList = crmInvoiceDetails.iterator();
                while (agreementMasterList.hasNext()) {
                    CrmAgreementMaster agreementMaster;
                    CrmInvoiceDetail crmInvoiceDetail = (CrmInvoiceDetail)agreementMasterList.next();
                    crmInvoiceDetail.setInvoiceId(crmInvoiceMaster.getInvoiceId());
                    if (crmInvoiceDetail.getInvoiceDetailId() == null || this.crmInvoiceDetailService.getById(crmInvoiceDetail.getInvoiceDetailId()) == null) {
                        crmInvoiceDetail.setCreator(BaseSecurityUtil.getUser().getId());
                        crmInvoiceDetail.setCreateTime(LocalDateTime.now());
                        crmInvoiceDetail.setLastEditor(BaseSecurityUtil.getUser().getId());
                        crmInvoiceDetail.setLastTime(LocalDateTime.now());
                        crmInvoiceDetail.setDelFlag(RETURN_CODE);
                        crmInvoiceDetail.setCreatorName(user.getUserName());
                        crmInvoiceDetail.setCreateDepartment(user.getDeptId());
                        crmInvoiceDetail.setCreateDepartmentName(user.getDeptName());
                        crmInvoiceDetail.setLastEditorName(user.getUserName());
                        crmInvoiceDetail.setRefundAmount(0.0);
                        crmInvoiceDetail.setNotRefundAmount(0.0);
                    } else {
                        crmInvoiceDetail.setLastEditor(BaseSecurityUtil.getUser().getId());
                        crmInvoiceDetail.setLastTime(LocalDateTime.now());
                        crmInvoiceDetail.setLastEditorName(BaseSecurityUtil.getUser().getUserName());
                    }
                    if (!ToolUtil.isNotEmpty((Object)(agreementMaster = (CrmAgreementMaster)agreementMasterMap.get(crmInvoiceDetail.getAgreementId()))) || !ToolUtil.isNotEmpty((Object)agreementMaster.getQualityAmountRate())) continue;
                    Double receivableAmount = crmInvoiceDetail.getTotalValueTax() - crmInvoiceDetail.getTotalValueTax() * (agreementMaster.getQualityAmountRate() / 100.0);
                    crmInvoiceDetail.setReceivableAmount(receivableAmount);
                }
                agreementIdList = crmInvoiceDetails.stream().map(CrmInvoiceDetail::getAgreementId).distinct().collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(agreementIdList) && CollectionUtil.isNotEmpty((Collection)(agreementMasterList = this.crmAgreementMasterService.listByIds(agreementIdList))) && CollectionUtil.isNotEmpty(opportunityTypeList = agreementMasterList.stream().map(CrmAgreementMaster::getAgreementType).distinct().collect(Collectors.toList()))) {
                    String opportunityType = String.join((CharSequence)",", opportunityTypeList);
                    this.crmInvoiceMasterService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(CrmInvoiceMaster::getInvoiceId, (Object)crmInvoiceMaster.getInvoiceId())).set(CrmInvoiceMaster::getOpportunityType, (Object)opportunityType));
                }
                this.crmInvoiceDetailService.saveOrUpdateBatch(crmInvoiceDetails);
            }
            businessId = String.valueOf(crmInvoiceMaster.getInvoiceId());
        }
        catch (Exception e) {
            throw new HussarException("\u4fdd\u5b58\u8868\u5355\u5f02\u5e38");
        }
        this.formsubmit(crmInvoiceDto, businessId);
        return ApiResponse.success((Object)businessId, (String)"\u63d0\u4ea4\u6d41\u7a0b\u8868\u5355\u6210\u529f");
    }

    @Override
    @HussarTransactional
    @HussarTokenDs
    public void formsubmit(CrmInvoiceDto crmInvoiceDto, String businessKey) {
        BpmResponseResult bpmResponseResult;
        if (HussarUtils.isEmpty((Object)BaseSecurityUtil.getUser())) {
            throw new HussarException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        HashMap<String, String> appointMap = new HashMap<String, String>();
        HashMap<String, String> variable = new HashMap<String, String>();
        String taskId = crmInvoiceDto.getTaskId();
        String comment = crmInvoiceDto.getComment();
        if (crmInvoiceDto.getFlowSelect() == null) {
            appointMap.put("static_appoint_assignee", crmInvoiceDto.getParticipantSelect());
        } else {
            appointMap.put(crmInvoiceDto.getFlowSelect(), crmInvoiceDto.getParticipantSelect());
            variable.put("bpm_next_node", crmInvoiceDto.getFlowSelect());
        }
        if (crmInvoiceDto.getSelectBranches() != null) {
            ArrayList<String> nextNodeIds = new ArrayList<String>();
            for (Map<String, String> map : crmInvoiceDto.getSelectBranches()) {
                appointMap.put(map.get("flowSelect"), map.get("participants"));
                nextNodeIds.add(map.get("flowSelect"));
            }
            variable.put("bpm_next_node", String.join((CharSequence)",", nextNodeIds));
        }
        String processDefinitionKey = crmInvoiceDto.getProcessDefinitionKey();
        CrmInvoiceMaster crmInvoiceMaster = (CrmInvoiceMaster)this.crmInvoiceMasterService.getById((Serializable)((Object)businessKey));
        String userId = String.valueOf(BaseSecurityUtil.getUser().getId());
        if (HussarUtils.isEmpty((Object)taskId)) {
            String deptId = BaseSecurityUtil.getUser().getDeptId() == null ? "" : String.valueOf(BaseSecurityUtil.getUser().getDeptId());
            BpmResponseResult startResult = InstanceEngineService.startProcessInstanceByKey((String)processDefinitionKey, (String)userId, (String)deptId, (String)businessKey, variable);
            crmInvoiceMaster.setFlowStatus("2");
            crmInvoiceMaster.setInitiator(user.getId());
            crmInvoiceMaster.setProcessStartTime(date);
            if ("1".equals(startResult.getCode())) {
                taskId = (String)startResult.getResult().getJSONObject(0).get((Object)"taskId");
            } else {
                throw new HussarException(startResult.getMsg());
            }
        }
        if (!"1".equals((bpmResponseResult = TaskEngineService.completeTask((String)taskId, (String)userId, appointMap, null, (String)comment, variable)).getCode())) {
            throw new HussarException(bpmResponseResult.getMsg());
        }
        String businessName = crmInvoiceDto.getFormdata().getApplyNumber();
        if ("\u7ed3\u675f".equals(bpmResponseResult.getResult().getJSONObject(0).get((Object)"taskDefinitionName"))) {
            crmInvoiceMaster.setFlowStatus("4");
            crmInvoiceMaster.setProcessEndTime(LocalDateTime.now());
            crmInvoiceMaster.setNotRefundAmount(crmInvoiceMaster.getThisApplyAmount());
            List<CrmInvoiceDetail> invoiceDetailList = crmInvoiceDto.getFormdata().getCrmInvoiceDetail();
            if (CollectionUtil.isNotEmpty(invoiceDetailList)) {
                List agreementIdList = invoiceDetailList.stream().map(CrmInvoiceDetail::getAgreementId).distinct().collect(Collectors.toList());
                List orderIdList = invoiceDetailList.stream().map(CrmInvoiceDetail::getOrderId).distinct().collect(Collectors.toList());
                List orderProductIdList = invoiceDetailList.stream().map(CrmInvoiceDetail::getOrderProductId).distinct().collect(Collectors.toList());
                List agreementMasterList = this.crmAgreementMasterService.listByIds(agreementIdList);
                List orderMasterList = this.crmOrderMasterService.listByIds(orderIdList);
                List orderProductList = this.crmOrderProductService.listByIds(orderProductIdList);
                Map<Long, CrmAgreementMaster> agreementMasterMap = agreementMasterList.stream().collect(Collectors.toMap(CrmAgreementMaster::getAgreementId, agreement -> agreement));
                Map<Long, CrmOrderMaster> orderMasterMap = orderMasterList.stream().collect(Collectors.toMap(CrmOrderMaster::getOrderId, order -> order));
                Map<Long, CrmOrderProduct> orderProductMap = orderProductList.stream().collect(Collectors.toMap(CrmOrderProduct::getOrderProductId, orderProduct -> orderProduct));
                HashMap<String, CrmInvoiceDetailMerge> mergedMap = new HashMap<String, CrmInvoiceDetailMerge>();
                for (CrmInvoiceDetail crmInvoiceDetail : invoiceDetailList) {
                    String key;
                    CrmOrderProduct orderProduct2;
                    CrmOrderMaster orderMaster;
                    CrmAgreementMaster agreementMaster = agreementMasterMap.get(crmInvoiceDetail.getAgreementId());
                    if (agreementMaster != null) {
                        agreementMaster.setInvoicedAmount(agreementMaster.getInvoicedAmount() + crmInvoiceDetail.getTotalValueTax());
                        agreementMaster.setUnbilledAmount(agreementMaster.getUnbilledAmount() - crmInvoiceDetail.getTotalValueTax());
                    }
                    if ((orderMaster = orderMasterMap.get(crmInvoiceDetail.getOrderId())) != null) {
                        orderMaster.setInvoicedAmount(orderMaster.getInvoicedAmount() + crmInvoiceDetail.getTotalValueTax());
                        orderMaster.setUnbilledAmount(orderMaster.getUnbilledAmount() - crmInvoiceDetail.getTotalValueTax());
                    }
                    if ((orderProduct2 = orderProductMap.get(crmInvoiceDetail.getOrderProductId())) != null) {
                        orderProduct2.setInvoicedNumber(orderProduct2.getInvoicedNumber() + crmInvoiceDetail.getThisInvoicedNumber());
                    }
                    if (mergedMap.containsKey(key = crmInvoiceDetail.getOrderId() + "-" + crmInvoiceDetail.getAgreementId())) {
                        CrmInvoiceDetailMerge existDetail = (CrmInvoiceDetailMerge)mergedMap.get(key);
                        existDetail.setInvoicedAmount(existDetail.getInvoicedAmount() + crmInvoiceDetail.getTotalValueTax());
                        existDetail.setNotRefundAmount(existDetail.getNotRefundAmount() + (crmInvoiceDetail.getTotalValueTax() - crmInvoiceDetail.getQualityAmount()));
                        existDetail.setAccountsReceivable(existDetail.getAccountsReceivable() + (crmInvoiceDetail.getTotalValueTax() - crmInvoiceDetail.getQualityAmount()));
                        mergedMap.put(key, existDetail);
                        if (!"1".equals(crmInvoiceDetail.getWhetherQualityAmount()) || !mergedMap.containsKey(key = key + "1")) continue;
                        CrmInvoiceDetailMerge qualityDetail = (CrmInvoiceDetailMerge)mergedMap.get(key);
                        qualityDetail.setInvoicedAmount(qualityDetail.getInvoicedAmount() + crmInvoiceDetail.getTotalValueTax());
                        qualityDetail.setNotRefundAmount(qualityDetail.getNotRefundAmount() + crmInvoiceDetail.getQualityAmount());
                        qualityDetail.setQualityAmount(qualityDetail.getQualityAmount() + crmInvoiceDetail.getQualityAmount());
                        mergedMap.put(key, qualityDetail);
                        continue;
                    }
                    boolean splt = false;
                    if ("1".equals(crmInvoiceDetail.getWhetherQualityAmount())) {
                        splt = true;
                    }
                    CrmInvoiceDetailMerge mergedDetail = this.initializeDetailMerge(crmInvoiceDetail, crmInvoiceMaster, agreementMaster, splt);
                    mergedMap.put(key, mergedDetail);
                    if (!"1".equals(crmInvoiceDetail.getWhetherQualityAmount())) continue;
                    key = key + "1";
                    CrmInvoiceDetailMerge qualityDetail = this.initializeDetailMerge(crmInvoiceDetail, crmInvoiceMaster, agreementMaster, false);
                    mergedMap.put(key, qualityDetail);
                }
                this.crmAgreementMasterService.updateBatchById(new ArrayList<CrmAgreementMaster>(agreementMasterMap.values()));
                this.crmOrderMasterService.updateBatchById(new ArrayList<CrmOrderMaster>(orderMasterMap.values()));
                this.crmOrderProductService.updateBatchById(new ArrayList<CrmOrderProduct>(orderProductMap.values()));
                this.crmInvoiceDetailMergeService.saveBatch(new ArrayList(mergedMap.values()));
                this.crmInvoiceDetailService.updateBatchById(invoiceDetailList);
                String unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/invoiceDetails?row=" + "\"" + businessKey + "\"";
                String startUserId = this.commonMapper.getStartUserId(businessKey);
                String content = "\u60a8\u63d0\u4ea4\u7684\u5f00\u7968\u3010" + businessName + "\u3011\u5ba1\u6279\u5b8c\u6210\uff0c\u8bf7\u53ca\u65f6\u67e5\u770b\u3002";
                AddSysMessageType addBpmSysMessageType2 = new AddSysMessageType();
                addBpmSysMessageType2.setBusinessAddress(unifyWebUrl);
                UnifyUtil.defaultMessage((AddSysMessageType)addBpmSysMessageType2, (String)content, (LocalDateTime)date, (SecurityUser)user, (String)startUserId, (String)user.getUserName(), (String)unifyWebUrl, (String)"");
                UnifyUtil.sendMessage((AddSysMessageType)addBpmSysMessageType2);
            }
        } else {
            crmInvoiceMaster.setFlowStatus("2");
            String userIds = this.commonMapper.queryTodoUser(businessKey);
            if (StringUtil.isNotBlank((CharSequence)userIds)) {
                List userIdList = Arrays.asList(userIds.split(",")).stream().filter(s -> !s.isEmpty()).collect(Collectors.toList());
                userIds = StringUtil.join(userIdList, (String)",");
                String taskDefinitionKey = this.commonMapper.getTaskDefinitionKey(businessKey);
                Long nextTaskId = this.commonMapper.getTaskIdByBusinessKey(Long.valueOf(businessKey));
                String bpmUnifyWebUrl = this.unifyProperties.getCrmUrl() + "/operationsManage/invoice/invoiceExamine?businessId=" + businessKey + "&taskId=" + nextTaskId + "&doneListIdentification=2&processDefinitionKey=bpm_fpsplc&taskDefinitionKey=" + taskDefinitionKey;
                String content = "\u60a8\u6709\u53d1\u7968\u3010" + businessName + "\u3011\u5f85\u5ba1\u6279\uff0c\u8bf7\u53ca\u65f6\u8ddf\u8fdb\u3002";
                AddSysMessageType addBpmSysMessageType = new AddSysMessageType();
                addBpmSysMessageType.setBusinessAddress(bpmUnifyWebUrl);
                UnifyUtil.defaultMessage((AddSysMessageType)addBpmSysMessageType, (String)content, (LocalDateTime)date, (SecurityUser)user, (String)userIds, (String)user.getUserName(), (String)bpmUnifyWebUrl, (String)"");
                UnifyUtil.sendMessage((AddSysMessageType)addBpmSysMessageType);
            }
        }
        this.crmInvoiceMasterService.updateById(crmInvoiceMaster);
    }

    @Override
    @HussarTransactional
    public ApiResponse<String> initialNodeReject(CrmInvoiceDto crmInvoiceDto) {
        String taskId = crmInvoiceDto.getTaskId();
        String comment = crmInvoiceDto.getComment();
        try {
            CrmInvoice crmInvoice = crmInvoiceDto.getFormdata();
            CrmInvoiceMaster crmInvoiceMaster = crmInvoice.gainCrmInvoiceMaster();
            crmInvoiceMaster.setFlowStatus("3");
            crmInvoiceMaster.setLastEditor(BaseSecurityUtil.getUser().getId());
            crmInvoiceMaster.setLastEditorName(BaseSecurityUtil.getUser().getUserName());
            crmInvoiceMaster.setLastTime(LocalDateTime.now());
            this.crmInvoiceMasterService.saveOrUpdate(crmInvoiceMaster);
            LambdaQueryWrapper ew0 = new LambdaQueryWrapper();
            ew0.eq(CrmInvoiceDetail::getInvoiceId, (Object)crmInvoiceMaster.getInvoiceId());
            this.crmInvoiceDetailService.remove((Wrapper)ew0);
            List<CrmInvoiceDetail> crmInvoiceDetails = crmInvoice.gainCrmInvoiceDetailArray();
            if (null != crmInvoiceDetails) {
                for (CrmInvoiceDetail crmInvoiceDetail : crmInvoiceDetails) {
                    crmInvoiceDetail.setInvoiceId(crmInvoiceMaster.getInvoiceId());
                }
                this.crmInvoiceDetailService.saveOrUpdateBatch(crmInvoiceDetails);
            }
        }
        catch (Exception e) {
            throw new HussarException(e.getMessage(), (Throwable)e);
        }
        return this.initialnodereject(taskId, comment);
    }

    @Override
    @HussarTransactional
    @HussarTokenDs
    public ApiResponse<String> initialnodereject(String taskId, String comment) {
        try {
            if (HussarUtils.isEmpty((Object)BaseSecurityUtil.getUser())) {
                throw new HussarException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
            }
            BpmResponseResult bpmResponseResult = TaskEngineService.rejectToFirstTask((String)taskId, (String)String.valueOf(BaseSecurityUtil.getUser().getId()), (String)comment, null, (boolean)true, null);
            if ("1".equals(bpmResponseResult.getCode())) {
                return ApiResponse.success((String)"");
            }
            throw new HussarException(bpmResponseResult.getMsg());
        }
        catch (Exception e) {
            throw new HussarException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public ApiResponse<CrmInvoicePageVO> hussarQuerycrmInvoiceCondition_1Page(CrmInvoiceCrminvoicedataset1 crminvoicedataset1) {
        try {
            PermissionDto permissionDto = this.invoiceOperate(crminvoicedataset1);
            CrmInvoicePageVO crmInvoicePageVO = new CrmInvoicePageVO();
            Page pager = new Page((long)crminvoicedataset1.getCurrent(), (long)crminvoicedataset1.getSize());
            HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
            ArrayList<String> orderRule = new ArrayList<String>();
            if (crminvoicedataset1.getOrders() != null) {
                StringBuilder order = new StringBuilder();
                for (OrderItem orderItem : crminvoicedataset1.getOrders()) {
                    if (orderItem.isAsc()) {
                        order.append(orderItem.getColumn()).append(ASC);
                        continue;
                    }
                    order.append(orderItem.getColumn()).append(DESC);
                }
                orderRule.add(order.toString());
                parameterMap.put(ORDER_RULE, orderRule.toArray(new String[0]));
            }
            SingleTableQueryGenerator singleTableQueryGenerator = new SingleTableQueryGenerator();
            QueryWrapper queryWrapper = singleTableQueryGenerator.initQueryWrapper((Object)new CrmInvoice(), parameterMap);
            Long currentUserId = BaseSecurityUtil.getUser().getId();
            crminvoicedataset1.setCurrentUserId(currentUserId);
            List<CrmInvoiceCrminvoicedataset1> dtoList = this.getOrderUnityDtoList(crminvoicedataset1);
            crminvoicedataset1.setPermissionDto(permissionDto);
            crminvoicedataset1.setCurrentUserId(currentUserId);
            crminvoicedataset1.setDtoList(dtoList);
            List<CrmInvoice> list = this.crmInvoiceMapper.hussarQuerycrmInvoiceCondition_1Page((Page<CrmInvoice>)pager, crminvoicedataset1, (QueryWrapper<CrmInvoice>)queryWrapper);
            crmInvoicePageVO.setData(list);
            crmInvoicePageVO.setCount(pager.getTotal());
            crmInvoicePageVO.setCode(RETURN_CODE);
            return ApiResponse.success((Object)crmInvoicePageVO);
        }
        catch (Exception e) {
            throw new HussarException("\u8868\u683c\u67e5\u8be2\u5f02\u5e38", (Throwable)e);
        }
    }

    @Override
    @HussarTransactional
    public ApiResponse<String> insertOrUpdatePlus(CrmInvoice crmInvoice) {
        try {
            CrmInvoiceMaster crmInvoiceMaster = crmInvoice.gainCrmInvoiceMaster();
            this.crmInvoiceMasterService.saveOrUpdate(crmInvoiceMaster);
            LambdaQueryWrapper ew0 = new LambdaQueryWrapper();
            ew0.eq(CrmInvoiceDetail::getInvoiceId, (Object)crmInvoiceMaster.getInvoiceId());
            this.crmInvoiceDetailService.remove((Wrapper)ew0);
            List<CrmInvoiceDetail> crmInvoiceDetails = crmInvoice.gainCrmInvoiceDetailArray();
            if (null != crmInvoiceDetails) {
                for (CrmInvoiceDetail crmInvoiceDetail : crmInvoiceDetails) {
                    crmInvoiceDetail.setInvoiceId(crmInvoiceMaster.getInvoiceId());
                }
                this.crmInvoiceDetailService.saveOrUpdateBatch(crmInvoiceDetails);
            }
            this.crmInvoiceDetailMergeService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(CrmInvoiceDetailMerge::getInvoiceId, (Object)crmInvoiceMaster.getInvoiceId())).set(CrmInvoiceDetailMerge::getInvoiceDate, (Object)LocalDate.now()));
            return ApiResponse.success((Object)String.valueOf(crmInvoiceMaster.getInvoiceId()), (String)"");
        }
        catch (Exception e) {
            throw new HussarException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List<AssociativeQueryVo> associativeQuery(CrmInvoiceAssociativeQueryDto dto) {
        String keyWord = dto.getKeyword();
        String queryScreening = null;
        if (dto.getDto() != null) {
            queryScreening = dto.getDto().getInvoiceNameFullLike();
        }
        ICrmInvoiceAssociativeQueryService adapterService = this.crmInvoiceAssociativeQueryService;
        AssociativeKeyword associativeKeyword = new AssociativeKeyword();
        associativeKeyword.setLabelName("\u5173\u952e\u5b57");
        associativeKeyword.setDataName("input_5Data");
        associativeKeyword.setDictTypeName("");
        associativeKeyword.setMultiOption(Boolean.valueOf(false));
        return this.associativeQueryService.associativeQuery((AssociativeQueryDto)dto, keyWord, queryScreening, (IAssociativeQueryAdapterService)adapterService, associativeKeyword);
    }

    private List<CrmInvoiceCrminvoicedataset1> getOrderUnityDtoList(CrmInvoiceCrminvoicedataset1 crminvoicedataset1) {
        ArrayList<CrmInvoiceCrminvoicedataset1> queryDtoList = new ArrayList<CrmInvoiceCrminvoicedataset1>();
        String view = crminvoicedataset1.getInvoiceView();
        if (StringUtil.isNotEmpty((Object)view) && !"preview".equals(view)) {
            CrmScene crmScene;
            long invoiceView = Long.parseLong(view);
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(CrmScene::getSceneId, (Object)invoiceView);
            lambdaQueryWrapper.eq(CrmScene::getModule, (Object)"invoice");
            List crmSceneList = this.crmSceneMapper.selectList((Wrapper)lambdaQueryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)crmSceneList) && RETURN_CODE.equals((crmScene = (CrmScene)crmSceneList.get(0)).getIsSystem())) {
                try {
                    String query = crmScene.getQuery();
                    if (StringUtil.isNotBlank((CharSequence)query)) {
                        String queryValue = JSONObject.parseObject((String)query).get((Object)"queryValue").toString();
                        CrmInvoiceCrminvoicedataset1 queryDto = (CrmInvoiceCrminvoicedataset1)JSONObject.parseObject((String)queryValue, CrmInvoiceCrminvoicedataset1.class);
                        queryDto.setInvoiceView(String.valueOf(invoiceView));
                        queryDtoList.add(queryDto);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        queryDtoList.add(this.crminvoicedataset1Condition(crminvoicedataset1));
        return queryDtoList;
    }

    private CrmInvoiceCrminvoicedataset1 crminvoicedataset1Condition(CrmInvoiceCrminvoicedataset1 crminvoicedataset1) {
        DateConvertVo dateConvertVo;
        if (ToolUtil.isNotEmpty((Object)crminvoicedataset1.getApplyTimeFlag()) && !"6".equals(crminvoicedataset1.getApplyTimeFlag()) && (dateConvertVo = CrmDateUtils.getCurrentTime((String)crminvoicedataset1.getApplyTimeFlag())) != null) {
            crminvoicedataset1.setApplyStartDate(LocalDate.parse(dateConvertVo.getStartDate()));
            crminvoicedataset1.setApplyEndDate(LocalDate.parse(dateConvertVo.getEndDate()));
        }
        if (ToolUtil.isNotEmpty((Object)crminvoicedataset1.getInvoiceTimeFlag()) && !"6".equals(crminvoicedataset1.getInvoiceTimeFlag()) && (dateConvertVo = CrmDateUtils.getCurrentTime((String)crminvoicedataset1.getInvoiceTimeFlag())) != null) {
            crminvoicedataset1.setInvoiceStartDate(LocalDate.parse(dateConvertVo.getStartDate()));
            crminvoicedataset1.setInvoiceEndDate(LocalDate.parse(dateConvertVo.getEndDate()));
        }
        if (CollectionUtil.isNotEmpty((Collection)crminvoicedataset1.getOwnDepartment())) {
            List departments = crminvoicedataset1.getOwnDepartment();
            ArrayList odpIds = new ArrayList();
            if (ToolUtil.isNotEmpty((Object)departments) && !departments.isEmpty()) {
                for (Object longOdpId : departments) {
                    ArrayList Ids;
                    String odpId = String.valueOf(longOdpId);
                    String odpIsTemp = com.jxdinfo.crm.core.utills.CommonUtills.translateDepId((String)odpId);
                    List idsTemp = com.jxdinfo.crm.core.utills.CommonUtills.selectOpportunityTissueTreeUserId((String)odpIsTemp, Ids = new ArrayList());
                    if (idsTemp.isEmpty()) continue;
                    for (int i = 0; i < idsTemp.size(); ++i) {
                        odpIds.add(idsTemp.get(i));
                    }
                }
                crminvoicedataset1.setOwnDepartment(odpIds);
            }
        }
        return crminvoicedataset1;
    }

    private CrmInvoice updateCrmInvoiceInfo(CrmInvoice crmInvoice) {
        String invoiceState;
        long focusCount;
        String applyBody;
        String claimType;
        SecurityUser user = BaseSecurityUtil.getUser();
        ArrayList<String> typeNameList = new ArrayList<String>();
        typeNameList.add("Invoice_type");
        typeNameList.add("claim_type");
        typeNameList.add("apply_body");
        typeNameList.add("abandon_state");
        typeNameList.add("invoice_state");
        List dictVoList = this.sysDicSingleMapper.getDictVosByTypeNames(typeNameList);
        List invoiceTypeDict = null;
        List claimTypeDict = null;
        List applyBodyDict = null;
        List abandonStateDict = null;
        List invoiceStateDict = null;
        for (DictVo dictVo : dictVoList) {
            switch (dictVo.getTypeName()) {
                case "Invoice_type": {
                    invoiceTypeDict = dictVo.getSingleList();
                    break;
                }
                case "claim_type": {
                    claimTypeDict = dictVo.getSingleList();
                    break;
                }
                case "apply_body": {
                    applyBodyDict = dictVo.getSingleList();
                    break;
                }
                case "abandon_state": {
                    abandonStateDict = dictVo.getSingleList();
                    break;
                }
                case "invoice_state": {
                    invoiceStateDict = dictVo.getSingleList();
                }
            }
        }
        String invoiceType = crmInvoice.getInvoiceType();
        if (CollectionUtil.isNotEmpty((Object)invoiceType) && StringUtil.isNotEmpty((Object)invoiceType)) {
            crmInvoice.setTranslateInvoiceType(this.valueToLabelByDictSingle(invoiceType, invoiceTypeDict));
        }
        if (CollectionUtil.isNotEmpty((Object)(claimType = crmInvoice.getClaimType())) && StringUtil.isNotEmpty((Object)claimType)) {
            crmInvoice.setTranslateClaimType(this.valueToLabelByDictSingle(claimType, claimTypeDict));
        }
        if (CollectionUtil.isNotEmpty((Object)(applyBody = crmInvoice.getApplyBody())) && StringUtil.isNotEmpty((Object)applyBody)) {
            crmInvoice.setTranslateApplyBody(this.valueToLabelByDictSingle(applyBody, applyBodyDict));
        }
        crmInvoice.setFocus((focusCount = this.focusService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(FocusEntity::getBusinessId, (Object)crmInvoice.getInvoiceId())).eq(FocusEntity::getCreatePersion, (Object)user.getId()))) > 0L);
        String abandonState = crmInvoice.getAbandonState();
        if (CollectionUtil.isNotEmpty((Object)abandonState) && StringUtil.isNotEmpty((Object)abandonState)) {
            crmInvoice.setTranslateAbandonState(this.valueToLabelByDictSingle(abandonState, abandonStateDict));
        }
        if (CollectionUtil.isNotEmpty((Object)(invoiceState = crmInvoice.getInvoiceState())) && StringUtil.isNotEmpty((Object)invoiceState)) {
            crmInvoice.setTranslateInvoiceState(this.valueToLabelByDictSingle(invoiceState, invoiceStateDict));
        }
        return crmInvoice;
    }

    private String valueToLabelByDictSingle(String values, List<DicSingle> dicSingleList) {
        Map<String, String> dictSingleMap = dicSingleList.stream().collect(Collectors.toMap(DicSingle::getValue, DicSingle::getLabel));
        String[] valueArray = values.split(",");
        String labels = "";
        for (String array : valueArray) {
            String label = dictSingleMap.get(array);
            if (!StringUtil.isNotEmpty((Object)label)) continue;
            labels = StringUtil.isNotEmpty((Object)labels) ? labels + "," + label : label;
        }
        return labels;
    }

    public PermissionDto invoiceOperate(CrmInvoiceCrminvoicedataset1 dto) {
        PermissionDto permissionDto = new PermissionDto();
        String orderView = dto.getInvoiceView();
        if (StringUtil.isNotEmpty((Object)orderView) && !RETURN_CODE.equals(orderView)) {
            permissionDto = this.invoiceDataRightModuleService.getCurrentUserRolePermissions();
        }
        return permissionDto;
    }

    @Override
    public Double sumTotalValueTax(Long agreementId, Long orderId) {
        return this.crmInvoiceMapper.sumTotalValueTax(agreementId, orderId);
    }

    @Override
    public Page<CrmInvoiceDetail> getInvoiceDetailList(CrmInvoiceDetailIncrementDTO dto) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(CrmInvoiceDetail::getOrderProductId, (Object)dto.getOrderProductId())).eq(CrmInvoiceDetail::getDelFlag, (Object)RETURN_CODE);
        Page pager = new Page(dto.getCurrent(), dto.getSize());
        Page detailList = (Page)this.crmInvoiceDetailService.page((IPage)pager, (Wrapper)queryWrapper);
        return detailList;
    }

    @Override
    @HussarTransactional
    public Boolean invoiceAbandon(CrmInvoiceCrminvoicedataset1 crminvoicedataset1) {
        if (HussarUtils.isEmpty((Object)crminvoicedataset1.getInvoiceId()) || HussarUtils.isEmpty((Object)crminvoicedataset1.getAbandonReason())) {
            throw new HussarException("\u53c2\u6570\u7f3a\u5931");
        }
        long claimDetailCount = this.crmRefundClaimDetailMapper.selectCount((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CrmRefundClaimDetail::getInvoiceId, (Object)crminvoicedataset1.getInvoiceId())).eq(CrmRefundClaimDetail::getDelFlag, (Object)RETURN_CODE));
        if (claimDetailCount > 0L) {
            throw new HussarException("\u8be5\u53d1\u7968\u5df2\u5173\u8054\u56de\u6b3e\u8ba4\u9886\uff0c\u4e0d\u80fd\u4f5c\u5e9f");
        }
        CrmInvoiceMaster crmInvoiceMaster = (CrmInvoiceMaster)this.crmInvoiceMasterService.getById(crminvoicedataset1.getInvoiceId());
        this.crmInvoiceMasterService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(CrmInvoiceMaster::getInvoiceId, (Object)crminvoicedataset1.getInvoiceId())).set(CrmInvoiceMaster::getAbandonState, (Object)"1")).set(CrmInvoiceMaster::getAbandonReason, (Object)crminvoicedataset1.getAbandonReason()));
        List crmInvoiceDetailList = this.crmInvoiceDetailService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CrmInvoiceDetail::getInvoiceDetailId, (Object)crminvoicedataset1.getInvoiceId())).eq(CrmInvoiceDetail::getDelFlag, (Object)RETURN_CODE));
        this.crmInvoiceDetailMergeService.remove((Wrapper)new LambdaQueryWrapper().eq(CrmInvoiceDetailMerge::getInvoiceId, (Object)crminvoicedataset1.getInvoiceId()));
        if (CollectionUtil.isNotEmpty((Collection)crmInvoiceDetailList)) {
            Double totalValueTaxSum;
            List<CrmInvoiceDetail> crmInvoiceDetails;
            Map<Long, List<CrmInvoiceDetail>> agreementMap = crmInvoiceDetailList.stream().collect(Collectors.groupingBy(CrmInvoiceDetail::getAgreementId));
            List agreementIdList = crmInvoiceDetailList.stream().map(CrmInvoiceDetail::getAgreementId).collect(Collectors.toList());
            List agreementMasterList = this.crmAgreementMasterService.listByIds(agreementIdList);
            Map<Long, List<CrmInvoiceDetail>> orderMap = crmInvoiceDetailList.stream().collect(Collectors.groupingBy(CrmInvoiceDetail::getOrderId));
            List orderIdList = crmInvoiceDetailList.stream().map(CrmInvoiceDetail::getOrderId).collect(Collectors.toList());
            List orderMasterList = this.crmOrderMasterService.listByIds(orderIdList);
            for (CrmAgreementMaster agreementMaster : agreementMasterList) {
                crmInvoiceDetails = agreementMap.get(agreementMaster.getAgreementId());
                if (!CollectionUtil.isNotEmpty(crmInvoiceDetails)) continue;
                totalValueTaxSum = crmInvoiceDetails.stream().mapToDouble(CrmInvoiceDetail::getTotalValueTax).sum();
                agreementMaster.setInvoicedAmount(agreementMaster.getInvoicedAmount() - totalValueTaxSum);
                agreementMaster.setUnbilledAmount(agreementMaster.getUnbilledAmount() + totalValueTaxSum);
            }
            this.crmAgreementMasterService.updateBatchById(agreementMasterList);
            for (CrmOrderMaster orderMaster : orderMasterList) {
                crmInvoiceDetails = orderMap.get(orderMaster.getOrderId());
                if (!CollectionUtil.isNotEmpty(crmInvoiceDetails)) continue;
                totalValueTaxSum = crmInvoiceDetails.stream().mapToDouble(CrmInvoiceDetail::getTotalValueTax).sum();
                orderMaster.setInvoicedAmount(orderMaster.getInvoicedAmount() - totalValueTaxSum);
                orderMaster.setUnbilledAmount(orderMaster.getUnbilledAmount() + totalValueTaxSum);
            }
            this.crmOrderMasterService.updateBatchById(orderMasterList);
        }
        return true;
    }

    @Override
    @HussarTransactional
    public Boolean invoiceDelete(Long invoiceId) {
        if (HussarUtils.isEmpty((Object)invoiceId)) {
            throw new HussarException("\u53c2\u6570\u7f3a\u5931");
        }
        this.crmInvoiceMasterService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(CrmInvoiceMaster::getInvoiceId, (Object)invoiceId)).set(CrmInvoiceMaster::getDelFlag, (Object)"1"));
        this.crmInvoiceDetailService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(CrmInvoiceDetail::getInvoiceId, (Object)invoiceId)).set(CrmInvoiceDetail::getDelFlag, (Object)"1"));
        InstanceEngineService.deleteProcessInstanceByBusinessKey((String)String.valueOf(invoiceId));
        return true;
    }

    @Override
    public List<CrmInvoice> selectInvoiceByOrderId(Long orderId) {
        return this.crmInvoiceMapper.getInvoiceByOrderId(orderId);
    }

    private void saveInvoiceOperateLog(CrmInvoice oldInvoice, CrmInvoice crmInvoice, LocalDateTime date) {
        String oldThisApplyNotAmount;
        String oldThisApplyAmount;
        ArrayList<String> typeNameList = new ArrayList<String>();
        typeNameList.add("Invoice_type");
        typeNameList.add("claim_type");
        typeNameList.add("apply_body");
        List dictVoList = this.sysDicSingleMapper.getDictVosByTypeNames(typeNameList);
        List invoiceTypeDict = new ArrayList();
        List claimTypeDict = new ArrayList();
        List applyBodyDict = new ArrayList();
        for (DictVo dictVo : dictVoList) {
            switch (dictVo.getTypeName()) {
                case "Invoice_type": {
                    invoiceTypeDict = dictVo.getSingleList();
                    break;
                }
                case "claim_type": {
                    claimTypeDict = dictVo.getSingleList();
                    break;
                }
                case "apply_body": {
                    applyBodyDict = dictVo.getSingleList();
                }
            }
        }
        ArrayList changeField = new ArrayList();
        HashMap<String, String> before = new HashMap<String, String>();
        HashMap<String, String> after = new HashMap<String, String>();
        Boolean hasChange = false;
        String newInvoiceType = crmInvoice.getInvoiceType();
        String oldInvoiceType = oldInvoice.getInvoiceType();
        if (!(ToolUtil.isEmpty((Object)newInvoiceType) && ToolUtil.isEmpty((Object)oldInvoiceType) || newInvoiceType.equals(oldInvoiceType))) {
            HashMap<String, String> field = new HashMap<String, String>();
            field.put("field", InvoiceEditEnum.INVOICE_TYPE.getField());
            field.put("fieldName", InvoiceEditEnum.INVOICE_TYPE.getName());
            changeField.add(field);
            before.put(InvoiceEditEnum.INVOICE_TYPE.getField(), DictUtils.valueToLabelByDictSingle((String)oldInvoiceType, invoiceTypeDict));
            after.put(InvoiceEditEnum.INVOICE_TYPE.getField(), DictUtils.valueToLabelByDictSingle((String)newInvoiceType, invoiceTypeDict));
            hasChange = true;
        }
        String newThisApplyAmount = crmInvoice.getThisApplyAmount() == null ? "\u7a7a" : CommonUtills.transferAmountSeparator((Double)crmInvoice.getThisApplyAmount());
        String string = oldThisApplyAmount = oldInvoice.getThisApplyAmount() == null ? "\u7a7a" : CommonUtills.transferAmountSeparator((Double)oldInvoice.getThisApplyAmount());
        if (!(ToolUtil.isEmpty((Object)newThisApplyAmount) && ToolUtil.isEmpty((Object)oldThisApplyAmount) || newThisApplyAmount.equals(oldThisApplyAmount))) {
            HashMap<String, String> field = new HashMap<String, String>();
            field.put("field", InvoiceEditEnum.THIS_APPLY_AMOUNT.getField());
            field.put("fieldName", InvoiceEditEnum.THIS_APPLY_AMOUNT.getName());
            changeField.add(field);
            before.put(InvoiceEditEnum.THIS_APPLY_AMOUNT.getField(), oldThisApplyAmount);
            after.put(InvoiceEditEnum.THIS_APPLY_AMOUNT.getField(), newThisApplyAmount);
            hasChange = true;
        }
        String newThisApplyNotAmount = crmInvoice.getThisApplyNotAmount() == null ? "\u7a7a" : CommonUtills.transferAmountSeparator((Double)crmInvoice.getThisApplyNotAmount());
        String string2 = oldThisApplyNotAmount = oldInvoice.getThisApplyNotAmount() == null ? "\u7a7a" : CommonUtills.transferAmountSeparator((Double)oldInvoice.getThisApplyNotAmount());
        if (!(ToolUtil.isEmpty((Object)newThisApplyNotAmount) && ToolUtil.isEmpty((Object)oldThisApplyNotAmount) || newThisApplyNotAmount.equals(oldThisApplyNotAmount))) {
            HashMap<String, String> field = new HashMap<String, String>();
            field.put("field", InvoiceEditEnum.THIS_APPLY_NOT_AMOUNT.getField());
            field.put("fieldName", InvoiceEditEnum.THIS_APPLY_NOT_AMOUNT.getName());
            changeField.add(field);
            before.put(InvoiceEditEnum.THIS_APPLY_NOT_AMOUNT.getField(), oldThisApplyNotAmount);
            after.put(InvoiceEditEnum.THIS_APPLY_NOT_AMOUNT.getField(), newThisApplyNotAmount);
            hasChange = true;
        }
        String newApplyBody = crmInvoice.getApplyBody();
        String oldApplyBody = oldInvoice.getApplyBody();
        if (!(ToolUtil.isEmpty((Object)newApplyBody) && ToolUtil.isEmpty((Object)oldApplyBody) || newApplyBody.equals(oldApplyBody))) {
            HashMap<String, String> field = new HashMap<String, String>();
            field.put("field", InvoiceEditEnum.APPLY_BODY.getField());
            field.put("fieldName", InvoiceEditEnum.APPLY_BODY.getName());
            changeField.add(field);
            before.put(InvoiceEditEnum.APPLY_BODY.getField(), DictUtils.valueToLabelByDictSingle((String)oldApplyBody, applyBodyDict));
            after.put(InvoiceEditEnum.APPLY_BODY.getField(), DictUtils.valueToLabelByDictSingle((String)newApplyBody, applyBodyDict));
            hasChange = true;
        }
        String newCustomerName = crmInvoice.getCustomerName();
        String oldCustomerName = oldInvoice.getCustomerName();
        if (!(ToolUtil.isEmpty((Object)newCustomerName) && ToolUtil.isEmpty((Object)oldCustomerName) || newCustomerName.equals(oldCustomerName))) {
            HashMap<String, String> field = new HashMap<String, String>();
            field.put("field", InvoiceEditEnum.CUSTOMER_NAME.getField());
            field.put("fieldName", InvoiceEditEnum.CUSTOMER_NAME.getName());
            changeField.add(field);
            before.put(InvoiceEditEnum.CUSTOMER_NAME.getField(), oldCustomerName);
            after.put(InvoiceEditEnum.CUSTOMER_NAME.getField(), newCustomerName);
            hasChange = true;
        }
        String newInvoiceTotal = crmInvoice.getInvoiceTotal();
        String oldInvoiceTotal = oldInvoice.getInvoiceTotal();
        if (!(ToolUtil.isEmpty((Object)newInvoiceTotal) && ToolUtil.isEmpty((Object)oldInvoiceTotal) || newInvoiceTotal.equals(oldInvoiceTotal))) {
            HashMap<String, String> field = new HashMap<String, String>();
            field.put("field", InvoiceEditEnum.INVOICE_TOTAL.getField());
            field.put("fieldName", InvoiceEditEnum.INVOICE_TOTAL.getName());
            changeField.add(field);
            before.put(InvoiceEditEnum.INVOICE_TOTAL.getField(), oldInvoiceTotal);
            after.put(InvoiceEditEnum.INVOICE_TOTAL.getField(), newInvoiceTotal);
            hasChange = true;
        }
        String newTaxCode = crmInvoice.getTaxCode();
        String oldTaxCode = oldInvoice.getTaxCode();
        if (!(ToolUtil.isEmpty((Object)newTaxCode) && ToolUtil.isEmpty((Object)oldTaxCode) || newTaxCode.equals(oldTaxCode))) {
            HashMap<String, String> field = new HashMap<String, String>();
            field.put("field", InvoiceEditEnum.TAX_CODE.getField());
            field.put("fieldName", InvoiceEditEnum.TAX_CODE.getName());
            changeField.add(field);
            before.put(InvoiceEditEnum.TAX_CODE.getField(), oldTaxCode);
            after.put(InvoiceEditEnum.TAX_CODE.getField(), newTaxCode);
            hasChange = true;
        }
        String newOpenBank = crmInvoice.getOpenBank();
        String oldOpenBank = oldInvoice.getOpenBank();
        if (!(ToolUtil.isEmpty((Object)newOpenBank) && ToolUtil.isEmpty((Object)oldOpenBank) || newOpenBank.equals(oldOpenBank))) {
            HashMap<String, String> field = new HashMap<String, String>();
            field.put("field", InvoiceEditEnum.OPEN_BANK.getField());
            field.put("fieldName", InvoiceEditEnum.OPEN_BANK.getName());
            changeField.add(field);
            before.put(InvoiceEditEnum.OPEN_BANK.getField(), oldOpenBank);
            after.put(InvoiceEditEnum.OPEN_BANK.getField(), newOpenBank);
            hasChange = true;
        }
        String newBankAccount = crmInvoice.getBankAccount();
        String oldBankAccount = oldInvoice.getBankAccount();
        if (!(ToolUtil.isEmpty((Object)newBankAccount) && ToolUtil.isEmpty((Object)oldBankAccount) || newBankAccount.equals(oldBankAccount))) {
            HashMap<String, String> field = new HashMap<String, String>();
            field.put("field", InvoiceEditEnum.BANK_ACCOUNT.getField());
            field.put("fieldName", InvoiceEditEnum.BANK_ACCOUNT.getName());
            changeField.add(field);
            before.put(InvoiceEditEnum.BANK_ACCOUNT.getField(), oldBankAccount);
            after.put(InvoiceEditEnum.BANK_ACCOUNT.getField(), newBankAccount);
            hasChange = true;
        }
        String newClaimType = crmInvoice.getClaimType();
        String oldClaimType = oldInvoice.getClaimType();
        if (!(ToolUtil.isEmpty((Object)newClaimType) && ToolUtil.isEmpty((Object)oldClaimType) || newClaimType.equals(oldClaimType))) {
            HashMap<String, String> field = new HashMap<String, String>();
            field.put("field", InvoiceEditEnum.CLAIM_TYPE.getField());
            field.put("fieldName", InvoiceEditEnum.CLAIM_TYPE.getName());
            changeField.add(field);
            before.put(InvoiceEditEnum.CLAIM_TYPE.getField(), DictUtils.valueToLabelByDictSingle((String)oldClaimType, claimTypeDict));
            after.put(InvoiceEditEnum.CLAIM_TYPE.getField(), DictUtils.valueToLabelByDictSingle((String)newClaimType, claimTypeDict));
            hasChange = true;
        }
        if (hasChange.booleanValue()) {
            String oldJson = JSON.toJSONString(before);
            String newJson = JSON.toJSONString(after);
            String changeFieldStr = JSON.toJSONString(changeField);
            OperateRecordAPIVo operateRecordDO = this.crmOpportunity2Service.initializeOperateLog(RecordProductTypeEnum.PRODUCE_CHANGE.getId(), oldJson, newJson, changeFieldStr);
            operateRecordDO.setChangeBatch(1);
            this.operateRecordAPIService.saveOperateLog(operateRecordDO, CrmBusinessTypeEnum.INVOICE, crmInvoice.getInvoiceId(), oldInvoice.getInvoiceNumber(), date, false, Collections.singletonList(crmInvoice.getInvoiceId()));
        }
    }

    @Override
    public Page<CrmInvoiceDetailMerge> selectInvoiceDetailByCustomer(CrmInvoiceCrminvoicedataset1 crminvoicedataset1) {
        Page page = new Page();
        if (ToolUtil.isNotEmpty((Object)crminvoicedataset1.getContractFullLike())) {
            crminvoicedataset1.setContractFullLike(crminvoicedataset1.getContractFullLike().replaceAll("%", "/%").replaceAll("_", "/_"));
        }
        if (ToolUtil.isNotEmpty((Object)crminvoicedataset1.getOrderFullLike())) {
            crminvoicedataset1.setOrderFullLike(crminvoicedataset1.getOrderFullLike().replaceAll("%", "/%").replaceAll("_", "/_"));
        }
        if (ToolUtil.isNotEmpty((Object)crminvoicedataset1.getInvoiceFullLike())) {
            crminvoicedataset1.setInvoiceFullLike(crminvoicedataset1.getInvoiceFullLike().replaceAll("%", "/%").replaceAll("_", "/_"));
        }
        List<CrmInvoiceDetailMerge> invoiceDetailByCustomerVoList = this.crmInvoiceDetailMapper.selectInvoiceDetailByCustomer(page, crminvoicedataset1);
        page.setRecords(invoiceDetailByCustomerVoList);
        return page;
    }

    @Override
    public OperateVo operate(Long invoiceId) {
        PermissionDto invoicePermissionDto;
        OperateVo operateVo = new OperateVo();
        if (invoiceId == null) {
            return operateVo;
        }
        CrmInvoiceMaster crmInvoice = (CrmInvoiceMaster)this.crmInvoiceMasterService.getById(invoiceId);
        if (crmInvoice == null || "1".equals(crmInvoice.getDelFlag())) {
            return operateVo;
        }
        if ("1".equals(crmInvoice.getAbandonState())) {
            operateVo.setViewOperate(Boolean.valueOf(true));
            operateVo.setEditOperate(Integer.valueOf(-1));
            return operateVo;
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        if (Objects.equals(crmInvoice.getChargePerson(), user.getUserId())) {
            operateVo.setEditOperate(Integer.valueOf(1));
            operateVo.setViewOperate(Boolean.valueOf(true));
            return operateVo;
        }
        this.teamMemberApiService.teamMemberOperate(invoiceId, user, operateVo, "25");
        if (!operateVo.getViewOperate().booleanValue() && ((invoicePermissionDto = this.invoiceDataRightModuleService.getUserRolePermission(user)).getPermissionDeptIds() == null || invoicePermissionDto.getPermissionDeptIds().contains(crmInvoice.getOwnDepartment()))) {
            operateVo.setViewOperate(Boolean.valueOf(true));
        }
        return operateVo;
    }

    @Override
    public void generateWordFromTemplate(String invoiceId, HttpServletResponse response) throws Exception {
        String outputPath = "output.docx";
        CrmInvoice crmInvoice = this.crmInvoiceMapper.formQuery(invoiceId);
        HashMap<String, Object> data = new HashMap<String, Object>();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5");
        data.put("date", crmInvoice.getApplyDate().format(formatter));
        data.put("applyPersonName", crmInvoice.getApplyPersonName());
        List<CrmInvoiceDetail> crmInvoiceDetailList = crmInvoice.getCrmInvoiceDetail();
        ArrayList<RowRenderData> serverDataList = new ArrayList<RowRenderData>();
        for (int i = 0; i < crmInvoiceDetailList.size(); ++i) {
            CrmInvoiceDetail crmInvoiceDetail = crmInvoiceDetailList.get(i);
            serverDataList.add(Rows.of((String[])new String[]{i + 1 + "", crmInvoice.getCustomerName(), crmInvoiceDetail.getProductName(), crmInvoiceDetail.getThisInvoicedNumber() + "", crmInvoiceDetail.getNotTaxUnitPrice() + "", crmInvoiceDetail.getAgreementNumber() + "", "", crmInvoice.getRemark() + ""}).textFontSize(13).center().create());
        }
        ServerTableData serverTableData = new ServerTableData();
        serverTableData.setServerDataList(serverDataList);
        data.put("crmInvoiceList", serverTableData);
        ServerTablePolicy serverTablePolicy = new ServerTablePolicy(3, 10);
        serverTablePolicy.setColArr(Arrays.asList(1, 9));
        Configure configure = Configure.builder().bind("crmInvoiceList", (RenderPolicy)serverTablePolicy).build();
        InputStream templateInputStream = CrmInvoiceServiceImpl.class.getClassLoader().getResourceAsStream("templates/fpsqb.docx");
        if (templateInputStream == null) {
            throw new RuntimeException("\u65e0\u6cd5\u627e\u5230\u6a21\u677f\u6587\u4ef6 fpsqb.docx");
        }
        XWPFTemplate template = XWPFTemplate.compile((InputStream)templateInputStream, (Configure)configure).render(data);
        FileOutputStream out = new FileOutputStream(new File(outputPath));
        BufferedOutputStream bos = new BufferedOutputStream(out);
        XWPFTable table = template.getXWPFDocument().getTableArray(0);
        MyPoiUtil.setTableBorder(table);
        bos.flush();
        out.flush();
        try {
            response.setContentType("application/vnd.openxmlformats-officedocument.wordprocessingml.document");
            BufferedOutputStream outputStream = new BufferedOutputStream((OutputStream)response.getOutputStream());
            template.write((OutputStream)outputStream);
            outputStream.flush();
            outputStream.close();
        }
        catch (Exception e) {
            throw new HussarException("\u5bfc\u51faWord\u6587\u6863\u65f6\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    @Override
    public List<CrmInvoiceDetailByWbsVo> invoiceDetailListByWbsVo(CrmInvoiceCrminvoicedataset1 crminvoicedataset1) {
        List<CrmInvoiceDetailByWbsVo> crmInvoiceDetailByWbsVoList = this.crmInvoiceDetailMapper.invoiceDetailListByWbsVo(crminvoicedataset1);
        return crmInvoiceDetailByWbsVoList;
    }

    @Override
    public CrmInvoicePageVO invoiceCount(CrmInvoiceCrminvoicedataset1 crminvoicedataset1) {
        CrmInvoicePageVO crmInvoicePageVO = new CrmInvoicePageVO();
        Page pager = new Page((long)crminvoicedataset1.getCurrent(), (long)crminvoicedataset1.getSize());
        List<CrmInvoice> list = this.crmInvoiceMapper.invoiceCount((Page<CrmInvoice>)pager, crminvoicedataset1);
        crmInvoicePageVO.setData(list);
        crmInvoicePageVO.setCount(pager.getTotal());
        crmInvoicePageVO.setCode(RETURN_CODE);
        return crmInvoicePageVO;
    }

    private CrmInvoiceDetailMerge initializeDetailMerge(CrmInvoiceDetail crmInvoiceDetail, CrmInvoiceMaster crmInvoiceMaster, CrmAgreementMaster crmAgreementMaster, boolean splt) {
        CrmInvoiceDetailMerge crmInvoiceDetailMerge = new CrmInvoiceDetailMerge();
        crmInvoiceDetailMerge.setCustomerId(crmInvoiceMaster.getCustomerId());
        crmInvoiceDetailMerge.setOrderId(crmInvoiceDetail.getOrderId());
        crmInvoiceDetailMerge.setOrderNumber(crmInvoiceDetail.getOrderNumber());
        crmInvoiceDetailMerge.setAgreementId(crmInvoiceDetail.getAgreementId());
        crmInvoiceDetailMerge.setAgreementNumber(crmInvoiceDetail.getAgreementNumber());
        crmInvoiceDetailMerge.setAgreementName(crmInvoiceDetail.getAgreementName());
        crmInvoiceDetailMerge.setInvoiceId(crmInvoiceDetail.getInvoiceId());
        crmInvoiceDetailMerge.setApplyNumber(crmInvoiceMaster.getApplyNumber());
        crmInvoiceDetailMerge.setInvoicedAmount(crmInvoiceDetail.getTotalValueTax());
        crmInvoiceDetailMerge.setRefundAmount(0.0);
        if (RETURN_CODE.equals(crmInvoiceDetail.getWhetherQualityAmount()) || splt) {
            crmInvoiceDetailMerge.setNotRefundAmount(crmInvoiceDetail.getTotalValueTax() - crmInvoiceDetail.getQualityAmount());
            crmInvoiceDetailMerge.setAccountsReceivable(crmInvoiceDetailMerge.getNotRefundAmount());
            crmInvoiceDetailMerge.setWhetherQualityAmount(RETURN_CODE);
            crmInvoiceDetailMerge.setQualityAmount(0.0);
            crmInvoiceDetailMerge.setQualityAmountRate(0.0);
        } else {
            crmInvoiceDetailMerge.setNotRefundAmount(crmInvoiceDetail.getRetentionProvision());
            crmInvoiceDetailMerge.setAccountsReceivable(0.0);
            crmInvoiceDetailMerge.setWhetherQualityAmount("1");
            crmInvoiceDetailMerge.setQualityAmount(crmInvoiceDetail.getQualityAmount());
            crmInvoiceDetailMerge.setQualityAmountRate(crmInvoiceDetail.getQualityAmountRate());
        }
        if (crmAgreementMaster != null) {
            crmInvoiceDetailMerge.setQualityDate(crmAgreementMaster.getQualityDate());
            crmInvoiceDetailMerge.setQualityExpireDate(crmAgreementMaster.getQualityExpireDate());
            crmInvoiceDetailMerge.setQualityRefundDate(crmAgreementMaster.getQualityRefundDate());
            crmInvoiceDetailMerge.setQualityActualDate(crmAgreementMaster.getQualityActualDate());
        }
        crmInvoiceDetailMerge.setQualityExpireDate(crmInvoiceMaster.getQualityExpireDate());
        crmInvoiceDetailMerge.setTransferReceivable(RETURN_CODE);
        return crmInvoiceDetailMerge;
    }
}

