/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.transaction.quote.pricelist.quotepricelist.service.impl;

import com.jxdinfo.crm.common.api.associativeQuery.dto.AssociativeQueryDto;
import com.jxdinfo.crm.common.api.associativeQuery.service.IAssociativeFiledQueryAPIService;
import com.jxdinfo.crm.common.api.associativeQuery.vo.AssociativeLabelVo;
import com.jxdinfo.crm.common.api.associativeQuery.vo.AssociativeQueryVo;
import com.jxdinfo.crm.core.associateQuery.service.ICommonAssociateQueryService;
import com.jxdinfo.crm.transaction.quote.pricelist.quotepricelist.dto.PriceListAssociativeQueryDto;
import com.jxdinfo.crm.transaction.quote.pricelist.quotepricelist.dto.PriceListHighSearchDto;
import com.jxdinfo.crm.transaction.quote.pricelist.quotepricelist.service.PriceListAssociativeQueryService;
import com.jxdinfo.crm.transaction.quote.pricelist.quotepricelist.vo.PriceAssociativeQueryEnum;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class PriceListAssociativeQueryServiceImpl
implements PriceListAssociativeQueryService {
    @Resource
    private IAssociativeFiledQueryAPIService associativeFiledQueryAPIService;
    @Resource
    private ICommonAssociateQueryService commonAssociateQueryService;

    public List<AssociativeQueryVo> getAssociativeQueryVo(String keyword, AssociativeQueryDto associativeQueryDto, Map<String, List<String>> excludeInfoMap) {
        ArrayList<AssociativeQueryVo> associativeQueryVoList = new ArrayList<AssociativeQueryVo>();
        PriceListAssociativeQueryDto priceListAssociativeQueryDto = null;
        if (associativeQueryDto instanceof PriceListAssociativeQueryDto) {
            priceListAssociativeQueryDto = (PriceListAssociativeQueryDto)associativeQueryDto;
        }
        assert (priceListAssociativeQueryDto != null);
        PriceListHighSearchDto searchDto = priceListAssociativeQueryDto.getDto();
        List<String> ownDepartmentList = null;
        List<String> principalIds = null;
        List<String> teamMemberIds = null;
        List<String> creator = null;
        String validStartDateRangeData = null;
        String validEndDateRangeData = null;
        String createTimeRangeData = null;
        List<String> enableStateData = null;
        List<String> isLockData = null;
        List<String> isStandardData = null;
        if (searchDto != null) {
            ownDepartmentList = searchDto.getOwnDepartment();
            principalIds = searchDto.getPrincipal();
            teamMemberIds = searchDto.getTeamMember();
            creator = searchDto.getCreator();
            validStartDateRangeData = searchDto.getValidStartDateRangeData();
            validEndDateRangeData = searchDto.getValidEndDateRangeData();
            createTimeRangeData = searchDto.getCreateTimeRangeData();
            enableStateData = Collections.singletonList(searchDto.getEnableState());
            isLockData = Collections.singletonList(searchDto.getIsLock());
            isStandardData = Collections.singletonList(searchDto.getIsStandard());
        }
        List selectedOwnDepartments = excludeInfoMap.get("selectedOwnDepartments");
        selectedOwnDepartments = this.associativeFiledQueryAPIService.getDepartmentAssociativeQuery(associativeQueryVoList, keyword, selectedOwnDepartments, ownDepartmentList, this.getAssociateLabelVoByEnum(PriceAssociativeQueryEnum.QUOTE_OWN_DEPARTMENT));
        excludeInfoMap.put("selectedOwnDepartments", selectedOwnDepartments);
        List selectedChargePersonIds = excludeInfoMap.get("selectedChargePersonIds");
        selectedChargePersonIds = this.associativeFiledQueryAPIService.getUsersAssociativeQuery(associativeQueryVoList, keyword, selectedChargePersonIds, principalIds, this.getAssociateLabelVoByEnum(PriceAssociativeQueryEnum.QUOTE_PRINCIPAL));
        excludeInfoMap.put("selectedChargePersonIds", selectedChargePersonIds);
        List selectedTeamMemberIds = excludeInfoMap.get("selectedTeamMemberIds");
        selectedTeamMemberIds = this.associativeFiledQueryAPIService.getUsersAssociativeQuery(associativeQueryVoList, keyword, selectedTeamMemberIds, teamMemberIds, this.getAssociateLabelVoByEnum(PriceAssociativeQueryEnum.PRICE_LIST_TEAM_MEMBER));
        excludeInfoMap.put("selectedTeamMemberIds", selectedTeamMemberIds);
        List selectedCreator = excludeInfoMap.get("selectedCreator");
        selectedCreator = this.associativeFiledQueryAPIService.getUsersAssociativeQuery(associativeQueryVoList, keyword, selectedCreator, creator, this.getAssociateLabelVoByEnum(PriceAssociativeQueryEnum.QUOTE_CREATOR));
        excludeInfoMap.put("selectedCreator", selectedCreator);
        List selectedValidStartDate = excludeInfoMap.get("selectedValidStartDate");
        selectedValidStartDate = this.associativeFiledQueryAPIService.getTimeTageAssociativeQuery(associativeQueryVoList, keyword, selectedValidStartDate, validStartDateRangeData, this.getAssociateLabelVoByEnum(PriceAssociativeQueryEnum.PRICE_LIST_VALID_STATE_DATE));
        excludeInfoMap.put("selectedValidStartDate", selectedValidStartDate);
        List selectedValidEndDate = excludeInfoMap.get("selectedValidEndDate");
        selectedValidEndDate = this.associativeFiledQueryAPIService.getTimeTageAssociativeQuery(associativeQueryVoList, keyword, selectedValidEndDate, validEndDateRangeData, this.getAssociateLabelVoByEnum(PriceAssociativeQueryEnum.PRICE_LIST_VALID_END_DATE));
        excludeInfoMap.put("selectedValidEndDate", selectedValidEndDate);
        List selectedCreateTimes = excludeInfoMap.get("selectedCreateTimes");
        selectedCreateTimes = this.associativeFiledQueryAPIService.getTimeTageAssociativeQuery(associativeQueryVoList, keyword, selectedCreateTimes, createTimeRangeData, this.getAssociateLabelVoByEnum(PriceAssociativeQueryEnum.QUOTE_CREATE_TIME));
        excludeInfoMap.put("selectedCreateTimes", selectedCreateTimes);
        List selectedEnableState = excludeInfoMap.get("selectedEnableState");
        selectedEnableState = this.associativeFiledQueryAPIService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedEnableState, enableStateData, this.getAssociateLabelVoByEnum(PriceAssociativeQueryEnum.PRICE_LIST_IS_ENABLE));
        excludeInfoMap.put("selectedEnableState", selectedEnableState);
        List selectedIsLock = excludeInfoMap.get("selectedIsLock");
        selectedIsLock = this.associativeFiledQueryAPIService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedIsLock, isLockData, this.getAssociateLabelVoByEnum(PriceAssociativeQueryEnum.PRICE_LIST_IS_LOCK));
        excludeInfoMap.put("selectedIsLock", selectedIsLock);
        List selectedIsStandard = excludeInfoMap.get("selectedEnableState");
        selectedIsStandard = this.associativeFiledQueryAPIService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedIsStandard, isStandardData, this.getAssociateLabelVoByEnum(PriceAssociativeQueryEnum.PRICE_LIST_IS_STANDARD));
        excludeInfoMap.put("selectedIsStandard", selectedIsStandard);
        return associativeQueryVoList;
    }

    private AssociativeLabelVo getAssociateLabelVoByEnum(PriceAssociativeQueryEnum queryEnum) {
        return new AssociativeLabelVo(queryEnum.getLabelName(), queryEnum.getDataName(), queryEnum.getDictTypeName(), queryEnum.getMultiOption());
    }
}

