/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.transaction.operationsmanage.ledger.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.common.api.associativeQuery.dto.AssociativeKeyword;
import com.jxdinfo.crm.common.api.associativeQuery.dto.AssociativeQueryDto;
import com.jxdinfo.crm.common.api.associativeQuery.service.IAssociativeQueryAdapterService;
import com.jxdinfo.crm.common.api.associativeQuery.vo.AssociativeQueryVo;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.api.util.CommonUtills;
import com.jxdinfo.crm.common.api.util.CrmDateUtils;
import com.jxdinfo.crm.common.api.util.entity.DateConvertVo;
import com.jxdinfo.crm.common.api.util.entity.PermissionDto;
import com.jxdinfo.crm.common.api.util.sort.SortOrderQo;
import com.jxdinfo.crm.common.associativeQuery.service.AssociativeQueryService;
import com.jxdinfo.crm.common.fileinfo.model.FileInfo;
import com.jxdinfo.crm.common.fileinfo.service.FileInfoService;
import com.jxdinfo.crm.core.common.service.CommonService;
import com.jxdinfo.crm.core.scene.dao.CrmSceneMapper;
import com.jxdinfo.crm.core.scene.model.CrmScene;
import com.jxdinfo.crm.transaction.api.service.IAgreementReceiveLedgerDataRightModuleService;
import com.jxdinfo.crm.transaction.api.service.IInvoiceDataRightModuleService;
import com.jxdinfo.crm.transaction.operationsmanage.ledger.dao.WarrantyLedgerMapper;
import com.jxdinfo.crm.transaction.operationsmanage.ledger.dto.AgreementLedgerAssociativeQueryDto;
import com.jxdinfo.crm.transaction.operationsmanage.ledger.dto.AgreementReceivableLedgerDto;
import com.jxdinfo.crm.transaction.operationsmanage.ledger.dto.WarrantyLedgerAssociativeQueryDto;
import com.jxdinfo.crm.transaction.operationsmanage.ledger.dto.WarrantyLedgerDto;
import com.jxdinfo.crm.transaction.operationsmanage.ledger.model.AgreementReceivableLedger;
import com.jxdinfo.crm.transaction.operationsmanage.ledger.model.WarrantyLedger;
import com.jxdinfo.crm.transaction.operationsmanage.ledger.service.IAgreementLedgerAssociativeQueryService;
import com.jxdinfo.crm.transaction.operationsmanage.ledger.service.IWarrantyLedgerAssociativeQueryService;
import com.jxdinfo.crm.transaction.operationsmanage.ledger.service.IWarrantyLedgerBillPeriodService;
import com.jxdinfo.crm.transaction.operationsmanage.ledger.service.IWarrantyLedgerService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class WarrantyLedgerServiceImpl
extends ServiceImpl<WarrantyLedgerMapper, WarrantyLedger>
implements IWarrantyLedgerService {
    private static final Logger log = LoggerFactory.getLogger(WarrantyLedgerServiceImpl.class);
    @Resource
    private CommonService commonService;
    @Resource
    private CrmCommonProperties crmProperties;
    @Resource
    private CrmSceneMapper crmSceneMapper;
    @Resource
    private AssociativeQueryService associativeQueryService;
    @Resource
    private IWarrantyLedgerAssociativeQueryService warrantyLedgerAssociativeQueryService;
    @Resource
    private IAgreementLedgerAssociativeQueryService agreementLedgerAssociativeQueryService;
    @Resource
    private IWarrantyLedgerService warrantyLedgerService;
    @Resource
    private IWarrantyLedgerBillPeriodService warrantyLedgerBillPeriodService;
    @Resource
    private IInvoiceDataRightModuleService invoiceDataRightModuleService;
    @Resource
    private IAgreementReceiveLedgerDataRightModuleService agreementReceiveLedgerDataRightModuleService;
    @Resource
    private FileInfoService fileInfoService;

    @Override
    public ApiResponse<?> warrantyLedgerList(WarrantyLedgerDto queryDto) {
        PermissionDto permissionDto = this.invoiceDataRightModuleService.getCurrentUserRolePermissions();
        List<WarrantyLedgerDto> dtoList = this.getWarrantyLedgerDtoList(queryDto);
        Page page = queryDto.getPage();
        ArrayList<OrderItem> orderItems = new ArrayList<OrderItem>();
        if (ToolUtil.isNotEmpty(queryDto.getSortOrderList()) && !queryDto.getSortOrderList().isEmpty()) {
            for (SortOrderQo sortOrder : queryDto.getSortOrderList()) {
                if (!ToolUtil.isNotEmpty((Object)sortOrder.getSortField()) || !ToolUtil.isNotEmpty((Object)sortOrder.getSortOrder())) continue;
                OrderItem orderItem = new OrderItem();
                orderItem.setColumn("cw." + this.commonService.getSortField(sortOrder.getSortField()));
                orderItem.setAsc("asc".equals(sortOrder.getSortOrder()));
                orderItems.add(orderItem);
            }
        }
        if (ToolUtil.isEmpty(orderItems)) {
            OrderItem defaultOrderItem = new OrderItem();
            defaultOrderItem.setColumn("cw.QUALITY_REFUND_DATE");
            defaultOrderItem.setAsc(false);
            orderItems.add(defaultOrderItem);
        }
        page.addOrder(orderItems);
        List<WarrantyLedger> list = ((WarrantyLedgerMapper)this.baseMapper).warrantyLedgerList(dtoList, queryDto.getCurrentUserId(), (Page<WarrantyLedger>)page, permissionDto);
        list = this.warrantyLedgerBillPeriodService.billPeriod(list);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("warrantyLedgerList", list);
        resultMap.put("totalCount", page.getTotal());
        return ApiResponse.success(resultMap);
    }

    private List<WarrantyLedgerDto> getWarrantyLedgerDtoList(WarrantyLedgerDto dto) {
        ArrayList<WarrantyLedgerDto> queryDtoList = new ArrayList<WarrantyLedgerDto>();
        String view = dto.getQueryType();
        if (StringUtil.isNotEmpty((Object)view) && !"preview".equals(view)) {
            CrmScene crmScene;
            long opportunityView = Long.parseLong(view);
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(CrmScene::getSceneId, (Object)opportunityView);
            lambdaQueryWrapper.eq(CrmScene::getModule, (Object)"WarrantyLedger");
            List crmSceneList = this.crmSceneMapper.selectList((Wrapper)lambdaQueryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)crmSceneList) && "0".equals((crmScene = (CrmScene)crmSceneList.get(0)).getIsSystem())) {
                try {
                    String query = crmScene.getQuery();
                    if (StringUtil.isNotBlank((CharSequence)query)) {
                        String queryValue = JSONObject.parseObject((String)query).get((Object)"queryValue").toString();
                        WarrantyLedgerDto queryDto = (WarrantyLedgerDto)((Object)JSONObject.parseObject((String)queryValue, WarrantyLedgerDto.class));
                        queryDto.setQueryType(String.valueOf(opportunityView));
                        queryDtoList.add(this.warrantyLedgerQueryCondition(queryDto));
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        queryDtoList.add(this.warrantyLedgerQueryCondition(dto));
        return queryDtoList;
    }

    private WarrantyLedgerDto warrantyLedgerQueryCondition(WarrantyLedgerDto dto) {
        DateConvertVo dateConvertVo;
        if (ToolUtil.isNotEmpty((Object)dto.getKeyWord())) {
            dto.setKeyWord(CommonUtills.escapeLike((String)dto.getKeyWord()));
        }
        if (ToolUtil.isNotEmpty((Object)dto.getTransferReceivable())) {
            dto.setTransferReceivableList(Arrays.asList(dto.getTransferReceivable().split(",")));
        }
        if (ToolUtil.isNotEmpty((Object)dto.getReceivableDateFlag()) && !"6".equals(dto.getReceivableDateFlag()) && (dateConvertVo = CrmDateUtils.getCurrentTime((String)dto.getReceivableDateFlag())) != null) {
            dto.setReceivableStartDate(dateConvertVo.getStartDate());
            dto.setReceivableFinalDate(dateConvertVo.getEndDate());
        }
        if (ToolUtil.isNotEmpty((Object)dto.getQualityRefundDateFlag()) && !"6".equals(dto.getQualityRefundDateFlag()) && (dateConvertVo = CrmDateUtils.getCurrentTime((String)dto.getQualityRefundDateFlag())) != null) {
            dto.setQualityRefundStartDate(dateConvertVo.getStartDate());
            dto.setQualityRefundFinalDate(dateConvertVo.getEndDate());
        }
        if (ToolUtil.isNotEmpty((Object)dto.getInvoiceDateFlag()) && !"6".equals(dto.getInvoiceDateFlag()) && (dateConvertVo = CrmDateUtils.getCurrentTime((String)dto.getInvoiceDateFlag())) != null) {
            dto.setInvoiceStartDate(dateConvertVo.getStartDate());
            dto.setInvoiceFinalDate(dateConvertVo.getEndDate());
        }
        dto.setCurrentUserId(BaseSecurityUtil.getUser().getUserId().toString());
        return dto;
    }

    @Override
    public List<AssociativeQueryVo> associativeQueryNew(WarrantyLedgerAssociativeQueryDto dto) {
        String keyWord = dto.getKeyword();
        String queryScreening = null;
        if (dto.getDto() != null) {
            queryScreening = dto.getDto().getKeyWord();
        }
        IWarrantyLedgerAssociativeQueryService adapterService = this.warrantyLedgerAssociativeQueryService;
        AssociativeKeyword associativeKeyword = new AssociativeKeyword();
        associativeKeyword.setLabelName("\u5173\u952e\u5b57");
        associativeKeyword.setDataName("keyWord");
        associativeKeyword.setDictTypeName("");
        associativeKeyword.setMultiOption(Boolean.valueOf(false));
        return this.associativeQueryService.associativeQuery((AssociativeQueryDto)dto, keyWord, queryScreening, (IAssociativeQueryAdapterService)adapterService, associativeKeyword);
    }

    @Override
    public ApiResponse<?> warrantyLedgerDetail(Long invoiceDetailMergeId) {
        if (null == invoiceDetailMergeId) {
            return ApiResponse.fail((String)"\u67e5\u8be2\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String userId = BaseSecurityUtil.getUser().getId().toString();
        ArrayList<WarrantyLedger> warrantyLedgerList = new ArrayList<WarrantyLedger>();
        WarrantyLedger warrantyLedger = ((WarrantyLedgerMapper)this.baseMapper).warrantyLedgerDetail(invoiceDetailMergeId, userId);
        if (warrantyLedger != null) {
            warrantyLedgerList.add(warrantyLedger);
        }
        warrantyLedger = this.warrantyLedgerBillPeriodService.billPeriod(warrantyLedgerList).get(0);
        LambdaQueryWrapper fileInfoQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(FileInfo::getBusinessId, Collections.singleton(warrantyLedger.getInvoiceDetailMergeId()))).ne(FileInfo::getDelFlag, (Object)"1");
        Integer userSecurityLevel = BaseSecurityUtil.getUser().getSecurityLevel();
        if (HussarUtils.isNotEmpty((Object)userSecurityLevel)) {
            fileInfoQueryWrapper.le(FileInfo::getSecurityLevel, (Object)userSecurityLevel);
        }
        warrantyLedger.setFileCount(this.fileInfoService.count((Wrapper)fileInfoQueryWrapper));
        return ApiResponse.success((Object)warrantyLedger);
    }

    @Override
    public ApiResponse<?> warrantyLedgerTransfer(WarrantyLedger warrantyLedger) {
        if (null == warrantyLedger.getInvoiceDetailMergeId()) {
            return ApiResponse.fail((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        warrantyLedger.setTransferReceivable("1");
        this.warrantyLedgerService.saveOrUpdate(warrantyLedger);
        return ApiResponse.success((Object)warrantyLedger.getAgreementId());
    }

    @Override
    public ApiResponse<?> agreementReceivableLedgerList(AgreementReceivableLedgerDto queryDto) {
        PermissionDto permissionDto = this.invoiceDataRightModuleService.getCurrentUserRolePermissions();
        AgreementReceivableLedgerDto agreementReceivableLedgerDto = queryDto;
        if (queryDto.getQueryType() != null && !queryDto.getQueryType().equals("preview")) {
            agreementReceivableLedgerDto = this.getAgreementReceivableLedgerDtoList(queryDto);
        }
        agreementReceivableLedgerDto.setCurrentUserId(BaseSecurityUtil.getUser().getUserId().toString());
        String signDateFlag = agreementReceivableLedgerDto.getSignDateFlag();
        if (ToolUtil.isNotEmpty((Object)signDateFlag) && !"6".equals(signDateFlag)) {
            DateConvertVo currentTime = CrmDateUtils.getCurrentTime((String)signDateFlag);
            agreementReceivableLedgerDto.setSignStartDate(currentTime.getStartDate());
            agreementReceivableLedgerDto.setSignFinalDate(currentTime.getEndDate());
        }
        agreementReceivableLedgerDto.setForecastState("2");
        agreementReceivableLedgerDto.setDelFlag("0");
        Page page = queryDto.getPage();
        ArrayList<OrderItem> orderItems = new ArrayList<OrderItem>();
        if (ToolUtil.isNotEmpty(agreementReceivableLedgerDto.getSortOrderList()) && agreementReceivableLedgerDto.getSortOrderList().size() > 0) {
            for (SortOrderQo sortOrderQo : agreementReceivableLedgerDto.getSortOrderList()) {
                if (!ToolUtil.isNotEmpty((Object)sortOrderQo.getSortField()) || !ToolUtil.isNotEmpty((Object)sortOrderQo.getSortOrder())) continue;
                OrderItem orderItem = new OrderItem();
                orderItem.setColumn("a." + this.commonService.getSortField(sortOrderQo.getSortField()));
                orderItem.setAsc("asc".equals(sortOrderQo.getSortOrder()));
                orderItems.add(orderItem);
            }
        }
        if (ToolUtil.isEmpty(orderItems)) {
            OrderItem defaultOrderItem = new OrderItem();
            defaultOrderItem.setColumn("a.SIGN_DATE");
            defaultOrderItem.setAsc(false);
            orderItems.add(defaultOrderItem);
        }
        page.addOrder(orderItems);
        List<AgreementReceivableLedger> list = ((WarrantyLedgerMapper)this.baseMapper).agreementReceivableLedgerList(agreementReceivableLedgerDto, (Page<AgreementReceivableLedger>)page, permissionDto);
        for (AgreementReceivableLedger agreementReceivableLedger : list) {
            if (agreementReceivableLedger.getCollectionStatus() != null) {
                BigDecimal accountReceivable;
                BigDecimal refundAmount = agreementReceivableLedger.getRefundAmount();
                BigDecimal qualityReduceAmount = agreementReceivableLedger.getQualityReduceAmount();
                BigDecimal qualityAmount = agreementReceivableLedger.getQualityAmount();
                BigDecimal needRefundAmount = qualityAmount.add(accountReceivable = agreementReceivableLedger.getAccountsReceivable()).subtract(qualityReduceAmount);
                if (refundAmount.compareTo(needRefundAmount) < 0) {
                    agreementReceivableLedger.setCollectionStatus("\u90e8\u5206\u56de\u6b3e");
                } else {
                    agreementReceivableLedger.setCollectionStatus("\u5b8c\u5168\u56de\u6b3e");
                }
            }
            if (agreementReceivableLedger.getQualityExpireDate() == null) continue;
            if (ChronoUnit.DAYS.between(agreementReceivableLedger.getQualityExpireDate(), LocalDateTime.now()) > 0L) {
                agreementReceivableLedger.setExpireStatus("\u5df2\u5230\u671f");
                continue;
            }
            agreementReceivableLedger.setExpireStatus("\u672a\u5230\u671f");
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("agreementReceivableLedgerList", list);
        hashMap.put("totalCount", page.getTotal());
        return ApiResponse.success(hashMap);
    }

    @Override
    public List<AssociativeQueryVo> agreementLedgerAssociativeQuery(AgreementLedgerAssociativeQueryDto dto) {
        String keyWord = dto.getKeyword();
        String queryScreening = null;
        if (dto.getDto() != null) {
            queryScreening = dto.getDto().getKeyWord();
        }
        IAgreementLedgerAssociativeQueryService adapterService = this.agreementLedgerAssociativeQueryService;
        AssociativeKeyword associativeKeyword = new AssociativeKeyword();
        associativeKeyword.setLabelName("\u5173\u952e\u5b57");
        associativeKeyword.setDataName("keyWord");
        associativeKeyword.setDictTypeName("");
        associativeKeyword.setMultiOption(Boolean.valueOf(false));
        return this.associativeQueryService.associativeQuery((AssociativeQueryDto)dto, keyWord, queryScreening, (IAssociativeQueryAdapterService)adapterService, associativeKeyword);
    }

    private AgreementReceivableLedgerDto getAgreementReceivableLedgerDtoList(AgreementReceivableLedgerDto agreementReceivableLedgerDto) {
        List<SortOrderQo> sortOrderList;
        String signDateFlag;
        AgreementReceivableLedgerDto queryDto = new AgreementReceivableLedgerDto();
        String view = agreementReceivableLedgerDto.getQueryType();
        if (StringUtil.isNotEmpty((Object)view)) {
            CrmScene crmScene;
            long queryType = Long.parseLong(view);
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(CrmScene::getSceneId, (Object)queryType);
            lambdaQueryWrapper.eq(CrmScene::getModule, (Object)"agreementReceivableLedger");
            List crmSceneList = this.crmSceneMapper.selectList((Wrapper)lambdaQueryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)crmSceneList) && "0".equals((crmScene = (CrmScene)crmSceneList.get(0)).getIsSystem())) {
                try {
                    String query = crmScene.getQuery();
                    if (StringUtil.isNotBlank((CharSequence)query)) {
                        String queryValue = JSONObject.parseObject((String)query).get((Object)"queryValue").toString();
                        queryDto = (AgreementReceivableLedgerDto)((Object)JSONObject.parseObject((String)queryValue, AgreementReceivableLedgerDto.class));
                    }
                }
                catch (Exception var14) {
                    Exception e = var14;
                    throw new RuntimeException(e);
                }
            }
        }
        if (ToolUtil.isNotEmpty((Object)agreementReceivableLedgerDto.getQueryType())) {
            queryDto.setQueryType(agreementReceivableLedgerDto.getQueryType());
        }
        if (ToolUtil.isNotEmpty((Object)agreementReceivableLedgerDto.getKeyWord())) {
            queryDto.setKeyWord(agreementReceivableLedgerDto.getKeyWord());
        }
        if (ToolUtil.isNotEmpty((Object)(signDateFlag = agreementReceivableLedgerDto.getSignDateFlag()))) {
            if ("6".equals(signDateFlag)) {
                queryDto.setSignDateFlag(agreementReceivableLedgerDto.getSignDateFlag());
                queryDto.setSignStartDate(agreementReceivableLedgerDto.getSignStartDate());
                queryDto.setSignFinalDate(agreementReceivableLedgerDto.getSignFinalDate());
            } else {
                queryDto.setSignDateFlag(agreementReceivableLedgerDto.getSignDateFlag());
            }
        }
        if (ToolUtil.isNotEmpty(sortOrderList = agreementReceivableLedgerDto.getSortOrderList()) && sortOrderList.size() > 0) {
            queryDto.setSortOrderList(sortOrderList);
        }
        return queryDto;
    }
}

