/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.transaction.operationsmanage.ledger.service.impl;

import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.core.common.service.CommonService;
import com.jxdinfo.crm.core.scene.dao.CrmSceneMapper;
import com.jxdinfo.crm.transaction.api.service.IAgreementAPIService;
import com.jxdinfo.crm.transaction.api.vo.AgreementAPIVo;
import com.jxdinfo.crm.transaction.operationsmanage.ledger.dao.AgreementOverviewMapper;
import com.jxdinfo.crm.transaction.operationsmanage.ledger.dao.WarrantyLedgerMapper;
import com.jxdinfo.crm.transaction.operationsmanage.ledger.dto.BillPeriodLedgerDto;
import com.jxdinfo.crm.transaction.operationsmanage.ledger.model.BillPeriodLedger;
import com.jxdinfo.crm.transaction.operationsmanage.ledger.service.IAgreementOverviewService;
import com.jxdinfo.crm.transaction.operationsmanage.ledger.service.IBillPeriodLedgerService;
import com.jxdinfo.crm.transaction.operationsmanage.ledger.vo.AgreementOverviewVo;
import com.jxdinfo.crm.transaction.operationsmanage.ledger.vo.CockpitQueryVo;
import com.jxdinfo.crm.transaction.operationsmanage.ledger.vo.InvoiceCollectDateVo;
import com.jxdinfo.crm.transaction.operationsmanage.ledger.vo.SaleProductVo;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Service
@Component(value="AgreementOverviewServiceImpl")
public class AgreementOverviewServiceImpl
implements IAgreementOverviewService {
    private static final Logger log = LoggerFactory.getLogger(AgreementOverviewServiceImpl.class);
    @Resource
    private CommonService commonService;
    @Resource
    private CrmCommonProperties crmProperties;
    @Resource
    private CrmSceneMapper crmSceneMapper;
    @Resource
    private IAgreementAPIService agreementAPIService;
    @Resource
    private AgreementOverviewMapper agreementOverviewMapper;
    @Resource
    private IBillPeriodLedgerService billPeriodLedgerService;
    @Resource
    private WarrantyLedgerMapper warrantyLedgerMapper;

    @Override
    public ApiResponse<?> agreementOverview(String agreementId) {
        AgreementAPIVo agreementAPIVo = this.agreementAPIService.formQuery(agreementId.toString());
        AgreementOverviewVo agreementOverviewVo = new AgreementOverviewVo();
        BeanUtil.copy((Object)agreementAPIVo, (Object)agreementOverviewVo);
        if (ToolUtil.isNotEmpty((Object)agreementOverviewVo.getCollectedAmount())) {
            if (agreementOverviewVo.getInvoicedAmount() != null && agreementOverviewVo.getInvoicedAmount().compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal collectionRate = agreementOverviewVo.getCollectedAmount().divide(agreementOverviewVo.getInvoicedAmount(), 2, 4);
                agreementOverviewVo.setCollectionRate(collectionRate);
            }
        } else {
            agreementOverviewVo.setCollectionRate(BigDecimal.ZERO);
        }
        AgreementOverviewVo orderItem = this.agreementOverviewMapper.selectContractAmount(agreementId);
        agreementOverviewVo.setOrderCount(orderItem.getOrderCount());
        agreementOverviewVo.setContractAmountTax(orderItem.getContractAmountTax());
        if (agreementOverviewVo.getAgreementCategory().equals("1")) {
            agreementOverviewVo.setTotalAmountTax(BigDecimal.valueOf(agreementOverviewVo.getOrderAmountTax()));
        }
        String saleInvoiceAmount = this.agreementOverviewMapper.selectInvoiceAmount(agreementId);
        agreementOverviewVo.setSaleInvoiceAmount(saleInvoiceAmount);
        if (ToolUtil.isNotEmpty((Object)agreementOverviewVo.getInvoicedAmount())) {
            if (agreementOverviewVo.getTotalAmountTax() != null && agreementOverviewVo.getTotalAmountTax().compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal invoiceRate = agreementOverviewVo.getInvoicedAmount().divide(agreementOverviewVo.getTotalAmountTax(), 2, 4);
                agreementOverviewVo.setInvoiceRate(invoiceRate);
            }
        } else {
            agreementOverviewVo.setInvoiceRate(BigDecimal.ZERO);
        }
        if (ToolUtil.isEmpty((Object)agreementOverviewVo.getCollectedAmount())) {
            agreementOverviewVo.setCollectedAmount(BigDecimal.ZERO);
        }
        if (ToolUtil.isEmpty((Object)agreementOverviewVo.getInvoicedAmount())) {
            agreementOverviewVo.setInvoicedAmount(BigDecimal.ZERO);
        }
        agreementOverviewVo.setInvoiceBalance(agreementOverviewVo.getInvoicedAmount().subtract(agreementOverviewVo.getCollectedAmount()));
        if (agreementOverviewVo.getInvoicedAmount().compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal invoiceReceivableRatio = agreementOverviewVo.getInvoiceBalance().divide(agreementOverviewVo.getInvoicedAmount(), 2, RoundingMode.HALF_UP);
            agreementOverviewVo.setInvoiceReceivableRatio(invoiceReceivableRatio);
        } else {
            agreementOverviewVo.setInvoiceReceivableRatio(BigDecimal.ZERO);
        }
        if (ToolUtil.isEmpty((Object)agreementOverviewVo.getTotalAmountTax())) {
            agreementOverviewVo.setTotalAmountTax(BigDecimal.ZERO);
        }
        agreementOverviewVo.setContractReceivable(agreementOverviewVo.getTotalAmountTax().subtract(agreementOverviewVo.getCollectedAmount()));
        if (agreementOverviewVo.getTotalAmountTax().compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal contractReceivableRatio = agreementOverviewVo.getContractReceivable().divide(agreementOverviewVo.getTotalAmountTax(), 4, RoundingMode.HALF_UP);
            agreementOverviewVo.setContractReceivableRatio(contractReceivableRatio);
        } else {
            agreementOverviewVo.setContractReceivableRatio(BigDecimal.ZERO);
        }
        CockpitQueryVo warrantyExpireData = this.warrantyLedgerMapper.warrantyExpireData(agreementId);
        agreementOverviewVo.setWarrantyExpireData(warrantyExpireData);
        BillPeriodLedgerDto billPeriodLedgerDto = new BillPeriodLedgerDto();
        billPeriodLedgerDto.setAgreementNumber(agreementOverviewVo.getAgreementNumber());
        billPeriodLedgerDto.setCurrent(1);
        billPeriodLedgerDto.setSize(100);
        Map<String, Object> resultMap = this.billPeriodLedgerService.billPeriodReceiveLedgerList(billPeriodLedgerDto);
        List list = (List)resultMap.get("billPeriodReceiveLedgerList");
        this.billPeriod(list);
        agreementOverviewVo.setBillPeriodLedgerList(list);
        List<SaleProductVo> saleProductVo = this.agreementOverviewMapper.selectSaleProduct(agreementId);
        agreementOverviewVo.setSaleProductVo(saleProductVo);
        List<InvoiceCollectDateVo> invoiceCollectDateVo = this.agreementOverviewMapper.selectDateLine(agreementId);
        agreementOverviewVo.setInvoiceCollectDateVo(invoiceCollectDateVo);
        return ApiResponse.success((Object)agreementOverviewVo);
    }

    public List<BillPeriodLedger> billPeriod(List<BillPeriodLedger> billPeriodLedger) {
        if (billPeriodLedger == null || billPeriodLedger.isEmpty()) {
            System.out.println("\u8d26\u671f\u6570\u636e\u4e3a\u7a7a\uff0c\u65e0\u9700\u5904\u7406");
            return billPeriodLedger;
        }
        block12: for (BillPeriodLedger item : billPeriodLedger) {
            String stage = item.getTermOfPayment();
            if (!ToolUtil.isNotEmpty((Object)stage)) continue;
            switch (stage) {
                case "\u4e00\u4e2a\u6708\u5185": {
                    item.setTermOfPayment("0-30\u5929");
                    continue block12;
                }
                case "\u4e24\u4e2a\u6708\u5185": {
                    item.setTermOfPayment("31-60\u5929");
                    continue block12;
                }
                case "\u4e09\u4e2a\u6708\u5185": {
                    item.setTermOfPayment("61-90\u5929");
                    continue block12;
                }
                case "\u56db\u4e2a\u6708\u5185": {
                    item.setTermOfPayment("91-120\u5929");
                    continue block12;
                }
            }
            item.setTermOfPayment("\u2265120\u5929");
        }
        return billPeriodLedger;
    }
}

