/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.transaction.quote.quotation.quotationdetailbpm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.common.api.config.PmsApiProperties;
import com.jxdinfo.crm.core.utills.EimPushUtil;
import com.jxdinfo.crm.transaction.quote.quotation.quotationdetailbpm.dao.CrmRiskMapper;
import com.jxdinfo.crm.transaction.quote.quotation.quotationdetailbpm.dto.CrmRiskPageDto;
import com.jxdinfo.crm.transaction.quote.quotation.quotationdetailbpm.model.CrmRisk;
import com.jxdinfo.crm.transaction.quote.quotation.quotationdetailbpm.service.CrmRiskService;
import com.jxdinfo.crm.transaction.quote.quotation.quotationdetailbpm.vo.CrmRiskSyncVo;
import com.jxdinfo.crm.transaction.quote.quotation.quotationdetailbpm.vo.CrmRiskVO;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="quote.quotation.quotationdetailbpm.CrmRiskServiceImpl")
@HussarTokenDs
public class CrmRiskServiceImpl
extends HussarServiceImpl<CrmRiskMapper, CrmRisk>
implements CrmRiskService {
    private static final Logger logger = LoggerFactory.getLogger(CrmRiskServiceImpl.class);
    private static final String RETURN_CODE = "0";
    private static final String ORDER_RULE = "orderRule";
    private static final String DEFAULT_ORDER_RULE = "defaultOrderRule";
    private static final String ASC = ",asc;";
    private static final String DESC = ",desc;";
    private static final String PMS_RISK_TYPE = "3";
    @Resource
    private CrmRiskMapper crmRiskMapper;
    @Resource
    private PmsApiProperties pmsApiProperties;

    public List<CrmRisk> getByMap(Map<String, Object> map) {
        return this.list((Wrapper)new LambdaQueryWrapper(BeanUtil.copy(map, CrmRisk.class)));
    }

    @Override
    public List<CrmRiskSyncVo> syncRisk(Long opportunityId, Long productId) {
        if (HussarUtils.isEmpty((Object)opportunityId) || HussarUtils.isEmpty((Object)productId)) {
            return new ArrayList<CrmRiskSyncVo>();
        }
        return this.crmRiskMapper.syncRisk(opportunityId, productId);
    }

    @Override
    public Page<CrmRiskSyncVo> getRisk(CrmRiskPageDto dto) {
        HashMap<String, Object> Type7720 = new HashMap<String, Object>();
        Type7720.put("keyword", dto.getRiskName());
        Type7720.put("riskTypeList", dto.getRiskType());
        ArrayList<String> appScopeList = new ArrayList<String>();
        appScopeList.add(PMS_RISK_TYPE);
        Type7720.put("appScopeList", appScopeList);
        Type7720.put("current", dto.getCurrent());
        Type7720.put("size", dto.getSize());
        HashMap<String, HashMap<String, Object>> param = new HashMap<String, HashMap<String, Object>>();
        param.put("Type7720", Type7720);
        ApiResponse riskJSON = EimPushUtil.post((String)this.pmsApiProperties.getSelectAllRiskList(), param);
        if (riskJSON == null) {
            return null;
        }
        List riskVoList = (List)((JSONObject)riskJSON.getData()).get((Object)"records");
        if (CollectionUtil.isEmpty((Collection)riskVoList)) {
            return null;
        }
        List<CrmRiskSyncVo> list = this.convertToRiskVo(riskVoList);
        Page page = new Page();
        page.setRecords(list);
        page.setTotal(((JSONObject)riskJSON.getData()).get((Object)"total") == null ? 0L : Long.parseLong(((JSONObject)riskJSON.getData()).get((Object)"total").toString()));
        return page;
    }

    @Override
    public ApiResponse<Page<CrmRiskVO>> getRiskListByQuoteId(CrmRiskPageDto dto) {
        try {
            Page riskVoPage = dto.getPage();
            List<CrmRiskVO> riskVoList = this.crmRiskMapper.getRiskListByQuoteId((Page<CrmRiskVO>)riskVoPage, dto.getQuoteId());
            return ApiResponse.success((Object)riskVoPage.setRecords(riskVoList));
        }
        catch (Exception e) {
            throw new HussarException("\u8868\u683c\u67e5\u8be2\u5f02\u5e38", (Throwable)e);
        }
    }

    private List<CrmRiskSyncVo> convertToRiskVo(List<Map<String, String>> riskVoList) {
        ArrayList<CrmRiskSyncVo> returnRiskVoList = new ArrayList<CrmRiskSyncVo>();
        for (Map<String, String> riskVoMap : riskVoList) {
            CrmRiskSyncVo riskVo = new CrmRiskSyncVo();
            riskVo.setProjectRiskId(Long.valueOf(riskVoMap.get("riskId")));
            riskVo.setRiskName(riskVoMap.get("riskName"));
            riskVo.setRiskType(riskVoMap.get("riskType"));
            riskVo.setSuggestion(riskVoMap.get("suggestion"));
            returnRiskVoList.add(riskVo);
        }
        return returnRiskVoList;
    }
}

