/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.transaction.operationsmanage.refund.crmrefund.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.common.api.associativeQuery.dto.AssociativeKeyword;
import com.jxdinfo.crm.common.api.associativeQuery.dto.AssociativeQueryDto;
import com.jxdinfo.crm.common.api.associativeQuery.service.IAssociativeQueryAPIService;
import com.jxdinfo.crm.common.api.associativeQuery.service.IAssociativeQueryAdapterService;
import com.jxdinfo.crm.common.api.associativeQuery.vo.AssociativeQueryVo;
import com.jxdinfo.crm.common.api.dataRightManage.vo.OperateVo;
import com.jxdinfo.crm.common.api.fileInfo.service.IFileInfoAPIService;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.operaterecord.service.IOperateRecordAPIService;
import com.jxdinfo.crm.common.api.operaterecord.vo.OperateRecordAPIVo;
import com.jxdinfo.crm.common.api.organUser.IOrganUserBoService;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.common.api.trackrecord.service.ITrackRecordAPIService;
import com.jxdinfo.crm.common.api.util.CommonUtills;
import com.jxdinfo.crm.common.api.util.CrmDateUtils;
import com.jxdinfo.crm.common.api.util.DictUtils;
import com.jxdinfo.crm.common.api.util.constant.common.CommonConstant;
import com.jxdinfo.crm.common.api.util.entity.DateConvertVo;
import com.jxdinfo.crm.common.api.util.entity.PermissionDto;
import com.jxdinfo.crm.common.fileinfo.model.FileInfo;
import com.jxdinfo.crm.common.fileinfo.service.FileInfoService;
import com.jxdinfo.crm.core.api.task.service.ITaskAPIService;
import com.jxdinfo.crm.core.api.teammember.service.ITeamMemberApiService;
import com.jxdinfo.crm.core.common.service.CommonService;
import com.jxdinfo.crm.core.config.UnifyProperties;
import com.jxdinfo.crm.core.crm.datasourcefolder.customer.crmopportunity2.service.CrmOpportunity2Service;
import com.jxdinfo.crm.core.focus.model.FocusEntity;
import com.jxdinfo.crm.core.focus.service.FocusService;
import com.jxdinfo.crm.core.scene.dao.CrmSceneMapper;
import com.jxdinfo.crm.core.scene.model.CrmScene;
import com.jxdinfo.crm.core.teammeber.model.TeamMeberEntity;
import com.jxdinfo.crm.core.teammeber.service.TeamMeberService;
import com.jxdinfo.crm.core.unify.dto.AddSysMessageType;
import com.jxdinfo.crm.core.unify.util.UnifyUtil;
import com.jxdinfo.crm.transaction.api.service.IRefundDataRightModuleService;
import com.jxdinfo.crm.transaction.operationsmanage.refund.crmrefund.constant.RefundEditEnum;
import com.jxdinfo.crm.transaction.operationsmanage.refund.crmrefund.dao.CrmRefundMapper;
import com.jxdinfo.crm.transaction.operationsmanage.refund.crmrefund.dto.CrmRefundAssociativeQueryDto;
import com.jxdinfo.crm.transaction.operationsmanage.refund.crmrefund.dto.CrmRefundCrmrefunddataset1;
import com.jxdinfo.crm.transaction.operationsmanage.refund.crmrefund.model.CrmRefund;
import com.jxdinfo.crm.transaction.operationsmanage.refund.crmrefund.service.CrmRefundService;
import com.jxdinfo.crm.transaction.operationsmanage.refund.crmrefund.service.ICrmRefundAssociativeQueryService;
import com.jxdinfo.crm.transaction.operationsmanage.refund.crmrefund.vo.CrmRefundPageVO;
import com.jxdinfo.crm.transaction.operationsmanage.refundclaim.crmrefundclaim.model.CrmRefundClaimMaster;
import com.jxdinfo.crm.transaction.operationsmanage.refundclaim.crmrefundclaim.service.CrmRefundClaimMasterService;
import com.jxdinfo.crm.transaction.operationsmanage.refundclaim.crmrefundclaim.service.CrmRefundClaimService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.dao.SysDicSingleMapper;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.vo.DictVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.query.generator.SingleTableQueryGenerator;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service(value="operationsmanage.refund.crmrefund.CrmRefundServiceImpl")
@HussarTokenDs
public class CrmRefundServiceImpl
extends HussarServiceImpl<CrmRefundMapper, CrmRefund>
implements CrmRefundService {
    private static final Logger logger = LoggerFactory.getLogger(CrmRefundServiceImpl.class);
    private static final String RETURN_CODE = "0";
    private static final String ORDER_RULE = "orderRule";
    private static final String DEFAULT_ORDER_RULE = "defaultOrderRule";
    private static final String ASC = ",asc;";
    private static final String DESC = ",desc;";
    @Autowired
    private CrmRefundMapper crmRefundMapper;
    @Resource
    private ICrmRefundAssociativeQueryService crmRefundAssociativeQueryService;
    @Resource
    private IAssociativeQueryAPIService associativeQueryService;
    @Resource
    private CommonService commonService;
    @Resource
    private TeamMeberService teamMeberService;
    @Resource
    private IOperateRecordAPIService operateRecordAPIService;
    @Resource
    private SysDicSingleMapper sysDicSingleMapper;
    @Resource
    private CrmOpportunity2Service crmOpportunity2Service;
    @Resource
    private FocusService focusService;
    @Resource
    @Lazy
    private CrmRefundClaimService crmRefundClaimService;
    @Resource
    private CrmRefundClaimMasterService crmRefundClaimMasterService;
    @Resource
    private CrmSceneMapper crmSceneMapper;
    @Resource
    private UnifyProperties unifyProperties;
    @Resource
    private ITeamMemberApiService teamMemberApiService;
    @Resource
    private IRefundDataRightModuleService refundDataRightModuleService;
    @Resource
    private ITrackRecordAPIService trackRecordAPIService;
    @Resource
    private FileInfoService fileInfoService;
    @Resource
    private IOrganUserBoService organUserBoService;
    @Resource
    private IFileInfoAPIService fileInfoAPIService;
    @Resource
    private ITaskAPIService taskAPIService;
    @Resource
    private ISysDicRefService sysDicRefService;

    public List<CrmRefund> getByMap(Map<String, Object> map) {
        return this.list((Wrapper)new LambdaQueryWrapper(BeanUtil.copy(map, CrmRefund.class)));
    }

    @Override
    public ApiResponse<CrmRefundPageVO> hussarQuerycrmRefundCondition_1crmRefundSort_1Page(CrmRefundCrmrefunddataset1 crmrefunddataset1) {
        try {
            PermissionDto permissionDto = this.refundOperate(crmrefunddataset1);
            CrmRefundPageVO crmRefundPageVO = new CrmRefundPageVO();
            Page pager = new Page((long)crmrefunddataset1.getCurrent(), (long)crmrefunddataset1.getSize());
            HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
            ArrayList<String> orderRule = new ArrayList<String>();
            if (crmrefunddataset1.getOrders() != null) {
                StringBuilder order = new StringBuilder();
                for (OrderItem orderItem : crmrefunddataset1.getOrders()) {
                    if (orderItem.isAsc()) {
                        order.append(orderItem.getColumn()).append(ASC);
                        continue;
                    }
                    order.append(orderItem.getColumn()).append(DESC);
                }
                orderRule.add(order.toString());
                parameterMap.put(ORDER_RULE, orderRule.toArray(new String[0]));
            }
            ArrayList<String> defaultOrderRule = new ArrayList<String>();
            String defaultOrder = "";
            defaultOrder = defaultOrder + "createTime,desc;";
            defaultOrderRule.add(defaultOrder);
            parameterMap.put(DEFAULT_ORDER_RULE, defaultOrderRule.toArray(new String[0]));
            SingleTableQueryGenerator singleTableQueryGenerator = new SingleTableQueryGenerator();
            QueryWrapper queryWrapper = singleTableQueryGenerator.initQueryWrapper((Object)new CrmRefund(), parameterMap);
            Long currentUserId = BaseSecurityUtil.getUser().getId();
            crmrefunddataset1.setCurrentUserId(currentUserId);
            if (CollectionUtil.isNotEmpty((Collection)crmrefunddataset1.getOwnDepartment())) {
                List departments = crmrefunddataset1.getOwnDepartment();
                ArrayList odpIds = new ArrayList();
                if (ToolUtil.isNotEmpty((Object)departments) && !departments.isEmpty()) {
                    for (Object longOdpId : departments) {
                        ArrayList Ids;
                        String odpId = String.valueOf(longOdpId);
                        String odpIsTemp = com.jxdinfo.crm.core.utills.CommonUtills.translateDepId((String)odpId);
                        List idsTemp = com.jxdinfo.crm.core.utills.CommonUtills.selectOpportunityTissueTreeUserId((String)odpIsTemp, Ids = new ArrayList());
                        if (idsTemp.isEmpty()) continue;
                        for (int i = 0; i < idsTemp.size(); ++i) {
                            odpIds.add(idsTemp.get(i));
                        }
                    }
                    crmrefunddataset1.setOwnDepartment(odpIds);
                }
            }
            List<CrmRefundCrmrefunddataset1> dtoList = this.getOrderUnityDtoList(crmrefunddataset1);
            List<CrmRefund> list = this.crmRefundMapper.hussarQuerycrmRefundCondition_1crmRefundSort_1Page((Page<CrmRefund>)pager, dtoList, currentUserId, (QueryWrapper<CrmRefund>)queryWrapper, permissionDto);
            List<Long> refundIdList = list.stream().map(CrmRefund::getRefundId).collect(Collectors.toList());
            Map<Long, Double> notClaimAmountMap = this.crmRefundClaimService.getClaimAmount(refundIdList);
            for (CrmRefund crmRefund : list) {
                Long refundId;
                Double amount;
                if (!CollectionUtil.isNotEmpty(notClaimAmountMap) || (amount = notClaimAmountMap.get(refundId = crmRefund.getRefundId())) == null || crmRefund.getRefundAmount() == null) continue;
                amount = crmRefund.getRefundAmount() - amount;
                crmRefund.setConfirmedAmount(amount);
            }
            crmRefundPageVO.setData(list);
            crmRefundPageVO.setCount(pager.getTotal());
            crmRefundPageVO.setCode(RETURN_CODE);
            return ApiResponse.success((Object)crmRefundPageVO);
        }
        catch (Exception e) {
            throw new HussarException("\u8868\u683c\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public ApiResponse<CrmRefund> formQuery(String id) {
        try {
            CrmRefund crmRefund = (CrmRefund)this.getById((Serializable)((Object)id));
            crmRefund = this.updateRefundInfo(crmRefund);
            Long refundId = Long.parseLong(id);
            Map<Long, Double> notClaimAmountMap = this.crmRefundClaimService.getClaimAmount(Collections.singletonList(refundId));
            if (CollectionUtil.isNotEmpty(notClaimAmountMap) && crmRefund.getRefundAmount() != null) {
                Double amount = notClaimAmountMap.get(refundId);
                amount = crmRefund.getRefundAmount() - amount;
                crmRefund.setConfirmedAmount(amount);
            }
            ArrayList<Long> businessIds = new ArrayList<Long>();
            businessIds.add(refundId);
            List fileRecordIds = this.trackRecordAPIService.selectRelationRecordIds(refundId);
            if (CollectionUtil.isNotEmpty((Collection)fileRecordIds)) {
                businessIds.addAll(fileRecordIds);
            }
            LambdaQueryWrapper fileInfoQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(FileInfo::getBusinessId, businessIds)).ne(FileInfo::getDelFlag, (Object)"1");
            Integer userSecurityLevel = BaseSecurityUtil.getUser().getSecurityLevel();
            if (HussarUtils.isNotEmpty((Object)userSecurityLevel)) {
                fileInfoQueryWrapper.le(FileInfo::getSecurityLevel, (Object)userSecurityLevel);
            }
            crmRefund.setFileCount(this.fileInfoService.count((Wrapper)fileInfoQueryWrapper));
            SecurityUser user = BaseSecurityUtil.getUser();
            long focusCount = this.focusService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(FocusEntity::getBusinessId, (Object)crmRefund.getRefundId())).eq(FocusEntity::getCreatePersion, (Object)user.getId()));
            crmRefund.setFocus(focusCount > 0L);
            return ApiResponse.success((Object)crmRefund);
        }
        catch (Exception e) {
            throw new HussarException("\u8868\u5355\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    @HussarTransactional
    public ApiResponse<String> insertOrUpdate(CrmRefund crmRefund) {
        try {
            Long refundId = crmRefund.getRefundId();
            CrmRefund oldCrmRefund = null;
            if (refundId != null) {
                oldCrmRefund = (CrmRefund)this.getById(refundId);
            }
            SecurityUser user = BaseSecurityUtil.getUser();
            LocalDateTime date = LocalDateTime.now();
            boolean push = false;
            if (crmRefund.getRefundId() == null || this.getById(crmRefund.getRefundId()) == null) {
                crmRefund.setCreator(user.getId());
                crmRefund.setCreateTime(date);
                crmRefund.setLastEditor(user.getId());
                crmRefund.setLastTime(date);
                crmRefund.setDelFlag(RETURN_CODE);
                crmRefund.setCreatorName(user.getUserName());
                crmRefund.setCreateDepartment(user.getDeptId());
                crmRefund.setCreateDepartmentName(user.getDeptName());
                crmRefund.setLastEditorName(user.getUserName());
                crmRefund.setChargePerson(user.getId());
                crmRefund.setChargePersonName(user.getUserName());
                crmRefund.setOwnDepartment(user.getDeptId());
                crmRefund.setOwnDepartmentName(user.getDeptName());
                crmRefund.setAbandonState(RETURN_CODE);
                push = true;
            } else {
                crmRefund.setLastEditor(user.getId());
                crmRefund.setLastTime(date);
                crmRefund.setLastEditorName(user.getUserName());
            }
            this.saveOrUpdate(crmRefund);
            if (crmRefund.getRefundId() != null) {
                this.teamMeberService.insertTeamMember(user.getUserName(), user.getId(), crmRefund.getRefundId(), "1", "1", date, CrmBusinessTypeEnum.REFUND.getId());
            }
            if (oldCrmRefund == null) {
                ArrayList<Long> typeIdList = new ArrayList<Long>(Collections.singletonList(crmRefund.getRefundId()));
                this.operateRecordAPIService.saveOperateLog((OperateRecordAPIVo)null, CrmBusinessTypeEnum.REFUND, crmRefund.getRefundId(), crmRefund.getRefundNumber(), date, false, typeIdList);
            } else {
                this.saveRefundOperateLog(oldCrmRefund, crmRefund, date);
            }
            this.fileInfoAPIService.deleteHighSecurityLevelFileInfo(crmRefund.getRefundId(), crmRefund.getSecurityLevel());
            this.taskAPIService.updateTaskSecurityLevel(crmRefund.getRefundId(), crmRefund.getSecurityLevel());
            this.fileInfoAPIService.updateTrackFileInfoSecurityLevel(crmRefund.getRefundId(), crmRefund.getSecurityLevel());
            if (push) {
                ArrayList pushPersonIdList;
                LocalDate refundDate = crmRefund.getRefundDate().toLocalDate();
                List memberIdList = this.teamMeberService.listObjs((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{TeamMeberEntity::getPersonId}).eq(TeamMeberEntity::getBusinessId, (Object)crmRefund.getCustomerId())).eq(TeamMeberEntity::getDelFlag, (Object)RETURN_CODE), s -> s.toString());
                if (CollectionUtil.isNotEmpty((Collection)memberIdList)) {
                    String contentUnify = "\u60a8\u7684\u5ba2\u6237\u3010" + crmRefund.getCustomerName() + "\u3011\u6709\u4e00\u7b14\u3010" + refundDate + "\u3011\u7684\u56de\u6b3e\u8bb0\u5f55\uff0c\u91d1\u989d\u3010" + crmRefund.getRefundAmount() + "\u3011\u5143\uff0c\u8bf7\u53ca\u65f6\u8ba4\u9886\u3002";
                    AddSysMessageType addSysMessageType = new AddSysMessageType();
                    String unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/refundDetails?row=" + "\"" + crmRefund.getRefundId() + "\"";
                    addSysMessageType.setMessageTypeId(CommonConstant.MESSAGE_TYPE_OTHER);
                    addSysMessageType.setMessageContent(contentUnify);
                    addSysMessageType.setReleaseDate(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                    String userId = String.join((CharSequence)",", memberIdList);
                    addSysMessageType.setUserId(userId);
                    addSysMessageType.setCreator(Long.valueOf(crmRefund.getCreator()));
                    addSysMessageType.setCreatoeDepartmentId(String.valueOf(crmRefund.getCreateDepartment()));
                    addSysMessageType.setLastEditor(Long.valueOf(crmRefund.getCreator()));
                    addSysMessageType.setMessageIssue(crmRefund.getCreatorName());
                    addSysMessageType.setBusinessAddress(unifyWebUrl);
                    addSysMessageType.setMobileBusinessAddress("");
                    addSysMessageType.setOpenWay("1");
                    UnifyUtil.sendMessage((AddSysMessageType)addSysMessageType);
                }
                if (CollectionUtil.isNotEmpty(pushPersonIdList = new ArrayList())) {
                    List dictVoList = this.sysDicSingleMapper.getDictVosByTypeNames(Collections.singletonList("refund_type"));
                    String transRefundType = this.valueToLabelByDictSingle(crmRefund.getRefundType(), ((DictVo)dictVoList.get(0)).getSingleList());
                    String contentUnify = "\u3010" + crmRefund.getCustomerName() + "\u3011\u4e8e\u3010" + refundDate + "\u3011\u3010" + transRefundType + "\u3011\u56de\u6b3e" + crmRefund.getRefundAmount() + "\u3011\u5143\u3002";
                    AddSysMessageType addSysMessageType = new AddSysMessageType();
                    String unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/refundDetails?row=" + "\"" + crmRefund.getRefundId() + "\"";
                    addSysMessageType.setMessageTypeId(CommonConstant.MESSAGE_TYPE_OTHER);
                    addSysMessageType.setMessageContent(contentUnify);
                    addSysMessageType.setReleaseDate(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                    String userId = String.join((CharSequence)",", pushPersonIdList);
                    addSysMessageType.setUserId(userId);
                    addSysMessageType.setCreator(Long.valueOf(crmRefund.getCreator()));
                    addSysMessageType.setCreatoeDepartmentId(String.valueOf(crmRefund.getCreateDepartment()));
                    addSysMessageType.setLastEditor(Long.valueOf(crmRefund.getCreator()));
                    addSysMessageType.setMessageIssue(crmRefund.getCreatorName());
                    addSysMessageType.setBusinessAddress(unifyWebUrl);
                    addSysMessageType.setMobileBusinessAddress("");
                    addSysMessageType.setOpenWay("1");
                    UnifyUtil.sendMessage((AddSysMessageType)addSysMessageType);
                }
            }
            return ApiResponse.success((Object)String.valueOf(crmRefund.getRefundId()), (String)"");
        }
        catch (Exception e) {
            throw new HussarException("\u65b0\u589e\u6216\u4fee\u6539\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public List<AssociativeQueryVo> associativeQuery(CrmRefundAssociativeQueryDto dto) {
        String keyWord = dto.getKeyword();
        String queryScreening = null;
        if (dto.getDto() != null) {
            queryScreening = dto.getDto().getRefundFullLike();
        }
        ICrmRefundAssociativeQueryService adapterService = this.crmRefundAssociativeQueryService;
        AssociativeKeyword associativeKeyword = new AssociativeKeyword();
        associativeKeyword.setLabelName("\u5173\u952e\u5b57");
        associativeKeyword.setDataName("input_5Data");
        associativeKeyword.setDictTypeName("");
        associativeKeyword.setMultiOption(Boolean.valueOf(false));
        return this.associativeQueryService.associativeQuery((AssociativeQueryDto)dto, keyWord, queryScreening, (IAssociativeQueryAdapterService)adapterService, associativeKeyword);
    }

    private List<CrmRefundCrmrefunddataset1> getOrderUnityDtoList(CrmRefundCrmrefunddataset1 crmrefunddataset1) {
        ArrayList<CrmRefundCrmrefunddataset1> queryDtoList = new ArrayList<CrmRefundCrmrefunddataset1>();
        String view = crmrefunddataset1.getRefundView();
        if (StringUtil.isNotEmpty((Object)view) && !"preview".equals(view)) {
            CrmScene crmScene;
            long refundView = Long.parseLong(view);
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(CrmScene::getSceneId, (Object)refundView);
            lambdaQueryWrapper.eq(CrmScene::getModule, (Object)"refund");
            List crmSceneList = this.crmSceneMapper.selectList((Wrapper)lambdaQueryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)crmSceneList) && RETURN_CODE.equals((crmScene = (CrmScene)crmSceneList.get(0)).getIsSystem())) {
                try {
                    String query = crmScene.getQuery();
                    if (StringUtil.isNotBlank((CharSequence)query)) {
                        String queryValue = JSONObject.parseObject((String)query).get((Object)"queryValue").toString();
                        CrmRefundCrmrefunddataset1 queryDto = (CrmRefundCrmrefunddataset1)JSONObject.parseObject((String)queryValue, CrmRefundCrmrefunddataset1.class);
                        queryDto.setRefundView(String.valueOf(refundView));
                        queryDtoList.add(this.crmrefunddataset1Condition(queryDto));
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        queryDtoList.add(this.crmrefunddataset1Condition(crmrefunddataset1));
        return queryDtoList;
    }

    private CrmRefundCrmrefunddataset1 crmrefunddataset1Condition(CrmRefundCrmrefunddataset1 crmrefunddataset1) {
        DateConvertVo dateConvertVo;
        if (ToolUtil.isNotEmpty((Object)crmrefunddataset1.getRefundTimeFlag()) && !"6".equals(crmrefunddataset1.getRefundTimeFlag()) && (dateConvertVo = CrmDateUtils.getCurrentTime((String)crmrefunddataset1.getRefundTimeFlag())) != null) {
            crmrefunddataset1.setRefundStartDate(LocalDate.parse(dateConvertVo.getStartDate()));
            crmrefunddataset1.setRefundEndDate(LocalDate.parse(dateConvertVo.getEndDate()));
        }
        return crmrefunddataset1;
    }

    private CrmRefund updateRefundInfo(CrmRefund crmRefund) {
        long focusCount;
        String claimState;
        SecurityUser user = BaseSecurityUtil.getUser();
        ArrayList<String> typeNameList = new ArrayList<String>();
        typeNameList.add("refund_type");
        typeNameList.add("claim_state");
        List dictVoList = this.sysDicSingleMapper.getDictVosByTypeNames(typeNameList);
        List refundTypeDict = null;
        List claimStateDict = null;
        for (DictVo dictVo : dictVoList) {
            switch (dictVo.getTypeName()) {
                case "refund_type": {
                    refundTypeDict = dictVo.getSingleList();
                    break;
                }
                case "claim_state": {
                    claimStateDict = dictVo.getSingleList();
                }
            }
        }
        String refundType = crmRefund.getRefundType();
        if (CollectionUtil.isNotEmpty((Object)refundType) && StringUtil.isNotEmpty((Object)refundType)) {
            crmRefund.setTranslateRefundType(this.valueToLabelByDictSingle(refundType, refundTypeDict));
        }
        if (CollectionUtil.isNotEmpty((Object)(claimState = crmRefund.getClaimState())) && StringUtil.isNotEmpty((Object)claimState)) {
            crmRefund.setTranslateClaimState(this.valueToLabelByDictSingle(claimState, claimStateDict));
        }
        crmRefund.setFocus((focusCount = this.focusService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(FocusEntity::getBusinessId, (Object)crmRefund.getRefundId())).eq(FocusEntity::getCreatePersion, (Object)user.getId()))) > 0L);
        return crmRefund;
    }

    private String valueToLabelByDictSingle(String values, List<DicSingle> dicSingleList) {
        Map<String, String> dictSingleMap = dicSingleList.stream().collect(Collectors.toMap(DicSingle::getValue, DicSingle::getLabel));
        String[] valueArray = values.split(",");
        String labels = "";
        for (String array : valueArray) {
            String label = dictSingleMap.get(array);
            if (!StringUtil.isNotEmpty((Object)label)) continue;
            labels = StringUtil.isNotEmpty((Object)labels) ? labels + "," + label : label;
        }
        return labels;
    }

    public PermissionDto refundOperate(CrmRefundCrmrefunddataset1 dto) {
        PermissionDto permissionDto = new PermissionDto();
        String refundView = dto.getRefundView();
        if (StringUtil.isNotEmpty((Object)refundView) && !RETURN_CODE.equals(refundView)) {
            permissionDto = this.refundDataRightModuleService.getCurrentUserRolePermissions();
        }
        return permissionDto;
    }

    @Override
    @HussarTransactional
    public Boolean refundAbandon(Long refundId) {
        if (HussarUtils.isEmpty((Object)refundId)) {
            throw new HussarException("\u53c2\u6570\u7f3a\u5931");
        }
        long claimCount = this.crmRefundClaimMasterService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CrmRefundClaimMaster::getRefundId, (Object)refundId)).eq(CrmRefundClaimMaster::getDelFlag, (Object)RETURN_CODE));
        if (claimCount > 0L) {
            throw new HussarException("\u5f53\u524d\u56de\u6b3e\u5df2\u8ba4\u9886\uff0c\u65e0\u6cd5\u4f5c\u5e9f");
        }
        return this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(CrmRefund::getRefundId, (Object)refundId)).set(CrmRefund::getAbandonState, (Object)"1"));
    }

    private void saveRefundOperateLog(CrmRefund oldCrmRefund, CrmRefund crmRefund, LocalDateTime date) {
        String oldRefundAmount;
        String oldRefundDate;
        ArrayList<String> typeNameList = new ArrayList<String>();
        typeNameList.add("refund_type");
        typeNameList.add("claim_type");
        List dictVoList = this.sysDicSingleMapper.getDictVosByTypeNames(typeNameList);
        List refundTypeDict = new ArrayList();
        for (DictVo dictVo : dictVoList) {
            switch (dictVo.getTypeName()) {
                case "refund_type": {
                    refundTypeDict = dictVo.getSingleList();
                }
            }
        }
        ArrayList changeField = new ArrayList();
        HashMap<String, String> before = new HashMap<String, String>();
        HashMap<String, String> after = new HashMap<String, String>();
        String newCustomerId = crmRefund.getCustomerName();
        String oldCustomerId = oldCrmRefund.getCustomerName();
        Boolean hasChange = false;
        if (!(ToolUtil.isEmpty((Object)newCustomerId) && ToolUtil.isEmpty((Object)oldCustomerId) || newCustomerId.equals(oldCustomerId))) {
            HashMap<String, String> field = new HashMap<String, String>();
            field.put("field", RefundEditEnum.CUSTOMER_NAME.getField());
            field.put("fieldName", RefundEditEnum.CUSTOMER_NAME.getName());
            changeField.add(field);
            before.put(RefundEditEnum.CUSTOMER_NAME.getField(), oldCustomerId);
            after.put(RefundEditEnum.CUSTOMER_NAME.getField(), newCustomerId);
            hasChange = true;
        }
        DateTimeFormatter sdf = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String newRefundDate = crmRefund.getRefundDate() == null ? "" : sdf.format(crmRefund.getRefundDate());
        String string = oldRefundDate = oldCrmRefund.getRefundDate() == null ? "" : sdf.format(oldCrmRefund.getRefundDate());
        if (!(ToolUtil.isEmpty((Object)newRefundDate) && ToolUtil.isEmpty((Object)oldRefundDate) || newRefundDate.equals(oldRefundDate))) {
            HashMap<String, String> field = new HashMap<String, String>();
            field.put("field", RefundEditEnum.REFUND_DATE.getField());
            field.put("fieldName", RefundEditEnum.REFUND_DATE.getName());
            changeField.add(field);
            before.put(RefundEditEnum.REFUND_DATE.getField(), oldRefundDate);
            after.put(RefundEditEnum.REFUND_DATE.getField(), newRefundDate);
            hasChange = true;
        }
        String newRefundType = crmRefund.getRefundType();
        String oldRefundType = oldCrmRefund.getRefundType();
        if (!(ToolUtil.isEmpty((Object)newRefundType) && ToolUtil.isEmpty((Object)oldRefundType) || newRefundType.equals(oldRefundType))) {
            HashMap<String, String> field = new HashMap<String, String>();
            field.put("field", RefundEditEnum.REFUND_TYPE.getField());
            field.put("fieldName", RefundEditEnum.REFUND_TYPE.getName());
            changeField.add(field);
            before.put(RefundEditEnum.REFUND_TYPE.getField(), DictUtils.valueToLabelByDictSingle((String)oldRefundType, refundTypeDict));
            after.put(RefundEditEnum.REFUND_TYPE.getField(), DictUtils.valueToLabelByDictSingle((String)newRefundType, refundTypeDict));
            hasChange = true;
        }
        String newRefundAmount = crmRefund.getRefundAmount() == null ? "\u7a7a" : CommonUtills.transferAmountSeparator((Double)crmRefund.getRefundAmount());
        String string2 = oldRefundAmount = oldCrmRefund.getRefundAmount() == null ? "\u7a7a" : CommonUtills.transferAmountSeparator((Double)oldCrmRefund.getRefundAmount());
        if (!(ToolUtil.isEmpty((Object)newRefundAmount) && ToolUtil.isEmpty((Object)oldRefundAmount) || newRefundAmount.equals(oldRefundAmount))) {
            HashMap<String, String> field = new HashMap<String, String>();
            field.put("field", RefundEditEnum.REFUND_AMOUNT.getField());
            field.put("fieldName", RefundEditEnum.REFUND_AMOUNT.getName());
            changeField.add(field);
            before.put(RefundEditEnum.REFUND_AMOUNT.getField(), oldRefundAmount);
            after.put(RefundEditEnum.REFUND_AMOUNT.getField(), newRefundAmount);
            hasChange = true;
        }
        Integer oldSecurityLevel = oldCrmRefund.getSecurityLevel();
        Integer newSecurityLevel = crmRefund.getSecurityLevel();
        if (!(ToolUtil.isEmpty((Object)oldSecurityLevel) && ToolUtil.isEmpty((Object)newSecurityLevel) || !ToolUtil.isEmpty((Object)oldSecurityLevel) && oldSecurityLevel.equals(newSecurityLevel))) {
            List list = this.sysDicRefService.getDictByType("security_level");
            String oldLabel = "";
            String newLabel = "";
            for (DicSingle dicSingle : list) {
                if (!dicSingle.getValue().equals(oldSecurityLevel.toString())) continue;
                oldLabel = dicSingle.getLabel();
                break;
            }
            for (DicSingle dicSingle : list) {
                if (!dicSingle.getValue().equals(newSecurityLevel.toString())) continue;
                newLabel = dicSingle.getLabel();
                break;
            }
            HashMap<String, String> field = new HashMap<String, String>();
            field.put("field", RefundEditEnum.SECURITY_LEVEL.getField());
            field.put("fieldName", RefundEditEnum.SECURITY_LEVEL.getName());
            changeField.add(field);
            before.put(RefundEditEnum.SECURITY_LEVEL.getField(), oldLabel);
            after.put(RefundEditEnum.SECURITY_LEVEL.getField(), newLabel);
            hasChange = true;
        }
        if (hasChange.booleanValue()) {
            String oldJson = JSON.toJSONString(before);
            String newJson = JSON.toJSONString(after);
            String changeFieldStr = JSON.toJSONString(changeField);
            OperateRecordAPIVo operateRecordDO = this.crmOpportunity2Service.initializeOperateLog(RecordProductTypeEnum.PRODUCE_CHANGE.getId(), oldJson, newJson, changeFieldStr);
            operateRecordDO.setChangeBatch(1);
            this.operateRecordAPIService.saveOperateLog(operateRecordDO, CrmBusinessTypeEnum.REFUND, crmRefund.getRefundId(), oldCrmRefund.getRefundNumber(), date, false, Collections.singletonList(crmRefund.getRefundId()));
        }
    }

    @Override
    public OperateVo operate(Long refundId) {
        PermissionDto refundPermissionDto;
        OperateVo operateVo = new OperateVo();
        if (refundId == null) {
            return operateVo;
        }
        CrmRefund crmRefund = (CrmRefund)this.getById(refundId);
        if (crmRefund == null || "1".equals(crmRefund.getDelFlag())) {
            return operateVo;
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        if (HussarUtils.isNotEmpty((Object)user.getSecurityLevel()) && user.getSecurityLevel() < crmRefund.getSecurityLevel()) {
            return operateVo;
        }
        if ("1".equals(crmRefund.getAbandonState())) {
            operateVo.setViewOperate(Boolean.valueOf(true));
            operateVo.setEditOperate(Integer.valueOf(-1));
            return operateVo;
        }
        if (Objects.equals(crmRefund.getChargePerson(), user.getUserId())) {
            operateVo.setEditOperate(Integer.valueOf(1));
            operateVo.setViewOperate(Boolean.valueOf(true));
            return operateVo;
        }
        this.teamMemberApiService.teamMemberOperate(refundId, user, operateVo, "26");
        if (!operateVo.getViewOperate().booleanValue() && ((refundPermissionDto = this.refundDataRightModuleService.getUserRolePermission(user)).getPermissionDeptIds() == null || refundPermissionDto.getPermissionDeptIds().contains(crmRefund.getOwnDepartment()))) {
            operateVo.setViewOperate(Boolean.valueOf(true));
        }
        return operateVo;
    }

    @Override
    public Double selectConfirmedAmountByRefundId(Long refundId) {
        CrmRefund refund = (CrmRefund)this.getById(refundId);
        if (refund != null) {
            List<String> statusList = Arrays.asList("2", "4");
            List crmRefundClaimList = this.crmRefundClaimMasterService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(CrmRefundClaimMaster::getFlowStatus, statusList)).eq(CrmRefundClaimMaster::getRefundId, (Object)refundId)).eq(CrmRefundClaimMaster::getDelFlag, (Object)RETURN_CODE));
            Double thisClaimAmountSum = 0.0;
            if (CollectionUtil.isNotEmpty((Collection)crmRefundClaimList)) {
                thisClaimAmountSum = crmRefundClaimList.stream().filter(claim -> claim.getThisClaimAmount() != null).mapToDouble(CrmRefundClaimMaster::getThisClaimAmount).sum();
            }
            return refund.getRefundAmount() - thisClaimAmountSum;
        }
        return 0.0;
    }
}

