/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.transaction.operationsmanage.ledger.job.service.impl;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.api.util.constant.common.CommonConstant;
import com.jxdinfo.crm.core.config.UnifyProperties;
import com.jxdinfo.crm.core.index.dto.SalesStatisticsDto;
import com.jxdinfo.crm.core.unify.dto.AddSysMessageType;
import com.jxdinfo.crm.core.unify.util.UnifyUtil;
import com.jxdinfo.crm.transaction.operationsmanage.ledger.dao.BillPeriodLedgerMapper;
import com.jxdinfo.crm.transaction.operationsmanage.ledger.dto.BillPeriodLedgerDto;
import com.jxdinfo.crm.transaction.operationsmanage.ledger.job.service.IBillPeriodLedgerMessageService;
import com.jxdinfo.crm.transaction.operationsmanage.ledger.model.BillPeriodLedger;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class BillPeriodLedgerMessageServiceImpl
implements IBillPeriodLedgerMessageService {
    @Resource
    private CrmCommonProperties crmProperties;
    @Resource
    private BillPeriodLedgerMapper billPeriodLedgerMapper;
    @Resource
    private UnifyProperties unifyProperties;

    @Override
    public ProcessResult agreementInvoiceProcess() {
        SalesStatisticsDto permissionDto = new SalesStatisticsDto();
        BillPeriodLedgerDto billPeriodLedgerDto = new BillPeriodLedgerDto();
        billPeriodLedgerDto.setQueryType("1");
        billPeriodLedgerDto.setDelFlag("0");
        List<BillPeriodLedger> list = this.billPeriodLedgerMapper.receiveLedgerList(Collections.singletonList(billPeriodLedgerDto), null, null);
        list.stream().filter(ledger -> ledger.getReceivableAmount() != null && ledger.getReceivableAmount().compareTo(BigDecimal.ZERO) == 0).filter(ledger -> ledger.getConfirmReceivableDate() != null && ledger.getPayProvision() != null).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(list)) {
            LocalDate now = LocalDate.now();
            for (BillPeriodLedger ledger2 : list) {
                if (!ToolUtil.isNotEmpty((Object)ledger2.getConfirmReceivableDate())) continue;
                LocalDate reminderDate = "7".equals(ledger2.getPayProvision()) ? ledger2.getConfirmReceivableDate().plusDays(6L) : ledger2.getConfirmReceivableDate().plusDays(Integer.valueOf(ledger2.getPayProvision()).intValue());
                LocalDate dueDate = ledger2.getConfirmReceivableDate().plusDays(Integer.valueOf(ledger2.getPayProvision()).intValue());
                LocalDate threeDate = dueDate.minusDays(3L);
                if (!now.equals(reminderDate) && !now.equals(threeDate)) continue;
                String contentUnify = "\u60a8\u7684\u5408\u540c\u3010" + ledger2.getAgreementNumber() + ledger2.getAgreementName() + "\u3011\u4e0b\u7684\u53d1\u7968";
                contentUnify = HussarUtils.isNotEmpty((Object)ledger2.getApplyNumber()) ? contentUnify + "\uff1a\u3010" + ledger2.getApplyNumber() + "\u3011\u5c06\u4e8e" + dueDate + "\u7ea6\u5b9a\u56de\u6b3e\uff0c\u8bf7\u53ca\u65f6\u8ddf\u8fdb" : contentUnify + "\u5c06\u4e8e" + dueDate + "\u7ea6\u5b9a\u56de\u6b3e\uff0c\u8bf7\u53ca\u65f6\u8ddf\u8fdb";
                AddSysMessageType addSysMessageType = new AddSysMessageType();
                String unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/contractDetails?row=" + "\"" + ledger2.getAgreementId() + "\"";
                addSysMessageType.setMessageTypeId(CommonConstant.MESSAGE_TYPE_OTHER);
                addSysMessageType.setMessageContent(contentUnify);
                addSysMessageType.setReleaseDate(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                List<Long> pushPersonIds = Arrays.asList(ledger2.getAgreementChargePerson(), ledger2.getInvoiceChargePerson());
                String userIds = String.valueOf(ledger2.getCreator());
                if (CollectionUtils.isNotEmpty(pushPersonIds)) {
                    userIds = pushPersonIds.stream().map(String::valueOf).collect(Collectors.joining(","));
                }
                addSysMessageType.setUserId(userIds);
                addSysMessageType.setCreator(ledger2.getCreator());
                addSysMessageType.setCreatoeDepartmentId(String.valueOf(ledger2.getCreateDepartment()));
                addSysMessageType.setLastEditor(ledger2.getCreator());
                addSysMessageType.setMessageIssue("\u8d85\u7ea7\u7ba1\u7406\u5458");
                addSysMessageType.setBusinessAddress(unifyWebUrl);
                addSysMessageType.setMobileBusinessAddress("");
                addSysMessageType.setOpenWay("1");
                UnifyUtil.sendMessage((AddSysMessageType)addSysMessageType);
            }
        }
        return new ProcessResult(true);
    }
}

