/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.transaction.quote.quotation.util;

import cn.afterturn.easypoi.word.WordExportUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class WordUtil {
    private static final Logger log = LoggerFactory.getLogger(WordUtil.class);

    public static String exportWord(String templatePath, String saveDir, String fileName, Map<String, Object> params) {
        File dir;
        Assert.notNull((Object)templatePath, (String)"\u6a21\u677f\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)saveDir, (String)"\u4e34\u65f6\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)fileName, (String)"\u5bfc\u51fa\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)fileName.endsWith(".docx"), (String)"word\u5bfc\u51fa\u8bf7\u4f7f\u7528docx\u683c\u5f0f");
        if (!saveDir.endsWith("/")) {
            saveDir = saveDir + File.separator;
        }
        if (!(dir = new File(saveDir)).exists()) {
            dir.mkdirs();
        }
        String savePath = saveDir + fileName;
        try {
            XWPFDocument doc = WordExportUtil.exportWord07((String)templatePath, params);
            FileOutputStream fos = new FileOutputStream(savePath);
            doc.write((OutputStream)fos);
            fos.flush();
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return savePath;
    }
}

