/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.transaction.quote.quotation.quotationdetailbpm.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.common.api.associativeQuery.dto.AssociativeKeyword;
import com.jxdinfo.crm.common.api.associativeQuery.dto.AssociativeQueryDto;
import com.jxdinfo.crm.common.api.associativeQuery.service.IAssociativeQueryAPIService;
import com.jxdinfo.crm.common.api.associativeQuery.service.IAssociativeQueryAdapterService;
import com.jxdinfo.crm.common.api.associativeQuery.vo.AssociativeQueryVo;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.operaterecord.service.IOperateRecordAPIService;
import com.jxdinfo.crm.common.api.operaterecord.vo.OperateRecordAPIVo;
import com.jxdinfo.crm.core.teammeber.dao.TeamMeberMapper;
import com.jxdinfo.crm.core.teammeber.dto.TeamMeberDto;
import com.jxdinfo.crm.core.teammeber.model.TeamMeberEntity;
import com.jxdinfo.crm.core.teammeber.service.TeamMeberService;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.crm.transaction.quote.quotation.quotation.model.Quotation;
import com.jxdinfo.crm.transaction.quote.quotation.quotation.service.QuotationService;
import com.jxdinfo.crm.transaction.quote.quotation.quotationdetailbpm.dao.QuotationDetailBpmMapper;
import com.jxdinfo.crm.transaction.quote.quotation.quotationdetailbpm.dto.QuotationAssociativeQueryDto;
import com.jxdinfo.crm.transaction.quote.quotation.quotationdetailbpm.dto.QuotationDetailBpmSelectCondition;
import com.jxdinfo.crm.transaction.quote.quotation.quotationdetailbpm.dto.QuotationPrincipalChangeDto;
import com.jxdinfo.crm.transaction.quote.quotation.quotationdetailbpm.model.CrmQuoteDetail;
import com.jxdinfo.crm.transaction.quote.quotation.quotationdetailbpm.model.QuotationDetailBpm;
import com.jxdinfo.crm.transaction.quote.quotation.quotationdetailbpm.service.QuotationAssociativeQueryService;
import com.jxdinfo.crm.transaction.quote.quotation.quotationdetailbpm.service.QuotationExtendService;
import com.jxdinfo.crm.transaction.quote.quotation.quotationdetailbpm.vo.ProductComboboxVo;
import com.jxdinfo.crm.transaction.quote.quotation.quotationdetailbpm.vo.QuotationDetailBpmPageVO;
import com.jxdinfo.crm.transaction.quote.quotation.quotationdetailbpm.vo.QuotationTrendVo;
import com.jxdinfo.crm.transaction.quote.quotation.util.QuoteUtil;
import com.jxdinfo.crm.transaction.quote.quotation.util.WordUtil;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.transdict.extend.formdesign.TransUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ResourceUtils;

@Service(value="quote.quotation.quotationdetailbpm.QuotationExtendServiceImpl")
@HussarTokenDs
public class QuotationExtendServiceImpl
implements QuotationExtendService {
    private static final Logger logger = LoggerFactory.getLogger(QuotationExtendServiceImpl.class);
    private static final String RETURN_CODE = "0";
    private static final String ORDER_RULE = "orderRule";
    private static final String DEFAULT_ORDER_RULE = "defaultOrderRule";
    private static final String ASC = ",asc;";
    private static final String DESC = ",desc;";
    @Autowired
    private QuotationDetailBpmMapper quotationDetailBpmMapper;
    @Resource
    private IAssociativeQueryAPIService associativeQueryService;
    @Resource
    private QuotationAssociativeQueryService quotationAssociativeQueryService;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Resource
    private QuoteUtil quoteUtil;
    @Resource
    private TeamMeberMapper teamMeberMapper;
    @Resource
    private TeamMeberService teamMeberService;
    @Resource
    private IOperateRecordAPIService operateRecordAPIService;
    @Resource
    private QuotationService quotationService;

    @Override
    public List<AssociativeQueryVo> associativeQueryNew(QuotationAssociativeQueryDto dto) {
        String keyWord = dto.getKeyword();
        String queryScreening = null;
        if (dto.getDto() != null) {
            queryScreening = dto.getDto().getKeyword();
        }
        QuotationAssociativeQueryService adapterService = this.quotationAssociativeQueryService;
        AssociativeKeyword associativeKeyword = new AssociativeKeyword();
        associativeKeyword.setLabelName("\u5173\u952e\u5b57");
        associativeKeyword.setDataName("keyword");
        associativeKeyword.setDictTypeName("");
        associativeKeyword.setMultiOption(Boolean.valueOf(false));
        return this.associativeQueryService.associativeQuery((AssociativeQueryDto)dto, keyWord, queryScreening, (IAssociativeQueryAdapterService)adapterService, associativeKeyword);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResponse<Boolean> changeQuotationPrincipal(List<QuotationPrincipalChangeDto> dto) {
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        ArrayList<Quotation> quotationUpdateList = new ArrayList<Quotation>();
        ArrayList<TeamMeberEntity> teamMemberDeleteList = new ArrayList<TeamMeberEntity>();
        ArrayList<Long> teamMemberAddList = new ArrayList<Long>();
        ArrayList<TeamMeberEntity> teamMemberUpdateList = new ArrayList<TeamMeberEntity>();
        ArrayList<OperateRecordAPIVo> recordList = new ArrayList<OperateRecordAPIVo>();
        for (QuotationPrincipalChangeDto changeDto : dto) {
            if (changeDto.getNewPrincipalId().equals(changeDto.getOldPrincipalId())) continue;
            Quotation update = new Quotation();
            update.setQuoteId(changeDto.getQuoteId());
            update.setPrincipalId(changeDto.getNewPrincipalId());
            update.setPrincipalName(changeDto.getNewPrincipalName());
            quotationUpdateList.add(update);
            if (!changeDto.getKeepFlag().booleanValue()) {
                TeamMeberEntity teamMemberDelete = new TeamMeberEntity();
                teamMemberDelete.setBusinessId(changeDto.getQuoteId());
                teamMemberDelete.setPersonId(changeDto.getOldPrincipalId());
                teamMemberDelete.setDelFlag("1");
                teamMemberDeleteList.add(teamMemberDelete);
            } else {
                TeamMeberEntity teamMemberUpdate = new TeamMeberEntity();
                teamMemberUpdate.setBusinessId(changeDto.getQuoteId());
                teamMemberUpdate.setPersonId(changeDto.getOldPrincipalId());
                teamMemberUpdate.setIsCharge(RETURN_CODE);
                teamMemberUpdateList.add(teamMemberUpdate);
            }
            TeamMeberDto teamMeberDto = new TeamMeberDto();
            teamMeberDto.setBusinessId(changeDto.getQuoteId());
            teamMeberDto.setPersonId(changeDto.getNewPrincipalId());
            teamMeberDto.setDelFlag(RETURN_CODE);
            List list = this.teamMeberMapper.selectTeamMeberList((Page)null, teamMeberDto);
            if (list.size() == 0) {
                teamMemberAddList.add(changeDto.getQuoteId());
            } else {
                TeamMeberEntity teamMemberUpdate = new TeamMeberEntity();
                teamMemberUpdate.setBusinessId(changeDto.getQuoteId());
                teamMemberUpdate.setPersonId(changeDto.getNewPrincipalId());
                teamMemberUpdate.setIsCharge("1");
                teamMemberUpdate.setModifyPower("1");
                teamMemberUpdateList.add(teamMemberUpdate);
            }
            Quotation quotation = (Quotation)this.quotationService.getById(changeDto.getQuoteId());
            OperateRecordAPIVo record = new OperateRecordAPIVo();
            record.setContactId(changeDto.getNewPrincipalId());
            record.setContactName(changeDto.getNewPrincipalName());
            record.setProduceType(RecordProductTypeEnum.PRODUCE_TRANSFER.getId());
            record.setOldContactId(changeDto.getOldPrincipalId());
            record.setOldContactName(changeDto.getOldPrincipalName());
            record.setRecordId(Long.valueOf(CommonUtills.generateAssignId()));
            record.setBusinessType("20");
            record.setTypeId(changeDto.getQuoteId());
            record.setBusinessName(quotation.getQuoteName());
            record.setCreatePerson(user.getUserId());
            record.setCreatePersonName(user.getUserName());
            record.setCreateTime(date);
            record.setChangePerson(user.getUserId());
            record.setChangeTime(date);
            record.setChangePersonName(user.getUserName());
            record.setDelflag(RETURN_CODE);
            recordList.add(record);
        }
        if (CollectionUtil.isNotEmpty(quotationUpdateList)) {
            this.quotationService.updateBatchById(quotationUpdateList);
        }
        if (CollectionUtil.isNotEmpty(teamMemberDeleteList)) {
            this.teamMeberMapper.deleteChargePersonBatch(teamMemberDeleteList);
        }
        if (CollectionUtil.isNotEmpty(teamMemberAddList)) {
            this.teamMeberService.insertTeamMemberBatch(dto.get(0).getNewPrincipalName(), dto.get(0).getNewPrincipalId(), teamMemberAddList, "1", "1", date, "20");
        }
        if (CollectionUtil.isNotEmpty(teamMemberUpdateList)) {
            this.teamMeberMapper.updateIsChargeBatch(teamMemberUpdateList);
        }
        if (CollectionUtil.isNotEmpty(recordList)) {
            this.operateRecordAPIService.saveOperateLogBatch(recordList);
        }
        return ApiResponse.success();
    }

    @Override
    public void exportWord(String id, HttpServletResponse response) throws IOException {
        String newTemplatePath;
        QuotationDetailBpm crmQuote = this.quotationDetailBpmMapper.formQuery(id);
        TransUtil.trans((Object)crmQuote);
        List<CrmQuoteDetail> crmQuoteDetails = crmQuote.getCrmQuoteDetail();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("q", crmQuote);
        params.put("detail", crmQuoteDetails);
        File rootFile = new File(ResourceUtils.getURL((String)"classpath:").getPath());
        File templateFile = new File(rootFile, "/templates/quotationTemplate.docx");
        String templatePath = templateFile.getPath();
        System.out.println(templateFile);
        String fileName = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + "_" + System.currentTimeMillis() + ".docx";
        if (templatePath.contains("!")) {
            String os = System.getProperty("os.name").toLowerCase();
            if (os.contains("windows")) {
                templatePath = templatePath.replaceFirst("file:\\\\", "");
            } else if (os.contains("linux")) {
                templatePath = templatePath.replaceFirst("file:", "");
            }
            rootFile = Paths.get(templatePath.split("!")[0], new String[0]).getRoot().toFile();
        } else {
            rootFile = Paths.get(templatePath, new String[0]).getRoot().toFile();
        }
        File saveFile = new File(rootFile, "/templates");
        String saveDir = saveFile.getPath();
        if (!saveFile.exists()) {
            saveFile.mkdirs();
        }
        if (!new File(newTemplatePath = saveDir + File.separator + "quotationTemplate.docx").exists()) {
            String classpathResource = "templates/quotationTemplate.docx";
            ClassPathResource resource = new ClassPathResource(classpathResource);
            InputStream templateInputStream = resource.getInputStream();
            Files.copy(templateInputStream, Paths.get(newTemplatePath, new String[0]), new CopyOption[0]);
        }
        try {
            int len1;
            String word = WordUtil.exportWord(newTemplatePath, saveDir, fileName, params);
            File file = new File(word);
            FileInputStream inputStream = new FileInputStream(file);
            response.setContentType("application/octet-stream");
            ServletOutputStream outputStream = response.getOutputStream();
            byte[] buffer1 = new byte[1024];
            while ((len1 = ((InputStream)inputStream).read(buffer1)) > 0) {
                outputStream.write(buffer1, 0, len1);
            }
            outputStream.flush();
            outputStream.close();
            ((InputStream)inputStream).close();
            file.delete();
        }
        catch (Exception e) {
            throw new HussarException("\u5bfc\u51faWord\u6587\u6863\u65f6\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    public List<QuotationDetailBpm> getByMap(Map<String, Object> map) {
        return this.quotationDetailBpmMapper.getByMap((QuotationDetailBpm)BeanUtil.copy(map, QuotationDetailBpm.class));
    }

    public String createQuoteNo() {
        String datetime = new SimpleDateFormat("yyyyMMdd").format(new Date());
        String key = MessageFormat.format("{0}:{1}", "sys", datetime);
        Long autoID = this.stringRedisTemplate.opsForValue().increment((Object)key, 1L);
        if (autoID == 1L) {
            this.stringRedisTemplate.expire((Object)key, 86400L, TimeUnit.SECONDS);
        }
        String value = StringUtils.leftPad((String)String.valueOf(autoID), (int)4, (String)RETURN_CODE);
        String code = MessageFormat.format("{0}{1}{2}{3}", "BJ-", datetime, "-", value);
        return code;
    }

    @Override
    public ApiResponse<QuotationDetailBpmPageVO> selectQuotationList(QuotationDetailBpmSelectCondition quotationDetailBpmSelectCondition) {
        try {
            Page pager = new Page((long)quotationDetailBpmSelectCondition.getCurrent(), (long)quotationDetailBpmSelectCondition.getSize());
            HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
            ArrayList<String> orderRule = new ArrayList<String>();
            if (quotationDetailBpmSelectCondition.getOrders() != null) {
                StringBuilder order = new StringBuilder();
                for (OrderItem orderItem : quotationDetailBpmSelectCondition.getOrders()) {
                    if (orderItem.isAsc()) {
                        order.append(orderItem.getColumn()).append(ASC);
                        continue;
                    }
                    order.append(orderItem.getColumn()).append(DESC);
                }
                orderRule.add(order.toString());
                parameterMap.put(ORDER_RULE, orderRule.toArray(new String[0]));
            }
            if (("3".equals((quotationDetailBpmSelectCondition = this.quoteUtil.dealQuotationQueryConditions(quotationDetailBpmSelectCondition)).getSceneTab()) || "4".equals(quotationDetailBpmSelectCondition.getSceneTab())) && CollectionUtil.isEmpty(quotationDetailBpmSelectCondition.getBpmIds())) {
                QuotationDetailBpmPageVO quotationDetailBpmPageVO = new QuotationDetailBpmPageVO();
                quotationDetailBpmPageVO.setData(new ArrayList<QuotationDetailBpm>());
                quotationDetailBpmPageVO.setCount(0L);
                quotationDetailBpmPageVO.setCode(RETURN_CODE);
                return ApiResponse.success((Object)quotationDetailBpmPageVO);
            }
            IPage<QuotationDetailBpm> list = this.quotationDetailBpmMapper.selectQuotationList((Page<QuotationDetailBpm>)pager, quotationDetailBpmSelectCondition);
            QuotationDetailBpmPageVO quotationDetailBpmPageVO = new QuotationDetailBpmPageVO();
            quotationDetailBpmPageVO.setData(list.getRecords());
            quotationDetailBpmPageVO.setCount(list.getTotal());
            quotationDetailBpmPageVO.setCode(RETURN_CODE);
            return ApiResponse.success((Object)quotationDetailBpmPageVO);
        }
        catch (Exception e) {
            throw new HussarException("\u8868\u683c\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public ApiResponse<Map<String, List<Object>>> getTrend(String customerId, String productId) {
        HashMap map = new HashMap();
        ArrayList<LocalDate> xAxisData = new ArrayList<LocalDate>();
        ArrayList<Double> yAxisData = new ArrayList<Double>();
        if (HussarUtils.isNull((Object)customerId) || HussarUtils.isNull((Object)productId)) {
            map.put("xAxisData", Collections.singletonList(xAxisData));
            map.put("yAxisData", Collections.singletonList(yAxisData));
            return ApiResponse.success(map);
        }
        List<QuotationTrendVo> quotationVos = this.quotationDetailBpmMapper.getTrend(customerId, productId);
        for (QuotationTrendVo quotationTrendVo : quotationVos) {
            if (xAxisData.contains(quotationTrendVo.getQuoteDate())) continue;
            xAxisData.add(quotationTrendVo.getQuoteDate());
            yAxisData.add(quotationTrendVo.getSalePrice());
        }
        map.put("xAxisData", Collections.singletonList(xAxisData));
        map.put("yAxisData", Collections.singletonList(yAxisData));
        return ApiResponse.success(map);
    }

    @Override
    public ApiResponse<List<ProductComboboxVo>> getProductComboboxByCustomerId(String customerId) {
        ArrayList productList2 = new ArrayList();
        List<Long> ids = this.quotationDetailBpmMapper.getQuoteIdListByCustomerId(customerId);
        if (ids.isEmpty()) {
            return ApiResponse.success(productList2);
        }
        return ApiResponse.success(this.quotationDetailBpmMapper.getProductFormDetailByQuoteId(ids));
    }
}

