/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.transaction.quote.quotation.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.operaterecord.service.IOperateRecordAPIService;
import com.jxdinfo.crm.common.api.operaterecord.vo.OperateRecordAPIVo;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.common.api.util.CrmDateUtils;
import com.jxdinfo.crm.common.api.util.constant.common.CommonConstant;
import com.jxdinfo.crm.common.api.util.entity.DateConvertVo;
import com.jxdinfo.crm.core.index.dto.SalesStatisticsDto;
import com.jxdinfo.crm.core.index.util.IndexUtil;
import com.jxdinfo.crm.core.scene.dao.CrmSceneMapper;
import com.jxdinfo.crm.core.scene.model.CrmScene;
import com.jxdinfo.crm.core.teammeber.model.TeamMeberEntity;
import com.jxdinfo.crm.core.teammeber.service.TeamMeberService;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.crm.transaction.conf.CrmQuoteProperties;
import com.jxdinfo.crm.transaction.quote.pricelist.crmquotepricelist.dto.CrmQuotePriceListCrmquotepricelistdataset1;
import com.jxdinfo.crm.transaction.quote.pricelist.crmquotepricelist.model.CrmQuotePriceList;
import com.jxdinfo.crm.transaction.quote.pricelist.crmquotepricelist.service.CrmQuotePriceListService;
import com.jxdinfo.crm.transaction.quote.pricelist.crmquotepricelistdetail.model.CrmQuotePriceListDetail;
import com.jxdinfo.crm.transaction.quote.pricelist.quotepricelist.dto.QuotePriceListQuotepricelistdataset3;
import com.jxdinfo.crm.transaction.quote.pricelist.quotepricelist.dto.QuotePriceListSelectCondition;
import com.jxdinfo.crm.transaction.quote.pricelist.quotepricelist.model.QuotePriceList;
import com.jxdinfo.crm.transaction.quote.quotation.quotationdetailbpm.dto.QuotationDetailBpmQuotationdetailbpmdataset1;
import com.jxdinfo.crm.transaction.quote.quotation.quotationdetailbpm.dto.QuotationDetailBpmSelectCondition;
import com.jxdinfo.crm.transaction.quote.quotation.quotationdetailbpm.model.QuotationDetailBpm;
import com.jxdinfo.crm.transaction.quote.quotation.quotationdetailbpm.model.QuotationDetailBpmMaster;
import com.jxdinfo.crm.transaction.quote.quotation.util.QuoteConst;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.vo.TaskManagerQueryVo;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.engine.TaskEngineService;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Component;

@Component
public class QuoteUtil {
    @Resource
    private CrmSceneMapper crmSceneMapper;
    @Resource
    private RedisTemplate redisTemplate;
    @Resource
    private IOperateRecordAPIService operateRecordAPIService;
    @Resource
    private CrmQuotePriceListService priceListService;
    @Resource
    private TeamMeberService teamMeberService;
    @Resource
    private CrmCommonProperties crmProperties;
    @Resource
    private CrmQuoteProperties crmQuoteProperties;
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static final String SERIAL_NUMBER_KEY_PREFIX = "dateSerial:";

    public QuotePriceListSelectCondition dealPriceListQueryConditions(QuotePriceListSelectCondition condition) {
        String sceneTab;
        DateConvertVo dateConvertVo;
        SecurityUser user = BaseSecurityUtil.getUser();
        condition.setCurrentUserId(user.getUserId());
        if (ToolUtil.isNotEmpty((Object)condition.getValidStartDateRangeData()) && !"6".equals(condition.getValidStartDateRangeData()) && (dateConvertVo = CrmDateUtils.getCurrentTime((String)condition.getValidStartDateRangeData())) != null) {
            condition.setValidStartDateStart(LocalDate.parse(dateConvertVo.getStartDate()));
            condition.setValidStartDateEnd(LocalDate.parse(dateConvertVo.getEndDate()));
        }
        if (ToolUtil.isNotEmpty((Object)condition.getValidEndDateRangeData()) && !"6".equals(condition.getValidEndDateRangeData()) && (dateConvertVo = CrmDateUtils.getCurrentTime((String)condition.getValidEndDateRangeData())) != null) {
            condition.setValidEndDateStart(LocalDate.parse(dateConvertVo.getStartDate()));
            condition.setValidEndDateEnd(LocalDate.parse(dateConvertVo.getEndDate()));
        }
        if (ToolUtil.isNotEmpty((Object)condition.getCreateTimeRangeData()) && !"6".equals(condition.getCreateTimeRangeData()) && (dateConvertVo = CrmDateUtils.getCurrentTime((String)condition.getCreateTimeRangeData())) != null) {
            condition.setCreateTimeStart(LocalDate.parse(dateConvertVo.getStartDate()));
            condition.setCreateTimeEnd(LocalDate.parse(dateConvertVo.getEndDate()));
        }
        if (ToolUtil.isNotEmpty((Object)(sceneTab = condition.getSceneTab()))) {
            CrmScene crmScene;
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(CrmScene::getSceneId, (Object)sceneTab);
            lambdaQueryWrapper.eq(CrmScene::getModule, (Object)"pricelist");
            List crmSceneList = this.crmSceneMapper.selectList((Wrapper)lambdaQueryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)crmSceneList) && "0".equals((crmScene = (CrmScene)crmSceneList.get(0)).getIsSystem())) {
                try {
                    String query = crmScene.getQuery();
                    if (StringUtil.isNotBlank((CharSequence)query)) {
                        String queryValue = JSONObject.parseObject((String)query).get((Object)"queryValue").toString();
                        QuotePriceListSelectCondition queryDto = (QuotePriceListSelectCondition)JSONObject.parseObject((String)queryValue, QuotePriceListSelectCondition.class);
                        condition.setSceneCondition(this.dealPriceListQueryConditions(queryDto));
                    }
                }
                catch (Exception var12) {
                    throw new RuntimeException(var12);
                }
            }
        }
        return condition;
    }

    public QuotePriceListQuotepricelistdataset3 dealPriceListQueryConditions(QuotePriceListQuotepricelistdataset3 condition) {
        String sceneTab;
        DateConvertVo dateConvertVo;
        SecurityUser user = BaseSecurityUtil.getUser();
        condition.setCurrentUserId(user.getUserId());
        if (ToolUtil.isNotEmpty((Object)condition.getValidStartDateRangeData()) && !"6".equals(condition.getValidStartDateRangeData()) && (dateConvertVo = CrmDateUtils.getCurrentTime((String)condition.getValidStartDateRangeData())) != null) {
            condition.setValidStartDateStart(LocalDate.parse(dateConvertVo.getStartDate()));
            condition.setValidStartDateEnd(LocalDate.parse(dateConvertVo.getEndDate()));
        }
        if (ToolUtil.isNotEmpty((Object)condition.getValidEndDateRangeData()) && !"6".equals(condition.getValidEndDateRangeData()) && (dateConvertVo = CrmDateUtils.getCurrentTime((String)condition.getValidEndDateRangeData())) != null) {
            condition.setValidEndDateStart(LocalDate.parse(dateConvertVo.getStartDate()));
            condition.setValidEndDateEnd(LocalDate.parse(dateConvertVo.getEndDate()));
        }
        if (ToolUtil.isNotEmpty((Object)condition.getCreateTimeRangeData()) && !"6".equals(condition.getCreateTimeRangeData()) && (dateConvertVo = CrmDateUtils.getCurrentTime((String)condition.getCreateTimeRangeData())) != null) {
            condition.setCreateTimeStart(LocalDate.parse(dateConvertVo.getStartDate()));
            condition.setCreateTimeEnd(LocalDate.parse(dateConvertVo.getEndDate()));
        }
        if (ToolUtil.isNotEmpty((Object)(sceneTab = condition.getSceneTab()))) {
            CrmScene crmScene;
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(CrmScene::getSceneId, (Object)sceneTab);
            lambdaQueryWrapper.eq(CrmScene::getModule, (Object)"pricelist");
            List crmSceneList = this.crmSceneMapper.selectList((Wrapper)lambdaQueryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)crmSceneList) && "0".equals((crmScene = (CrmScene)crmSceneList.get(0)).getIsSystem())) {
                try {
                    String query = crmScene.getQuery();
                    if (StringUtil.isNotBlank((CharSequence)query)) {
                        String queryValue = JSONObject.parseObject((String)query).get((Object)"queryValue").toString();
                        QuotePriceListQuotepricelistdataset3 queryDto = (QuotePriceListQuotepricelistdataset3)JSONObject.parseObject((String)queryValue, QuotePriceListQuotepricelistdataset3.class);
                        condition.setSceneCondition(this.dealPriceListQueryConditions(queryDto));
                    }
                }
                catch (Exception var12) {
                    throw new RuntimeException(var12);
                }
            }
        }
        condition.setPermissionDto(this.priceListOperate(condition));
        return condition;
    }

    private SalesStatisticsDto priceListOperate(QuotePriceListQuotepricelistdataset3 dto) {
        SalesStatisticsDto permissionDto = new SalesStatisticsDto();
        String sceneTab = dto.getSceneTab();
        if (StringUtil.isNotEmpty((Object)sceneTab) && !"0".equals(sceneTab) && !"1".equals(sceneTab)) {
            IndexUtil.currentUserRolePermissions((SalesStatisticsDto)permissionDto, (CrmCommonProperties)this.crmProperties);
            SecurityUser user = BaseSecurityUtil.getUser();
            if (user == null || ToolUtil.isEmpty((Object)user.getUserId())) {
                throw new HussarException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5f02\u5e38");
            }
            if (user.getRolesList().contains(Long.valueOf(this.crmQuoteProperties.getRoles().getAllQuote()))) {
                permissionDto.setPermissionDeptIds((List)null);
                permissionDto.setPermissionUserId((Long)null);
            }
        }
        return permissionDto;
    }

    public SalesStatisticsDto priceListOperate(CrmQuotePriceListCrmquotepricelistdataset1 dto) {
        SalesStatisticsDto permissionDto = new SalesStatisticsDto();
        IndexUtil.currentUserRolePermissions((SalesStatisticsDto)permissionDto, (CrmCommonProperties)this.crmProperties);
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user == null || ToolUtil.isEmpty((Object)user.getUserId())) {
            throw new HussarException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5f02\u5e38");
        }
        if (user.getRolesList().contains(Long.valueOf(this.crmQuoteProperties.getRoles().getAllQuote()))) {
            permissionDto.setPermissionDeptIds((List)null);
            permissionDto.setPermissionUserId((Long)null);
        }
        return permissionDto;
    }

    public QuotationDetailBpmSelectCondition dealQuotationQueryConditions(QuotationDetailBpmSelectCondition condition) {
        String sceneTab;
        List result;
        DateConvertVo dateConvertVo;
        SecurityUser user = BaseSecurityUtil.getUser();
        condition.setCurrentUserId(user.getUserId());
        if (ToolUtil.isNotEmpty((Object)condition.getQuoteDateRangeData()) && !"6".equals(condition.getQuoteDateRangeData()) && (dateConvertVo = CrmDateUtils.getCurrentTime((String)condition.getQuoteDateRangeData())) != null) {
            condition.setQuoteDateStart(LocalDate.parse(dateConvertVo.getStartDate()));
            condition.setQuoteDateEnd(LocalDate.parse(dateConvertVo.getEndDate()));
        }
        if (ToolUtil.isNotEmpty((Object)condition.getCreateTimeRangeData()) && !"6".equals(condition.getCreateTimeRangeData()) && (dateConvertVo = CrmDateUtils.getCurrentTime((String)condition.getCreateTimeRangeData())) != null) {
            condition.setCreateTimeStart(LocalDate.parse(dateConvertVo.getStartDate()));
            condition.setCreateTimeEnd(LocalDate.parse(dateConvertVo.getEndDate()));
        }
        if ("3".equals(condition.getSceneTab())) {
            BpmResponseResult toDoResult = TaskEngineService.queryToDoProcessTaskList((String)String.valueOf(BaseSecurityUtil.getUser().getId()), null, null);
            List<String> toDoIds = new ArrayList<String>();
            if (toDoResult.isSuccess() && !CollectionUtils.isEmpty((Collection)(result = (List)toDoResult.getResult().getJSONObject(0).get((Object)"data")))) {
                toDoIds = result.stream().map(item -> item.getBusinessId()).distinct().collect(Collectors.toList());
            }
            condition.setBpmIds(toDoIds);
        }
        if ("4".equals(condition.getSceneTab())) {
            BpmResponseResult finishedResult = TaskEngineService.queryFinishedProcessTaskList((String)String.valueOf(BaseSecurityUtil.getUser().getId()), null, null);
            ArrayList<String> finishedIds = new ArrayList<String>();
            if (finishedResult.isSuccess() && !CollectionUtils.isEmpty((Collection)(result = (List)finishedResult.getResult().getJSONObject(0).get((Object)"data")))) {
                for (TaskManagerQueryVo item2 : result) {
                    if ("\u7533\u8bf7".equals(item2.getTaskDefinitionName())) continue;
                    finishedIds.add(item2.getBusinessId());
                }
            }
            condition.setBpmIds(finishedIds);
        }
        if (ToolUtil.isNotEmpty((Object)(sceneTab = condition.getSceneTab()))) {
            CrmScene crmScene;
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(CrmScene::getSceneId, (Object)sceneTab);
            lambdaQueryWrapper.eq(CrmScene::getModule, (Object)"quotation");
            List crmSceneList = this.crmSceneMapper.selectList((Wrapper)lambdaQueryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)crmSceneList) && "0".equals((crmScene = (CrmScene)crmSceneList.get(0)).getIsSystem())) {
                try {
                    String query = crmScene.getQuery();
                    if (StringUtil.isNotBlank((CharSequence)query)) {
                        String queryValue = JSONObject.parseObject((String)query).get((Object)"queryValue").toString();
                        QuotationDetailBpmSelectCondition queryDto = (QuotationDetailBpmSelectCondition)JSONObject.parseObject((String)queryValue, QuotationDetailBpmSelectCondition.class);
                        condition.setSceneCondition(this.dealQuotationQueryConditions(queryDto));
                    }
                }
                catch (Exception var12) {
                    throw new RuntimeException(var12);
                }
            }
        }
        return condition;
    }

    public QuotationDetailBpmQuotationdetailbpmdataset1 dealQuotationQueryConditions(QuotationDetailBpmQuotationdetailbpmdataset1 condition) {
        String sceneTab;
        List result;
        DateConvertVo dateConvertVo;
        SecurityUser user = BaseSecurityUtil.getUser();
        condition.setCurrentUserId(user.getUserId());
        if (ToolUtil.isNotEmpty((Object)condition.getQuoteDateRangeData()) && !"6".equals(condition.getQuoteDateRangeData()) && (dateConvertVo = CrmDateUtils.getCurrentTime((String)condition.getQuoteDateRangeData())) != null) {
            condition.setQuoteDateStart(LocalDate.parse(dateConvertVo.getStartDate()));
            condition.setQuoteDateEnd(LocalDate.parse(dateConvertVo.getEndDate()));
        }
        if (ToolUtil.isNotEmpty((Object)condition.getCreateTimeRangeData()) && !"6".equals(condition.getCreateTimeRangeData()) && (dateConvertVo = CrmDateUtils.getCurrentTime((String)condition.getCreateTimeRangeData())) != null) {
            condition.setCreateTimeStart(LocalDate.parse(dateConvertVo.getStartDate()));
            condition.setCreateTimeEnd(LocalDate.parse(dateConvertVo.getEndDate()));
        }
        if ("3".equals(condition.getSceneTab())) {
            BpmResponseResult toDoResult = TaskEngineService.queryToDoProcessTaskList((String)String.valueOf(BaseSecurityUtil.getUser().getId()), null, null, null, (Integer)10000);
            List<String> toDoIds = new ArrayList<String>();
            if (toDoResult.isSuccess() && !CollectionUtils.isEmpty((Collection)(result = (List)toDoResult.getResult().getJSONObject(0).get((Object)"data")))) {
                toDoIds = result.stream().map(item -> item.getBusinessId()).distinct().collect(Collectors.toList());
            }
            condition.setBpmIds(toDoIds);
        }
        if ("4".equals(condition.getSceneTab())) {
            BpmResponseResult finishedResult = TaskEngineService.queryFinishedProcessTaskList((String)String.valueOf(BaseSecurityUtil.getUser().getId()), null, null, null, (Integer)10000);
            ArrayList<String> finishedIds = new ArrayList<String>();
            if (finishedResult.isSuccess() && !CollectionUtils.isEmpty((Collection)(result = (List)finishedResult.getResult().getJSONObject(0).get((Object)"data")))) {
                for (TaskManagerQueryVo item2 : result) {
                    if ("\u7533\u8bf7".equals(item2.getTaskDefinitionName())) continue;
                    finishedIds.add(item2.getBusinessId());
                }
            }
            condition.setBpmIds(finishedIds);
        }
        if (ToolUtil.isNotEmpty((Object)(sceneTab = condition.getSceneTab()))) {
            CrmScene crmScene;
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(CrmScene::getSceneId, (Object)sceneTab);
            lambdaQueryWrapper.eq(CrmScene::getModule, (Object)"quotation");
            List crmSceneList = this.crmSceneMapper.selectList((Wrapper)lambdaQueryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)crmSceneList) && "0".equals((crmScene = (CrmScene)crmSceneList.get(0)).getIsSystem())) {
                try {
                    String query = crmScene.getQuery();
                    if (StringUtil.isNotBlank((CharSequence)query)) {
                        String queryValue = JSONObject.parseObject((String)query).get((Object)"queryValue").toString();
                        QuotationDetailBpmQuotationdetailbpmdataset1 queryDto = (QuotationDetailBpmQuotationdetailbpmdataset1)JSONObject.parseObject((String)queryValue, QuotationDetailBpmQuotationdetailbpmdataset1.class);
                        condition.setSceneCondition(this.dealQuotationQueryConditions(queryDto));
                    }
                }
                catch (Exception var12) {
                    throw new RuntimeException(var12);
                }
            }
        }
        condition.setPermissionDto(this.quotationOperate(condition));
        return condition;
    }

    private SalesStatisticsDto quotationOperate(QuotationDetailBpmQuotationdetailbpmdataset1 dto) {
        SalesStatisticsDto permissionDto = new SalesStatisticsDto();
        String sceneTab = dto.getSceneTab();
        if (!(!StringUtil.isNotEmpty((Object)sceneTab) || "0".equals(sceneTab) || "1".equals(sceneTab) || "3".equals(sceneTab) || "4".equals(sceneTab))) {
            IndexUtil.currentUserRolePermissions((SalesStatisticsDto)permissionDto, (CrmCommonProperties)this.crmProperties);
            SecurityUser user = BaseSecurityUtil.getUser();
            if (user == null || ToolUtil.isEmpty((Object)user.getUserId())) {
                throw new HussarException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5f02\u5e38");
            }
            if (user.getRolesList().contains(Long.valueOf(this.crmQuoteProperties.getRoles().getAllQuote()))) {
                permissionDto.setPermissionDeptIds((List)null);
                permissionDto.setPermissionUserId((Long)null);
            }
        }
        return permissionDto;
    }

    public List<QuotePriceList> dealPriceListResult(List<QuotePriceList> result) {
        SecurityUser user = BaseSecurityUtil.getUser();
        block0: for (QuotePriceList entity : result) {
            if ("1".equals(entity.getIsStandard())) {
                entity.setCanEdit(CommonConstant.noPermission);
                continue;
            }
            if (user.getUserId().longValue() == entity.getPrincipalId().longValue()) {
                entity.setCanEdit(CommonConstant.salesman);
                continue;
            }
            List teamList = this.teamMeberService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TeamMeberEntity::getBusinessId, (Object)entity.getPriceListId())).eq(TeamMeberEntity::getDelFlag, (Object)"0")).eq(TeamMeberEntity::getPersonId, (Object)user.getUserId())).eq(TeamMeberEntity::getBusinessType, (Object)"19"));
            if (CollectionUtil.isNotEmpty((Collection)teamList)) {
                entity.setCanEdit(CommonConstant.readOnly);
                for (TeamMeberEntity item : teamList) {
                    if (!"1".equals(item.getModifyPower())) continue;
                    entity.setCanEdit(CommonConstant.otherRole);
                    continue block0;
                }
                continue;
            }
            entity.setCanEdit(CommonConstant.noPermission);
        }
        return result;
    }

    public List<QuotationDetailBpm> dealQuotationQueryResult(List<QuotationDetailBpm> result) {
        SecurityUser user = BaseSecurityUtil.getUser();
        block0: for (QuotationDetailBpm entity : result) {
            if ("2".equals(entity.getFlowStatus()) || "4".equals(entity.getFlowStatus())) {
                entity.setCanEdit(CommonConstant.noPermission);
                continue;
            }
            if (user.getUserId().longValue() == entity.getPrincipalId().longValue()) {
                entity.setCanEdit(CommonConstant.salesman);
                continue;
            }
            List teamList = this.teamMeberService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TeamMeberEntity::getBusinessId, (Object)entity.getQuoteId())).eq(TeamMeberEntity::getDelFlag, (Object)"0")).eq(TeamMeberEntity::getPersonId, (Object)user.getUserId())).eq(TeamMeberEntity::getBusinessType, (Object)"20"));
            if (CollectionUtil.isNotEmpty((Collection)teamList)) {
                entity.setCanEdit(CommonConstant.readOnly);
                for (TeamMeberEntity item : teamList) {
                    if (!"1".equals(item.getModifyPower())) continue;
                    entity.setCanEdit(CommonConstant.otherRole);
                    continue block0;
                }
                continue;
            }
            entity.setCanEdit(CommonConstant.noPermission);
        }
        return result;
    }

    public String createQuoteNo(int times) {
        LocalDate currentDate = LocalDate.now();
        String key = SERIAL_NUMBER_KEY_PREFIX + currentDate.format(formatter);
        ValueOperations valueOps = this.redisTemplate.opsForValue();
        Long serialNumber = valueOps.increment((Object)key, 1L);
        if (serialNumber == 0L) {
            valueOps.set((Object)key, (Object)1L);
            serialNumber = 1L;
        }
        String formattedSerialNumber = String.format("%04d", serialNumber);
        return "BJ-" + currentDate.format(formatter) + "-" + formattedSerialNumber;
    }

    public void saveQuoteEditTrackRecord(QuotationDetailBpmMaster oldQuotation, QuotationDetailBpmMaster newQuotation) {
        String newRemark;
        String oldRemark;
        Long newPriceList;
        Long oldPriceList;
        BigDecimal newQuoteTotalPrice;
        BigDecimal oldQuoteTotalPrice;
        BigDecimal newQuoteDiscount;
        BigDecimal oldQuoteDiscount;
        Long newOpportunity;
        Long oldOpportunity;
        Long newCustomer;
        Long oldCustomer;
        String newQuoteName;
        boolean changeFlag = false;
        LocalDateTime date = LocalDateTime.now();
        ArrayList<Map<String, Object>> changeField = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> before = new HashMap<String, Object>();
        HashMap<String, Object> after = new HashMap<String, Object>();
        DecimalFormat decimalFormat = new DecimalFormat("#,##0.00");
        String oldQuoteName = oldQuotation.getQuoteName();
        if (this.isFieldChange(oldQuoteName, newQuoteName = newQuotation.getQuoteName())) {
            HashMap<String, String> field = new HashMap<String, String>();
            field.put("field", QuoteConst.QuotationEditConstant.QUOTE_NAME.getField());
            field.put("fieldName", QuoteConst.QuotationEditConstant.QUOTE_NAME.getName());
            changeField.add(field);
            before.put(QuoteConst.QuotationEditConstant.QUOTE_NAME.getField(), oldQuoteName);
            after.put(QuoteConst.QuotationEditConstant.QUOTE_NAME.getField(), newQuoteName);
            changeFlag = true;
        }
        if (this.isFieldChange(oldCustomer = oldQuotation.getCustomerId(), newCustomer = newQuotation.getCustomerId())) {
            HashMap<String, String> field = new HashMap<String, String>();
            field.put("field", QuoteConst.QuotationEditConstant.CUSTOMER_NAME.getField());
            field.put("fieldName", QuoteConst.QuotationEditConstant.CUSTOMER_NAME.getName());
            changeField.add(field);
            before.put(QuoteConst.QuotationEditConstant.CUSTOMER_NAME.getField(), oldQuotation.getCustomerName());
            after.put(QuoteConst.QuotationEditConstant.CUSTOMER_NAME.getField(), newQuotation.getCustomerName());
            changeFlag = true;
        }
        if (this.isFieldChange(oldOpportunity = oldQuotation.getOpportunityId(), newOpportunity = newQuotation.getOpportunityId())) {
            HashMap<String, String> field = new HashMap<String, String>();
            field.put("field", QuoteConst.QuotationEditConstant.OPPORTUNITY_NAME.getField());
            field.put("fieldName", QuoteConst.QuotationEditConstant.OPPORTUNITY_NAME.getName());
            changeField.add(field);
            before.put(QuoteConst.QuotationEditConstant.OPPORTUNITY_NAME.getField(), oldQuotation.getOpportunityName());
            after.put(QuoteConst.QuotationEditConstant.OPPORTUNITY_NAME.getField(), newQuotation.getOpportunityName());
            changeFlag = true;
        }
        LocalDateTime oldQuoteDate = oldQuotation.getQuoteDate();
        LocalDateTime newQuoteDate = newQuotation.getQuoteDate();
        String oldQuoteDateStr = "";
        String newQuoteDateStr = "";
        if (ToolUtil.isNotEmpty((Object)oldQuoteDate)) {
            oldQuoteDateStr = String.valueOf(oldQuoteDate).substring(0, 10);
        }
        if (ToolUtil.isNotEmpty((Object)newQuoteDate)) {
            newQuoteDateStr = String.valueOf(newQuoteDate).substring(0, 10);
        }
        if (this.isFieldChange(oldQuoteDateStr, newQuoteDateStr)) {
            HashMap<String, String> field = new HashMap<String, String>();
            field.put("field", QuoteConst.QuotationEditConstant.QUOTE_DATE.getField());
            field.put("fieldName", QuoteConst.QuotationEditConstant.QUOTE_DATE.getName());
            changeField.add(field);
            before.put(QuoteConst.QuotationEditConstant.QUOTE_DATE.getField(), oldQuoteDateStr);
            after.put(QuoteConst.QuotationEditConstant.QUOTE_DATE.getField(), newQuoteDateStr);
            changeFlag = true;
        }
        if (this.isFieldChange(oldQuoteDiscount = oldQuotation.getQuoteDiscount(), newQuoteDiscount = newQuotation.getQuoteDiscount())) {
            HashMap<String, String> field = new HashMap<String, String>();
            field.put("field", QuoteConst.QuotationEditConstant.QUOTE_DISCOUNT.getField());
            field.put("fieldName", QuoteConst.QuotationEditConstant.QUOTE_DISCOUNT.getName());
            changeField.add(field);
            oldQuoteDiscount = oldQuoteDiscount == null ? new BigDecimal("0.0") : oldQuoteDiscount;
            newQuoteDiscount = newQuoteDiscount == null ? new BigDecimal("0.0") : newQuoteDiscount;
            String oldQuoteDiscountStr = decimalFormat.format(oldQuoteDiscount);
            String newQuoteDiscountStr = decimalFormat.format(newQuoteDiscount);
            before.put(QuoteConst.QuotationEditConstant.QUOTE_DISCOUNT.getField(), oldQuoteDiscountStr);
            after.put(QuoteConst.QuotationEditConstant.QUOTE_DISCOUNT.getField(), newQuoteDiscountStr);
            changeFlag = true;
        }
        if (this.isFieldChange(oldQuoteTotalPrice = oldQuotation.getQuoteTotalPrice(), newQuoteTotalPrice = oldQuotation.getQuoteTotalPrice())) {
            HashMap<String, String> field = new HashMap<String, String>();
            field.put("field", QuoteConst.QuotationEditConstant.QUOTE_TOTAL_PRICE.getField());
            field.put("fieldName", QuoteConst.QuotationEditConstant.QUOTE_TOTAL_PRICE.getName());
            changeField.add(field);
            oldQuoteTotalPrice = oldQuoteTotalPrice == null ? new BigDecimal("0.0") : oldQuoteTotalPrice;
            newQuoteTotalPrice = newQuoteTotalPrice == null ? new BigDecimal("0.0") : newQuoteTotalPrice;
            String oldQuoteTotalPriceStr = decimalFormat.format(oldQuoteTotalPrice);
            String newQuoteTotalPriceStr = decimalFormat.format(newQuoteTotalPrice);
            before.put(QuoteConst.QuotationEditConstant.QUOTE_TOTAL_PRICE.getField(), oldQuoteTotalPriceStr);
            after.put(QuoteConst.QuotationEditConstant.QUOTE_TOTAL_PRICE.getField(), newQuoteTotalPriceStr);
            changeFlag = true;
        }
        if (this.isFieldChange(oldPriceList = oldQuotation.getPriceListId(), newPriceList = newQuotation.getPriceListId())) {
            CrmQuotePriceList newById;
            CrmQuotePriceList oldById;
            HashMap<String, String> field = new HashMap<String, String>();
            field.put("field", QuoteConst.QuotationEditConstant.PRICE_LIST_ID.getField());
            field.put("fieldName", QuoteConst.QuotationEditConstant.PRICE_LIST_ID.getName());
            changeField.add(field);
            String oldPriceListName = null;
            if (oldPriceList != null && BeanUtil.isNotEmpty((Object)(oldById = (CrmQuotePriceList)this.priceListService.getById(oldPriceList)), (String[])new String[0])) {
                oldPriceListName = oldById.getPriceListName();
            }
            String newPriceListName = null;
            if (newPriceList != null && BeanUtil.isNotEmpty((Object)(newById = (CrmQuotePriceList)this.priceListService.getById(newPriceList)), (String[])new String[0])) {
                newPriceListName = newById.getPriceListName();
            }
            before.put(QuoteConst.QuotationEditConstant.PRICE_LIST_ID.getField(), oldPriceListName);
            after.put(QuoteConst.QuotationEditConstant.PRICE_LIST_ID.getField(), newPriceListName);
            changeFlag = true;
        }
        if (this.isFieldChange(oldRemark = oldQuotation.getRemark(), newRemark = newQuotation.getRemark())) {
            HashMap<String, String> field = new HashMap<String, String>();
            field.put("field", QuoteConst.QuotationEditConstant.REMARK.getField());
            field.put("fieldName", QuoteConst.QuotationEditConstant.REMARK.getName());
            changeField.add(field);
            before.put(QuoteConst.QuotationEditConstant.REMARK.getField(), oldRemark);
            after.put(QuoteConst.QuotationEditConstant.REMARK.getField(), newRemark);
            changeFlag = true;
        }
        if (changeFlag) {
            OperateRecordAPIVo record = this.initTrackRecord(RecordProductTypeEnum.PRODUCE_CHANGE.getId(), before, after, changeField);
            record.setChangeBatch(Integer.parseInt("1"));
            this.operateRecordAPIService.saveOperateLog(record, CrmBusinessTypeEnum.QUOTATION, newQuotation.getQuoteId(), newQuotation.getQuoteName(), date, false, Arrays.asList(newQuotation.getQuoteId()));
        }
    }

    public OperateRecordAPIVo savePriceDetailListEditTrackRecord(CrmQuotePriceListDetail old, CrmQuotePriceListDetail newEntity, String priceListName) {
        BigDecimal newPrice;
        BigDecimal oldPrice;
        BigDecimal newDiscount;
        OperateRecordAPIVo record = null;
        boolean changeFlag = false;
        LocalDateTime date = LocalDateTime.now();
        ArrayList<Map<String, Object>> changeField = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> before = new HashMap<String, Object>();
        HashMap<String, Object> after = new HashMap<String, Object>();
        DecimalFormat decimalFormat = new DecimalFormat("#,##0.00");
        SecurityUser user = BaseSecurityUtil.getUser();
        BigDecimal oldDiscount = old.getDiscount();
        if (this.isFieldChange(oldDiscount, newDiscount = newEntity.getDiscount())) {
            HashMap<String, String> field = new HashMap<String, String>();
            field.put("field", QuoteConst.PriceListEditConstant.PRICE_LIST_DETAIL_DISCOUNT.getField());
            field.put("fieldName", QuoteConst.PriceListEditConstant.PRICE_LIST_DETAIL_DISCOUNT.getName());
            changeField.add(field);
            oldDiscount = oldDiscount == null ? new BigDecimal("0.0") : oldDiscount;
            newDiscount = newDiscount == null ? new BigDecimal("0.0") : newDiscount;
            String oldDiscountStr = decimalFormat.format(oldDiscount);
            String newDiscountStr = decimalFormat.format(newDiscount);
            before.put(QuoteConst.PriceListEditConstant.PRICE_LIST_DETAIL_DISCOUNT.getField(), oldDiscountStr);
            after.put(QuoteConst.PriceListEditConstant.PRICE_LIST_DETAIL_DISCOUNT.getField(), newDiscountStr);
            changeFlag = true;
        }
        if (this.isFieldChange(oldPrice = old.getListPrice(), newPrice = newEntity.getListPrice())) {
            HashMap<String, String> field = new HashMap<String, String>();
            field.put("field", QuoteConst.PriceListEditConstant.PRICE_LIST_DETAIL_PRICE.getField());
            field.put("fieldName", QuoteConst.PriceListEditConstant.PRICE_LIST_DETAIL_PRICE.getName());
            changeField.add(field);
            oldPrice = oldPrice == null ? new BigDecimal("0.0") : oldPrice;
            newPrice = newPrice == null ? new BigDecimal("0.0") : newPrice;
            String oldPriceStr = decimalFormat.format(oldPrice);
            String newPriceStr = decimalFormat.format(newPrice);
            before.put(QuoteConst.PriceListEditConstant.PRICE_LIST_DETAIL_PRICE.getField(), oldPriceStr);
            after.put(QuoteConst.PriceListEditConstant.PRICE_LIST_DETAIL_PRICE.getField(), newPriceStr);
            changeFlag = true;
        }
        if (changeFlag) {
            record = this.initTrackRecord(RecordProductTypeEnum.PRODUCE_PRICE_LIST_MODIFY_PRODUCT.getId(), before, after, changeField);
            record.setChangeBatch(Integer.parseInt("1"));
            record.setRecordId(Long.valueOf(CommonUtills.generateAssignId()));
            record.setBusinessType("19");
            record.setTypeId(newEntity.getPriceListId());
            record.setBusinessName(priceListName);
            record.setContactName(newEntity.getProductName());
            record.setCreatePerson(user.getUserId());
            record.setCreatePersonName(user.getUserName());
            record.setCreateTime(date);
            record.setChangePerson(user.getUserId());
            record.setChangeTime(date);
            record.setChangePersonName(user.getUserName());
            record.setDelflag("0");
        }
        return record;
    }

    public void savePriceListEditTrackRecord(QuotePriceList old, QuotePriceList newEntity) {
        String newRemark;
        String oldRemark;
        String newPriceListName;
        boolean changeFlag = false;
        LocalDateTime date = LocalDateTime.now();
        ArrayList<Map<String, Object>> changeField = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> before = new HashMap<String, Object>();
        HashMap<String, Object> after = new HashMap<String, Object>();
        String oldPriceListName = old.getPriceListName();
        if (this.isFieldChange(oldPriceListName, newPriceListName = newEntity.getPriceListName())) {
            HashMap<String, String> field = new HashMap<String, String>();
            field.put("field", QuoteConst.PriceListEditConstant.PRICE_LIST_NAME.getField());
            field.put("fieldName", QuoteConst.PriceListEditConstant.PRICE_LIST_NAME.getName());
            changeField.add(field);
            before.put(QuoteConst.PriceListEditConstant.PRICE_LIST_NAME.getField(), oldPriceListName);
            after.put(QuoteConst.PriceListEditConstant.PRICE_LIST_NAME.getField(), newPriceListName);
            changeFlag = true;
        }
        LocalDateTime oldStartDate = old.getStartDate();
        LocalDateTime newStartDate = newEntity.getStartDate();
        String oldStartDateStr = "";
        String newStartDateStr = "";
        if (ToolUtil.isNotEmpty((Object)oldStartDate)) {
            oldStartDateStr = String.valueOf(oldStartDate).substring(0, 10);
        }
        if (ToolUtil.isNotEmpty((Object)newStartDate)) {
            newStartDateStr = String.valueOf(newStartDate).substring(0, 10);
        }
        if (this.isFieldChange(oldStartDateStr, newStartDateStr)) {
            HashMap<String, String> field = new HashMap<String, String>();
            field.put("field", QuoteConst.PriceListEditConstant.START_DATE.getField());
            field.put("fieldName", QuoteConst.PriceListEditConstant.START_DATE.getName());
            changeField.add(field);
            before.put(QuoteConst.PriceListEditConstant.START_DATE.getField(), oldStartDateStr);
            after.put(QuoteConst.PriceListEditConstant.START_DATE.getField(), newStartDateStr);
            changeFlag = true;
        }
        LocalDateTime oldEndDate = old.getEndDate();
        LocalDateTime newEndDate = newEntity.getEndDate();
        String oldEndDateStr = "";
        String newEndDateStr = "";
        if (ToolUtil.isNotEmpty((Object)oldEndDate)) {
            oldEndDateStr = String.valueOf(oldEndDate).substring(0, 10);
        }
        if (ToolUtil.isNotEmpty((Object)newEndDate)) {
            newEndDateStr = String.valueOf(newEndDate).substring(0, 10);
        }
        if (this.isFieldChange(oldEndDateStr, newEndDateStr)) {
            HashMap<String, String> field = new HashMap<String, String>();
            field.put("field", QuoteConst.PriceListEditConstant.END_DATE.getField());
            field.put("fieldName", QuoteConst.PriceListEditConstant.END_DATE.getName());
            changeField.add(field);
            before.put(QuoteConst.PriceListEditConstant.END_DATE.getField(), oldEndDateStr);
            after.put(QuoteConst.PriceListEditConstant.END_DATE.getField(), newEndDateStr);
            changeFlag = true;
        }
        if (this.isFieldChange(oldRemark = old.getRemark(), newRemark = newEntity.getRemark())) {
            HashMap<String, String> field = new HashMap<String, String>();
            field.put("field", QuoteConst.PriceListEditConstant.REMARK.getField());
            field.put("fieldName", QuoteConst.PriceListEditConstant.REMARK.getName());
            changeField.add(field);
            before.put(QuoteConst.PriceListEditConstant.REMARK.getField(), oldRemark);
            after.put(QuoteConst.PriceListEditConstant.REMARK.getField(), newRemark);
            changeFlag = true;
        }
        if (changeFlag) {
            OperateRecordAPIVo record = this.initTrackRecord(RecordProductTypeEnum.PRODUCE_CHANGE.getId(), before, after, changeField);
            record.setChangeBatch(Integer.parseInt("1"));
            this.operateRecordAPIService.saveOperateLog(record, CrmBusinessTypeEnum.PRICE_LIST, newEntity.getPriceListId(), newEntity.getPriceListName(), date, false, Arrays.asList(newEntity.getPriceListId()));
        }
    }

    private boolean isFieldChange(Object oldField, Object newField) {
        return !(ToolUtil.isEmpty((Object)oldField) && ToolUtil.isEmpty((Object)newField) || !ToolUtil.isEmpty((Object)oldField) && oldField.equals(newField));
    }

    private OperateRecordAPIVo initTrackRecord(String produceType, Map<String, Object> changeBefore, Map<String, Object> changeAfter, List<Map<String, Object>> changeField) {
        String oldJson = JSON.toJSONString(changeBefore);
        String newJson = JSON.toJSONString(changeAfter);
        String changeFieldStr = JSON.toJSONString(changeField);
        OperateRecordAPIVo record = new OperateRecordAPIVo();
        record.setProduceType(produceType);
        record.setChangeBefore(oldJson);
        record.setChangeAfter(newJson);
        record.setChangeField(changeFieldStr);
        return record;
    }
}

