/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.transaction.quote.pricelist.quotepricelist.service.impl;

import com.jxdinfo.crm.core.associativeQuery.dto.AssociativeQueryDto;
import com.jxdinfo.crm.core.associativeQuery.queryEnum.AssociativeQueryEnum;
import com.jxdinfo.crm.core.associativeQuery.service.AssociativeFiledQueryService;
import com.jxdinfo.crm.core.common.vo.AssociativeQueryVo;
import com.jxdinfo.crm.transaction.quote.pricelist.quotepricelist.dto.PriceListAssociativeQueryDto;
import com.jxdinfo.crm.transaction.quote.pricelist.quotepricelist.dto.PriceListHighSearchDto;
import com.jxdinfo.crm.transaction.quote.pricelist.quotepricelist.service.PriceListAssociativeQueryService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class PriceListAssociativeQueryServiceImpl
implements PriceListAssociativeQueryService {
    @Resource
    private AssociativeFiledQueryService associativeFiledQueryService;

    public List<AssociativeQueryVo> getAssociativeQueryVo(String keyword, AssociativeQueryDto associativeQueryDto, Map<String, List<String>> excludeInfoMap) {
        ArrayList<AssociativeQueryVo> associativeQueryVoList = new ArrayList<AssociativeQueryVo>();
        PriceListAssociativeQueryDto priceListAssociativeQueryDto = null;
        if (associativeQueryDto instanceof PriceListAssociativeQueryDto) {
            priceListAssociativeQueryDto = (PriceListAssociativeQueryDto)associativeQueryDto;
        }
        assert (priceListAssociativeQueryDto != null);
        PriceListHighSearchDto searchDto = priceListAssociativeQueryDto.getDto();
        List<String> ownDepartmentList = null;
        List<String> principalIds = null;
        List<String> teamMemberIds = null;
        List<String> creator = null;
        String validStartDateRangeData = null;
        String validEndDateRangeData = null;
        String createTimeRangeData = null;
        List<String> enableStateData = null;
        List<String> isLockData = null;
        List<String> isStandardData = null;
        if (searchDto != null) {
            ownDepartmentList = searchDto.getOwnDepartment();
            principalIds = searchDto.getPrincipal();
            teamMemberIds = searchDto.getTeamMember();
            creator = searchDto.getCreator();
            validStartDateRangeData = searchDto.getValidStartDateRangeData();
            validEndDateRangeData = searchDto.getValidEndDateRangeData();
            createTimeRangeData = searchDto.getCreateTimeRangeData();
            enableStateData = Arrays.asList(searchDto.getEnableState());
            isLockData = Arrays.asList(searchDto.getIsLock());
            isStandardData = Arrays.asList(searchDto.getIsStandard());
        }
        List selectedOwnDepartments = excludeInfoMap.get("selectedOwnDepartments");
        selectedOwnDepartments = this.associativeFiledQueryService.getOwnDepartmentAssociativeQuery(associativeQueryVoList, keyword, selectedOwnDepartments, ownDepartmentList, AssociativeQueryEnum.QUOTE_OWN_DEPARTMENT);
        excludeInfoMap.put("selectedOwnDepartments", selectedOwnDepartments);
        List selectedChargePersonIds = excludeInfoMap.get("selectedChargePersonIds");
        selectedChargePersonIds = this.associativeFiledQueryService.getChargePersonAssociativeQuery(associativeQueryVoList, keyword, selectedChargePersonIds, principalIds, AssociativeQueryEnum.QUOTE_PRINCIPAL);
        excludeInfoMap.put("selectedChargePersonIds", selectedChargePersonIds);
        List selectedTeamMemberIds = excludeInfoMap.get("selectedTeamMemberIds");
        selectedTeamMemberIds = this.associativeFiledQueryService.getTeamMemberIdAssociativeQuery(associativeQueryVoList, keyword, selectedTeamMemberIds, teamMemberIds);
        excludeInfoMap.put("selectedTeamMemberIds", selectedTeamMemberIds);
        List selectedCreator = excludeInfoMap.get("selectedCreator");
        selectedCreator = this.associativeFiledQueryService.getCreatePersonIdAssociativeQuery(associativeQueryVoList, keyword, selectedCreator, creator, AssociativeQueryEnum.QUOTE_CREATOR);
        excludeInfoMap.put("selectedCreator", selectedCreator);
        List selectedValidStartDate = excludeInfoMap.get("selectedValidStartDate");
        selectedValidStartDate = this.associativeFiledQueryService.getTimeTageAssociativeQuery(associativeQueryVoList, keyword, selectedValidStartDate, validStartDateRangeData, AssociativeQueryEnum.PRICE_LIST_VALID_STATE_DATE);
        excludeInfoMap.put("selectedValidStartDate", selectedValidStartDate);
        List selectedValidEndDate = excludeInfoMap.get("selectedValidEndDate");
        selectedValidEndDate = this.associativeFiledQueryService.getTimeTageAssociativeQuery(associativeQueryVoList, keyword, selectedValidEndDate, validEndDateRangeData, AssociativeQueryEnum.PRICE_LIST_VALID_END_DATE);
        excludeInfoMap.put("selectedValidEndDate", selectedValidEndDate);
        List selectedCreateTimes = excludeInfoMap.get("selectedCreateTimes");
        selectedCreateTimes = this.associativeFiledQueryService.getTimeTageAssociativeQuery(associativeQueryVoList, keyword, selectedCreateTimes, createTimeRangeData, AssociativeQueryEnum.QUOTE_CREATE_TIME);
        excludeInfoMap.put("selectedCreateTimes", selectedCreateTimes);
        List selectedEnableState = excludeInfoMap.get("selectedEnableState");
        selectedEnableState = this.associativeFiledQueryService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedEnableState, enableStateData, AssociativeQueryEnum.PRICE_LIST_IS_ENABLE);
        excludeInfoMap.put("selectedEnableState", selectedEnableState);
        List selectedIsLock = excludeInfoMap.get("selectedIsLock");
        selectedIsLock = this.associativeFiledQueryService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedIsLock, isLockData, AssociativeQueryEnum.PRICE_LIST_IS_LOCK);
        excludeInfoMap.put("selectedIsLock", selectedIsLock);
        List selectedIsStandard = excludeInfoMap.get("selectedEnableState");
        selectedIsStandard = this.associativeFiledQueryService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedIsStandard, isStandardData, AssociativeQueryEnum.PRICE_LIST_IS_STANDARD);
        excludeInfoMap.put("selectedIsStandard", selectedIsStandard);
        return associativeQueryVoList;
    }
}

