/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.salesKPI.message.service.impl;

import com.jxdinfo.crm.salesKPI.constants.MsgConstants;
import com.jxdinfo.crm.salesKPI.message.service.BaseMsgService;
import com.jxdinfo.crm.salesKPI.message.service.IMsgService;
import com.jxdinfo.crm.salesKPI.rule.model.Rule;
import com.jxdinfo.crm.salesKPI.scope.dto.ScopeDto;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class CreateGoal
extends BaseMsgService
implements IMsgService {
    @Override
    public void sendMsg(List<Map<String, Object>> list) {
        if (list.isEmpty()) {
            return;
        }
        List<ScopeDto> dtoList = list.stream().map(map -> (ScopeDto)BeanUtil.mapToBean((Map)map, ScopeDto.class, (boolean)true)).collect(Collectors.toList());
        Long ruleId = ((ScopeDto)dtoList.get(0)).getRuleId();
        Rule rule = (Rule)((Object)this.ruleService.getById(ruleId));
        String checkObject = rule.getCheckObject();
        String userName = BaseSecurityUtil.getUser().getUserName();
        Long userId = BaseSecurityUtil.getUser().getUserId();
        String ruleName = rule.getRuleName();
        if (MsgConstants.CheckObject.DEPT.getCode().toString().equals(checkObject)) {
            this.sendDeptGoalCreateMsg(userName, userId, ruleName, dtoList);
        } else if (MsgConstants.CheckObject.PERSON.getCode().toString().equals(checkObject)) {
            this.sendPersonGoalCreateMsg(userName, userId, ruleName, dtoList);
        }
    }

    private void sendDeptGoalCreateMsg(String creatorName, Long creatorId, String ruleName, List<ScopeDto> dtoList) {
        List deptIdList = dtoList.stream().map(ScopeDto::getObjectId).collect(Collectors.toList());
        Map chargePersonList = this.dataRightBoService.getChargePersonList(deptIdList);
        if (null == chargePersonList || chargePersonList.isEmpty()) {
            return;
        }
        dtoList.forEach(scope -> {
            List securityUsers = (List)chargePersonList.get(scope.getObjectId());
            if (null == securityUsers || securityUsers.isEmpty()) {
                return;
            }
            List<String> sendMsgUserIds = securityUsers.stream().map(UserDetails::getUserId).map(String::valueOf).filter(id -> !creatorId.toString().equals(id)).collect(Collectors.toList());
            if (sendMsgUserIds.isEmpty()) {
                return;
            }
            String deptName = scope.getObjectName();
            String tile = "\u3010\u9500\u552e\u76ee\u6807\u63d0\u9192\u3011";
            String content = creatorName + "\u4e3a\u60a8\u8d1f\u8d23\u7684\u3010" + deptName + "\u3011\u8bbe\u7f6e\u4e86\u9500\u552e\u76ee\u6807\u3010" + ruleName + "\u3011\uff0c\u8bf7\u77e5\u6089";
            this.sendNoteMsg(tile, content, "#/crm/salesTarget/index", sendMsgUserIds, LocalDateTime.now());
            String mobileTile = creatorName + "\u4e3a\u60a8\u8d1f\u8d23\u7684\u3010" + deptName + "\u3011\u8bbe\u7f6e\u4e86\u9500\u552e\u76ee\u6807";
            String mobileContent = "\u9500\u552e\u76ee\u6807\u540d\u79f0\u3010" + ruleName + "\u3011\uff0c\u8bf7\u5728CRM\u95e8\u6237\u3010CRM\u7cfb\u7edf-\u9500\u552e\u76ee\u6807-\u76ee\u6807\u5b8c\u6210\u60c5\u51b5\u3011\u4e2d\u67e5\u770b\u8be6\u60c5\u3002";
            this.sendJqxNoteMsg(mobileTile, mobileContent, "/crm/sy/yddsy", sendMsgUserIds);
        });
    }

    private void sendPersonGoalCreateMsg(String creatorName, Long creatorId, String ruleName, List<ScopeDto> dtoList) {
        String tile = "\u3010\u9500\u552e\u76ee\u6807\u63d0\u9192\u3011";
        String content = creatorName + "\u4e3a\u60a8\u8bbe\u7f6e\u4e86\u9500\u552e\u76ee\u6807\u3010" + ruleName + "\u3011\uff0c\u8bf7\u53ca\u65f6\u8ddf\u8fdb";
        List<String> sendMsgUserIds = dtoList.stream().map(ScopeDto::getObjectId).filter(id -> !creatorId.equals(id)).map(String::valueOf).collect(Collectors.toList());
        if (sendMsgUserIds.isEmpty()) {
            return;
        }
        this.sendNoteMsg(tile, content, "#/crm/salesTarget/index", sendMsgUserIds, LocalDateTime.now());
        String mobileTile = creatorName + "\u4e3a\u60a8\u8bbe\u7f6e\u4e86\u9500\u552e\u76ee\u6807";
        String mobileContent = "\u9500\u552e\u76ee\u6807\u540d\u79f0\u3010" + ruleName + "\u3011\uff0c\u8bf7\u5728CRM\u95e8\u6237\u3010CRM\u7cfb\u7edf-\u9500\u552e\u76ee\u6807-\u76ee\u6807\u5b8c\u6210\u60c5\u51b5\u3011\u4e2d\u67e5\u770b\u8be6\u60c5\u3002";
        this.sendJqxNoteMsg(mobileTile, mobileContent, "/crm/sy/yddsy", sendMsgUserIds);
    }
}

