/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.salesKPI.job.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.crm.salesKPI.constants.CycleConstants;
import com.jxdinfo.crm.salesKPI.constants.MsgConstants;
import com.jxdinfo.crm.salesKPI.job.service.IStatisticService;
import com.jxdinfo.crm.salesKPI.message.Dto.RuleCompletionMsgDto;
import com.jxdinfo.crm.salesKPI.rule.vo.RuleVo;
import com.jxdinfo.crm.salesKPI.scope.service.IScopeService;
import com.jxdinfo.crm.salesKPI.scope.vo.ScopeFinishValueVo;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class StatisticServiceImpl
implements IStatisticService {
    @Resource
    private IScopeService scopeService;

    @Override
    public List<RuleVo> filterAlertRule(List<RuleVo> ruleVoList, JSONObject msgNoteDaysConfig, Integer beforeOrAfter) {
        return ruleVoList.stream().filter(ruleVo -> {
            LocalDate alterDate;
            String checkCycle = ruleVo.getCheckCycle();
            int checkCycleInt = Integer.parseInt(checkCycle);
            String markByCode = MsgConstants.getMarkByCode(checkCycleInt);
            Object o = msgNoteDaysConfig.get((Object)markByCode);
            int timeConfig = Integer.parseInt(o.toString());
            int scopeSort = MsgConstants.BeforeOrAfter.BEFORE.getCode().equals(beforeOrAfter) ? this.scopeService.getNowScopeSort(ruleVo.getRuleId()) : this.scopeService.getLastScopeSort(ruleVo.getRuleId());
            switch (checkCycleInt) {
                case 1: {
                    alterDate = this.calcYearFinishDate((RuleVo)ruleVo, timeConfig, beforeOrAfter);
                    break;
                }
                case 2: {
                    alterDate = this.calcHalfYearFinishDate((RuleVo)ruleVo, scopeSort, timeConfig, beforeOrAfter);
                    break;
                }
                case 3: {
                    alterDate = this.calcQuarterFinishDate((RuleVo)ruleVo, scopeSort, timeConfig, beforeOrAfter);
                    break;
                }
                case 4: {
                    alterDate = this.calcMonthFinishDate((RuleVo)ruleVo, scopeSort, timeConfig, beforeOrAfter);
                    break;
                }
                default: {
                    alterDate = LocalDate.of(1970, 1, 1);
                }
            }
            assert (alterDate != null);
            return LocalDate.now().isEqual(alterDate);
        }).collect(Collectors.toList());
    }

    private LocalDate calcMonthFinishDate(RuleVo ruleVo, int scopeSort, int timeConfig, Integer beforeOrAfter) {
        String analyseYear = ruleVo.getAnalyseYear();
        int year = Integer.parseInt(analyseYear);
        LocalDate finishDate = LocalDate.of(year, scopeSort, 1).plusMonths(1L).minusDays(1L);
        if (MsgConstants.BeforeOrAfter.BEFORE.getCode().equals(beforeOrAfter)) {
            return finishDate.minusDays(timeConfig);
        }
        if (MsgConstants.BeforeOrAfter.AFTER.getCode().equals(beforeOrAfter)) {
            return finishDate.plusDays(timeConfig);
        }
        return finishDate;
    }

    private LocalDate calcQuarterFinishDate(RuleVo ruleVo, int scopeSort, int timeConfig, Integer beforeOrAfter) {
        LocalDate startDate;
        String analyseYear = ruleVo.getAnalyseYear();
        int year = Integer.parseInt(analyseYear);
        switch (scopeSort) {
            case 1: {
                startDate = LocalDate.of(year, 1, 1);
                break;
            }
            case 2: {
                startDate = LocalDate.of(year, 4, 1);
                break;
            }
            case 3: {
                startDate = LocalDate.of(year, 7, 1);
                break;
            }
            case 4: {
                startDate = LocalDate.of(year, 10, 1);
                break;
            }
            default: {
                return null;
            }
        }
        LocalDate finishDate = startDate.plusMonths(3L).minusDays(1L);
        if (MsgConstants.BeforeOrAfter.BEFORE.getCode().equals(beforeOrAfter)) {
            return finishDate.minusDays(timeConfig);
        }
        if (MsgConstants.BeforeOrAfter.AFTER.getCode().equals(beforeOrAfter)) {
            return finishDate.plusDays(timeConfig);
        }
        return finishDate;
    }

    private LocalDate calcHalfYearFinishDate(RuleVo ruleVo, int scopeSort, int timeConfig, Integer beforeOrAfter) {
        String analyseYear = ruleVo.getAnalyseYear();
        int year = Integer.parseInt(analyseYear);
        LocalDate startDate = scopeSort == 1 ? LocalDate.of(year, 1, 1) : LocalDate.of(year, 7, 1);
        LocalDate finishDate = startDate.plusMonths(6L).minusDays(1L);
        if (MsgConstants.BeforeOrAfter.BEFORE.getCode().equals(beforeOrAfter)) {
            return finishDate.minusDays(timeConfig);
        }
        if (MsgConstants.BeforeOrAfter.AFTER.getCode().equals(beforeOrAfter)) {
            return finishDate.plusDays(timeConfig);
        }
        return finishDate;
    }

    private LocalDate calcYearFinishDate(RuleVo ruleVo, int timeConfig, Integer beforeOrAfter) {
        String analyseYear = ruleVo.getAnalyseYear();
        String fiscalYearMonth = ruleVo.getFiscalYearMonth();
        int year = Integer.parseInt(analyseYear);
        int month = Integer.parseInt(fiscalYearMonth);
        LocalDate startDate = LocalDate.of(year, month, 1);
        LocalDate finishDate = startDate.plusYears(1L).minusDays(1L);
        if (MsgConstants.BeforeOrAfter.BEFORE.getCode().equals(beforeOrAfter)) {
            return finishDate.minusDays(timeConfig);
        }
        if (MsgConstants.BeforeOrAfter.AFTER.getCode().equals(beforeOrAfter)) {
            return finishDate.plusDays(timeConfig);
        }
        return finishDate;
    }

    @Override
    public List<RuleCompletionMsgDto> getStatisticCompletion(List<RuleVo> alterRuleVoList, String checkCycle, Integer beforeOrAfter) {
        ArrayList<ScopeFinishValueVo> finishValueVos = new ArrayList<ScopeFinishValueVo>();
        List<RuleVo> cycleAlterRuleVoList = alterRuleVoList.stream().filter(vo -> checkCycle.equals(vo.getCheckCycle())).collect(Collectors.toList());
        if (cycleAlterRuleVoList.isEmpty()) {
            return new ArrayList<RuleCompletionMsgDto>();
        }
        cycleAlterRuleVoList.forEach(alterRuleVo -> {
            String scopeSort = MsgConstants.BeforeOrAfter.BEFORE.getCode().equals(beforeOrAfter) ? String.valueOf(this.scopeService.getNowScopeSort(alterRuleVo.getRuleId())) : String.valueOf(this.scopeService.getLastScopeSort(alterRuleVo.getRuleId()));
            List scopeFinishValueVos = this.scopeService.getSalesKPIScopeValueList(alterRuleVo.getRuleId(), scopeSort, true, null, null).stream().filter(vo -> alterRuleVo.getRuleId().equals(vo.getRuleId())).peek(vo -> {
                vo.setAnalyseYear(alterRuleVo.getAnalyseYear());
                vo.setNowScopeSort(Integer.parseInt(scopeSort));
                vo.setCheckCycle(checkCycle);
            }).collect(Collectors.toList());
            finishValueVos.addAll(scopeFinishValueVos);
        });
        return this.statisticCompletion(finishValueVos);
    }

    private List<RuleCompletionMsgDto> statisticCompletion(List<ScopeFinishValueVo> finishValueVos) {
        ArrayList<RuleCompletionMsgDto> params = new ArrayList<RuleCompletionMsgDto>();
        HashMap<String, Map> completionCountByMonth = new HashMap<String, Map>();
        finishValueVos.forEach(finishValueVo -> {
            Integer[] count;
            Map cycleCompletionCount;
            String checkObject = finishValueVo.getCheckObject();
            Long objectId = finishValueVo.getObjectId();
            Float finishRate = finishValueVo.getValueRate().get(0);
            String cycle = finishValueVo.getCheckCycle();
            Integer nowScopeSort = finishValueVo.getNowScopeSort();
            String analyseYear = finishValueVo.getAnalyseYear();
            String nowCycleName = this.getNowCycleName(cycle, nowScopeSort, analyseYear);
            String objectName = finishValueVo.getObjectName();
            String keyName = checkObject + "|" + nowCycleName + "|" + objectName;
            if (!completionCountByMonth.containsKey(objectId.toString())) {
                completionCountByMonth.put(objectId.toString(), new HashMap());
            }
            if (!(cycleCompletionCount = (Map)completionCountByMonth.get(objectId.toString())).containsKey(keyName)) {
                cycleCompletionCount.put(keyName, new Integer[]{0, 0, 0});
            }
            Integer[] integerArray = count = (Integer[])cycleCompletionCount.get(keyName);
            Integer n = integerArray[0];
            Integer n2 = integerArray[0] = Integer.valueOf(integerArray[0] + 1);
            if (BigDecimal.valueOf(100.0).compareTo(BigDecimal.valueOf(finishRate.floatValue())) <= 0) {
                integerArray = count;
                n = integerArray[1];
                n2 = integerArray[1] = Integer.valueOf(integerArray[1] + 1);
            } else {
                integerArray = count;
                n = integerArray[2];
                n2 = integerArray[2] = Integer.valueOf(integerArray[2] + 1);
            }
            cycleCompletionCount.put(keyName, count);
            completionCountByMonth.put(objectId.toString(), cycleCompletionCount);
        });
        completionCountByMonth.forEach((objectId, monthCompletionCount) -> monthCompletionCount.forEach((cycleName, count) -> {
            String[] split = cycleName.split("\\|");
            RuleCompletionMsgDto ruleCompletionMsgDto = new RuleCompletionMsgDto();
            ruleCompletionMsgDto.setObjectId(Long.parseLong(objectId));
            ruleCompletionMsgDto.setCheckObject(split[0]);
            ruleCompletionMsgDto.setCycleName(split[1]);
            ruleCompletionMsgDto.setObjectName(split[2]);
            ruleCompletionMsgDto.setTotal(count[0]);
            ruleCompletionMsgDto.setFinish(count[1]);
            ruleCompletionMsgDto.setUnFinish(count[2]);
            params.add(ruleCompletionMsgDto);
        }));
        return params;
    }

    @Override
    public String getNowCycleName(String cycle, Integer nowScopeSort, String analyseYear) {
        String cycleName;
        switch (Integer.parseInt(cycle)) {
            case 1: {
                cycleName = analyseYear + "\u5e74\u5ea6";
                break;
            }
            case 2: {
                cycleName = CycleConstants.HalfYear.getNameByCode(nowScopeSort);
                break;
            }
            case 3: {
                cycleName = CycleConstants.Quarter.getNameByCode(nowScopeSort);
                break;
            }
            case 4: {
                cycleName = CycleConstants.MonthCycle.getNameByCode(nowScopeSort);
                break;
            }
            default: {
                cycleName = "\u5f53\u524d\u5468\u671f";
            }
        }
        return cycleName;
    }
}

